<?php
    function CheckBrandisNew($inputData){
        $pdo = $inputData['db']['dbApp'];
        $sql = "SELECT * FROM wood_brands WHERE brand_name = :brandName and deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':brandName', $inputData['brandName']);
        $stmt->execute();
        $result = $stmt->fetchColumn();
        if ($result) {
            $data['status']  = 'failed';
            $data['message'] = 'Brand already exists';
        } else {
            $data['status'] = 'success';
        }
        return $data;
    }
    function viewPageBrands($inputData) {
        $data['status'] = 'success';
        $inputData['table'] = 'wood_brands';
        $lastModified = getMaxDate($inputData);
        $and = ' and `enable` = 1 ';
        $userid = $inputData['userId'] ?? '';
        $roleId = $inputData['roleId'] ?? '';
        $admin = 0;
        if(isset($userid) && $userid != '' && $roleId == 1){
            $and = '  ';
            $admin= 1;
        }

        if(isset($inputData['lastModified']) && $inputData['lastModified'] == $lastModified){
            $data['message'] = 'Content is up to date';
        }else{
            $pdo = $inputData['db']['dbApp'];
            $sql = "SELECT id, brand_name, brand_img, brand_folder, `order`, view_product_info, view_product_details, `enable` FROM wood_brands where deleted != 1 $and order by `order` asc";
            $stmt = $pdo->prepare($sql);
            $stmt->execute();
            $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if ($results) { 
                foreach ($results as $row) {
                    $result = [];
                    $result['id']                       = $row['id'];
                    $result['brands']                   = $row['brand_name'];
                    $result['brandsImg']                = $row['brand_img'];
                    $result['brandFolder']              = $row['brand_folder'];
                    $result['order']                    = $row['order'];
                    $result['viewProductInfo']          = $row['view_product_info'];
                    $result['viewProductDetails']       = $row['view_product_details'];
                    if($admin == 1){
                        $result['enable']               = $row['enable'];
                    }
                    $data['result']['brand'][] = $result;
                }
                $data['lastModified'] = $lastModified;

            } else {
                $data['status'] = 'failed';
                $data['message'] = 'No content found';
            }
        }
        return $data;
    }
    function edgeBanding($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $brandId = $inputData['brandId'];
        $tableName = array();
        array_push($tableName, 'wood_edge_banding');
        array_push($tableName, 'wood_edge_thicknesses_prices');
        $inputData['table'] =  $tableName;
        $lastModified = getMaxDate($inputData);
        if(isset($inputData['lastModified']) && $inputData['lastModified'] == $lastModified){
            $data['status'] = 'success';
            $data['message'] = 'Content is up to date';
        }else{
            $SQL = "SELECT * FROM wood_edge_banding WHERE brand_id = :brandId and deleted = 0";
            $stmt = $pdo->prepare($SQL);
            $stmt->bindParam(':brandId', $brandId);
            $result = $stmt->execute();
            if ($result) { 
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) { 
                    $res['id'] = $row['id'];
                    $res['boardThickness'] = $row['board_thickness'];
                    $res['bandingDetails'] = $row['banding_details'];
                    $thinkness = $row['edge_thickness'];
                    $thicknessPart = explode('.', $thinkness);
                    if($thicknessPart[1] == '00'){
                        $res['edgeThickness'] = $thicknessPart[0];
                    }else{
                        $res['edgeThickness'] = $thinkness;
                    }
                    $res['bandingType'] = $row['banding_type'];
                    $inputData['productId'] = $row['id'];
                    $res['price'] = getEdgePriceInfo($inputData);
                    $data['result'][] = $res;
                }
                $rowCount = 1;
                $data['lastModified'] = $lastModified;
                $data['status'] = 'success';
            } else {
                $data['status'] = 'failed';
                $data['message'] = 'No content found';
            }
        }
        return $data;
    }
    function standardProduct($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $brandId = $inputData['brandId'];
        $tableName = array();
        array_push($tableName, 'wood_product');
        array_push($tableName, 'wood_product_pricing');
        $inputData['table'] =  $tableName;
        $lastModified = getMaxDate($inputData);
        if(isset($inputData['lastModified']) && $inputData['lastModified'] == $lastModified){
            $data['status'] = 'success';
            $data['message'] = 'Content is up to date';
        }else{
            $sql = "SELECT * FROM wood_product WHERE brand_id = :brandId and deleted = 0";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':brandId', $brandId);
            $data = [];
            $pdo = $inputData['db']['dbApp'];
            $brandId = $inputData['brandId'];
            $stmt->execute();
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if ($result) {
                foreach ($result as $row) {
                    $res['id'] = $row['id'];
                    $res['no'] = $row['no'];
                    $res['decorCode'] = $row['decor_code'];
                    $res['decorName'] = $row['decor_name']; //  kill value 2 for some reason :(
                    $res['decorGroup'] = $row['decor_group'];
                    $res['core'] = $row['core'];
                    $res['isNew'] = $row['is_new'];
                    $res['isNotAvailable'] = $row['is_not_available'];
                    $inputData['productId'] = $row['id'];
                    $res['dimensions'] = getProductDimensions($inputData);
                    $res['images'] = getImageList($inputData);
                    $data['result'][] = $res;
                }
                $data['lastModified'] = $lastModified;
                $data['status'] = 'success';
            } else {
                $data['status'] = 'failed';
                $data['message'] = 'No content found';
            }   
        }
        return $data;
    }
    function getProductDimensions($inputData){
        $pdo = $inputData['db']['dbApp'];
        $product_id = $inputData['productId'];
        $sql = "SELECT * FROM wood_product_dimensions WHERE product_id = :product_id and deleted = 0";
        $stmt = $pdo->prepare($sql);
        $data = [];
        $stmt->bindParam(':product_id', $product_id);
        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($result) { 
            foreach ($result as $row) { 
                $res['id'] = $row['id'];
                $res['length'] = $row['length'];
                $res['width'] = $row['width'];
                $inputData['dimensionsId'] = $row['id'];
                $res['price'] = getPriceInfoByDimensions($inputData);
                $data[] = $res;
            }
        } else {
            $res['length'] = 0;
            $res['width'] = 0;
            $res['price'] = [];
            $data[] = $res;
        }
        return $data;
    }
    function getPriceInfo($inputData){
        $pdo = $inputData['db']['dbApp'];
        $product_id = $inputData['productId'];
        $sql = "SELECT * FROM wood_product_pricing  WHERE product_id = :product_id and deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':product_id', $product_id);
        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($result) { 
            foreach ($result as $row) { 
                $res['id']       = $row['id'];
                $res['price']    = $row['price'];
                $thinkness          = $row['thickness'];
                $thickness_part     = explode('.', $thinkness);
                if($thickness_part[1] == '00'){
                    $res['thickness'] = $thickness_part[0];
                }else{
                    $res['thickness'] = $thinkness;
                }
                $data[] = $res;
            }
        } else {
            $res['price'] = 0;
            $res['thickness'] = 0;
            $data[] = $res;
        }
        return $data;        
    }
    function getPriceInfoByDimensions($inputData){
        $pdo = $inputData['db']['dbApp'];
        $dimensionsId = $inputData['dimensionsId'];
        $data = [];
        $sql = "SELECT * FROM wood_product_pricing  WHERE dimensions_id = :dimensions_id and deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':dimensions_id', $dimensionsId);
        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($result) { 
            foreach ($result as $row) { 
                $res['id']          = $row['id'];
                $res['price']       = $row['price'];
                $thicknessRaw      = isset($row['thickness']) ? (string)$row['thickness'] : '';
                if ($thicknessRaw === '' || $thicknessRaw === null) {
                    $res['thickness'] = null; 
                    } else {
                        $normalized = number_format((float)$thicknessRaw, 2, '.', '');
                        $res['thickness'] = rtrim(rtrim($normalized, '0'), '.');
                    }
                $data[] = $res;
            }
        } else {
            $res['price'] = 0;
            $res['thickness'] = 0;
            $data[] = $res;
        }
        return $data;        
    }
    function getEdgePriceInfo($inputData){
        $pdo = $inputData['db']['dbApp'];
        $product_id = $inputData['productId'];
        $sql = "SELECT * FROM wood_edge_thicknesses_prices  WHERE edge_banding_id = :product_id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':product_id', $product_id);
        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($result) {
            foreach ($result as $row) {
                $res['id'] = $row['id'];
                $res['pricePerMeter'] = $row['price_per_meter'];
                $res['thicknessRange'] = $row['thickness_range'];
                $data[] = $res;
            }
        } else {
            $data['status'] = 'failed';
            $data['message'] = 'No content found';
            $res['pricePerMeter'] = 0;
            $res['thicknessRange'] = 0;
            $data[] = $res;
        }
        return $data;
    }
    function getProductForHistory($inputData){
        $pdo = $inputData['db']['dbApp'];
        $productId = $inputData['productId'];

        $inputData['id'] = $productId;
        $inputData['table'] = 'wood_product';
        $count = checkIdExists($inputData);
        if($count == 0){
            $data['status'] = 'failed';
            $data['message'] = 'Product ID does not exist';
            return $data;
        }

        $sql = "SELECT * FROM wood_product p WHERE p.id = :productId";

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':productId', $productId);
        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($result) {
            foreach ($result as $row) {
                $res['productId']            = $row['id'];
                $res['brandId']              = $row['brand_id'];
                $res['no']                   = $row['no'];
                $res['decorCode']            = $row['decor_code'];
                $res['decorName']            = $row['decor_name'];
                $res['decorGroup']           = $row['decor_group'];
                $res['core']                 = $row['core'];
                $res['isNew']                = $row['is_new'];
                $res['isNotAvailable']       = $row['is_not_available'];
                $res['deleted']              = $row['deleted'];
                $res['images']               = getImageList($inputData);
                $res['dimensions']           = getProductDimensionHistory($inputData);
                $data['cms'] = $res;
            }
            $data['status'] = 'success';
        } else {
            $data['status'] = 'failed';
            $data['message'] = 'No content found';
        }
        return $data;
    }
    function getProductDimensionHistory($inputData){
        $pdo = $inputData['db']['dbApp'];
        $productId = $inputData['productId'];
        $sql = "SELECT * FROM wood_product_dimensions WHERE product_id = :productId and deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':productId', $productId);
        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($result) {
            foreach ($result as $row) {
                $res['id'] = $row['id'];
                $res['length'] = $row['length'];
                $res['width'] = $row['width'];
                $res['deleted'] = $row['deleted'];
                $inputData['dimensionId'] = $row['id'];
                $res['price'] = getPriceFromDimensionId($inputData);
                $data[] = $res;
            }
            $data['status'] = 'success';
        } else {
            $data['status'] = 'failed';
            $data['message'] = 'No content found';
        }
        return $data;
    }
    function getPriceFromDimensionId($inputData){
        $pdo = $inputData['db']['dbApp'];
        $dimensionId = $inputData['dimensionId'];
        $sql = "SELECT * FROM wood_product_pricing WHERE dimensions_id = :dimensionId and deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':dimensionId', $dimensionId);
        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($result) {
            foreach ($result as $row) {
                $res['id'] = $row['id'];
                $res['price'] = $row['price'];
                $res['thickness'] = $row['thickness'];
                $res['deleted'] = $row['deleted'];
                $data[] = $res;
            }
            $data['status'] = 'success';
        } else {
            $data['status'] = 'failed';
            $data['message'] = 'No content found';
        }
        return $data;
    }
    function getMaxDate($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $data = 'failed';
        $sql = '';
        if (is_array($inputData['table'])) {
            $tables = $inputData['table'];
            $unionQueries = [];

            foreach ($tables as $table) {
                $unionQueries[] = "SELECT MAX(last_updated) AS last_updated FROM $table";
            }

            // Works in BOTH MySQL and SQLite
            $sql = "SELECT MAX(last_updated) AS last_updated FROM (" . implode(" UNION ALL ", $unionQueries) . ")";
        } else {
            $table = $inputData['table'];
            $sql = "SELECT MAX(last_updated) AS last_updated FROM $table";
        }

        $stmt = $pdo->prepare($sql);
        $result = $stmt->execute();

        if ($result) {
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $data = $row['last_updated'] ?? 'failed';
        }

        return $data;
    }
    function getProductByPriceId($inputData){
        $res = [];
        $db = $inputData['db']['dbApp'];
        $stmt = $db->prepare("select product_id from wood_product_pricing where id = :priceId and deleted = 0");
        $stmt->bindParam(':priceId', $inputData['priceId']);
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($result) { 
            $res['productId'] = $result !== false ? $result['product_id'] : 0;
            $res['status']    = 'success';
        }else{
            $res['status']    = 'failed';
            $res['message']       = 'Product not found';
        }
        return  $res;
    }
    function getImageList($inputData){
        $res = [];
        $db = $inputData['db']['dbApp'];
        $stmt = $db->prepare("select id, `no`, lower(image_path) as image_path, image_location from wood_product_images where product_id = :productId and deleted = 0 order by `no` asc");
        $stmt->bindParam(':productId', $inputData['productId']);
        $stmt->execute();
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($result) { 
            foreach ($result as $row) { 
                $res['id'] = $row['id'];
                $res['no'] = $row['no'];
                $res['imagePath'] = $row['image_path'];
                $res['imageLocation'] = $row['image_location'];
                $data[] = $res;
            }
        }else{
            $data = [];
        }
        return $data;   
    }
    function checkIdExists($inputData){
        $pdo    = $inputData['db']['dbApp'];
        $id     = isset($inputData['id']) ? $inputData['id'] : null;
        if($id === null){
            return 0;
        }
        $table  = $inputData['table'];
        $sql    = "SELECT COUNT(*) FROM $table WHERE id = :id and deleted = 0";
        $stmt   = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        $count  = $stmt->fetchColumn();
        return $count;
    }
    function checkDimensionAndIdExists($inputData){
        $pdo            = $inputData['db']['dbApp'];
        $dimensionId    = isset($inputData['id']) ? $inputData['id'] : null;
        $productId      = isset($inputData['productId']) ? $inputData['productId'] : null;
        if($dimensionId === null || $productId === null){
            return 0;
        }
        $table  = 'wood_product_dimensions';
        $sql    = "SELECT COUNT(*) FROM $table WHERE id = :dimensionId and product_id = :productId and deleted = 0";
        $stmt   = $pdo->prepare($sql);
        $stmt->bindParam(':dimensionId', $dimensionId);
        $stmt->bindParam(':productId', $productId);
        $stmt->execute();
        $count  = $stmt->fetchColumn();
        return $count;
    }
    function checkDimensionAndPriceExists($inputData){
        $pdo            = $inputData['db']['dbApp'];
        $dimensionsId   = isset($inputData['dimensionsId']) ? $inputData['dimensionsId'] : null;
        $priceId        = isset($inputData['priceId']) ? $inputData['priceId'] : null;
        if($dimensionsId === null || $priceId === null){
            return 0;
        }
        $table  = 'wood_product_pricing';
        $sql    = "SELECT COUNT(*) FROM $table WHERE id = :priceId and dimensions_id = :dimensions_id and deleted = 0";
        $stmt   = $pdo->prepare($sql);
        $stmt->bindParam(':dimensions_id', $dimensionsId);
        $stmt->bindParam(':priceId', $priceId);
        $stmt->execute();
        $count  = $stmt->fetchColumn();
        return $count;
    }
?>
