<?php
    function updateBrand($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $data['status'] = 'failed';
        $data['message'] = 'No changes made';
        // check if id exists
        $inputData['table'] = 'wood_brands';
        $res = checkIdExists($inputData);
        if($res == 0){
            $data['status'] = 'failed';
            $data['message'] = 'ID does not exist';
            return $data;
        }
        
        $updateStatementParts = [];
        $bindings = [];
        $fields = [
            'id' => PDO::PARAM_INT,
            'brandName' => PDO::PARAM_STR, 
            'brandImg' => PDO::PARAM_STR, 
            //'brandOrder' => PDO::PARAM_INT,
            'enable' => PDO::PARAM_INT,
            'deleted' => PDO::PARAM_INT,
            'viewProductInfo' => PDO::PARAM_STR,
            'viewProductDetails' => PDO::PARAM_STR,
        ];
        foreach ($fields as $field => $pdoType) {
            if (isset($inputData[$field])) {
                $snakeCaseField = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                $updateStatementParts[] = "$snakeCaseField = :$field";
                $bindings[$field] = [
                    'value' => $inputData[$field], 
                    'type' => $pdoType
                ];
            }
        }
        $updateStatement = implode(', ', $updateStatementParts);
        $sql = "UPDATE wood_brands SET $updateStatement WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':id', $inputData['id'], PDO::PARAM_INT);
        foreach ($bindings as $key => $binding) {
            $stmt->bindValue(":$key", $binding['value'], $binding['type']);
        }
        $result = $stmt->execute();
        if ($result) {
            $data['status'] = 'success';
        } else {
            $data['status'] = 'failed';
            $data['message'] = 'Record not updated';
        }
        return $data;
    }
    function update($inputData) {
        $data = [];
        $updateStatementParts = [];
        $bindings = [];

        $pdo = $inputData['db']['dbApp'];
        // begin transaction

        // Map of updatable fields and their PDO types
        $fields = [
            'brandId'         => PDO::PARAM_INT,
            'no'              => PDO::PARAM_STR,
            'decorCode'       => PDO::PARAM_STR,
            'core'            => PDO::PARAM_STR,
            'decorName'       => PDO::PARAM_STR,
            'decorGroup'      => PDO::PARAM_STR,
            'width'           => PDO::PARAM_STR,
            'isNew'           => PDO::PARAM_INT, // TINYINT
            'isNotAvailable'  => PDO::PARAM_INT, // TINYINT
            'dimensions'      => PDO::PARAM_STR,
            'priceDelete'     => PDO::PARAM_STR,
            'dimensionsDelete'=> PDO::PARAM_STR,
            'imagesEdit'      => PDO::PARAM_STR,
            'imagesDelete'    => PDO::PARAM_STR,
        ];

        // Fields that should NOT be bound into the SQL SET clause
        $sideEffectOnly = ['dimensions','priceDelete','dimensionsDelete','imagesEdit','imagesDelete'];
        $temp['sideEffects'] = [];

        // helper: convert camelCase / digits to snake_case
        $toSnake = static function(string $name): string {
            $withUnderscore = preg_replace('/[A-Z]/', '_$0', $name);
            $withDigits     = preg_replace('/([0-9])/', '_$1', $withUnderscore);
            return strtolower($withDigits);
        };

        foreach ($fields as $field => $pdoType) {
            if (!isset($inputData[$field])) {
                continue;
            }

            if ($field === 'dimensions') {
                $data['dimensions'] = updateDimensions($inputData);
                $temp['sideEffects'][] = 'dimensions';
                continue;
            }


            // Handle side-effect fields (do not add to SQL)
            if ($field === 'priceDelete') {
                $originalId = $inputData['id'] ?? null; // temp hold
                $inputData['table'] = 'wood_product_pricing';
                foreach ($inputData['priceDelete'] as $price) {
                    $inputData['id'] = $price['id'] ?? null;
                    if(!$inputData['id']){
                        $data['status'] = 'failed';
                        $data['message'] = 'No Price ID Found for deletion';    
                        return $data;
                    }
                    $idCheck = checkIdExists($inputData);
                    if($idCheck == 0){
                        $data['status'] = 'failed';
                        $data['message'] = 'Price ID '.$price['id'].' does not exist';
                        return $data;
                    }
                    $data['priceDelete'][] = deletePrice($inputData);
                }
                $inputData['id'] = $originalId; // reset
                $temp['sideEffects'][] = 'priceDelete';
                continue;
            }

            if ($field === 'dimensionsDelete') {
                $inputData['action'] = 'dimensionDelete';
                $originalId = $inputData['id'] ?? null; // temp hold
                $inputData['table'] = 'wood_product_dimensions';
                foreach ($inputData['dimensionsDelete'] as $dimension) {
                    $inputData['id'] = $dimension['id'] ?? null;
                    if(!$inputData['id']){
                        $data['status'] = 'failed';
                        $data['message'] = 'No Dimension ID Found for deletion';
                        return $data;
                    }
                    $idCheck = checkIdExists($inputData);
                    if($idCheck == 0){
                        $data['status'] = 'failed';
                        $data['message'] = 'Dimension ID '.$inputData['id'].' does not exist';
                        return $data;
                    }

                    $data['dimensionsDelete'][] = deleteDimension($inputData);
                }
                $temp['sideEffects'][] = 'dimensionsDelete';
                $inputData['id'] = $originalId;
                continue;
            }

            if ($field === 'imagesDelete') {
                $inputData['action'] = 'imageDelete';
                $originalId = $inputData['id'] ?? null; // temp hold
                $inputData['table'] = 'wood_product_images';
                foreach ($inputData['imagesDelete'] as $image) {
                    $inputData['id'] = $image['id'] ?? null;
                    if(!$inputData['id']){
                        $data['status'] = 'failed';
                        $data['message'] = 'No Image ID Found for deletion';
                        return $data;
                    }
                    $idCheck = checkIdExists($inputData);
                    if($idCheck == 0){
                        $data['status'] = 'failed';
                        $data['message'] = 'Image ID '.$inputData['id'].' does not exist';
                        return $data;
                    }
                    $data['imagesDelete'][] = deleteImage($inputData);
                }
                $inputData['id'] = $originalId;
                $temp['sideEffects'][] = 'imagesDelete';
                continue;
            }

            if ($field === 'imagesEdit') {
                if(empty($inputData['imagesEdit'])){
                    $data['status'] = 'failed';
                    $data['message'] = 'No images data provided for edit';
                    return $data;
                }
                $inputData['images'] = $inputData['imagesEdit'];
                $data['images'] = updateImages($inputData);
                $temp['sideEffects'][] = 'imagesEdit';
                continue;
            }

            // Regular field: add to bindings and SET clause
            $value = $inputData[$field];
            $snake = $toSnake($field);

            if (!in_array($field, $sideEffectOnly, true)) {
                $bindings[$field] = [
                    'type'  => $pdoType,
                    'value' => $value,
                ];
                $updateStatementParts[] = "$snake = :$field";
            }
        }

        // Nothing to update / no side effects
        if (empty($updateStatementParts) && empty($temp['sideEffects'])) {
            $data['status']  = 'failed';
            $data['message'] = 'No data to update';
            return $data;
        }
        // if we have side effects but no main update, return success for side effects
        if (empty($updateStatementParts) && !empty($temp['sideEffects'])) {
            $data['status']  = 'success';
            return $data;
        }

        // Build and prepare UPDATE
        $updateStatement = implode(', ', $updateStatementParts);
        $id = $inputData['productId'];
        $inputData['table'] = 'wood_product';
        $inputData['id'] = $id;
        $idCheck = checkIdExists($inputData);
        if($idCheck == 0){
            $data['status'] = 'failed';
            $data['message'] = 'Product ID '.$id.' does not exist';
            return $data;
        }


        $sql = "UPDATE wood_product SET $updateStatement WHERE id = :id";

        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':id', $id, PDO::PARAM_INT);

        // Bind parameters with specific types
        foreach ($bindings as $key => $binding) {
            $stmt->bindValue(":$key", $binding['value'], $binding['type']);
        }

        // Execute update
        $result = $stmt->execute();

        // Success/Failure for the main UPDATE
        if ($result) {
            $data['status'] = 'success';
        } else {
            $data['status']  = 'failed';
            $data['message'] = 'Record not updated';
        }

        // Post-checks for dimensions updates (preserve original logic)
        if ($data['status'] === 'success' && isset($data['dimensions'])) {
            if ($data['dimensions']['status'] === 'failed') {
                $data['status']  = 'failed';
                $data['message'] = 'Dimensions not updated';
            } elseif (isset($data['dimensions']['price']) && $data['dimensions']['price']['status'] === 'failed') {
                $data['status']  = 'failed';
                $data['message'] = 'Price not updated';
            } else {
                $data['message'] = 'Data updated';
            }
        }

        return $data;
    }
    function updateDimensions($inputData){
        $data = [];
        $dimensionsId = 0;
        $data['dimensions'] = [];
        $pdo = $inputData['db']['dbApp'];
        $fields = [
            'length'        => PDO::PARAM_STR,
            'width'         => PDO::PARAM_STR,
        ];
        if(isset($inputData['dimensions'])){
            foreach($inputData['dimensions'] as $dimension){
                // Prepare data array  
                if(isset($dimension['id'])){
                    $dimensionId = $dimension['id'];
                    // Update existing dimension
                    $updateStatementParts = [];
                    $bindings = [];
                    foreach ($fields as $field => $pdoType) {
                        if (isset($dimension[$field])) {
                            $snakeCaseField = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                            $updateStatementParts[] = "$snakeCaseField = :$field";
                            if($field != 'price' && $field != 'priceDelete'){
                                $bindings[$field] = [
                                    'value' => $dimension[$field], 
                                    'type' => $pdoType
                                ];
                            }
                        }
                    }
                    
                    // check if there are fields to update
                    if(empty($updateStatementParts)){
                        $res['message'] = 'No fields or missing fields to update for Dimension ID ' . $dimension['id'];
                        $res['status'] = 'failed';
                        $data['dimensions'][] = $res;
                        return $data;
                    }
                    //check that both length and width are provided
                    if(!isset($dimension['length']) || !isset($dimension['width'])){
                        $res['message'] = 'Both length and width must be provided for Dimension ID ' . $dimension['id'];
                        $res['status'] = 'failed';
                        $data['dimensions'][] = $res;
                        return $data;
                    }

                    $tempId = $inputData['id'] ?? null;
                    $inputData['id'] = $dimension['id'];
                    $check = checkDimensionAndIdExists($inputData);
                    if($check == 0){
                        $res['message'] = 'Dimension ID ' . $dimension['id'] . ' does not exist for Product ID ' . $inputData['productId'];
                        $res['status'] = 'failed';
                        $data['dimensions'][] = $res;
                        return $data;
                    }
                    $inputData['id'] = $tempId;

                    $updateStatement = implode(', ', $updateStatementParts);
                    $sql = "UPDATE wood_product_dimensions SET $updateStatement WHERE id = :id and product_id = :product_id";
                    $stmt = $pdo->prepare($sql);
                    $stmt->bindValue(':id', $dimension['id'], PDO::PARAM_INT);
                    $stmt->bindValue(':product_id', $inputData['productId'], PDO::PARAM_INT);
                    foreach ($bindings as $key => $binding) {
                        $stmt->bindValue(":$key", $binding['value'], $binding['type']);
                    }
                    $result = $stmt->execute();
                    if ($result) {
                        $res['status'] = 'success';
                        $res['id'] = $dimension['id'];
                        $res['product_id'] = $inputData['productId'];
                    } else {
                        $res['id'] = $dimension['id'];
                        $res['status'] = 'failed';
                        $res['message'] = 'Dimensions not updated';
                    }
                    $data['dimensions'][] = $res;
                } else {
                    // Insert new dimension
                    $columns      = [];
                    $placeholders = [];
                    $bindings     = [];

                    // Map camelCase => snake_case columns and collect placeholders/bindings
                    foreach ($fields as $field => $pdoType) {
                        if (isset($dimension[$field])) { // note: skips NULLs; use array_key_exists if you want to allow NULL
                            $snake = strtolower(preg_replace('/[A-Z]/', '_$0', $field)); // e.g. overallLength -> overall_length
                            $columns[]      = "`$snake`";         // backticks are fine in MySQL; SQLite accepts them too
                            $placeholders[] = ":$field";
                            $bindings[$field] = ['value' => $dimension[$field], 'type' => $pdoType];
                        }
                    }

                    // Always include product_id
                    $columns[]      = "`product_id`";
                    $placeholders[] = ":product_id";

                    $sql = "INSERT INTO wood_product_dimensions (" . implode(', ', $columns) . ")
                            VALUES (" . implode(', ', $placeholders) . ")";

                    $stmt = $pdo->prepare($sql);
                    // Bind dynamic fields
                    foreach ($bindings as $key => $binding) {
                        $stmt->bindValue(":$key", $binding['value'], $binding['type']);
                    }
                    // Bind product_id
                    $stmt->bindValue(":product_id", (int)$inputData['productId'], PDO::PARAM_INT);

                    $result      = $stmt->execute();
                    $dimensionId = $pdo->lastInsertId();
                    if ($result) {
                        $res['status'] = 'success';
                        $res['id']     = $dimensionId !== false ? (int)$dimensionId : null; // SQLite returns string; cast if you like
                    } else {
                        $res['status']  = 'failed';
                        $res['message'] = 'New dimensions not inserted';
                    }
                    $data['dimensions'][] = $res;
                }

                if(isset($dimension['price'])){
                    $inputData1['dimensionsId'] = $dimensionId;
                    $inputData1['price'] = $dimension['price'];
                    $inputData1['db']['dbApp'] = $inputData['db']['dbApp'];
                    $data['price'] = updatePriceDimensions($inputData1);
                }
            }
        }

        return $data;
    }
    function updatePriceDimensions($inputData) {
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $fields = [
            'price' => PDO::PARAM_STR,
            'thickness' => PDO::PARAM_STR,
        ];
        if (isset($inputData['price'])) {
            foreach ($inputData['price'] as $price) {
                $updateStatementParts = [];
                $bindings = [];
                // Check if the price record has an 'id' field for updating
                if (isset($price['id'])) {

                    $inputData['priceId'] = $price['id'];
                    $check = checkDimensionAndPriceExists($inputData);
                    if($check == 0){
                        $data['status'] = 'failed';
                        $data['priceid'] = $price['id'];
                        $data['dimensionId'] = $inputData['dimensionsId'];
                        $data['message'] = 'Price ID '.$price['id'].' does not exist for Dimensions ID '.$inputData['dimensionsId'];
                        return $data;
                    }


                    // Prepare the fields for the UPDATE statement
                    foreach ($fields as $field => $pdoType) {
                        if (isset($price[$field])) {
                            $snakeCaseField = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                            $updateStatementParts[] = "$snakeCaseField = :$field";
                            $bindings[$field] = [
                                'value' => $price[$field], 
                                'type' => $pdoType
                            ];
                        }
                    }

                    // Check if there are any fields to update
                    if (empty($updateStatementParts)) {
                        $data['message'] = 'No fields or missing fields to update for Price ID ' . $price['id'];
                        $data['status'] = 'failed';
                        return $data;
                    }
                    // check that both thickness and price are provided
                    if (!isset($price['thickness']) || !isset($price['price'])) {
                        $data['message'] = 'Both thickness and price must be provided for Price ID ' . $price['id'];
                        $data['status'] = 'failed';
                        return $data;
                    }

                    // Prepare and execute the UPDATE statement
                    $updateStatement = implode(', ', $updateStatementParts);
                    $sql = "UPDATE wood_product_pricing SET $updateStatement WHERE id = :id";
                    $stmt = $pdo->prepare($sql);
                    $stmt->bindValue(':id', $price['id'], PDO::PARAM_INT);
                    
                    foreach ($bindings as $key => $binding) {
                        $stmt->bindValue(":$key", $binding['value'], $binding['type']);
                    }
                    $result = $stmt->execute();
    
                    // Check if any rows were updated
                    if ($result) {
                        $data['status'] = 'success';
                    } else {
                        $data['status'] = 'failed';
                        $data['message'] = 'Record not updated';
                    }
                } else {
                    // Prepare $inputData2 with the necessary fields for insertion
                    $inputData2 = [
                        'db' => $inputData['db'],
                        'dimensionsId' => $inputData['dimensionsId'],
                        'price' => [
                            "0" => [
                                'thickness' => $price['thickness'],
                                'price' => $price['price']
                            ]
                        ]
                    ];    
                    try {
                        // Call the insertPriceDimensions function with the new $inputData2
                        $insertData = insertPriceDimensions($inputData2);
                        if (!empty($insertData)) {
                            $data['status'] = 'success';
                            $data['inserted_ids'] = $insertData;
                        } else {
                            $data['status'] = 'failed';
                            $data['message'] = 'Insert failed';
                        }
                    } catch (Exception $e) {
                        // Handle any errors that occur in the insertPriceDimensions function
                        $data['status'] = 'failed';
                        $data['message'] = $e->getMessage();
                    }
                }
            }
        }
    
        return $data;
    }
    function updatePrice($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $updateStatementParts = [];
        $bindings = [];
        $fields = [
            'id' => PDO::PARAM_INT,
            'price' => PDO::PARAM_STR,
            'thickness' => PDO::PARAM_STR,
        ];
        if(isset($inputData['price'])){
            foreach($inputData['price'] as $price){
                if(isset($price['id'])){
                    $updateStatementParts = [];
                    $bindings = [];
                    foreach ($fields as $field => $pdoType) {
                        if (isset($price[$field])) {
                            $snakeCaseField = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                            $updateStatementParts[] = "$snakeCaseField = :$field";
                            $bindings[$field] = [
                                'value' => $price[$field], 
                                'type' => $pdoType
                            ];
                        }
                    }
                    $updateStatement = implode(', ', $updateStatementParts);
                    $sql = "UPDATE wood_product_pricing SET $updateStatement WHERE id = :id";
                    $stmt = $pdo->prepare($sql);
                    $stmt->bindValue(':id', $price['id'], PDO::PARAM_INT);
                    foreach ($bindings as $key => $binding) {
                        $stmt->bindValue(":$key", $binding['value'], $binding['type']);
                    }
                    $result = $stmt->execute();
                    if ($result) {
                        $data['status'] = 'success';
                    } else {
                        $data['status'] = 'failed';
                        $data['message'] = 'Record not updated';
                    }
                }else{
                    $updateStatementParts = [];
                    $bindings = [];
                    foreach ($fields as $field => $pdoType) {
                        if (isset($price[$field])) {
                            $snakeCaseField = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                            $updateStatementParts[] = "$snakeCaseField = :$field";
                            $bindings[$field] = [
                                'value' => $price[$field], 
                                'type' => $pdoType
                            ];
                        }
                    }
                    $updateStatementParts[] = "product_Id = :product_Id";
                    $updateStatement = implode(', ', $updateStatementParts);
                    $sql = "INSERT INTO wood_product_pricing SET $updateStatement";
                    $stmt = $pdo->prepare($sql);
                    foreach ($bindings as $key => $binding) {
                        $stmt->bindValue(":$key", $binding['value'], $binding['type']);
                    }
                    $stmt->bindValue(":product_Id", $inputData['productId'], PDO::PARAM_INT);
                    $result = $stmt->execute();
                    if ($result) {
                        $data['status'] = 'success';
                    } else {
                        $data['status'] = 'failed';
                    }
                }
            }
        }
        return $data;
    }
    function updateImages($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $updateStatementParts = [];
        $bindings = [];
        $fields = [
            'no' => PDO::PARAM_INT,
            'image_path' => PDO::PARAM_STR,
            'image_location' => PDO::PARAM_STR,
        ];
        $inputData['images2'] = $inputData['images'];
        if(isset($inputData['images2'])){
            foreach($inputData['images2'] as $image){
                if(isset($image['id'])){
                    $updateStatementParts = [];
                    $bindings = [];
                    foreach ($fields as $field => $pdoType) {
                        if (isset($image[$field])) {
                            $snakeCaseField = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                            $updateStatementParts[] = "$snakeCaseField = :$field";
                            $bindings[$field] = [
                                'value' => $image[$field], 
                                'type' => $pdoType
                            ];
                        }
                    }
                    $updateStatement = implode(', ', $updateStatementParts);
                    $sql = "UPDATE wood_product_images SET $updateStatement WHERE id = :id";
                    $stmt = $pdo->prepare($sql);
                    $stmt->bindValue(':id', $image['id'], PDO::PARAM_INT);
                    foreach ($bindings as $key => $binding) {
                        $stmt->bindValue(":$key", $binding['value'], $binding['type']);
                    }
                    $result = $stmt->execute();
                    if ($result) {
                        $data['status'] = 'success';
                    } else {
                        $data['status'] = 'failed';
                        $data['message'] = 'Record not updated';
                    }
                }else{
                    $inputData['images'] = [];
                    $inputData['images'][] = $image;
                    $data['images'][] = insertImage($inputData);
                }
            }
        }
                return $data;
    }
    function deleteBrand($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        if($inputData['action'] == 'brandDelete'){
            $inputData['table'] = 'wood_brands';
            $res = checkIdExists($inputData);
            if($res == 0){
                $data['status'] = 'failed';
                $data['message'] = 'ID does not exist';
                return $data;
            }

            $id = $inputData['id'];
            $sql = "UPDATE wood_brands set deleted = 1 where id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $result = $stmt->execute();
            // check if statement was successful
            if ($result) {
                $data['status'] = 'success';
            } else {
                $data['status'] = 'failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
            $inputData['brand_id'] = $id;
            $data['products'] = deleteProduct($inputData);
        }else{
            // step one get all the brands that relate to the brand into a list called $brands_id
            $id = $inputData['brand_id'];
            $sql = "SELECT id FROM wood_product WHERE brand_id = :brand_id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':brand_id', $inputData['id'], PDO::PARAM_INT);
            $stmt->execute();
            $brands_id = $stmt->fetchAll(PDO::FETCH_ASSOC);
            // loop through the list and call deleteProduct($id) for each brand
            foreach($brands_id as $brand){
                // delete all the products that relate to the brand
                $inputData['product_id'] = $brand['id'];
                $data['products'][] = deleteProduct($inputData);
            }
    
            $sql = "UPDATE wood_brands set deleted = 1 where id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $result = $stmt->execute();
            // check if statement was successful
            if ($result) {
                $data['status'] = 'success';
            } else {
                $data['status'] = 'failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
        }
        return $data;
    }
    function deleteProduct($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        if($inputData['action'] == 'productDelete'){
            $id = $inputData['id'];
            $sql = "UPDATE wood_product set deleted = 1 where id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $result = $stmt->execute();
            // check if statement was successful
            if ($result) {
                $data['status'] = 'success';
            } else {
                $data['status'] = 'failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
            $inputData['product_id'] = $id;
            $data['dimensions'] = deleteDimension($inputData);
            $data['images'] = deleteImage($inputData);
        }else{
            // step one get all the products that relate to the brand into a list called $products_id
            $id = $inputData['brand_id'];
            $sql = "SELECT id FROM wood_product WHERE brand_id = :brand_id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':brand_id', $inputData['id'], PDO::PARAM_INT);
            $stmt->execute();
            $products_id = $stmt->fetchAll(PDO::FETCH_ASSOC);
            // loop through the list and call deleteDimension($id) for each product
            foreach($products_id as $product){
                // delete all the dimensions that relate to the product
                $inputData['product_id'] = $product['id'];
                $data['dimensions'][] = deleteDimension($inputData);
                $data['images'][] = deleteImage($inputData);
            }

            $sql = "UPDATE wood_product set deleted = 1 where brand_id = :brand_id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':brand_id', $id, PDO::PARAM_INT);
            $result = $stmt->execute();
            // check if statement was successful
            if ($result) {
                $data['status'] = 'success';
            } else {
                $data['status'] = 'failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
        }
        
        return $data;
    }
    function deleteDimension($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        if($inputData['action'] == 'dimensionDelete'){
            $id = $inputData['id'];
            $sql = "UPDATE wood_product_dimensions set deleted = 1 where id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $result = $stmt->execute();
            // check if statement was successful
            if ($result) {
                $data['status'] = 'success';
            } else {
                $data['status'] = 'failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
            $inputData['dimensions_id'] = $id;
            $data['prices'] = deletePrice($inputData);
        }else{
            // step one get all the dimensions that relate to the product into a list called $dimensions_id
            $id = $inputData['product_id'];
            $sql = "SELECT id FROM wood_product_dimensions WHERE product_id = :product_id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':product_id', $id, PDO::PARAM_INT);
            $result = $stmt->execute();
            $idList = [];
            if ($result) { 
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) { 
                    $idList['id'][]    = $row['id'];
                }
                // loop through the list and call deletePrice($id) for each dimension
                foreach($idList as $dimension){
                    foreach($dimension as $dim){
                    // delete all the prices that relate to the dimension
                        $inputData['dimensions_id'] = $dim;
                        $data['prices'][] = deletePrice($inputData);
                    }
                }
            }
    
            $sql = "UPDATE wood_product_dimensions set deleted = 1 where product_id = :product_id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':product_id', $id, PDO::PARAM_INT);
            $result = $stmt->execute();
            // check if statement was successful
            if ($result) {
                $data['status'] = 'success';
            } else {
                $data['status'] = 'failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
        }
        
        return $data;
    }
    function deletePrice($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $id = $inputData['id'];
        $dimensions_id = $inputData['dimensions_id'] ?? null;
       if($dimensions_id){
            $sql = "UPDATE wood_product_pricing SET deleted = 1 WHERE dimensions_id = :dimensions_id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':dimensions_id', $dimensions_id, PDO::PARAM_INT);
            $result = $stmt->execute();
            // check if statement was successful
            if ($result) {
                $data['status'] = 'success';
            } else {
                $data['status'] = 'failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
        }else{
            $sql = "UPDATE wood_product_pricing SET deleted = 1 WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $result = $stmt->execute();
            // check if statement was successful
            if ($result) {
                $data['status'] = 'success';
            } else {
                $data['status'] = 'failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
    
        }
        return $data;
    }
    function deleteImage($inputData){

            $data = [];
            $pdo = $inputData['db']['dbApp'];
            if($inputData['action'] == 'imageDelete'){
                $id = $inputData['id'];
                $sql = "UPDATE wood_product_images set deleted = 1 where id = :id";
                $stmt = $pdo->prepare($sql);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                $result = $stmt->execute();
                // check if statement was successful
                if ($result) {
                    $data['status'] = 'success';
                } else {
                    $data['status'] = 'failed';
                    $data['message'] = 'Record not deleted';
                    $data['id'] = $id;
                }
            }else{
                // step one get all the images that relate to the product into a list called $images_id
                $id = $inputData['product_id'];
                $sql = "UPDATE wood_product_images set deleted = 1 where product_id = :product_id";
                $stmt = $pdo->prepare($sql);
                $stmt->bindParam(':product_id', $id, PDO::PARAM_INT);
                $result = $stmt->execute();
                // check if statement was successful
                if ($result) {
                    $data['status'] = 'success';
                } else {
                    $data['status'] = 'failed';
                    $data['message'] = 'Record not deleted';
                    $data['id'] = $id;
                }
            }
        return $data;
    }
?>
