<?php

    namespace Azui\Orbit\WoodProduct;

    // this should only be used for testing purposes
    if (defined('TEST_ENV')) {
        //require_once __DIR__ . '/../../orbit-core/src/config.php';
        // Flexible path resolution for core files
        if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "src" . DIRECTORY_SEPARATOR . "Fcors.php")) {
            require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "src" . DIRECTORY_SEPARATOR . "Fcors.php";
        } else {
            require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "Fcors.php";
        }
        // Flexible path resolution for core files
        if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "unit-test" . DIRECTORY_SEPARATOR . "scripts" . DIRECTORY_SEPARATOR . "bootstrap.php")) {
            require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "unit-test" . DIRECTORY_SEPARATOR . "scripts" . DIRECTORY_SEPARATOR . "bootstrap.php";
        } else {
            require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "unit-test" . DIRECTORY_SEPARATOR . "scripts" . DIRECTORY_SEPARATOR . "bootstrap.php";
        }
        // Flexible path resolution for core files
        if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "src" . DIRECTORY_SEPARATOR . "generic.php")) {
            require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "src" . DIRECTORY_SEPARATOR . "generic.php";
        } else {
            require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "generic.php";
        }
        $testInfo['0'] = ("\nFunction Running in Test Environment\n");
    } else {
        // this is code for live environment Dev, Uat, Production
        require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "error_monitor.php";
        require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "generic.php";
    }
    
    require_once __DIR__ . DIRECTORY_SEPARATOR . "core.php";
    require_once __DIR__ . DIRECTORY_SEPARATOR . "view.php";
    require_once __DIR__ . DIRECTORY_SEPARATOR . "insert.php";
    require_once __DIR__ . DIRECTORY_SEPARATOR . "update.php";

    $inputData =\initializeGeneric();  // ✅ Ensures fresh initialization in each test

    $inputData['requiresAdmin'] = 
        [ 
            'productUpdate'     =>  [1,2,3,4,5],          'brandCreate' => [1,2,3,4,5],     'brandUpdate'   => [1,2,3,4,5], 
            'productCreate'     =>  [1,2,3,4,5],          'brandDelete' => [1,2,3,4,5],     'productDelete' => [1,2,3,4,5],
            'dimensionDelete'   =>  [1,2,3,4,5],          'priceDelete' => [1,2,3,4,5]
        ];


    $inputData['keepLive'] = \checkLive();
    if(!isset($inputData['action']) || empty($inputData['action'])){
        $out['status']   = 'failed';
        $out['message']  = 'No Action Found';
        echo json_encode(\propagateStatusAndMessage($out));
        exit;
    }

    $action = $inputData['action'];

    // check if action need auth and if does check it valid otherwise move to swithc statments 
    $security = \SecurityCheck($inputData); // skip security for a bit 

    if($security['security'] === '1'){
        switch ($action) {
            case "brandCreate":
                $out = newBrand($inputData);
                break;
            case "productCreate":
                $out = newProduct($inputData);
                break;
            case "productBrandView":
                $out = viewPageBrands($inputData);
                break;
            case "productInfoFromBrand":
                $out = viewProductInfoFromBrand($inputData);
                break;
            case "productUpdate":
                $inputData['nextOperation']      = __NAMESPACE__ . '\contentChange';
                $inputData['type']          = 'UPDATE'; // type of change 
                $inputData['followUp']      = __NAMESPACE__ . '\\update'; // next operation to run 
                $out = executeDatabaseOperation($inputData);
                break;
            case "brandUpdate":
                $out = updateBrand($inputData);
                break;
            case "brandDelete":
                $out = deleteBrand($inputData);
                break;
            case "productDelete":
                $inputData['nextOperation']      = __NAMESPACE__ . '\contentChange';
                $inputData['type']          = 'DELETE'; // did not work as expected 
                $inputData['followUp']      = __NAMESPACE__ . '\\deleteProduct';
                $inputData['id']            = $inputData['productId'];
                $out = executeDatabaseOperation($inputData);
                //$data = deleteProduct($inputData); // revert if failes 
                break;
            /*
            case "dimensionDelete": // Not used anymore
                $out = deleteDimension($inputData);
                break;
            case "priceDelete": // Not used anymore
                $out = deletePrice($inputData);
                break;
            */
            default:
                $out = \failed($inputData);
                break;
        }
    }else{
        $out = $security;
    }

   echo json_encode(\propagateStatusAndMessage($out));
?>
