<?php
    ini_set('error_log', 'php://stderr');
    error_log("Something went wrong");

    use PHPUnit\Framework\TestCase;
    
    require_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'core' . DIRECTORY_SEPARATOR . 'unit-test' . DIRECTORY_SEPARATOR . 'scripts' . DIRECTORY_SEPARATOR . 'bootstrap.php'; // ✅ Use shared mock DB
    //require_once __DIR__ . '/../src/function.php';
    echo "\T12_WoodProductsTest.php\n";
    
    // Print list of table that exist in the database
    //$tables = $GLOBALS['mockPdo']->query("SELECT name FROM sqlite_master WHERE type='table';")->fetchAll(PDO::FETCH_COLUMN);
    //echo("\n🔍 Tables: " . implode(', ', $tables). "\n");

    class T12_WoodProductsTest extends TestCase{
        private $mockPdo;
        private static $lastModified;

        protected function setUp(): void{
            // ✅ Use the shared mock database connection
            $_SESSION = [];
            $_GET = [];
            $_POST = [];
            $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
            $_SERVER['HTTP_REFERER'] = 'http://localhost/test';
            $this->mockPdo = $GLOBALS['mockPdo'];
            if (session_status() !== PHP_SESSION_ACTIVE) {
                if (session_status() !== PHP_SESSION_ACTIVE && !headers_sent()) {
                    session_start();
                }
            }
        }
        private function executeFunctionPhp(): array {
            ob_start();
        // Flexible path resolution for module function.php
        if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php')) {
            require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php';
        } else {
            require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'function.php';
        }
        $output = ob_get_clean();
            
            // ✅ Ensure only valid JSON output
            $decodedOutput = json_decode($output, true);
            if (json_last_error() !== JSON_ERROR_NONE) {
                throw new Exception("Invalid JSON output: " . json_last_error_msg() . "\nOutput: " . $output);
            }
        
            return [$output, $decodedOutput];
        }
        public function test001DummyTest(): void{
            $this->assertTrue(true);
        }
        public function test002FakeCall(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action' => 'fakeCall',
                'debug' => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);  
        }
        public function test003BrandCreateSuccess(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action' => 'brandCreate',
                'brandName' => 'Test Brand',
                'brandImg' => 'path/to/image.jpg',
                'viewProductInfo' => 'Some info',
                'viewProductDetails' => 'Some details',
                'debug' => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);  


            $stmt = $this->mockPdo->prepare("SELECT * FROM wood_brands WHERE brand_name = 'Test Brand'");
            $stmt->execute();
            $brand = $stmt->fetch(PDO::FETCH_ASSOC);
            //echo print_r($brand);
            $this->assertNotFalse($brand, "Brand was not found in the database.");
            $this->assertEquals('Test Brand', $brand['brand_name']);
            $this->assertEquals('0', $brand['deleted']);
        }
        public function test004BrandCreateDuplicate(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action' => 'brandCreate',
                'brandName' => 'Test Brand', // Same name to trigger duplicate
                'brandImg' => 'path/to/image.jpg',
                'viewProductInfo' => 'Some info',
                'viewProductDetails' => 'Some details',
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Brand already exists', $decodedOutput['message']);
        }
        public function test005BrandCreateSecondSuccess(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action' => 'brandCreate',
                'brandName' => 'Another Test Brand', // Different name
                'brandImg' => 'path/to/image2.jpg',
                'viewProductInfo' => 'Some info',
                'viewProductDetails' => 'Some details',
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
        }
        // Brand Id 1 and 2 should now exist from previous tests
        public function test006ViewProductBrandViewFailNotAdminOrEnabled(): void{
            $_POST = [
                'action' => 'productBrandView',
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('No content found', $decodedOutput['message']);
        }
        public function test007ViewProductBrandViewAdmin(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action' => 'productBrandView',
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertGreaterThanOrEqual(2, count($decodedOutput['brand']));
        }
        public function test008ViewProductBrandViewEnabled(): void{

            $stmt = $this->mockPdo->prepare("UPDATE wood_brands SET enable = 1 WHERE id in (1, 2)");
            $stmt->execute();

            $_POST = [
                'action' => 'productBrandView',
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            // Enable brand id 1
            $stmt = $this->mockPdo->prepare("UPDATE wood_brands SET enable = 1 WHERE id = 1");
            $stmt->execute();

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertGreaterThanOrEqual(2, count($decodedOutput['brand']));

            $stmt = $this->mockPdo->prepare("UPDATE wood_brands SET enable = 0 WHERE id in (1, 2)");
            $stmt->execute();
        }
        public function test009UpdateProductBrandNoAuth(): void{
            $_POST = [
                'action' => 'brandUpdate',
                'id' => 1,
                'enable' => 1,
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
        }
        public function test010UpdateProductBrandInvalidId(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action' => 'brandUpdate',
                'id' => 999, // Non-existent ID
                'enable' => 1,
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('ID does not exist', $decodedOutput['message']);
        }
        public function test011UpdateProductBrand(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action' => 'brandUpdate',
                'id' => 1,
                'enable' => 1,
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);

            $stmt = $this->mockPdo->prepare("SELECT * FROM wood_brands WHERE id = 1");
            $stmt->execute();
            $brand = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertEquals('1', $brand['enable']);
        }
        public function test012UpdateProductBrandAllFields(): void{
            $stmst = $this->mockPdo->prepare("select * from wood_brands where id = 1");
            $stmst->execute();
            $originalBrand = $stmst->fetch(PDO::FETCH_ASSOC);
            // Debug output
            //echo print_r($originalBrand); // or var_dump($originalBrand)
            $this->assertNotFalse($originalBrand, "Original brand not found for comparison.");
            $this->assertEquals('1', $originalBrand['enable']);
            $this->assertEquals('Test Brand', $originalBrand['brand_name']);
            $this->assertEquals('path/to/image.jpg', $originalBrand['brand_img']);
            $this->assertEquals('Test Brand', $originalBrand['brand_folder']);
            $this->assertEquals('Some info', $originalBrand['view_product_info']);
            $this->assertEquals('Some details', $originalBrand['view_product_details']);
            $this->assertEquals('0', $originalBrand['deleted']);
            $this->assertEquals('1', $originalBrand['enable']);
            $this->assertEquals('1', $originalBrand['order']);

            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action' => 'brandUpdate',
                'id' => 1,
                'brandName' => 'Updated Brand Name',
                'brandImg' => 'new/path/to/image.jpg',
                'viewProductInfo' => 'Updated info',
                'viewProductDetails' => 'Updated details',
                'enable' => 0,
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);

            $stmt = $this->mockPdo->prepare("SELECT * FROM wood_brands WHERE id = 1");
            $stmt->execute();
            $brand = $stmt->fetch(PDO::FETCH_ASSOC);
            // Debug output
            //echo print_r($brand); // or var_dump($brand)
            $this->assertEquals('Updated Brand Name', $brand['brand_name']);
            $this->assertEquals('new/path/to/image.jpg', $brand['brand_img']);
            $this->assertEquals('Updated info', $brand['view_product_info']);
            $this->assertEquals('Updated details', $brand['view_product_details']);
            $this->assertEquals('0', $brand['enable']);
        }
        // not implemented yet
            /*
            public function test013UpdateProductBrandChangeOrder(): void{
                $_SESSION['id'] = 5;     
                $_SESSION['roleValue'] = 1;
                $_POST = [
                    'action' => 'brandUpdate',
                    'id' => 1,
                    'order' => 2,
                    'debug' => 'CSD' // Add debug flag to the request
                ];  
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);

                $stmt = $this->mockPdo->prepare("SELECT * FROM wood_brands WHERE id = 1");
                $stmt->execute();
                $brand = $stmt->fetch(PDO::FETCH_ASSOC);
                $this->assertEquals('2', $brand['order']);
            }
            */
        //
        public function test014DeleteProductBrandNoId(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action' => 'brandDelete',
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('ID does not exist', $decodedOutput['message']);
        }
        public function test015DeleteProductBrandNonExistentId(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action' => 'brandDelete',
                'id' => 999, // Non-existent ID
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('ID does not exist', $decodedOutput['message']);
        }
        public function test016DeleteProductBrandRoleNotAllowed(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 9;
            $_POST = [
                'action' => 'brandDelete',
                'id' => 1,
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test017DeleteProductBrandNoRole(): void{
            $_SESSION['id'] = 5;     
            $_POST = [
                'action' => 'brandDelete',
                'id' => 1,
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test018DeleteProductBrand(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action' => 'brandDelete',
                'id' => 1,
                'debug' => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);

            $stmt = $this->mockPdo->prepare("SELECT * FROM wood_brands WHERE id = 1");
            $stmt->execute();
            $brand = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertEquals('1', $brand['deleted']);
        }
        public function test019AProductCreateSuccess(): void{
            $stmt = $this->mockPdo->prepare("SELECT count(*) as count FROM wood_product");
            $stmt->execute();
            $product = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertEquals('0', $product['count']);

            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productCreate',
                'brandId'       => 1,
                'decoreCode'    => 'Test Product',
                'decoreName'    => 'This is a test product.',
                'decoreGroup'   => 'Group A',
                'core'          => 'Core A',
                'images'        => [
                    0 => [
                        'imageLocation' => 'path/to/',
                        'imagePath'     => 'u11.jpg',
                    ],
                    1 => [
                        'imageLocation' => 'path/to/',
                        'imagePath'     => 'u12.jpg',
                    ],
                ],
                'dimensions'    => [
                    0 => [
                        'width'     => 100,
                        'length'    => 200,
                        'price'     => [
                            0 => [
                                'thickness' => 10,
                                'price'     => 15.5
                            ],
                            1 => [
                                'thickness' => 12,
                                'price'     => 17.0
                            ]
                        ]
                    ],
                    1 => [
                        'width'     => 150,
                        'length'    => 250,
                        'price'     => [
                            0 => [
                                'thickness' => 10,
                                'price'     => 15.5
                            ],
                            1 => [
                                'thickness' => 12,
                                'price'     => 17.0
                            ]
                        ]
                    ]
                ],
                'debug'         => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
        }
        public function test019BProductCreateSuccess(): void{
            $stmt = $this->mockPdo->prepare("SELECT count(*) as count FROM wood_product");
            $stmt->execute();
            $product = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertEquals('1', $product['count']);

            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productCreate',
                'brandId'       => 1,
                'decoreCode'    => 'Test Product 2',
                'decoreName'    => 'This is a test product 2.',
                'decoreGroup'   => 'Group A',
                'core'          => 'Plywood',
                'images'        => [
                    0 => [
                        'imageLocation' => 'path/to/',
                        'imagePath'     => 'u11.jpg',
                    ],
                    1 => [
                        'imageLocation' => 'path/to/',
                        'imagePath'     => 'u12.jpg',
                    ],
                ],
                'dimensions'    => [
                    0 => [
                        'width'     => 100,
                        'length'    => 200,
                        'price'     => [
                            0 => [
                                'thickness' => 10,
                                'price'     => 15.5
                            ],
                            1 => [
                                'thickness' => 12,
                                'price'     => 17.0
                            ]
                        ]
                    ],
                    1 => [
                        'width'     => 150,
                        'length'    => 250,
                        'price'     => [
                            0 => [
                                'thickness' => 10,
                                'price'     => 15.5
                            ],
                            1 => [
                                'thickness' => 12,
                                'price'     => 17.0
                            ]
                        ]
                    ]
                ],
                'debug'         => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
        }
        public function test019CProductCreateSuccess(): void{
            $stmt = $this->mockPdo->prepare("SELECT count(*) as count FROM wood_product");
            $stmt->execute();
            $product = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertEquals('2', $product['count']);

            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productCreate',
                'brandId'       => 1,
                'decoreCode'    => 'Test Product 3',
                'decoreName'    => 'This is a test product 3.',
                'decoreGroup'   => 'Group A',
                'core'          => 'MDF',
                'images'        => [
                    0 => [
                        'imageLocation' => 'path/to/',
                        'imagePath'     => 'u11.jpg',
                    ],
                    1 => [
                        'imageLocation' => 'path/to/',
                        'imagePath'     => 'u12.jpg',
                    ],
                ],
                'dimensions'    => [
                    0 => [
                        'width'     => 100,
                        'length'    => 200,
                        'price'     => [
                            0 => [
                                'thickness' => 10,
                                'price'     => 15.5
                            ],
                            1 => [
                                'thickness' => 12,
                                'price'     => 17.0
                            ]
                        ]
                    ],
                    1 => [
                        'width'     => 150,
                        'length'    => 250,
                        'price'     => [
                            0 => [
                                'thickness' => 10,
                                'price'     => 15.5
                            ],
                            1 => [
                                'thickness' => 12,
                                'price'     => 17.0
                            ]
                        ]
                    ]
                ],
                'debug'         => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
        }
        public function test020ProductCreateMissingBrandId(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productCreate',
                // Missing brandId and decoreCode
                'decoreName'    => 'This is a test product.',
                'decoreGroup'   => 'Group A',
                'core'          => 'Core A',
                'debug'         => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Brand ID is required to create a new product.', $decodedOutput['message']);
        }
        public function test021ProductCreateMissingFields(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productCreate',
                'brandId'       => 1,
                'decoreName'    => 'This is a test product.',
                'decoreGroup'   => 'Group A',
                'core'          => 'Core A',
                'debug'         => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Invalid or missing dimensions data. | Invalid or missing image data.', $decodedOutput['message']);
        }
        public function test022ProductUserNotLoggedIn(): void{
            $_POST = [
                'action'        => 'productCreate',
                'debug'         => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('User is not logged in', $decodedOutput['message']);
        }
        public function test023ProductUserNoRole(): void{
            $_SESSION['id'] = 5;     
            $_POST = [
                'action'        => 'productCreate',
                'debug'         => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test024ProductUserRoleNotAllowed(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 9;
            $_POST = [
                'action'        => 'productCreate',
                'debug'         => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test025ProductViewMisingBrandId(): void{
            $_POST = [
                'action'        => 'productInfoFromBrand',
                'debug'         => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('No Brand ID Found', $decodedOutput['message']);
        }
        public function test026ProductViewFromBrand(): void{
            $_POST = [
                'action'        => 'productInfoFromBrand',
                'brandId'       => 18,
                'debug'         => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);   
            $this->assertEquals('No content found', $decodedOutput['message']);
        }
        public function testStmt001(): void{
            $stmt = $this->mockPdo->prepare("SELECT * FROM wood_product WHERE brand_id = 1");
            $stmt->execute();
            $products = $stmt->fetchAll(PDO::FETCH_ASSOC);
            // Debug output
            //echo print_r($products); // or var_dump($products)
            $this->assertGreaterThanOrEqual(3, count($products), "Expected at least 3 products for brand_id 1.");

            $stmt = $this->mockPdo->prepare("SELECT * FROM wood_product_dimensions WHERE product_id in (1,2,3,4)");
            $stmt->execute();
            $dimensions = $stmt->fetchAll(PDO::FETCH_ASSOC);
            // Debug output
            //echo print_r($dimensions); // or var_dump($dimensions)
            $this->assertGreaterThanOrEqual(4, count($dimensions), "Expected at least 4 dimensions for products 1,2,3,4.");

            $stmt = $this->mockPdo->prepare("SELECT id as price_id, dimensions_id, thickness, price, deleted, last_updated FROM wood_product_pricing");
            $stmt->execute();
            $pricing = $stmt->fetchAll(PDO::FETCH_ASSOC);
            // Debug output
            //echo print_r($pricing); // or var_dump($pricing)
        }
        public function test027ProductViewFromBrandSuccess(): void{ // uses this to see products info for brand 1
            $_POST = [
                'action'        => 'productInfoFromBrand',
                'brandId'       => 1,
                //'debug'         => 'CSD' // Add debug flag to the request
            ];  
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);   
            //$this->assertGreaterThanOrEqual(3, count($decodedOutput['products']));
        }  
        public function test028ProductUpdate(): void{
            $stmt = $this->mockPdo->prepare("SELECT * FROM wood_product WHERE id = 1");
            $stmt->execute();
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertEquals(1, $result['id']);
            $this->assertEquals('This is a test product.', $result['decor_name']);

            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => 1,
                'decorName'     => 'Updated Product Name',
                'debug'         => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $stmt = $this->mockPdo->prepare("SELECT * FROM wood_product WHERE id = 1");
            $stmt->execute();
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertEquals('Updated Product Name', $result['decor_name']);

            $stmt = $this->mockPdo->prepare("SELECT * FROM wood_product_history");
            $stmt->execute();
            // Debug output
            //echo print_r($stmt->fetchAll(PDO::FETCH_ASSOC)); // or var_dump($decodedOutput)
            $history = $stmt->fetchAll(PDO::FETCH_ASSOC);
            $this->assertGreaterThanOrEqual(1, count($history), "No history record found after product update.");
        }
        public function test029ProductUpdateNoChanges(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => 1,
                'debug'         => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('No data to update', $decodedOutput['message']);
        }
        public function test030ProductUpdateNoAuth(): void{
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => 1,
                'decorName'     => 'Updated Product Name',
                'debug'         => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('User is not logged in', $decodedOutput['message']);
        }
        public function test031ProductUpdateNoRole(): void{
            $_SESSION['id'] = 5;     
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => 1,
                'decorName'     => 'Updated Product Name',
                'debug'         => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Access denied: insufficient permissions', $decodedOutput['message']);
        }  
        public function test032ProductUpdateRoleNotAllowed(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 9;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => 1,
                'decorName'     => 'Updated Product Name',
                'debug'         => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Access denied: insufficient permissions', $decodedOutput['message']);
        } 
        public function test033ProductPriceDelete(): VOID{
            // row count of prices before
            $stmt = $this->mockPdo->prepare("SELECT count(*) as count FROM wood_product_pricing where deleted = 0");
            $stmt->execute();
            $rowCount = $stmt->fetchColumn();

            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '1',
                        'length'    => '200',
                        'width'     => '100',
                        'price'     => [
                            1 => [
                                'id'        => '2',
                                'price'     => '17',
                                'thickness' => '12'
                            ]
                        ]
                    ],
                    1 => [
                        'id'        => '2',
                        'length'    => '250',
                        'width'     => '150',
                        'price'    => [
                            0 => [
                                'id'        => '3',
                                'price'     => '15.5',
                                'thickness' => '10'
                            ],
                            1 => [
                                'id'        => '4',
                                'price'     => '17',
                                'thickness' => '12'
                            ]
                        ]
                    ],
                ],
                'priceDelete'   => [
                    0 => [
                        'id'    => '1'
                    ]
                ],
                'debug'         => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);

            // row count of prices after
            $stmt = $this->mockPdo->prepare("SELECT count(*) as count FROM wood_product_pricing where deleted = 0");
            $stmt->execute();
            $rowCountAfter = $stmt->fetchColumn();
            // Debug output
            //echo "Row count before: $rowCount, Row count after: $rowCountAfter";
            $this->assertEquals($rowCount - 1, $rowCountAfter);
        }
        public function test034ProductPriceDeleteInvalidId(): VOID{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '1',
                        'length'    => '200',
                        'width'     => '100',
                        'price'     => [
                            1 => [
                                'id'        => '2',
                                'price'     => '17',
                                'thickness' => '12'
                            ]
                        ]
                    ],
                ],
                'priceDelete'   => [
                    0 => [
                        'id'    => '999' // Invalid ID
                    ]
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Price ID 999 does not exist', $decodedOutput['message']);
        }
        public function test035ProductPriceDeleteMissingId(): VOID{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '1',
                        'length'    => '200',
                        'width'     => '100',
                        'price'     => [
                            1 => [
                                'id'        => '2',
                                'price'     => '17',
                                'thickness' => '12'
                            ]
                        ]
                    ],
                ],
                'priceDelete'   => [
                    0 => []
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('No Price ID Found for deletion', $decodedOutput['message']);
        }
        public function test036ProductDimensionsDelete(): VOID{
            // row count of dimensions before
            $stmt = $this->mockPdo->prepare("SELECT count(*) as count FROM wood_product_dimensions where deleted = 0");
            $stmt->execute();
            $rowCount = $stmt->fetchColumn();

            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '2',
                        'length'    => '250',
                        'width'     => '150',
                        'price'    => [
                            0 => [
                                'id'        => '3',
                                'price'     => '15.5',
                                'thickness' => '10'
                            ],
                            1 => [
                                'id'        => '4',
                                'price'     => '17',
                                'thickness' => '12'
                            ]
                        ]
                    ],
                ],
                'dimensionsDelete'   => [
                    0 => [
                        'id'    => '1'
                    ]
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);

            // row count of prices after
            $stmt = $this->mockPdo->prepare("SELECT count(*) as count FROM wood_product_dimensions where deleted = 0");
            $stmt->execute();
            $rowCountAfter = $stmt->fetchColumn();
            // Debug output
            //echo "Row count before: $rowCount, Row count after: $rowCountAfter";
            $this->assertEquals($rowCount - 1, $rowCountAfter);
        }
        public function test037ProductDimensionsDeleteInvalidId(): VOID{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '2',
                        'length'    => '250',
                        'width'     => '150',
                        'price'    => [
                            0 => [
                                'id'        => '3',
                                'price'     => '15.5',
                                'thickness' => '10'
                            ],
                            1 => [
                                'id'        => '4',
                                'price'     => '17',
                                'thickness' => '12'
                            ]
                        ]
                    ],
                ],
                'dimensionsDelete'   => [
                    0 => [
                        'id'    => '999' // Invalid ID
                    ]
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Dimension ID 999 does not exist', $decodedOutput['message']);
        }
        public function test038ProductDimensionsDeleteMissingId(): VOID{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '2',
                        'length'    => '250',
                        'width'     => '150',
                        'price'    => [
                            0 => [
                                'id'        => '3',
                                'price'     => '15.5',
                                'thickness' => '10'
                            ],
                            1 => [
                                'id'        => '4',
                                'price'     => '17',
                                'thickness' => '12'
                            ]
                        ]
                    ],
                ],
                'dimensionsDelete'   => [
                    0 => []
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('No Dimension ID Found for deletion', $decodedOutput['message']);
        }
        public function test039ProductImageDelete(): VOID{
            // row count of images before
            $stmt = $this->mockPdo->prepare("SELECT count(*) as count FROM wood_product_images where deleted = 0");
            $stmt->execute();
            $rowCount = $stmt->fetchColumn();

            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'images'        => [
                    0 => [
                        'id'            => '2',
                        'imageLocation' => 'path/to/',
                        'imagePath'     => 'u12.jpg',
                    ],
                ],
                'imagesDelete'   => [
                    0 => [
                        'id'    => '1'
                    ]
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);

            // row count of images after
            $stmt = $this->mockPdo->prepare("SELECT count(*) as count FROM wood_product_images where deleted = 0");
            $stmt->execute();
            $rowCountAfter = $stmt->fetchColumn();
            // Debug output
            //echo "Row count before: $rowCount, Row count after: $rowCountAfter";
            $this->assertEquals($rowCount - 1, $rowCountAfter);
        }
        public function test040ProductImageDeleteInvalidId(): VOID{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'images'        => [
                    0 => [
                        'id'            => '2',
                        'imageLocation' => 'path/to/',
                        'imagePath'     => 'u12.jpg',
                    ],
                ],
                'imagesDelete'   => [
                    0 => [
                        'id'    => '999' // Invalid ID
                    ]
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Image ID 999 does not exist', $decodedOutput['message']);
        }
        public function test041ProductImageDeleteMissingId(): VOID{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'images'        => [
                    0 => [
                        'id'            => '2',
                        'imageLocation' => 'path/to/',
                        'imagePath'     => 'u12.jpg',
                    ],
                ],
                'imagesDelete'   => [
                    0 => []
                ]
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('No Image ID Found for deletion', $decodedOutput['message']);
        }
        public function test042ProductImageEdit(): VOID{
            $stmt = $this->mockPdo->prepare("SELECT count(*) FROM wood_product_images");
            $stmt->execute();
            $rowCount = $stmt->fetchColumn();

            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'images'        => [
                    0 => [
                        'imagePath'     => 'u12_updated.jpg',
                        'imageLocation' => 'new/path/to/',
                    ],
                ],
                'imagesEdit'    => [
                    0 => [
                        'imagePath'     => 'u15_updated.jpg',
                        'imageLocation' => 'new/path/to/',
                    ],
                ],
                     
                'debug'         => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);

            $stmt = $this->mockPdo->prepare("SELECT count(*) FROM wood_product_images");
            $stmt->execute();
            $rowCountAfter = $stmt->fetchColumn();
            $this->assertEquals($rowCount + 1, $rowCountAfter);

        }
        public function test043ProductImageEditMissingData(): VOID{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'images'        => [
                    0 => [
                        'imagePath'     => 'u12_updated.jpg',
                        'imageLocation' => 'new/path/to/',
                    ],
                ],
                'imagesEdit'    => [
                    0 => [
                        // Missing imagePath and imageLocation
                    ],
                ],
                     
                'debug'         => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Missing imagePath or imageLocation.', $decodedOutput['message']);
        }
        public function test044ProductDimensionsEdit(): VOID{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '2',
                        'length'    => '300', // Updated length
                        'width'     => '150',
                        'price'    => [
                            0 => [
                                'id'        => '3',
                                'price'     => '16.0', // Updated price
                                'thickness' => '10'
                            ],
                            1 => [
                                'id'        => '4',
                                'price'     => '18.0', // Updated price
                                'thickness' => '12'
                            ]
                        ]
                    ],
                ],
                     
                'debug'         => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);

            // Check if the dimensions were updated correctly
            $stmt = $this->mockPdo->prepare("SELECT `length`, `width` FROM wood_product_dimensions WHERE id = 2");
            $stmt->execute();
            $dimension = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertEquals('300', $dimension['length']);
            $this->assertEquals('150', $dimension['width']);

            $stmt = $this->mockPdo->prepare("SELECT `price` FROM wood_product_pricing WHERE id = 3");
            $stmt->execute();
            $price = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertEquals('16.0', $price['price']);

            $stmt = $this->mockPdo->prepare("SELECT `price` FROM wood_product_pricing WHERE id = 4");
            $stmt->execute();
            $price = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertEquals('18.0', $price['price']);
        }
        public function test045ProductDimentionEditAdd(): VOID{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '2',
                        'length'    => '300',
                        'width'     => '150',
                        'price'    => [
                            0 => [
                                'id'        => '3',
                                'price'     => '16.0',
                                'thickness' => '10'
                            ],
                            1 => [
                                'id'        => '4',
                                'price'     => '18.0',
                                'thickness' => '12'
                            ]
                        ]
                    ],
                    1 => [
                        'length'    => '350',
                        'width'     => '175'
                    ],
                ],
                'debug'         => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
        }
        public function test046ProductDimensionsEditMissingData(): VOID{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '2',
                        // Missing length and width
                        'price'    => [
                            0 => [
                                'id'        => '3',
                                'price'     => '16.0', // Updated price
                                'thickness' => '10'
                            ],
                            1 => [
                                'id'        => '4',
                                'price'     => '18.0', // Updated price
                                'thickness' => '12'
                            ]
                        ]
                    ],
                ],
                     
                'debug'         => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('No fields or missing fields to update for Dimension ID 2', $decodedOutput['message']);
        }
        public function test047ProductDimensionsEditMissingData(): VOID{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '2',
                        'length'    => '300',
                        'price'    => [
                            0 => [
                                'id'        => '3',
                                'price'     => '16.0', // Updated price
                                'thickness' => '10'
                            ],
                            1 => [
                                'id'        => '4',
                                'price'     => '18.0', // Updated price
                                'thickness' => '12'
                            ]
                        ]
                    ],
                ],
                     
                'debug'         => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Both length and width must be provided for Dimension ID 2', $decodedOutput['message']);
        }
        public function test048ProductDimensionsEditPriceMissingData(): VOID{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '2',
                        'length'    => '300',
                        'width'     => '150',
                        'price'    => [
                            0 => [
                                'id'        => '3',
                                // Missing price
                                'thickness' => '10'
                            ],
                            1 => [
                                'id'        => '4',
                                'price'     => '22.0', // Updated price
                                'thickness' => '12'
                            ]
                        ]
                    ],
                ],
                     
                'debug'         => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Both thickness and price must be provided for Price ID 3', $decodedOutput['message']);
        }
        public function test049ProductDimensionsEditPriceAndThicknessMissingData(): VOID{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '2',
                        'length'    => '300',
                        'width'     => '150',
                        'price'    => [
                            0 => [
                                'id'        => '4',
                                'price'     => '22.0', // Updated price
                                'thickness' => '12'
                            ],
                            1 => [
                                'id'        => '3',
                                // Missing price and thickness
                            ]
                        ]
                    ],
                ],
                     
                'debug'         => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('No fields or missing fields to update for Price ID 3', $decodedOutput['message']);

            $stmt = $this->mockPdo->prepare("SELECT `price` FROM wood_product_pricing WHERE id = 4");
            $stmt->execute();
            $price = $stmt->fetch(PDO::FETCH_ASSOC);
            $this->assertEquals('18.0', $price['price']);

        }
        public function test050ProductUpdateInvalidProductId(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '999',
                'dimensions'    => [
                    0 => [
                        'id'        => '2',
                        'length'    => '300',
                        'width'     => '150',
                        'price'    => [
                            0 => [
                                'id'        => '4',
                                'price'     => '22.0',
                                'thickness' => '12'
                            ],
                        ]
                    ],
                ],
                     
                'debug'         => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Product ID does not exist', $decodedOutput['message']);
        }
        public function test051ProductUpdateProductIdAndDimensionsMissmatch(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '3', // Dimension ID 3 does not belong to Product ID 1
                        'length'    => '300',
                        'width'     => '150',
                        'price'    => [
                            0 => [
                                'id'        => '4',
                                'price'     => '22.0',
                                'thickness' => '12'
                            ],
                        ]
                    ],
                ],
                     
                'debug'         => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Dimension ID 3 does not exist for Product ID 1', $decodedOutput['message']);
        }
        public function test052ProductUpdateDimensionsAndPricesMissmatch(): void{
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productUpdate',
                'productId'     => '1',
                'dimensions'    => [
                    0 => [
                        'id'        => '2',
                        'length'    => '300',
                        'width'     => '150',
                        'price'    => [
                            0 => [
                                'id'        => '999', // Price ID 999 does not belong to Dimension ID 2
                                'price'     => '22.0',
                                'thickness' => '12'
                            ],
                        ]
                    ],
                ],
                     
                'debug'         => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Price ID 999 does not exist for Dimensions ID 2', $decodedOutput['message']);
        }
        public function test053ProductDeleteNotExistent() : void {
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1;
            $_POST = [
                'action'        => 'productDelete',
                'productId'     => '999', // Non-existent Product ID
                'debug'         => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Product ID does not exist', $decodedOutput['message']);
        }
        public function test054ProductDeleteNotLoggedIn() : void {
            // No user logged in
            $_POST = [
                'action'        => 'productDelete',
                'productId'     => '1',
                'debug'         => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('User is not logged in', $decodedOutput['message']);
        }
        public function test055ProductDeleteInsufficientPermissions() : void {
            // User with insufficient permissions
            $_SESSION['id'] = 6;     
            $_SESSION['roleValue'] = 999; // Assuming roleValue 999 does not have delete permissions
            $_POST = [
                'action'        => 'productDelete',
                'productId'     => '1',
                'debug'         => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Access denied: insufficient permissions', $decodedOutput['message']);
        }
        public function test056ProductDeleteSuccess() : void {
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1; // Assuming roleValue 1 has delete permissions
            $_POST = [
                'action'        => 'productDelete',
                'productId'     => '1',
                'debug'         => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
        }
        public function test057ProductDeleteAlreadyDeleted() : void {
            $_SESSION['id'] = 5;     
            $_SESSION['roleValue'] = 1; // Assuming roleValue 1 has delete permissions
            $_POST = [
                'action'        => 'productDelete',
                'productId'     => '1', // Product ID 1 was deleted in the previous test
                'debug'         => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('Product ID does not exist', $decodedOutput['message']);
        }
}

?>