# Frontend API Interface Specification

---

## Overview
This document outlines the frontend API contract required to interact with the backend PHP application. All operations are triggered via a single endpoint (function.php) using POST or GET requests, with the action defined in the action field. Role-based access is enforced via session variables.

---

## Role Definitions

```sql
INSERT INTO `user_role` (`pk_role_id`, `role_name`, `scope`) VALUES
(1, "SystemAdmin", "Platform"),
(2, "SupportAgent", "Platform"),
(3, "ContentModerator", "Platform"),
(4, "BusinessOwner", "Tenant"),
(5, "BusinessManager", "Tenant"),
(6, "Staff", "Tenant"),
(7, "Operator", "Tenant"),
(8, "Customer", "Public");
```

## API Summary Table

| Action                    | Method | Required Role    | Description                                                                                           |
|---------------------------|--------|------------------|-------------------------------------------------------------------------------------------------------|
| [`brandCreate`](#brandCreate)             | POST   |  1,2,3,4,5       | Create a new brand                                                                                    |
| [`productCreate`](#productCreate)           | POST   |  1,2,3,4,5       |                                                                                                       |
| [`productUpdate`](#productUpdate)           | GET    |  1,2,3,4,5       |                                                                                                       |
| [`brandUpdate`](#brandUpdate)             | POST   |  1,2,3,4,5       |                                                                                                       |
| [`brandDelete`](#brandDelete)             | POST   |  1,2,3,4,5       |                                                                                                       |
| [`productDelete`](#productDelete)           | POST   |  1,2,3,4,5       |                                                                                                       |
| [`productBrandView`](#productBrandView)        | GET    |  1,2,3,4,5 View  | Logged in will show all data otherwise only enabled, pass last modifed value to check if latest data  |
| [`productInfoFromBrand`](#productInfoFromBrand)    | POST   |  1,2,3,4,5       |                                                                                                       |



<a id="brandCreate"></a>
### `brandCreate`
```json
    "action"                : "brandCreate",
    "brandName"             : "string",
    "brandImg"              : "string" (Path For Azure Image),
    "viewProductInfo"       : "string",
    "viewProductDetails"    : "string"
```

<a id="productBrandView"></a>
### `productBrandView`
```json
    "action"            :   "productBrandView"
    "lastModified"      :   "dateTime" optional,
```

<a id="productInfoFromBrand"></a>
### `productInfoFromBrand`
```json
    "action"                : "productInfoFromBrand",
    "brandId"               : int,
```

<a id="brandUpdate"></a>
### `brandUpdate`

```json
    "action"                :"brandUpdate"
    "id"                    : int,
    "enable"                : int,      //optional [0|1]
    "brandName"             : "string", //optional, 
    "brandImg"              : "string", //optional, 
    "viewProductInfo"       : "string", //optional, 
    "viewProductDetails"    : "string"  //optional, 
```

<a id="brandDelete"></a>
### `brandDelete`
```json
    "action"            : "brandDelete",
    "id"                : int
```

<a id="productDelete"></a>
### `productDelete`
```json
    "action"            : "productDelete",
    "id"                : int
```

<a id="productCreate"></a>
### `productCreate`
```json
    "action"            : "productCreate",
    "brandId"           :  int,
    "decoreCode"        : "string",
    "decoreName"        : "string",
    "decoreGroup"       : "string",
    "core"              : "string",
    "images"            : [
        [
            "imageLocation" :   "string",
            "imagePath"     :   "string",
        ],
        [
            "imageLocation" :   "string",
            "imagePath"     :   "string",
        ]
    ],
    "dimensions"        : [
        [
            "width"         :    int,
            "length"        :    int,
            "price"         :    [
                [
                    "thickness"         : int,
                    "price"             : float
                ],
                [
                    ...
                ]
            ]
        ],
        [
            ...
        ]
    ]
```


<a id="productUpdate"></a>
### `productUpdate`
```json
    "action"            : "productUpdate",
    "id"                :  int,
    "enablebrandName"   : "string",  //optional, 
    "brandImg"          : "string",  //optional, 
    "brandOrder"        :  int,      //optional, not implemented
    "enable"            :  int,      //optional,
    "viewProductInfo"   : "string",  //optional,
    "viewProductDetails": "string",  //optional
    "dimensions"        : [ // needs to be included if there is a deletion to "priceDelete" or "dimensionsDelete" is used or if there is an update to a dimensions value that pre exist at any level within the []
        [
            "id"    :   "string",
            "lenght":   "string",
            "width" :   "string",
            "price": [
                [
                "id"        : "string",
                "price"     : "string",
                "thickness" : "string",
                ],
                [
                    ... // Don't included if deleting pass id into priceDelete array set
                ]
            ],
            [
                ... // Don't included if deleting pass id into dimensionsDelete array set
            ],
        ]
    ],
    "images": [ // needs to be included if there is a deletion to "imagesDelete" or "imagesEdit" is used
        [
            "id"            : "string",     // optional on image edit (New image added)
            "no"            : "string"      // optional on image edit (New image added)
            "imagePath"     : "string",
            "imageLocation" : "string"
        ],
        [
            ... // Don't included if deleting pass id into dimensionsDelete array set
        ]
    ],
    "priceDelete"       : [ //optional
        [
            "id"    : "string"
        ],
        [
            ...
        ]
    ],
    "dimensionsDelete"  : [ // optional
        [
            "id"  : "string"
        ],
        [
            ...
        ]
    ],
    "imagesDelete"      : [ // optional
        [
            "id"    : "string"
        ],
        [
            ...
        ]
    ],
    "imagesEdit"        : [ // optional
        [
            "imagePath"     : "string",
            "imageLocation" : "string",
        ],
        [
            ...
        ]
    ],

```