/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.jetty.ee9.nested.ContextHandler;
import org.eclipse.jetty.ee9.nested.Request;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.InputStreamContentSource;
import org.eclipse.jetty.server.Components;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.URIUtil;

public class ServletCoreRequest
implements org.eclipse.jetty.server.Request {
    private final HttpServletRequest _servletRequest;
    private final ContextHandler.CoreContextRequest _coreContextRequest;
    private final HttpFields _httpFields;
    private final HttpURI _uri;
    private final Attributes _attributes;
    private final boolean _wrapped;
    private Content.Source _source;

    public org.eclipse.jetty.server.Request wrap(HttpServletRequest httpServletRequest) {
        Request baseRequest = Objects.requireNonNull(Request.getBaseRequest(httpServletRequest));
        ContextHandler.CoreContextRequest coreContextRequest = baseRequest.getCoreRequest();
        return new ServletCoreRequest(coreContextRequest, httpServletRequest, coreContextRequest);
    }

    ServletCoreRequest(ContextHandler.CoreContextRequest coreContextRequest, HttpServletRequest request, Attributes attributes) {
        this._servletRequest = request;
        this._wrapped = !(request instanceof org.eclipse.jetty.server.Request);
        this._coreContextRequest = coreContextRequest;
        this._attributes = attributes;
        HttpFields.Mutable fields = HttpFields.build();
        Enumeration<String> headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            Enumeration<String> headerValues = request.getHeaders(headerName);
            while (headerValues.hasMoreElements()) {
                String headerValue = headerValues.nextElement();
                fields.add(new HttpField(headerName, headerValue));
            }
        }
        this._httpFields = fields.asImmutable();
        String includedServletPath = (String)request.getAttribute("jakarta.servlet.include.servlet_path");
        boolean included = includedServletPath != null;
        HttpURI.Mutable builder = HttpURI.build();
        builder.scheme(request.getScheme()).authority(request.getServerName(), request.getServerPort());
        if (request.getDispatcherType() != DispatcherType.REQUEST) {
            builder.path(URIUtil.addEncodedPaths(request.getContextPath(), URIUtil.encodePath(URIUtil.addPaths(this._servletRequest.getServletPath(), this._servletRequest.getPathInfo()))));
        } else {
            builder.path(request.getRequestURI());
        }
        builder.query(request.getQueryString());
        this._uri = builder.asImmutable();
        this._source = this._wrapped ? null : this._coreContextRequest;
    }

    private Content.Source source() throws IOException {
        if (this._source == null) {
            this._source = this._wrapped ? new InputStreamContentSource(this.getServletRequest().getInputStream()) : this._coreContextRequest;
        }
        return this._source;
    }

    @Override
    public HttpFields getHeaders() {
        return this._httpFields;
    }

    @Override
    public HttpURI getHttpURI() {
        return this._uri;
    }

    @Override
    public String getId() {
        return this._coreContextRequest.getId();
    }

    @Override
    public String getMethod() {
        return this._servletRequest.getMethod();
    }

    public HttpServletRequest getServletRequest() {
        return this._servletRequest;
    }

    @Override
    public boolean isSecure() {
        return this._servletRequest.isSecure();
    }

    @Override
    public Object removeAttribute(String name) {
        return this._attributes.removeAttribute(name);
    }

    @Override
    public Object setAttribute(String name, Object attribute) {
        return this._attributes.setAttribute(name, attribute);
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    @Override
    public Set<String> getAttributeNameSet() {
        return this._attributes.getAttributeNameSet();
    }

    @Override
    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    @Override
    public void fail(Throwable failure) {
        try {
            this.source().fail(failure);
        }
        catch (Throwable t) {
            ExceptionUtil.addSuppressedIfNotAssociated(failure, t);
        }
    }

    @Override
    public Components getComponents() {
        return this._coreContextRequest.getComponents();
    }

    @Override
    public ConnectionMetaData getConnectionMetaData() {
        return this._coreContextRequest.getConnectionMetaData();
    }

    @Override
    public Context getContext() {
        return this._coreContextRequest.getContext();
    }

    @Override
    public void demand(Runnable demandCallback) {
        try {
            this.source().demand(demandCallback);
        }
        catch (Throwable t) {
            demandCallback.run();
        }
    }

    @Override
    public HttpFields getTrailers() {
        return this._coreContextRequest.getTrailers();
    }

    @Override
    public long getBeginNanoTime() {
        return this._coreContextRequest.getBeginNanoTime();
    }

    @Override
    public long getHeadersNanoTime() {
        return this._coreContextRequest.getHeadersNanoTime();
    }

    @Override
    public Content.Chunk read() {
        try {
            return this.source().read();
        }
        catch (Throwable t) {
            return Content.Chunk.from(t, true);
        }
    }

    @Override
    public boolean consumeAvailable() {
        if (this._wrapped) {
            try {
                Content.Source.consumeAll(this.source());
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return this._coreContextRequest.consumeAvailable();
    }

    @Override
    public void addIdleTimeoutListener(Predicate<TimeoutException> onIdleTimeout) {
        this._coreContextRequest.addIdleTimeoutListener(onIdleTimeout);
    }

    @Override
    public void addFailureListener(Consumer<Throwable> onFailure) {
        this._coreContextRequest.addFailureListener(onFailure);
    }

    @Override
    public TunnelSupport getTunnelSupport() {
        return null;
    }

    @Override
    public void addHttpStreamWrapper(Function<HttpStream, HttpStream> wrapper) {
        this._coreContextRequest.addHttpStreamWrapper(wrapper);
    }

    @Override
    public Session getSession(boolean create) {
        return Session.getSession(this._servletRequest.getSession(create));
    }

    public static class ServletAttributes
    implements Attributes {
        private final HttpServletRequest _servletRequest;
        private Set<String> _attributeNames;

        public ServletAttributes(HttpServletRequest httpServletRequest) {
            this._servletRequest = httpServletRequest;
        }

        @Override
        public Object removeAttribute(String name) {
            Object value = this._servletRequest.getAttribute(name);
            if (value != null) {
                this._attributeNames = null;
            }
            this._servletRequest.removeAttribute(name);
            return value;
        }

        @Override
        public Object setAttribute(String name, Object attribute) {
            Object value = this._servletRequest.getAttribute(name);
            if (value == null) {
                this._attributeNames = null;
            }
            this._servletRequest.setAttribute(name, attribute);
            return value;
        }

        @Override
        public Object getAttribute(String name) {
            return this._servletRequest.getAttribute(name);
        }

        @Override
        public Set<String> getAttributeNameSet() {
            Set<String> set = this._attributeNames;
            if (set == null) {
                set = new HashSet<String>();
                Enumeration<String> e = this._servletRequest.getAttributeNames();
                while (e.hasMoreElements()) {
                    set.add(e.nextElement());
                }
                this._attributeNames = set;
            }
            return set;
        }

        @Override
        public void clearAttributes() {
            Enumeration<String> e = this._servletRequest.getAttributeNames();
            this._attributeNames = null;
            while (e.hasMoreElements()) {
                this._servletRequest.removeAttribute(e.nextElement());
            }
        }
    }
}

