/*
 * Decompiled with CFR 0.152.
 */
package winstone;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jetty.server.Server;
import winstone.HostConfiguration;
import winstone.Launcher;
import winstone.Logger;

public class HostGroup {
    private static final String DEFAULT_HOSTNAME = "default";
    private final Server server;
    private Map<String, HostConfiguration> hostConfigs;
    private String defaultHostName;

    public HostGroup(Server server, ClassLoader commonLibCL, Map<String, String> args) throws IOException {
        this.server = server;
        this.hostConfigs = new Hashtable<String, HostConfiguration>();
        this.initHost(DEFAULT_HOSTNAME, commonLibCL, args);
        this.defaultHostName = DEFAULT_HOSTNAME;
        Logger.log(Level.FINER, Launcher.RESOURCES, "HostGroup.InitSingleComplete", "" + this.hostConfigs.size(), "" + this.hostConfigs.keySet());
    }

    public HostConfiguration getHostByName(String hostname) {
        HostConfiguration host;
        if (hostname != null && this.hostConfigs.size() > 1 && (host = this.hostConfigs.get(hostname)) != null) {
            return host;
        }
        return this.hostConfigs.get(this.defaultHostName);
    }

    protected void initHost(String hostname, ClassLoader commonLibCL, Map<String, String> args) throws IOException {
        Logger.log(Level.FINER, Launcher.RESOURCES, "HostGroup.DeployingHost", (Object)hostname);
        HostConfiguration config = new HostConfiguration(this.server, hostname, commonLibCL, args);
        this.hostConfigs.put(hostname, config);
    }
}

