<?php
    ini_set('error_log', 'php://stderr');
    use PHPUnit\Framework\TestCase;
    
    //require_once __DIR__ . '/../../tests/scripts/bootstrap.php'; // ✅ Use shared mock DB
    //require_once __DIR__ . '/../src/function.php';
    error_log(">>>>>>>>>>>>>>>>>>>>>>>>>====<<<<<<<<<<<<<<<<<<<<<<<<<");
    error_log("T06_TenantTest.php");
    
    // Print list of table that exist in the database
    //$tables = $GLOBALS['mockPdo']->query("SELECT name FROM sqlite_master WHERE type='table';")->fetchAll(\PDO::FETCH_COLUMN);
    //echo("\n🔍 Tables: " . implode(', ', $tables). "\n");
    
    class T06_TenantTest extends TestCase
    {
        private $mockPdo;
        private static $lastModified;

    protected function setUp(): void{
        // ✅ Use the shared mock database connection
        $_SESSION = [];
        $_GET = [];
        $_POST = [];
        $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
        $_SERVER['HTTP_REFERER'] = 'http://localhost/test';
        $this->mockPdo = $GLOBALS['mockPdo'];
        if (session_status() !== PHP_SESSION_ACTIVE) {
            if (session_status() !== PHP_SESSION_ACTIVE && !headers_sent()) {
                session_start();
            }
        }
    }

    private function executeFunctionPhp(): array {
        ob_start();
        // Flexible path resolution for module function.php
        if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php')) {
            require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php';
        } else {
            require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'function.php';
        }
        $output = ob_get_clean();
    
        // ✅ Ensure only valid JSON output
        $decodedOutput = json_decode($output, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception("Invalid JSON output: " . json_last_error_msg() . "\nOutput: " . $output);
        }
    
        return [$output, $decodedOutput];
    }

    public function test001DummyTest(): void{
        $this->assertTrue(true);
    }

    public function test002InsertNewTenantMissingRole(){
        $_SESSION['id'] = 293;
        unset($_SESSION['roleValue']);
        $_POST = [
            'action' => 'newTenant',
            'companyName' => "Fishy Fish",
            'domain' => "fishyfish.com",
            'companyNumber' => "123456",
            'foodHygieneId' => "123456",
            'primaryContactName' => "Mr Fish",
            'tenantStatus' => "active",
            'minimumOrderAmount' => 10,
            'smallOrderFee' => 2
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test003InsertNewTenantInccorectRole(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 2;
        unset($_SESSION['roleValue']);
        $_POST = [
            'action' => 'newTenant',
            'companyName' => "Fishy Fish",
            'domain' => "fishyfish.com",
            'companyNumber' => "123456",
            'foodHygieneId' => "123456",
            'primaryContactName' => "Mr Fish",
            'tenantStatus' => "active",
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test004InsertNewTenantMissingKeyObjects(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'newTenant',
            'tenant' => [
                'companyName' => "Fishy Fish",
                'foodHygieneId' => "123456",
                'primaryContactName' => "Mr Fish",
                'tenantStatus' => "active",
                'minimumOrderAmount' => 10,
                'smallOrderFee' => 2
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Domain is required, Company number is required | tenantId missing; cannot insert default fees', $decodedOutput['message']);
    }
    public function test005InsertNewTenant(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'newTenant',
            'tenant' => [
                'companyName' => "Fishy Fish",
                'domain' => "fishyfish.com",
                'companyNumber' => "123456",
                'foodHygieneId' => "123456",
                'primaryContactName' => "Mr Fish",
                'tenantStatus' => "active",
                'minimumOrderAmount' => 10,
                'smallOrderFee' => 2
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test006InsertNewTenantDuplicate(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'newTenant',
            'tenant' => [
                'companyName' => "Fishy Fish",
                'domain' => "fishyfish.com",
                'companyNumber' => "123456",
                'foodHygieneId' => "123456",
                'primaryContactName' => "Mr Fish",
                'tenantStatus' => "active",
                'minimumOrderAmount' => 10,
                'smallOrderFee' => 2
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Duplicate Entry: Domain already exists', $decodedOutput['message']);
    }
    public function test007InsertNewTenant02(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'newTenant',
            'tenant' => [
                'companyName' => "Pie & Peas",
                'domain' => "PP.com",
                'companyNumber' => "4324",
                'foodHygieneId' => "5342452",
                'primaryContactName' => "Mrs Pie",
                'tenantStatus' => "active",
                'minimumOrderAmount' => 5,
                'smallOrderFee' => 1
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test008InsertNewTenant03(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'newTenant',
            'tenant' => [
                'companyName' => "Crubble and Custard",
                'domain' => "CC.com",
                'companyNumber' => "345341",
                'foodHygieneId' => "562434",
                'primaryContactName' => "Mr Crubble",
                'tenantStatus' => "pending",
                'minimumOrderAmount' => 15,
                'smallOrderFee' => 3
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    // add another tenant that refers to the first tenant
    public function test009InsertNewTenantWithParent(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'newTenant',
            'tenant' => [
                'companyName' => "Burgers n Chips",
                'domain' => "bnchips.com",
                'companyNumber' => "123456",
                'foodHygieneId' => "123456",
                'primaryContactName' => "Mr Fish",
                'tenantStatus' => "active",
                'parentId' => 1,
                'minimumOrderAmount' => 10,
                'smallOrderFee' => 2
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test010SelectViewTenantOwner(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantOwner',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $expectedResult = [
            'companyName' => 'Fishy Fish',
            'companyNumber' => '123456',
            'domain' => 'https://fishyfish.com',
            'foodHygieneId' => '123456',
            'tenantStatus' => 'active',
            'minimumOrderAmount' => 10,
            'smallOrderFee' => 2,
            'maxDistance' => 0,
            'activeDelivery' => 1,
            'activePickup' => 1,
            'children' => [
                    [
                        'tenantId' => 4,
                        'companyName' => 'Burgers n Chips',
                        'companyNumber' => '123456',
                        'domain' => 'https://bnchips.com',
                        'foodHygieneId' => '123456',
                        'tenantStatus' => 'active',
                        'minimumOrderAmount' => 10,
                        'smallOrderFee' => 2,
                        'maxDistance' => 0,
                        'activeDelivery' => 1,
                        'activePickup' => 1
                    ]
                ]
            
        ];
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Tenant found', $decodedOutput['message']);
        $this->assertEquals($expectedResult, $decodedOutput['tenant']);
    }
    public function test011SelectViewTenantSysAdmin(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantSysAdmin',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $expectedResult = [
            'tenantId' => 1,
            'parentId' => null,
            'companyName' => 'Fishy Fish',
            'domain' => 'https://fishyfish.com',
            'companyNumber' => '123456',
            'foodHygieneId' => '123456',
            'primaryContactName' => 'Mr Fish',
            'tenantStatus' => 'active',
            'paymentProvider' => 'stripe',
            'paymentApiKey' => null,
            'minimumOrderAmount' => 10,
            'smallOrderFee' => 2,
            'isDeleted' => 0,
            'maxDistance' => 0,
            'activeDelivery' => 1,
            'activePickup' => 1,
            'createdAt' => $decodedOutput['tenant']['createdAt'],
            'updatedAt' => $decodedOutput['tenant']['updatedAt'],
            'children' => [
                [
                    'tenantId' => 4,
                    'parentId' => 1,
                    'companyName' => 'Burgers n Chips',
                    'domain' => 'https://bnchips.com',
                    'companyNumber' => '123456',
                    'foodHygieneId' => '123456',
                    'primaryContactName' => 'Mr Fish',
                    'tenantStatus' => 'active',
                    'minimumOrderAmount' => 10,
                    'smallOrderFee' => 2,
                    'maxDistance' => 0,
                    'paymentProvider' => 'stripe',
                    'paymentApiKey' => null,
                    'isDeleted' => 0,
                    'activeDelivery' => 1,
                    'activePickup' => 1,
                    'createdAt' => $decodedOutput['tenant']['children'][0]['createdAt'],
                    'updatedAt' => $decodedOutput['tenant']['children'][0]['updatedAt'],
                ]
            ]
        ];
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Tenant found', $decodedOutput['message']);
        $this->assertEquals($expectedResult, $decodedOutput['tenant']);
    }   
    // test public cant see tenant 3
    public function test012SelectViewTenantPublic(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 3;
        $_POST = [
            'action' => 'viewTenantPublic',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Tenant not found', $decodedOutput['message']);
    }
    // test sysadmin can see tenant 2
    public function test013SelectViewTenantSysAdminTwo(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 2;
        $_POST = [
            'action' => 'viewTenantSysAdmin',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $expectedResult = [
            'tenantId' => 2,
            'parentId' => null,
            'companyName' => 'Pie &amp; Peas',
            'companyNumber' => '4324',
            'domain' => 'https://PP.com',
            'primaryContactName' => 'Mrs Pie',
            'isDeleted' => 0,
            'foodHygieneId' => '5342452',
            'tenantStatus' => 'active',
            'minimumOrderAmount' => 5,
            'smallOrderFee' => 1,
            'paymentProvider' => 'stripe',
            'paymentApiKey' => null,
            'maxDistance' => 0,
            'createdAt' => $decodedOutput['tenant']['createdAt'],
            'updatedAt' => $decodedOutput['tenant']['updatedAt'],
            'activeDelivery' => 1,
            'activePickup' => 1,
            'children' => []
        ];
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Tenant found', $decodedOutput['message']);
        $this->assertEquals($expectedResult, $decodedOutput['tenant']);
    }
    // test owner can see tenant 2
    public function test014SelectViewTenantOwnerTwo(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 2;
        $_SESSION['tenantId'] = 2;
        $_POST = [
            'action' => 'viewTenantOwner',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $expectedResult = [
            'companyName' => 'Pie &amp; Peas',
            'companyNumber' => '4324',
            'domain' => 'https://PP.com',
            'foodHygieneId' => '5342452',
            'tenantStatus' => 'active',
            'minimumOrderAmount' => 5,
            'smallOrderFee' => 1,
            'maxDistance' => 0,
            'activeDelivery' => 1,
            'activePickup' => 1,
            'children' => []
        ];
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Tenant found', $decodedOutput['message']);
        $this->assertEquals($expectedResult, $decodedOutput['tenant']);
    }
    public function test015UpdateTenantMissingRole(){
        $_SESSION['id'] = 293;
        $_SESSION['tenantId'] = 1;
        unset($_SESSION['roleValue']);
        $_POST = [
            'action' => 'updateTenant',
            'tenant' => [
                'companyName' => "Fishy Fish",
                'domain' => "https://fishyfish.com",
                'companyNumber' => "123456",
                'foodHygieneId' => "123456",
                'primaryContactName' => "Mr Fish",
                'tenantStatus' => "active",
                'minimumOrderAmount' => 7,
                'smallOrderFee' => 2
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test016UpdateTenantWrongRole(){
        unset($_SESSION['roleValue']);
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 2;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenant',
            'tenant' => [
                'companyName' => "Fishy Fish",
                'domain' => "https://fishyfish.com",
                'companyNumber' => "123456",
                'foodHygieneId' => "123456",
                'primaryContactName' => "Mr Fish",
                'tenantStatus' => "active",
                'minimumOrderAmount' => 7,
                'smallOrderFee' => 2
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test017UpdateTenantStatus(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenant',
            'tenant' => [
                'tenantStatus' => "suspended"
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test018UpdateTenantStatusWithRoleFour(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenant',
            'tenant' => [
                'minimumOrderAmount'  => 10,
                'smallOrderFee'       => 1.5
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test019SelectViewTenantOwnerWithChange(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantOwner',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $expectedResult = [
            'companyName' => 'Fishy Fish',
            'companyNumber' => '123456',
            'domain' => 'https://fishyfish.com',
            'foodHygieneId' => '123456',
            'tenantStatus' => 'suspended',
            'minimumOrderAmount' => 10,
            'smallOrderFee' => 1.5,
            'maxDistance' => 0,
            'activeDelivery' => 1,
            'activePickup' => 1,
            'children' => [
                    [
                        'tenantId' => 4,
                        'companyName' => 'Burgers n Chips',
                        'companyNumber' => '123456',
                        'domain' => 'https://bnchips.com',
                        'foodHygieneId' => '123456',
                        'tenantStatus' => 'active',
                        'minimumOrderAmount' => 10,
                        'smallOrderFee' => 2,
                        'maxDistance' => 0,
                        'activeDelivery' => 1,
                        'activePickup' => 1,
                    ]
                ]
            
        ];
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Tenant found', $decodedOutput['message']);
        $this->assertEquals($expectedResult, $decodedOutput['tenant']);
    }
    public function test020UpdateTenantMissingTenantId(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'updateTenant',
            'tenant' => [
                'companyName' => "Fishy Fish",
                'domain' => "fishyfish.com",
                'companyNumber' => "123456",
                'foodHygieneId' => "123456",
                'primaryContactName' => "Mr Fish",
                'tenantStatus' => "active"
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Missing tenantId', $decodedOutput['message']);
    }
    public function test021UpdateTenantMissingAttributes(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenant',
            'tenant' => []
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('No data to update', $decodedOutput['message']);
    }
    public function test022UpdateTenantWithNoExistantId(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 10;
        $_POST = [
            'action' => 'updateTenant',
            'tenant' => [
                'companyName' => "Fishy Fish",
                'domain' => "fishyfish.com",
                'companyNumber' => "123456",
                'foodHygieneId' => "123456",
                'primaryContactName' => "Mr Fish",
                'tenantStatus' => "active",
                'parentId' => 2
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('No content found for the id 10 | No data found for history', $decodedOutput['message']);
    }
    public function test023UpdateTenantDomainWithRoleFour(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenant',
            'tenant' => [
                'domain' => "fishyfish.com",
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('User role 4 not allowed to update domain', $decodedOutput['message']);
    }
    public function test024UpdateTenantDomainWithRoleOne(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenant',
            'tenant' => [
                'domain' => "fishyfish.com",
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test025DeleteTenantWithRoleOne(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'deleteTenant',
            'tenant' => [
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test026SelectViewTenantSysAdminAfterDelete(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantSysAdmin',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $expectedResult = [
            'tenantId' => 1,
            'parentId' => null,
            'companyName' => 'Fishy Fish',
            'companyNumber' => '123456',
            'domain' => 'fishyfish.com',
            'primaryContactName' => 'Mr Fish',
            'isDeleted' => 1,
            'foodHygieneId' => '123456',
            'tenantStatus' => 'deleted',
            'minimumOrderAmount' => 10,
            'smallOrderFee' => 1.5,
            'paymentProvider' => 'stripe',
            'paymentApiKey' => null,
            'maxDistance' => 0,
            'activeDelivery' => 1,
            'activePickup' => 1,
            'createdAt' => $decodedOutput['tenant']['createdAt'],
            'updatedAt' => $decodedOutput['tenant']['updatedAt'],
            'children' => [
                [
                    'tenantId' => 4,
                    'parentId' => 1,
                    'companyName' => 'Burgers n Chips',
                    'companyNumber' => '123456',
                    'domain' => 'https://bnchips.com',
                    'foodHygieneId' => '123456',
                    'tenantStatus' => 'deleted',
                    'minimumOrderAmount' => 10,
                    'smallOrderFee' => 2,
                    'primaryContactName' => 'Mr Fish',
                    'isDeleted' => 1,
                    'maxDistance' => 0,
                    'paymentProvider' => 'stripe',
                    'paymentApiKey' => null,
                    'activeDelivery' => 1,
                    'activePickup' => 1,
                    'createdAt' => $decodedOutput['tenant']['children'][0]['createdAt'],
                    'updatedAt' => $decodedOutput['tenant']['children'][0]['updatedAt']
                ]
            ]
        ];
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Tenant found', $decodedOutput['message']);
        $this->assertEquals($expectedResult, $decodedOutput['tenant']);
    }
    public function test027DeleteTenantWithRole1Retry(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'deleteTenant',
            'tenant' => []
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('No content found for the id 1 | Tenant already deleted', $decodedOutput['message']);
    }
    public function test028DeleteTenantWithRole3Retry(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 3;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'deleteTenant',
            'tenant' => []
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test029ReEnableDeletedTenantWithRoleOne(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenant',
            'tenant' => [
                'tenantStatus' => "active",
                'isDeleted' => 0
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test030UpdateSqlite(){
        $this->mockPdo->query("UPDATE tenant SET is_deleted = 0, tenant_status = 'active' WHERE id = 1");
        $stmt = $this->mockPdo->query("SELECT * FROM tenant where id = 1");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals("1", "1");
    }
    public function test031AddNewThemeToTenantOne(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'addNewTenantTheme',
            'tenantTheme' => [
                'themeName' => "Fishy Fish",
                'primaryColor' => "#000000",
                'secondaryColor' => "#000000",
                'textColor' => "#000000",
                'secondaryTextColor' => "#000000",
                'accentColor' => "#000000",
                'backgroundColor' => "#000000",
                'buttonColor' => "#000000"
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test032AddNewThemeToTenant1Draft(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'addNewTenantTheme',
            'tenantTheme' => [
                'themeName' => "Fishy Fish Draft",
                'primaryColor' => "#000000",
                'secondaryColor' => "#000000",
                'textColor' => "#000000",
                'secondaryTextColor' => "#000000",
                'accentColor' => "#000000",
                'backgroundColor' => "#000000",
                'buttonColor' => "#000000"
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test033AddNewThemeToTenant1ToBeDeletedLater(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'addNewTenantTheme',
            'tenantTheme' => [
                'themeName' => "Fishy Fish",
                'primaryColor' => "#000000",
                'secondaryColor' => "#000000",
                'textColor' => "#000000",
                'secondaryTextColor' => "#000000",
                'accentColor' => "#000000",
                'backgroundColor' => "#000000",
                'buttonColor' => "#000000"
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test034AddNewThemeToTenant1NoAccess(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 6;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'addNewTenantTheme',
            'tenantTheme' => [
                'themeName' => "Fishy Fish",
                'primaryColor' => "#000000",
                'secondaryColor' => "#000000",
                'textColor' => "#000000",
                'secondaryTextColor' => "#000000",
                'accentColor' => "#000000",
                'backgroundColor' => "#000000",
                'buttonColor' => "#000000"
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test035AddNewThemeToTenant1NoRole(){
        $_SESSION['id'] = 293;
        $_SESSION['tenantId'] = 1;
        unset($_SESSION['roleValue']);
        $_POST = [
            'action' => 'addNewTenantTheme',
            'tenantTheme' => [
                'themeName' => "Fishy Fish",
                'primaryColor' => "#000000",
                'secondaryColor' => "#000000",
                'textColor' => "#000000",
                'secondaryTextColor' => "#000000",
                'accentColor' => "#000000",
                'backgroundColor' => "#000000",
                'buttonColor' => "#000000"
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }   
    public function test036AddNewThemeToTenant1MissingAttributs(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'addNewTenantTheme',
            'tenantTheme' => [
                'themeName' => "Fishy Fish",
                'primaryColor' => "#000000",
                'secondaryColor' => "#000000",
                'textColor' => "#000000",
                'secondaryTextColor' => "#000000",
                'accentColor' => "#000000",
                'backgroundColor' => "#000000",
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('buttonColor is missing', $decodedOutput['message']);
    }
    public function test037AddNewThemeToTenant1MissingValue(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'addNewTenantTheme',
            'tenantTheme' => [
                'themeName' => "Fishy Fish",
                'primaryColor' => "#000000",
                'secondaryColor' => "#000000",
                'textColor' => "#000000",
                'secondaryTextColor' => "#000000",
                'accentColor' => "#000000",
                'backgroundColor' => "#000000",
                'buttonColor' => ""
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('buttonColor is required', $decodedOutput['message']);
    }
    public function test038AddNewThemeToTenant1MissingTenantId(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'addNewTenantTheme',
            'tenantTheme' => [
                'themeName' => "Fishy Fish",
                'primaryColor' => "#000000",
                'secondaryColor' => "#000000",
                'textColor' => "#000000",
                'secondaryTextColor' => "#000000",
                'accentColor' => "#000000",
                'backgroundColor' => "#000000",
                'buttonColor' => "#000000"
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('tenantId is required', $decodedOutput['message']);
    }
    public function test039AddNewThemeToTenantWithaTenantIdThatDoesNotExist(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 100;
        $_POST = [
            'action' => 'addNewTenantTheme',
            'tenantTheme' => [
                'themeName' => "Fishy Fish",
                'primaryColor' => "#000000",
                'secondaryColor' => "#000000",
                'textColor' => "#000000",
                'secondaryTextColor' => "#000000",
                'accentColor' => "#000000",
                'backgroundColor' => "#000000",
                'buttonColor' => "#000000"
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('tenantId is not valid', $decodedOutput['message']);
    }
    public function test040UpdateTenantTheme1ToActive(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenantTheme',
            'tenantTheme' => [
                'themeId' => 1,
                'isApplied' => "yes",
                'themeStatus' => "active"
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test041UpdateThemeMarkAsDeleted(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'updateTenantTheme',
            'tenantTheme' => [
                'themeId' => 3,
                'isApplied' => "no",
                'themeStatus' => "deleted",
                'isDeleted' => 1
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test042UpdateThemeMarkAsDeletedRoleFive(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_POST = [
            'action' => 'updateTenantTheme',
            'tenantTheme' => [
                'themeId' => 2,
                'isApplied' => "no",
                'themeStatus' => "deleted",
                'isDeleted' => 1
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test043UpdateTenantThemeNoExisitingTheme(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'updateTenantTheme',
            'tenantTheme' => [
                'themeId' => 100,
                'isApplied' => "yes",
                'themeStatus' => "active"
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('No content found for the id 100 | No data found for history', $decodedOutput['message']);
    }
    public function test044UpdateTenantThemeNoRole(){
        $_SESSION['id'] = 293;
        unset($_SESSION['roleValue']);
        $_POST = [
            'action' => 'updateTenantTheme',
            'tenantTheme' => [
                'themeId' => 1,
                'isApplied' => "yes",
                'themeStatus' => "active"
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test045UpdateTenantThemeWrongRole(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 6;
        $_POST = [
            'action' => 'updateTenantTheme',
            'tenantTheme' => [
                'themeId' => 1,
                'isApplied' => "yes",
                'themeStatus' => "active"
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test046ViewThemeSysAdmin(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewThemeSysAdmin',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Theme(s) found',
            'action' => 'viewThemeSysAdmin',
            'security' =>[
                'security' => 1,
            ],
            'theme' => [
                0 =>    [
                        'themeId'               => 1,
                        'tenantId'              => 1,
                        'themeName'             => 'Fishy Fish',
                        'primaryColor'          => '#000000',
                        'secondaryColor'        => '#000000',
                        'textColor'             => '#000000',
                        'secondaryTextColor'    => '#000000',
                        'accentColor'           =>'#000000',
                        'backgroundColor'       => '#000000',
                        'buttonColor'           => '#000000',
                        'isApplied'             => 'yes',
                        'themeStatus'           => 'active',
                        'isDeleted'             => 0,
                        'createdAt'             => $decodedOutput['theme'][0]['createdAt'],
                        'updatedAt'             => $decodedOutput['theme'][0]['updatedAt']
                    ],
                1=>    [
                            'themeId' => 2,
                            'tenantId' => 1,
                            'themeName' => 'Fishy Fish Draft',
                            'primaryColor' => '#000000',
                            'secondaryColor' => '#000000',
                            'textColor' => '#000000',
                            'secondaryTextColor' => '#000000',
                            'accentColor' => '#000000',
                            'backgroundColor' => '#000000',
                            'buttonColor' => '#000000',
                            'isApplied' => 'no',
                            'themeStatus' => 'draft',
                            'isDeleted' => 0,
                            'createdAt' => $decodedOutput['theme'][1]['createdAt'],
                            'updatedAt' => $decodedOutput['theme'][1]['updatedAt']
                    ],
                2=>   [
                            'themeId' => 3,
                            'tenantId' => 1,
                            'themeName' => 'Fishy Fish',
                            'primaryColor' => '#000000',
                            'secondaryColor' => '#000000',
                            'textColor' => '#000000',
                            'secondaryTextColor' => '#000000',
                            'accentColor' => '#000000',
                            'backgroundColor' => '#000000',
                            'buttonColor' => '#000000',
                            'isApplied' => 'no',
                            'themeStatus' => 'deleted',
                            'isDeleted' => 1,
                            'createdAt' => $decodedOutput['theme'][2]['createdAt'],
                            'updatedAt' => $decodedOutput['theme'][2]['updatedAt']
                    ]
                ],
        ];
        
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals($expectedResult, $decodedOutput);
    }
    public function test047ViewThemePublic(){
        $_SESSION['id'] = 293;
        $_SESSION['tenantId'] = 1;
        //$_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'viewThemePublic',
            'themeId' => 1,
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Theme(s) found',
            'action' => 'viewThemePublic',
            'security' =>[
                'security' => 1,
            ],
            'theme' => [
                0 =>    [
                        'themeName'             => 'Fishy Fish',
                        'primaryColor'          => '#000000',
                        'secondaryColor'        => '#000000',
                        'textColor'             => '#000000',
                        'secondaryTextColor'    => '#000000',
                        'accentColor'           =>'#000000',
                        'backgroundColor'       => '#000000',
                        'buttonColor'           => '#000000',
                        'themeStatus'           => 'active',
                    ]
                ],
        ];
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals($expectedResult, $decodedOutput);
    }
    public function test048ViewThemePublicTenantId(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'viewThemePublic',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test049ViewThemeOwner(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewThemeOwner',
            'debug' => 'CSD'
        ];
        
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Theme(s) found',
            'action' => 'viewThemeOwner',
            'security' =>[
                'security' => 1,
            ],
            'theme' => [
                0 =>    [
                        'themeId'               => 1,
                        'themeName'             => 'Fishy Fish',
                        'primaryColor'          => '#000000',
                        'secondaryColor'        => '#000000',
                        'textColor'             => '#000000',
                        'secondaryTextColor'    => '#000000',
                        'accentColor'           =>'#000000',
                        'backgroundColor'       => '#000000',
                        'buttonColor'           => '#000000',
                        'isApplied'             => 'yes',
                        'themeStatus'           => 'active',
                ],
                1 =>[
                    'themeId' => 2,
                    'themeName' => 'Fishy Fish Draft',
                    'primaryColor' => '#000000',
                    'secondaryColor' => '#000000',
                    'textColor' => '#000000',
                    'secondaryTextColor' => '#000000',
                    'accentColor' => '#000000',
                    'backgroundColor' => '#000000',
                    'buttonColor' => '#000000',
                    'isApplied' => 'no',
                    'themeStatus' => 'draft',
                ]
            ],
        ];
        
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals($expectedResult, $decodedOutput);
    }
    public function test050ViewThemeOwnerNoIds(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_POST = [
            'action' => 'viewThemeOwner',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Missing required Id(tenantId or themeId)', $decodedOutput['message']);
    }
    public function test051ViewThemOwnerNoRole(){
        $_SESSION['id'] = 293;
        unset($_SESSION['roleValue']);
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewThemeOwner',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }  
    public function test052ViewThemeOwnerWrongRole(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 6;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewThemeOwner',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    // Net table set 
    public function test053InsertNewTenantContactAdmin(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'insertNewTenantContactOwner',
            'tenantContact' => [
                'userId' => 1,
                'label' => "Mr Fish",
                'contactType' => "Name",
                'contactValue' => "Fishy Fish Content",
                'isPrimary' => 'yes'
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test054InsertNewTenantContactEmailOne(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'insertNewTenantContactBusiness',
            'tenantContact' => [
                'label' => "Email Primary",
                'contactType' => "Email",
                'contactValue' => "chips@fish.com",
                'isPrimary' => 'yes'
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test055InsertNewTenantContactEmailTwo(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'insertNewTenantContactBusiness',
            'tenantContact' => [
                'label' => "Email Secondary",
                'contactType' => "Email",
                'contactValue' => "info@fish.com",
                'isPrimary' => 'no'
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test056ViewContactSysAdmin(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantContactBusiness',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);

        $expectedResult = [
            'status' => 'success',
            'message' => 'Contact(s) found',
            'contact' =>
            [
                'owner' =>[
                    0 =>[
                        'contactId'     => 1,
                        'tenantId'      => 1,
                        'userId'        => 1,
                        'contactType'   => 'Name',
                        'isPrimary'     => 'yes',
                        'label'         => 'Mr Fish',
                        'contactValue'  => 'Fishy Fish Content',
                        'isDeleted'     => 0,
                        'createdAt'     => $decodedOutput['contact']['owner'][0]['createdAt'],
                        'updatedAt'     => $decodedOutput['contact']['owner'][0]['updatedAt']
                    ],
                ],
                'shop' => [
                    0 =>[
                        'contactId'     => 2,
                        'tenantId'      => 1,
                        'userId'        => null,
                        'contactType'   => 'Email',
                        'isPrimary'     => 'yes',
                        'label'         => 'Email Primary',
                        'contactValue'  => 'chips@fish.com',
                        'isDeleted'     => 0,
                        'createdAt'     => $decodedOutput['contact']['shop'][0]['createdAt'],
                        'updatedAt'     => $decodedOutput['contact']['shop'][0]['updatedAt'],
                    ],
                    1 => [
                        'contactId'     => 3,
                        'tenantId'      => 1,
                        'userId'        => null,
                        'contactType'   => 'Email',
                        'isPrimary'     => 'no',
                        'label'         => 'Email Secondary',
                        'contactValue'  => 'info@fish.com',
                        'isDeleted'     => 0,
                        'createdAt'     => $decodedOutput['contact']['shop'][1]['createdAt'],
                        'updatedAt'     => $decodedOutput['contact']['shop'][1]['updatedAt']
                    ]
                ],
            ],
            'action' => 'viewTenantContactBusiness',
            'security' =>[
                'security' => 1,
            ]
        ];

        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals($expectedResult, $decodedOutput);
    }
    public function test057ViewContactOwner(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantContactOwner',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Contact(s) found',
            'contact' =>
            [
                'owner' =>[
                    0 =>[
                        'contactId'     => 1,
                        'userId'        => 1,
                        'contactType'   => 'Name',
                        'isPrimary'     => 'yes',
                        'label'         => 'Mr Fish',
                        'contactValue'  => 'Fishy Fish Content',
                    ],
                ],
                'shop' => [
                    0 =>[
                        'contactId'     => 2,
                        'userId'        => null,
                        'contactType'   => 'Email',
                        'isPrimary'     => 'yes',
                        'label'         => 'Email Primary',
                        'contactValue'  => 'chips@fish.com',
                    ],
                    1 => [
                        'contactId'     => 3,
                        'userId'        => null,
                        'contactType'   => 'Email',
                        'isPrimary'     => 'no',
                        'label'         => 'Email Secondary',
                        'contactValue'  => 'info@fish.com',
                    ]
                ],
            ],
            'action' => 'viewTenantContactOwner',
            'security' =>[
                'security' => 1,
            ]
        ];
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals($expectedResult, $decodedOutput);
    } 
    public function test058ViewContactPublic(){
        $_SESSION['id'] = 293;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantContactPublic',
            'debug' => 'CSD'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        //echo print_r($output);
        $decodedOutput = json_decode($output, true);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Contact(s) found',
            'contact' => [
            0 =>    [
                    'contactType'   => 'Email',
                    'label'         => 'Email Primary',
                    'contactValue'  => 'chips@fish.com'
                ]
            ],
            'action' => 'viewTenantContactPublic',
            'security' =>[
                'security' => 1,
            ]
        ];

        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals($expectedResult, $decodedOutput);
    }
    public function test059InsertNewTenantContactEmailThree(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'insertNewTenantContactBusiness',
            'tenantContact' => [
                'label' => "Email Secondary",
                'contactType' => "Email",
                'contactValue' => "info@fish.com",
                'isPrimary' => 'yes'
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test060ViewContactPublicCheckForMutipleRecords(){
        $_SESSION['id'] = 293;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantContactPublic',
            'debug' => 'CSD'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($output);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Contact(s) found',
            'contact' => [
                0 =>    [
                        'contactType'   => 'Email',
                        'label'         => 'Email Primary',
                        'contactValue'  => 'chips@fish.com'
                ],
                1 =>    [
                        'contactType'   => 'Email',
                        'label'         => 'Email Secondary',
                        'contactValue'  => 'info@fish.com',
                ]
            ],
            'action' => 'viewTenantContactPublic',
            'security' =>[
                'security' => 1,
            ]
        ];

        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals($expectedResult, $decodedOutput);
    }
    public function test061ViewContactPublicNoTenantId(){
        $_POST = [
            'action' => 'viewTenantContactPublic',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Missing required tenantId', $decodedOutput['message']);
    }
    public function test062ViewContactPublicNoUser(){
        unset($_SESSION['roleValue']);
        unset($_SESSION['id']);
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantContactPublic',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test063UpdateEmailForAdmin(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'updateTenantContact',
            'tenantContact' => [
                'contactId' => 1,
                'userId' => 1,
                'label' => "Mr Fish",
                'contactType' => "Name",
                'contactValue' => "Fishy Fish Content",
                'isPrimary' => 'yes'
            ]

        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test064UpdateEmailForAdminNoRole(){
        $_SESSION['id'] = 293;
        unset($_SESSION['roleValue']);
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'updateTenantContact',
            'tenantContact' => [
                'contactId' => 1,
                'userId' => 1,
                'label' => "Mr Fish",
                'contactType' => "Name",
                'contactValue' => "Fishy Fish Content",
                'isPrimary' => 'yes'
            ]

        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        
    }
    public function test065UpdateEmailForAdminNoTenantId(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST =[
            'action' => 'updateTenantContact',
            'tenantContact' => [
                'contactId' => 1,
                'userId' => 1,
                'label' => "Mr Fish",
                'contactType' => "Name",
                'contactValue' => "Fishy Fish Content",
                'isPrimary' => 'yes'
            ]

        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test066UpdateEmailForAdminWrongRoleId(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_POST =[
            'action' => 'updateTenantContact',
            'tenantContact' => [
                'contactId' => 1,
                'userId' => 1,
                'label' => "Mr Fish",
                'contactType' => "Name",
                'contactValue' => "Fishy Fish Content",
                'isPrimary' => 'yes'
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('User role 4 not allowed to update userId', $decodedOutput['message']);
    }
    public function test067UpdateEmailForAdminNoContactId(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'updateTenantContact',
            'tenantContact' => [
                'userId' => 1,
                'label' => "Mr Fish",
                'contactType' => "Name",
                'contactValue' => "Fishy Fish Content",
                'isPrimary' => 'yes'
            ]

        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Missing contactId', $decodedOutput['message']);
    }
    public function test068UpdateEmailForOwner(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'updateTenantContact',
            'tenantContact' => [
                'contactId' => 2,
                'label' => "Mr Fish",
                'contactType' => "Name",
                'contactValue' => "Fishy Fish Content",
                'isPrimary' => 'yes'
            ]

        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test069UpdateEmailForOwnerNoRole(){
        $_SESSION['id'] = 293;
        $_SESSION['tenantId'] = 1;
        unset($_SESSION['roleValue']);
        $_POST =[
            'action' => 'updateTenantContact',
            'tenantContact' => [
                'contactId' => 2,
                'label' => "Mr Fish",
                'contactType' => "Name",
                'contactValue' => "Fishy Fish Content",
                'isPrimary' => 'yes'
            ]

        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test070UpdateEmailForPublicNoRole(){
        $_SESSION['id'] = 293;
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'updateTenantContact',
            'tenantContact' => [
                'contactId' => 2,
                'label' => "Mr Fish",
                'contactType' => "Name",
                'contactValue' => "Fishy Fish Content",
                'isPrimary' => 'yes'
            ]

        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test071UpdateEmailForPublic(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 6;
        $_POST =[
            'action' => 'updateTenantContact',
            'tenantContact' => [
                'contactId' => 2,
                'label' => "Mr Fish",
                'contactType' => "Name",
                'contactValue' => "Fishy Fish Content",
                'isPrimary' => 'yes'
            ]

        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test072DeleteContactUsingOwner(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'deleteTenantContact',
            'tenantContact' => [
                'contactId' => 2,
                'userId' => 1,
                'isDeleted' => 1,
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('User role 4 not allowed to update userId', $decodedOutput['message']);
    }
    public function test073DeleteContactNoRole(){
        $_SESSION['id'] = 293;
        $_SESSION['tenantId'] = 1;
        unset($_SESSION['roleValue']);
        $_POST =[
            'action' => 'deleteTenantContact',
            'tenantContact' => [
                'contactId' => 2,
                'userId' => 1,
                'isDeleted' => 1,
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test074DeleteContactNoUser(){
        unset($_SESSION['id']);
        unset($_SESSION['roleValue']);
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'deleteTenantContact',
            'tenantContact' => [
                'contactId' => 2,
                'userId' => 1,
                'isDeleted' => 1,
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('User is not logged in', $decodedOutput['message']);
    }
    public function test075DeleteContactSysAdmin(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'deleteTenantContact',
            'tenantContact' => [
                'contactId' => 2,
                'userId' => 1,
                'isDeleted' => 1,
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test076DeleteContactSysAdminNoRole(){
        $_SESSION['id'] = 293;
        $_SESSION['tenantId'] = 1;
        unset($_SESSION['roleValue']);
        $_POST =[
            'action' => 'deleteTenantContact',
            'tenantContact' => [
                'contactId' => 2,
                'userId' => 1,
                'isDeleted' => 1,
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test077DeleteContactOwner(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_POST =[
            'action' => 'deleteTenantContact',
            'tenantContact' => [
                'contactId' => 3,
                'isDeleted' => 1,
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test078ViewContactSysAdminAfterSomeDeleted(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantContactBusiness',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Contact(s) found',
            'contact' => [
                'owner' => [
                    0 => [
                        'contactId'     => 1,
                        'tenantId'      => 1,
                        'userId'        => 1,
                        'contactType'   => 'Name',
                        'isPrimary'     => 'yes',
                        'label'         => 'Mr Fish',
                        'contactValue'  => 'Fishy Fish Content',
                        'isDeleted'     => 0,
                        'createdAt'     => $decodedOutput['contact']['owner'][0]['createdAt'],
                        'updatedAt'     => $decodedOutput['contact']['owner'][0]['updatedAt']
                    ],
                    1 =>[
                        'contactId'     => 2,
                        'tenantId'      => 1,
                        'userId'        => 1,
                        'contactType'   => 'Name',
                        'isPrimary'     => 'yes',
                        'label'         => 'Mr Fish',
                        'contactValue'  => 'Fishy Fish Content',
                        'isDeleted'     => 1,
                        'createdAt'     => $decodedOutput['contact']['owner'][1]['createdAt'],
                        'updatedAt'     => $decodedOutput['contact']['owner'][1]['updatedAt']
                    ],
                ],
                'shop' => [
                    
                    0 => [
                        'contactId'     => 3,
                        'tenantId'      => 1,
                        'userId'        => null,
                        'contactType'   => 'Email',
                        'isPrimary'     => 'no',
                        'label'         => 'Email Secondary',
                        'contactValue'  => 'info@fish.com',
                        'isDeleted'     => 1,
                        'createdAt'     => $decodedOutput['contact']['shop'][0]['createdAt'],
                        'updatedAt'     => $decodedOutput['contact']['shop'][0]['updatedAt']
                    ],
                    1 => [
                        'contactId'     => 4,
                        'tenantId'      => 1,
                        'userId'        => null,
                        'contactType'   => 'Email',
                        'isPrimary'     => 'yes',
                        'label'         => 'Email Secondary',
                        'contactValue'  => 'info@fish.com',
                        'isDeleted'     => 0,
                        'createdAt'     => $decodedOutput['contact']['shop'][1]['createdAt'],
                        'updatedAt'     => $decodedOutput['contact']['shop'][1]['updatedAt']
                    ]
                ],
            ],
            'action' => 'viewTenantContactBusiness',
            'security' =>[
                'security' => 1,
            ]
        ];
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals($expectedResult, $decodedOutput);
    }
    // build Opening Times next 
    public function test079InsertBuissnessHoursPublic(){
        $_SESSION['id'] = 293;
        $_SESSION['tenantId'] = 1;
        unset($_SESSION['roleValue']);
        $_POST =[
            'action' => 'insertNewBusinessHours',
            'tenantBusinessHours' => [
                'openingDay' => 'Monday',
                'openTime' => '09:00:00:00',
                'closeTime' => '17:00:00:00'
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test080InsertBuissnessHoursNoAuth(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 6;
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'insertNewBusinessHours',
            'tenantBusinessHours' => [
                'day' => 'Monday',
                'openTime' => '09:00:00:00',
                'closeTime' => '17:00:00:00'
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test081InsertBuissnessHoursSysAdminStoreMonday(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'insertNewBusinessHours',
            'tenantBusinessHours' => [
                'hoursCategory' => 'store',
                'openingDay' => 'Monday',
                'openTime' => '09:00:00',
                'closeTime' => '17:00:00'
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test082InsertBuissnessHoursSysAdminStoreTuesdayToSunday(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'insertNewBusinessHours',
            'tenantBusinessHours' => [
                0 => [
                    'hoursCategory' => 'store',
                    'openingDay' => 'Tuesday',
                    'isClosed' => '1',
                ],
                1 => [
                    'hoursCategory' => 'store',
                    'openingDay' => 'Wednesday',
                    'openTime' => '09:00:00',
                    'closeTime' => '18:00:00'
                ],
                2 => [
                    'hoursCategory' => 'store',
                    'openingDay' => 'Thursday',
                    'openTime' => '09:00:00',
                    'closeTime' => '18:00:00'
                ],
                3 => [
                    'hoursCategory' => 'store',
                    'openingDay' => 'Friday',
                    'openTime' => '09:00:00',
                    'closeTime' => '22:30:00'
                ],
                4 => [
                    'hoursCategory' => 'store',
                    'openingDay' => 'Saturday',
                    'openTime' => '09:00:00',
                    'closeTime' => '23:00:00'
                ],
                5 => [
                    'hoursCategory' => 'store',
                    'openingDay' => 'Sunday',
                    'openTime' => '09:00:00',
                    'closeTime' => '17:00:00'
                ]
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test083InsertBuissnessHoursOwnerDeliveryMonday(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'insertNewBusinessHours',
            'tenantBusinessHours' => [
                'hoursCategory' => 'delivery',
                'openingDay' => 'Monday',
                'openTime' => '15:00:00',
                'closeTime' => '18:00:00'
            ],
            //'debug'=>'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test084InsertBuissnessHoursOwnerDeliveryTuesdayToSunday(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST =[
            'action' => 'insertNewBusinessHours',
            'tenantBusinessHours' => [
                0 => [
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Tuesday',
                    'isClosed' => '1',
                ],
                1 => [
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Wednesday',
                    'openTime' => '15:00:00',
                    'closeTime' => '18:00:00'
                ],
                2 => [
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Thursday',
                    'openTime' => '16:00:00',
                    'closeTime' => '20:00:00'
                ],
                3 => [
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Friday',
                    'openTime' => '16:00:00',
                    'closeTime' => '00:00:00'
                ],
                4 => [
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Saturday',
                    'openTime' => '16:00:00',
                    'closeTime' => '00:00:00'
                ],
                5 => [
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Sunday',
                    'isClosed' => '1'
                ]
            ],
            //'debug'=>'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test085InsertBuissnessHoursSpecialDay(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $nineDaysFromNow = date('Y-m-d', strtotime('+9 days'));
        $_POST =[
            'action' => 'insertNewBusinessHours',
            'tenantBusinessHours' => [
                'hoursCategory'     => 'special',
                'specificDate'      => $nineDaysFromNow,
                'isClosed'          => '1',

            ],
            //'debug'=>'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test086ViewBusinessHoursPublicWithSeedData() {
        // View Data in sql
        $stmt = $this->mockPdo->prepare("SELECT * FROM tenant_business_hours WHERE tenant_id = 1");
        $stmt->execute();
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        //echo print_r($rows, true);
        $_SESSION['id'] = 293;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewBusinessHoursPublic',
            'debug' => 'CSD'
        ];
    
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
    
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Business Hours found', $decodedOutput['message']);
        $this->assertArrayHasKey('businessHour', $decodedOutput);

        //echo print_r($decodedOutput, true);
    
        // Build expected output from today onwards
        $expected = [];
        $weekdayMap = [
            'Monday'    => ['store' => ['09:00:00', '17:00:00'],         'delivery' => ['15:00:00', '18:00:00']],
            'Tuesday'   => ['store' => [null, null, '1'],                'delivery' => [null, null, '1']],
            'Wednesday' => ['store' => ['09:00:00', '18:00:00'],         'delivery' => ['15:00:00', '18:00:00']],
            'Thursday'  => ['store' => ['09:00:00', '18:00:00'],         'delivery' => ['16:00:00', '20:00:00']],
            'Friday'    => ['store' => ['09:00:00', '22:30:00'],         'delivery' => ['16:00:00', '00:00:00']],
            'Saturday'  => ['store' => ['09:00:00', '23:00:00'],         'delivery' => ['16:00:00', '00:00:00']],
            'Sunday'    => ['store' => ['09:00:00', '17:00:00'],         'delivery' => [null, null, '1']],
        ];
    
        for ($i = 0; $i <= 7; $i++) {
            $date = date('Y-m-d', strtotime("+$i days"));
            $weekday = date('l', strtotime($date)); // 'Monday', 'Tuesday', etc.
    
            foreach (['store', 'delivery'] as $businessHour) {
                $expectedEntry = [
                    'generatedDate' => $date,
                    'tenantId' => 1,
                    'hoursCategory' => $businessHour,
                    'openingDay' => $weekday,
                    'openTime' => $weekdayMap[$weekday][$businessHour][0] ?? '',
                    'closeTime' => $weekdayMap[$weekday][$businessHour][1] ?? '',
                    'isClosed' => $weekdayMap[$weekday][$businessHour][2] ?? '', // default ''
                ];
    
                $matchFound = false;
                foreach ($decodedOutput['businessHour'] as $row) {
                    if (
                        $row['generatedDate'] === $expectedEntry['generatedDate'] &&
                        $row['hoursCategory'] === $expectedEntry['hoursCategory']
                    ) {
                        $this->assertEquals($expectedEntry['tenantId'], $row['tenantId']);
                        $this->assertEquals($expectedEntry['openTime'], $row['openTime']);
                        $this->assertEquals($expectedEntry['closeTime'], $row['closeTime']);
                        $this->assertEquals($expectedEntry['isClosed'], $row['isClosed']);
                        $matchFound = true;
                        break;
                    }
                }
    
                $this->assertTrue($matchFound, "Expected entry not found for {$businessHour} on {$date}");
            }
        }
    
        // Validate the special day (9 days from now)
        $specialDate = date('Y-m-d', strtotime('+9 days'));
        $foundSpecial = false;
        foreach ($decodedOutput['businessHour'] as $row) {
            if (
                $row['generatedDate'] === $specialDate &&
                $row['hoursCategory'] === 'special' &&
                $row['isClosed'] == '1'
            ) {
                $foundSpecial = true;
                break;
            }
        }
        $this->assertTrue($foundSpecial, "Special closed date not found for $specialDate");
    }
    public function test087ViewBusinessHoursOwner(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewBusinessHoursOwner',
            'debug' => 'CSD'
        ];
    
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Business Hours found',
            'businessHour' => [
                0 => [
                    'businessHourId' => 1,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Monday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '17:00:00',
                    'isClosed' => null,
                ],
                1 => [
                    'businessHourId' => 2,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Tuesday',
                    'specificDate' => null,
                    'openTime' => null,
                    'closeTime' => null,
                    'isClosed' => 1,
                ],
                2 => [
                    'businessHourId' => 3,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Wednesday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '18:00:00',
                    'isClosed' => null,
                ],
                3 => [
                    'businessHourId' => 4,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Thursday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '18:00:00',
                    'isClosed' => null,
                ],
                4 => [
                    'businessHourId' => 5,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Friday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '22:30:00',
                    'isClosed' => null,
                ],
                5 => [
                    'businessHourId' => 6,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Saturday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '23:00:00',
                    'isClosed' => null,
                ],
                6 => [
                    'businessHourId' => 7,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Sunday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '17:00:00',
                    'isClosed' => null,
                ],
                7 => [
                    'businessHourId' => 8,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Monday',
                    'specificDate' => null,
                    'openTime' => '15:00:00',
                    'closeTime' => '18:00:00',
                    'isClosed' => null,
                ],
                8 => [
                    'businessHourId' => 9,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Tuesday',
                    'specificDate' => null,
                    'openTime' => null,
                    'closeTime' => null,
                    'isClosed' => 1,
                ],
                9 => [
                    'businessHourId' => 10,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Wednesday',
                    'specificDate' => null,
                    'openTime' => '15:00:00',
                    'closeTime' => '18:00:00',
                    'isClosed' => null,
                ],
                10 => [
                    'businessHourId' => 11,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Thursday',
                    'specificDate' => null,
                    'openTime' => '16:00:00',
                    'closeTime' => '20:00:00',
                    'isClosed' => null,
                ],
                11 => [
                    'businessHourId' => 12,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Friday',
                    'specificDate' => null,
                    'openTime' => '16:00:00',
                    'closeTime' => '00:00:00',
                    'isClosed' => null,
                ],
                12 => [
                    'businessHourId' => 13,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Saturday',
                    'specificDate' => null,
                    'openTime' => '16:00:00',
                    'closeTime' => '00:00:00',
                    'isClosed' => null,
                ],
                13 => [
                    'businessHourId' => 14,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Sunday',
                    'specificDate' => null,
                    'openTime' => null,
                    'closeTime' => null,
                    'isClosed' => 1,
                ],
                14 => [
                    'businessHourId' => 15,
                    'hoursCategory' => 'special',
                    'openingDay' => null,
                    'specificDate' => date('Y-m-d', strtotime('+9 days')),
                    'openTime' => null,
                    'closeTime' => null,
                    'isClosed' => 1,
                ]
            ],
            'action' => 'viewBusinessHoursOwner',
            'security' =>[
                'security' => 1,
            ]
        ];

        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Business Hours found', $decodedOutput['message']);
        $this->assertEquals($expectedResult, $decodedOutput);
    }
    public function test088ViewBusinessHoursSysAdmin(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewBusinessHoursSysAdmin',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Business Hours found',
            'businessHour' => [
                0 => [
                    'tenantId' => 1,
                    'businessHourId' => 1,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Monday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '17:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][0]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][0]['updatedAt']
                ],
                1 => [
                    'tenantId' => 1,
                    'businessHourId' => 2,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Tuesday',
                    'specificDate' => null,
                    'openTime' => null,
                    'closeTime' => null,
                    'isClosed' => 1,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][1]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][1]['updatedAt']
                ],
                2 => [
                    'tenantId' => 1,
                    'businessHourId' => 3,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Wednesday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '18:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][2]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][2]['updatedAt']
                ],
                3 => [
                    'tenantId' => 1,
                    'businessHourId' => 4,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Thursday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '18:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][3]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][3]['updatedAt']
                ],
                4 => [
                    'tenantId' => 1,
                    'businessHourId' => 5,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Friday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '22:30:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][4]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][4]['updatedAt']
                ],
                5 => [
                    'tenantId' => 1,
                    'businessHourId' => 6,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Saturday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '23:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][5]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][5]['updatedAt']
                ],
                6 => [
                    'tenantId' => 1,
                    'businessHourId' => 7,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Sunday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '17:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][6]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][6]['updatedAt']
                ],
                7 => [
                    'tenantId' => 1,
                    'businessHourId' => 8,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Monday',
                    'specificDate' => null,
                    'openTime' => '15:00:00',
                    'closeTime' => '18:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][7]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][7]['updatedAt']
                ],
                8 => [
                    'tenantId' => 1,
                    'businessHourId' => 9,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Tuesday',
                    'specificDate' => null,
                    'openTime' => null,
                    'closeTime' => null,
                    'isClosed' => 1,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][8]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][8]['updatedAt']
                ],
                9 => [
                    'tenantId' => 1,
                    'businessHourId' => 10,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Wednesday',
                    'specificDate' => null,
                    'openTime' => '15:00:00',
                    'closeTime' => '18:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][9]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][9]['updatedAt']
                ],
                10 => [
                    'tenantId' => 1,
                    'businessHourId' => 11,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Thursday',
                    'specificDate' => null,
                    'openTime' => '16:00:00',
                    'closeTime' => '20:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][10]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][10]['updatedAt']
                ],
                11 => [
                    'tenantId' => 1,
                    'businessHourId' => 12,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Friday',
                    'specificDate' => null,
                    'openTime' => '16:00:00',
                    'closeTime' => '00:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][11]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][11]['updatedAt']
                ],
                12 => [
                    'tenantId' => 1,
                    'businessHourId' => 13,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Saturday',
                    'specificDate' => null,
                    'openTime' => '16:00:00',
                    'closeTime' => '00:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][12]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][12]['updatedAt']
                ],
                13 => [
                    'tenantId' => 1,
                    'businessHourId' => 14,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Sunday',
                    'specificDate' => null,
                    'openTime' => null,
                    'closeTime' => null,
                    'isClosed' => 1,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][13]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][13]['updatedAt']
                ],
                14 => [
                    'tenantId' => 1,
                    'businessHourId' => 15,
                    'hoursCategory' => 'special',
                    'openingDay' => null,
                    'specificDate' => date('Y-m-d', strtotime('+9 days')),
                    'openTime' => null,
                    'closeTime' => null,
                    'isClosed' => 1,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][14]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][14]['updatedAt']
                ]
            ],
            'action' => 'viewBusinessHoursSysAdmin',
            'security' =>[
                'security' => 1,
            ]
        ];

        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Business Hours found', $decodedOutput['message']);
        $this->assertEquals($expectedResult, $decodedOutput);
    }
    public function test089UpdateBusinessHoursSysSupport(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 2;
        $_POST =[
            'action' => 'updateBusinessHours',
            'tenantBusinessHours' => [
                'businessHoursId' => 1,
                'hoursCategory' => 'store',
                'openingDay' => 'Monday',
                'openTime' => '10:00:00',
            ],
            'debug'=>'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test090UpdateBusinessHoursOwner(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_POST =[
            'action' => 'updateBusinessHours',
            'tenantBusinessHours' => [
                'businessHoursId' => 3,
                'hoursCategory' => 'store',
                'isClosed' => '1',
            ],
            'debug'=>'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test091UpdateBusinessHoursManager(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_POST =[
            'action' => 'updateBusinessHours',
            'tenantBusinessHours' => [
                'businessHoursId' => 6,
                'hoursCategory' => 'store',
                'isClosed' => '1',
            ],
            'debug'=>'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test092UpdateBusinessHoursManagerHoursIdDoesNotExist(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 5;
        $_POST =[
            'action' => 'updateBusinessHours',
            'tenantBusinessHours' => [
                'businessHoursId' => 72,
                'hoursCategory' => 'store',
                'isClosed' => '1',
            ],
            'debug'=>'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('No content found for the id 72 | No data found for history', $decodedOutput['message']);
    }
    public function test093DeleteBusinessHoursManager(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_POST =[
            'action' => 'deleteBusinessHours',
            'tenantBusinessHours' => [
                'businessHoursId' => 11,
                'isDeleted' => 1,
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test094ViewBusinessHoursSysAdminAfterUpdatesAndDelets(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewBusinessHoursSysAdmin',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Business Hours found',
            'businessHour' => [
                0 => [
                    'tenantId' => 1,
                    'businessHourId' => 1,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Monday',
                    'specificDate' => null,
                    'openTime' => '10:00:00',
                    'closeTime' => '17:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][0]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][0]['updatedAt']
                ],
                1 => [
                    'tenantId' => 1,
                    'businessHourId' => 2,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Tuesday',
                    'specificDate' => null,
                    'openTime' => null,
                    'closeTime' => null,
                    'isClosed' => 1,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][1]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][1]['updatedAt']
                ],
                2 => [
                    'tenantId' => 1,
                    'businessHourId' => 3,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Wednesday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '18:00:00',
                    'isClosed' => 1,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][2]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][2]['updatedAt']
                ],
                3 => [
                    'tenantId' => 1,
                    'businessHourId' => 4,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Thursday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '18:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][3]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][3]['updatedAt']
                ],
                4 => [
                    'tenantId' => 1,
                    'businessHourId' => 5,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Friday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '22:30:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][4]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][4]['updatedAt']
                ],
                5 => [
                    'tenantId' => 1,
                    'businessHourId' => 6,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Saturday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '23:00:00',
                    'isClosed' => 1,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][5]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][5]['updatedAt']
                ],
                6 => [
                    'tenantId' => 1,
                    'businessHourId' => 7,
                    'hoursCategory' => 'store',
                    'openingDay' => 'Sunday',
                    'specificDate' => null,
                    'openTime' => '09:00:00',
                    'closeTime' => '17:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][6]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][6]['updatedAt']
                ],
                7 => [
                    'tenantId' => 1,
                    'businessHourId' => 8,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Monday',
                    'specificDate' => null,
                    'openTime' => '15:00:00',
                    'closeTime' => '18:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][7]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][7]['updatedAt']
                ],
                8 => [
                    'tenantId' => 1,
                    'businessHourId' => 9,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Tuesday',
                    'specificDate' => null,
                    'openTime' => null,
                    'closeTime' => null,
                    'isClosed' => 1,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][8]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][8]['updatedAt']
                ],
                9 => [
                    'tenantId' => 1,
                    'businessHourId' => 10,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Wednesday',
                    'specificDate' => null,
                    'openTime' => '15:00:00',
                    'closeTime' => '18:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][9]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][9]['updatedAt']
                ],
                10 => [
                    'tenantId' => 1,
                    'businessHourId' => 11,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Thursday',
                    'specificDate' => null,
                    'openTime' => '16:00:00',
                    'closeTime' => '20:00:00',
                    'isClosed' => null,
                    'isDeleted' => 1,
                    'createdAt' => $decodedOutput['businessHour'][10]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][10]['updatedAt']
                ],
                11 => [
                    'tenantId' => 1,
                    'businessHourId' => 12,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Friday',
                    'specificDate' => null,
                    'openTime' => '16:00:00',
                    'closeTime' => '00:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][11]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][11]['updatedAt']
                ],
                12 => [
                    'tenantId' => 1,
                    'businessHourId' => 13,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Saturday',
                    'specificDate' => null,
                    'openTime' => '16:00:00',
                    'closeTime' => '00:00:00',
                    'isClosed' => null,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][12]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][12]['updatedAt']
                ],
                13 => [
                    'tenantId' => 1,
                    'businessHourId' => 14,
                    'hoursCategory' => 'delivery',
                    'openingDay' => 'Sunday',
                    'specificDate' => null,
                    'openTime' => null,
                    'closeTime' => null,
                    'isClosed' => 1,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][13]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][13]['updatedAt']
                ],
                14 => [
                    'tenantId' => 1,
                    'businessHourId' => 15,
                    'hoursCategory' => 'special',
                    'openingDay' => null,
                    'specificDate' => date('Y-m-d', strtotime('+9 days')),
                    'openTime' => null,
                    'closeTime' => null,
                    'isClosed' => 1,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['businessHour'][14]['createdAt'],
                    'updatedAt' => $decodedOutput['businessHour'][14]['updatedAt']
                ]
            ],
            'action' => 'viewBusinessHoursSysAdmin',
            'security' =>[
                'security' => 1,
            ]
        ];

        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Business Hours found', $decodedOutput['message']);
        $this->assertEquals($expectedResult, $decodedOutput);
    }
    public function test095ViewBusinessHoursPublicWithSeedDataUpdated() {
        $_SESSION['id'] = 293;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewBusinessHoursPublic',
            'debug' => 'CSD'
        ];
    
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput, true); // Uncomment for debugging
    
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Business Hours found', $decodedOutput['message']);
        $this->assertArrayHasKey('businessHour', $decodedOutput);
    
        // Expected business hours based on seeded data
        $weekdayMap = [
            'Monday'    => ['store' => ['10:00:00', '17:00:00'],            'delivery' => ['15:00:00', '18:00:00']],
            'Tuesday'   => ['store' => [null, null, '1'],                   'delivery' => [null, null, '1']],
            'Wednesday' => ['store' => [null, null, '1'],                   'delivery' => ['15:00:00', '18:00:00']],
            'Thursday'  => ['store' => ['09:00:00', '18:00:00']], // No delivery on Thursday (deleted)
            'Friday'    => ['store' => ['09:00:00', '22:30:00'],            'delivery' => ['16:00:00', '00:00:00']],
            'Saturday'  => ['store' => [null, null, '1'],                   'delivery' => ['16:00:00', '00:00:00']],
            'Sunday'    => ['store' => ['09:00:00', '17:00:00'],            'delivery' => [null, null, '1']],
        ];
    
        // Validate business hours for the next 7 days
        for ($i = 0; $i <= 7; $i++) {
            $date = date('Y-m-d', strtotime("+$i days"));
            $weekday = date('l', strtotime($date)); // e.g. "Monday"
    
            foreach (['store', 'delivery'] as $category) {
                // ❗ Skip validation if not defined in the map
                if (!isset($weekdayMap[$weekday][$category])) {
                    continue;
                }
    
                $expected = [
                    'generatedDate' => $date,
                    'tenantId' => 1,
                    'hoursCategory' => $category,
                    'openTime'  => $weekdayMap[$weekday][$category][0] ?? '',
                    'closeTime' => $weekdayMap[$weekday][$category][1] ?? '',
                    'isClosed'  => $weekdayMap[$weekday][$category][2] ?? ''
                ];
    
                $matchFound = false;
    
                foreach ($decodedOutput['businessHour'] as $row) {
                    if (
                        $row['generatedDate'] === $expected['generatedDate'] &&
                        $row['hoursCategory'] === $expected['hoursCategory']
                    ) {
                        $this->assertEquals($expected['tenantId'], $row['tenantId']);
                        $this->assertEquals($expected['openTime'] ?? '', $row['openTime']);
                        $this->assertEquals($expected['closeTime'] ?? '', $row['closeTime']);
                        $this->assertEquals((string)($expected['isClosed'] ?? ''), (string)($row['isClosed'] ?? ''));
                        $matchFound = true;
                        break;
                    }
                }
    
                $this->assertTrue($matchFound, "Expected entry not found for {$category} on {$date}");
            }
        }
    
        // ✅ Validate presence of a single special closed day
        $specials = array_filter($decodedOutput['businessHour'], function ($entry) {
            return $entry['hoursCategory'] === 'special' && (string)$entry['isClosed'] === '1';
        });
    
        $this->assertCount(1, $specials, "Expected exactly 1 special closed day");
    
        $special = reset($specials);
        $this->assertArrayHasKey('generatedDate', $special);
        $this->assertEquals('special', $special['hoursCategory']);
        $this->assertEquals('1', (string)$special['isClosed']);
    }
    public function test096ViewTenantChangeHistoryNoAuth(){
        $_SESSION['id'] = 293;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantChangeHistory',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test097ViewTenantChangeHistory() {
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantChangeHistory',
            'debug' => 'CSD'
        ];
    
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
    
        // Top-level validation
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('History found', $decodedOutput['message']);
        $this->assertArrayHasKey('history', $decodedOutput);
        $this->assertIsArray($decodedOutput['history']);
    
        foreach ($decodedOutput['history'] as $entry) {
            // Validate core structure
            $this->assertArrayHasKey('historyId', $entry);
            $this->assertArrayHasKey('tenantId', $entry);
            $this->assertArrayHasKey('actionType', $entry);
            $this->assertArrayHasKey('tableOfSource', $entry);
            $this->assertArrayHasKey('oldValue', $entry);
            $this->assertArrayHasKey('actionBy', $entry);
            $this->assertArrayHasKey('actionAt', $entry); // we won’t compare values
    
            // Validate actionType and tableOfSource (optional, but good sanity check)
            $this->assertContains($entry['actionType'], ['update', 'delete']);
            $this->assertNotEmpty($entry['tableOfSource']);
    
            // Validate oldValue is JSON and has expected keys
            $decodedOldValue = json_decode($entry['oldValue'], true);
            $this->assertIsArray($decodedOldValue, "Failed to decode oldValue for historyId {$entry['historyId']}");
    
            // Light check for presence of key properties
            $this->assertArrayHasKey('id', $decodedOldValue);
        }
    
        // Optional: check at least N entries exist
        $this->assertGreaterThanOrEqual(1, count($decodedOutput['history']), 'No history entries returned');
    }
    public function test098ViewAllTenantsSuperAdmin(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'viewAllTenantsSuperAdmin',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Tenant found', $decodedOutput['message']);
    }
    public function test099ViewAllTenantsSuperAdminWrongRole(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_POST = [
            'action' => 'viewAllTenantsSuperAdmin',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test100UnsetTennantSuperAdminIdAsSuperAdmin(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'clearTenantId',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test101UnsetTennantSuperAdminIdAsOwner(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'clearTenantId',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test102UnsetTennantSuperAdminIdAsSuperAdminNoSet(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'clearTenantId',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test103TennantThemeSetActive(){
    
        $stmt = $this->mockPdo->query("SELECT * FROM tenant_theme where is_deleted = 0 and tenant_id = 1" );
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);

        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals("yes", $rows[0]['is_applied']);
        $this->assertEquals("active", $rows[0]['theme_status']);
        $this->assertEquals("no", $rows[1]['is_applied']);
        $this->assertEquals("draft", $rows[1]['theme_status']);
        // --------------------------- Request

        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenantTheme',
            'debug' => 'CSD',
            'tenantTheme' => [
                'themeId' => 2,
                'isApplied' => 'yes',
                'themeStatus' => 'active',
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);

        // --------------------------- After Change

        $stmt = $this->mockPdo->query("SELECT * FROM tenant_theme where is_deleted = 0 and tenant_id = 1" );
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);

        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals("yes",      $rows[1]['is_applied']);
        $this->assertEquals("active",   $rows[1]['theme_status']);
        $this->assertEquals("no",       $rows[0]['is_applied']);
        $this->assertEquals("draft",    $rows[0]['theme_status']);

    }
    public function test104InsertNewThemeForTenantThree(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 3;
        $_POST = [
            'action' => 'addNewTenantTheme',
            'tenantTheme' => [
                'themeName' => "Fishy Fish V1",
                'primaryColor' => "#000000",
                'secondaryColor' => "#000000",
                'textColor' => "#000000",
                'secondaryTextColor' => "#000000",
                'accentColor' => "#000000",
                'backgroundColor' => "#000000",
                'buttonColor' => "#000000",
                'isApplied' => "no",
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
        
        
        $_POST = [
            'action' => 'addNewTenantTheme',
            'tenantTheme' => [
                'themeName' => "Fishy Fish V2",
                'primaryColor' => "#ffffff",
                'secondaryColor' => "#ffffff",
                'textColor' => "#ffffff",
                'secondaryTextColor' => "#ffffff",
                'accentColor' => "#ffffff",
                'backgroundColor' => "#ffffff",
                'buttonColor' => "#ffffff",
                'isApplied' => 'no'
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test105UpdateThemeToActvieForTenantThree(){
        $stmt = $this->mockPdo->query("SELECT * FROM tenant_theme where tenant_id = 3" );
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals("Fishy Fish V1", $rows[0]['theme_name']);
        $this->assertEquals("draft", $rows[0]['theme_status']);
        $this->assertEquals("no", $rows[0]['is_applied']);
        $this->assertEquals("Fishy Fish V2", $rows[1]['theme_name']);
        $this->assertEquals("draft", $rows[1]['theme_status']);
        $this->assertEquals("no", $rows[1]['is_applied']);
        // --------------------------- Request
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 3;
        $_POST = [
            'action' => 'updateTenantTheme',
            'debug' => 'CSD',
            'tenantTheme' => [
                'themeId' => 4,
                'themeStatus' => 'active',
            ]
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);

        $stmt = $this->mockPdo->query("SELECT * FROM tenant_theme where tenant_id = 3" );
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals("Fishy Fish V1", $rows[0]['theme_name']);
        $this->assertEquals("active", $rows[0]['theme_status']);
        $this->assertEquals("yes", $rows[0]['is_applied']);
        $this->assertEquals("Fishy Fish V2", $rows[1]['theme_name']);
        $this->assertEquals("draft", $rows[1]['theme_status']);
        $this->assertEquals("no", $rows[1]['is_applied']);

        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 3;
        $_POST = [
            'action' => 'updateTenantTheme',
            'debug' => 'CSD',
            'tenantTheme' => [
                'themeId' => 5,
                'themeStatus' => 'active',
            ]
        ];
    
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);

        $stmt = $this->mockPdo->query("SELECT * FROM tenant_theme where tenant_id = 3" );
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals("Fishy Fish V1", $rows[0]['theme_name']);
        $this->assertEquals("draft", $rows[0]['theme_status']);
        $this->assertEquals("no", $rows[0]['is_applied']);
        $this->assertEquals("Fishy Fish V2", $rows[1]['theme_name']);
        $this->assertEquals("active", $rows[1]['theme_status']);
        $this->assertEquals("yes", $rows[1]['is_applied']);
    }
    public function test106GetCurrentAccountInfo(){
        $stmt = $this->mockPdo->query("SELECT * FROM tenant");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
    
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals("1", "1");
    }
    public function test107GetCurrentAccountTheme(){
        $stmt = $this->mockPdo->query("SELECT * FROM tenant_theme where tenant_id = 3");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
    
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals("1", "1");
    }
    public function test108InsertNewTenantDeliveryRules(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'addNewTenantDeliveryRules',
            'tenantDeliveryRules' => [
                'minimumDeliveryAmount' => 0,
                'deliveryCharge' => 5
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);

        $stmt = $this->mockPdo->query("SELECT * FROM tenant_delivery_rules where tenant_id = 1 and id=1");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals(0, $rows[0]['minimum_delivery_amount']);
        $this->assertEquals(5, $rows[0]['delivery_charge']);
        $this->assertEquals(0, $rows[0]['is_active']);
        $this->assertEquals(0, $rows[0]['is_deleted']);

    }
    public function test109InsertNewTenantDeliveryRulesSetActive(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'addNewTenantDeliveryRules',
            'tenantDeliveryRules' => [
                'minimumDeliveryAmount' => 10,
                'deliveryCharge' => 2,
                'isActive' => 1,
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
        $stmt = $this->mockPdo->query("SELECT * FROM tenant_delivery_rules where tenant_id = 1 and id=2");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals(10, $rows[0]['minimum_delivery_amount']);
        $this->assertEquals(2, $rows[0]['delivery_charge']);
        $this->assertEquals(1, $rows[0]['is_active']);
        $this->assertEquals(0, $rows[0]['is_deleted']);
    }
    public function test110InsertNewTenantDeliveryRulesSetWithStrings(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'addNewTenantDeliveryRules',
            'tenantDeliveryRules' => [
                'minimumDeliveryAmount' => "twenty",
                'deliveryCharge' => 3,
                'isActive' => 1,
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('failed', $decodedOutput['status']);
        
    }
    public function test111UpdateTenantMinumunFeeAndMinOrderAmount(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenant',
            'tenant' => [
                'minimumOrderAmount' => 12,
                'smallOrderFee' => 0.5,
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $stmt = $this->mockPdo->query("SELECT * FROM tenant where id = 1");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals(12, $rows[0]['minimum_order_amount']);
        $this->assertEquals(0.5, $rows[0]['small_order_fee']);

    }
    public function test112InsertNewTenantDeliveryRulesTwo(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'addNewTenantDeliveryRules',
            'tenantDeliveryRules' => [
                'minimumDeliveryAmount' => 20,
                'deliveryCharge' => 0,
                'isActive' => 1,
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);

        $stmt = $this->mockPdo->query("SELECT * FROM tenant_delivery_rules where tenant_id = 1 and id=3");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals(20, $rows[0]['minimum_delivery_amount']);
        $this->assertEquals(0, $rows[0]['delivery_charge']);
        $this->assertEquals(1, $rows[0]['is_active']);
        $this->assertEquals(0, $rows[0]['is_deleted']);

    }
    public function test113UpdateDeliveryRulesSetActive(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenantDeliveryRules',
            'deliveryRulesId' => 2,
            'tenantDeliveryRules' => [
                'minimumDeliveryAmount' => 20,
                'deliveryCharge' => 3,
                'isActive' => 1,
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
        
        $stmt = $this->mockPdo->query("SELECT * FROM tenant_delivery_rules where tenant_id = 1 and id=2");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals(20, $rows[0]['minimum_delivery_amount']);
        $this->assertEquals(3, $rows[0]['delivery_charge']);
        $this->assertEquals(1, $rows[0]['is_active']);
    }
    /*
        public function test114UpdateDeliveryRulesSetActiveAndString(){ // Review Later 
            $_SESSION['id'] = 293;
            $_SESSION['roleValue'] = 1;
            $_SESSION['tenantId'] = 3;
            $_POST = [
                'action' => 'updateTenantDeliveryRules',
                'deliveryRulesId' => 2,
                'tenantDeliveryRules' => [
                    'minimumOrderAmount' => "twenty",
                    'deliveryCharge' => 3,
                    'isActive' => 1,
                ],
                'debug' => 'CSD'
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('Failed', $decodedOutput['status']);
            
            $stmt = $this->mockPdo->query("SELECT * FROM tenant_delivery_rules where tenant_id = 3 and id=2");
            $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals(20, $rows[0]['minimum_order_amount']);
            $this->assertEquals(3, $rows[0]['delivery_charge']);
            $this->assertEquals(1, $rows[0]['is_active']);
        }
    */
    public function test115DeleteDeliveryRules(){
            $_SESSION['id'] = 293;
            $_SESSION['roleValue'] = 1;
            $_SESSION['tenantId'] = 1;
            $_POST = [
                'action' => 'deleteTenantDeliveryRules',
                'deliveryRulesId' => 2,
                'tenantDeliveryRules' => [
                    'isDeleted' => 1,
                ],
                'debug' => 'CSD'
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //print_r($decodedOutput); // or var_dump($decodedOutput)
            //$this->assertEquals('success', $decodedOutput['status']);
            
            $stmt = $this->mockPdo->query("SELECT * FROM tenant_delivery_rules where tenant_id = 1 and id=2");
            $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals(1, $rows[0]['is_deleted']);
    }
    public function test116ViewDeliveryRulesPublic(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = null; // No role for public access
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantDeliveryRulesPublic',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Delivery rules found',
            'deliveryRules' => [
                'minimumDeliveryAmount' => 20,
                'deliveryCharge' => 0,
            ],
            'action' => 'viewTenantDeliveryRulesPublic',
            'security' => [
                'security' => 1,
            ]
        ];
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Delivery rules found', $decodedOutput['message']);
        $this->assertEquals($expectedResult['deliveryRules'], $decodedOutput['deliveryRules']);

    }
    public function test117ViewDeliveryRulesOwner(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantDeliveryRulesOwner',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Delivery rules found',
            'deliveryRules' => [
                [
                'minimumDeliveryAmount' => 0,
                'deliveryCharge' => 5,
                'isActive' => 0,
                'deliveryRulesId' => 1,
                ],
                [
                'minimumDeliveryAmount' => 20,
                'deliveryCharge' => 0,
                'isActive' => 1,
                'deliveryRulesId' => 3,
                ]
            ],
            'action' => 'viewTenantDeliveryRulesOwner',
            'security' => [
                'security' => 1,
            ]
        ];
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Delivery rules found', $decodedOutput['message']);
        $this->assertEquals($expectedResult['deliveryRules'], $decodedOutput['deliveryRules']);
    }
    public function test118ViewDeliveryRulesSysAdmin(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantDeliveryRulesSysAdmin',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $expectedResult = [
            'status' => 'success',
            'message' => 'Delivery rules found',
            'deliveryRules' => [
                [
                    'minimumDeliveryAmount' => 0,
                    'deliveryCharge' => 5,
                    'tenantId' => 1,
                    'deliveryRulesId' => 1,
                    'isActive' => 0,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['deliveryRules'][0]['createdAt'],
                    'updatedAt' => $decodedOutput['deliveryRules'][0]['updatedAt']
                ],
                [
                    'deliveryRulesId' => 2,
                    'tenantId' => 1,
                    'minimumDeliveryAmount' => 20,
                    'deliveryCharge' => 3,
                    'isActive' => 0,
                    'isDeleted' => 1,
                    'createdAt' => $decodedOutput['deliveryRules'][1]['createdAt'],
                    'updatedAt' => $decodedOutput['deliveryRules'][1]['updatedAt']
                ],
                [
                    'deliveryRulesId' => 3,
                    'tenantId' => 1,
                    'minimumDeliveryAmount' => 20,
                    'deliveryCharge' => 0,
                    'isActive' => 1,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['deliveryRules'][2]['createdAt'],
                    'updatedAt' => $decodedOutput['deliveryRules'][2]['updatedAt']
                ]
            ],
            'action' => 'viewTenantDeliveryRulesSysAdmin',
            'security' => [
                'security' => 1,
            ]
        ];
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Delivery rules found', $decodedOutput['message']);
        $this->assertEquals($expectedResult['deliveryRules'], $decodedOutput['deliveryRules']);

    }
    public function test119UpdateDeliveryRulesSetActiveTwo(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenantDeliveryRules',
            'deliveryRulesId' => 1,
            'tenantDeliveryRules' => [
                'isActive' => 1,
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
        
        $stmt = $this->mockPdo->query("SELECT * FROM tenant_delivery_rules where tenant_id = 1 and id in (1,3)");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals(0, $rows[0]['minimum_delivery_amount']);
        $this->assertEquals(5, $rows[0]['delivery_charge']);
        $this->assertEquals(1, $rows[0]['is_active']);
        $this->assertEquals(20, $rows[1]['minimum_delivery_amount']);
        $this->assertEquals(0, $rows[1]['delivery_charge']);
        $this->assertEquals(1, $rows[1]['is_active']);
    }
    /*
        public function test120InsertFees(){
            $_SESSION['id'] = 293;
            $_SESSION['roleValue'] = 1;
            $_SESSION['tenantId'] = 1;
            $_POST = [
                'action' => 'insertTenantFees',
                'tenantAdminFees' => [
                    'customerAdminFee' => 0.79,
                    'tenantAdminFee' => 0.71,
                    'isActive' => 1,
                ],
                'debug' => 'CSD'
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //print_r($decodedOutput);
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Tenant admin fees inserted successfully', $decodedOutput['message']);

            $stmt = $this->mockPdo->query("SELECT * FROM tenant_admin_fees where tenant_id = 1 and id=1");
            $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals(0.79, $rows[0]['customer_admin_fee']);
            $this->assertEquals(0.71, $rows[0]['tenant_admin_fee']);
            $this->assertEquals(1, $rows[0]['is_active']);
            $this->assertEquals(1, $rows[0]['tenant_id']);
            $this->assertEquals(0, $rows[0]['is_deleted']);
        }
        public function test121InsertFeesCheckActiveDisables(){
            $_SESSION['id'] = 293;
            $_SESSION['roleValue'] = 1;
            $_SESSION['tenantId'] = 1;
            $_POST = [
                'action' => 'insertTenantFees',
                'tenantAdminFees' => [
                    'customerAdminFee' => 0.69,
                    'tenantAdminFee' => 0.31,
                    'isActive' => 1,
                ],
                'debug' => 'CSD'
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //print_r($decodedOutput);
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals('Tenant admin fees inserted successfully', $decodedOutput['message']);

            $stmt = $this->mockPdo->query("SELECT * FROM tenant_admin_fees where tenant_id = 1 order by id asc");
            $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows); // or var_dump($rows)
            $this->assertEquals(0.79, $rows[0]['customer_admin_fee']);
            $this->assertEquals(0.71, $rows[0]['tenant_admin_fee']);
            $this->assertEquals(0, $rows[0]['is_active']);
            $this->assertEquals(1, $rows[0]['tenant_id']);
            $this->assertEquals(0, $rows[0]['is_deleted']);

            $this->assertEquals(0.69, $rows[1]['customer_admin_fee']);
            $this->assertEquals(0.31, $rows[1]['tenant_admin_fee']);
            $this->assertEquals(1, $rows[1]['tenant_id']);
            $this->assertEquals(0, $rows[1]['is_deleted']);
            $this->assertEquals(1, $rows[1]['is_active']);
        }
        public function test122InsertFeesNotAdmin(){
            $_SESSION['id'] = 293;
            $_SESSION['roleValue'] = 4; // Owner role
            $_SESSION['tenantId'] = 1;
            $_POST = [
                'action' => 'insertTenantFees',
                'tenantAdminFees' => [
                    'customerAdminFee' => 0.79,
                    'tenantAdminFee' => 0.71,
                    'isActive' => 1,
                ],
                'debug' => 'CSD'
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //print_r($decodedOutput);
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
        }
    */
    public function test123UpdateFees(){
        // view current fees
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenantFees',
            'tenantAdminFeesId' => 1,
            'tenantAdminFees' => [
                'customerAdminFee' => 0.89,
                'tenantAdminFee' => 0.11,
                'isActive' => 1,
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Content updated successfully', $decodedOutput['message']);

        $stmt = $this->mockPdo->query("SELECT * FROM tenant_admin_fees where tenant_id = 1 and id=1");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals(0.89, $rows[0]['customer_admin_fee']);
        $this->assertEquals(0.11, $rows[0]['tenant_admin_fee']);
    }
    public function test124DeleteFees(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'deleteTenantFees',
            'tenantAdminFeesId' => 1,
            'tenantAdminFees' => [
                'isDeleted' => 1,
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Content updated successfully', $decodedOutput['message']);

        $stmt = $this->mockPdo->query("SELECT * FROM tenant_admin_fees where tenant_id = 1 and id=1");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals(1, $rows[0]['is_deleted']);
    }
    public function test125UpdateFeesId2(){
        // view current fees
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'updateTenantFees',
            'tenantAdminFeesId' => 2,
            'tenantAdminFees' => [
                'isActive' => 1,
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Content updated successfully', $decodedOutput['message']);
    }
    public function test126DataFeesConfig(){
        // update fees config to enabled and not delted
        $stmt = $this->mockPdo->query("update tenant_admin_fees set is_active = 1, is_deleted = 0 where id = 1" );
        $this->assertEquals(1, $stmt->rowCount());

    }
    public function test127ViewDataFromtenant_admin_fees(){
        $stmt = $this->mockPdo->query("SELECT * FROM tenant_admin_fees where tenant_id = 1");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals(0.89, $rows[0]['customer_admin_fee']);
        $this->assertEquals(0.11, $rows[0]['tenant_admin_fee']);
        $this->assertEquals(1, $rows[0]['is_active']);
        $this->assertEquals(1, $rows[0]['tenant_id']);
        $this->assertEquals(0, $rows[0]['is_deleted']);
    }
    public function test128ViewPublicTenantFees(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = null; // No role for public access
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantFeesPublic',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Tenant fees found',
            'fees' => [
                'serviceFee' => 0.89,
            ],
            'action' => 'viewTenantFeesPublic',
            'security' => [
                'security' => 1,
            ]
        ];
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Tenant fees found', $decodedOutput['message']);
        $this->assertEquals($expectedResult, $decodedOutput);
    }
    public function test129ViewOwnerTenantFees(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4;
        $_SESSION['roleTenantId'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantFeesOwner',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Tenant fees found',
            'fees' => [
                [
                    'customerAdminFee' => 0.89,
                    'tenantAdminFee' => 0.11,
                    'isActive' => 1,
                    'feesId' => 1,
                ]
            ],
            'action' => 'viewTenantFeesOwner',
            'security' => [
                'security' => 1,
            ]
        ];
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Tenant fees found', $decodedOutput['message']);
        $this->assertEquals($expectedResult, $decodedOutput);
    }
    public function test130ViewSysAdminTenantFees(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'viewTenantFeesSysAdmin',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedResult = [
            'status' => 'success',
            'message' => 'Tenant fees found',
            'fees' => [
                [
                    'customerAdminFee' => 0.89,
                    'tenantAdminFee' => 0.11,
                    'isActive' => 1,
                    'tenantId' => 1,
                    'feesId' => 1,
                    'isDeleted' => 0,
                    'createdAt' => $decodedOutput['fees'][0]['createdAt'],
                    'updatedAt' => $decodedOutput['fees'][0]['updatedAt']
                ],
                
            ],
            'action' => 'viewTenantFeesSysAdmin',
            'security' => [
                'security' => 1,
            ]
        ];
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Tenant fees found', $decodedOutput['message']);
        $this->assertEquals($expectedResult, $decodedOutput);
    }
    public function test131setTenantStripeDomain(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'setTenantStripeDomain',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test132setTenantStripeDomain(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 999;
        $_POST = [
            'action' => 'setTenantStripeDomain',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('tenantId is not valid', $decodedOutput['message']);
    }
    public function test133setTenantStripeDomain(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4; // Owner role
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'setTenantStripeDomain',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test134deleteTenantStripeDomain(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'deleteTenantStripeDomain',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test135deleteTenantStripeDomain(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 999;
        $_POST = [
            'action' => 'deleteTenantStripeDomain',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('tenantId is not valid', $decodedOutput['message']);
    }
    public function test136deleteTenantStripeDomain(){
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 4; // Owner role
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'deleteTenantStripeDomain',
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test137InsertOrderPause(){

        $stmt = $this->mockPdo->query("Select * FROM tenant_pause_active where tenant_id = 1");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals(0, count($rows));
        $_SESSION['id'] = 293;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 1;
        $_POST = [
            'action' => 'insertOrderPause',
            'tenantPauseActive' => [
                'isClosedCollection' => 1,
                'isClosedDelivery' => 1,
                'pauseStartAt'  => date('Y-m-d H:i:s'), // now    
                'pauseUntil'    => date('Y-m-d H:i:s', strtotime('+15 minutes')), // now plus 15 minutes
                'pauseType'     => 'MINUTES_15',
            ],
            'debug' => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        // Debug output
        //print_r($decodedOutput); // or var_dump($decodedOutput)
        $this->assertEquals('success', $decodedOutput['status']);

        // check if the order pause was inserted correctly
        $stmt = $this->mockPdo->query("Select * FROM tenant_pause_active where tenant_id = 1");
        $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
        // Debug output
        //print_r($rows); // or var_dump($rows)
        $this->assertEquals(1, count($rows));   
        $this->assertEquals(1, $rows[0]['is_closed_collection']);
        $this->assertEquals(1, $rows[0]['is_closed_delivery']);
    }
    /* To Do: 
        - test view as sysadmin with a deleted tenant
        - test view as owner with a deleted tenant
        - test view as public with a deleted tenant
    */
}
?>