<?php

    namespace Azui\Orbit\Tenant;

    function genericUpdateStatment($inputData) {
        $tableName = $inputData['tableName'];
        $idName = $inputData['idName'];
        $tablesColumn = tableColumnMapping();
        $extraSetsSql = "  ";
        $extraSqlToPass = " ";
    
        if (!isset($tablesColumn[$tableName])) {
            return [
                'status' => 'failed',
                'message' => "Table mapping not found for: $tableName"
            ];
        }
    
        $columnMap = $tablesColumn[$tableName];
        $updateParts = [];
        $bindParams = [];
    
        foreach ($columnMap as $key => $meta) {
            if (isset($inputData[$tableName][$key]) && isset($meta['mapping'])) {
                $updateParts[] = "{$meta['mapping']} = :$key";
                $bindParams[$key] = $inputData[$tableName][$key];
                $meta['updateRole'] = array_unique($meta['updateRole']);
                $userRole = $inputData['roleId'] ?? null;
                if ($userRole !== null && !in_array($userRole, $meta['updateRole'])) {
                    return [
                        'status' => 'failed',
                        'message' => "User role $userRole not allowed to update $key"
                    ];
                }
                // Check if the value is empty and if the user role is not allowed to update it
            }
        }
        // check if the field is domain that is being updated 
        if($tableName == 'tenant' && isset($inputData[$tableName]['domain'])){
            // strip any http or https from the domain and www
            $inputData[$tableName]['domain'] = preg_replace('#^https?://#', '', rtrim($inputData[$tableName]['domain'], '/'));
            $inputData[$tableName]['domain'] = preg_replace('#^www\.#', '', $inputData[$tableName]['domain']);  
            $inputData[$tableName]['domain'] = 'https://'.$inputData[$tableName]['domain'];
        }
    
        if (empty($updateParts)) {
            return [
                'status'    => 'failed',
                'message'   => 'No data to update',
                'columns'   => $columnMap,
                'input'     => $inputData[$tableName]
            ];
        }

        $sqlAdd = '';

        if($inputData['actionType'] == 'delete'){
            if($inputData['checkParent'] == 1){
               $sqlAdd = " or parent_id = :id2"; 
            }
            // Step 4: check if there is an is_active field and if it is set to 0 then do delete
            if(in_array('tenantStatus', array_keys($columnMap))){
                $extraSetsSql .= " , tenant_status = 'deleted' ";
            }
            if(in_array('isApplied', array_keys($columnMap))){
                $extraSetsSql .= " , is_applied = 'no' ";
            }
            if(in_array('themeStatus', array_keys($columnMap))){
                $extraSetsSql .= " , theme_status = 'deleted' ";
            }
            if(in_array('isActive', array_keys($columnMap))){
                $res = isActiveDisableOnDelete($inputData, $tableName, $inputData[$tableName][$idName . 'Id'] ?? $inputData[$idName . 'Id']);
                if($res['status'] == 'failed'){
                    return ['status' => 'failed', 'message' => $res['message']];
                }
            }
            // check if the delete if for a tenant, if so we need to disable the account permissions
            if($tableName == 'tenant'){
                $res = disableAccountOnTenantDelete($inputData);
                if($res['status'] == 'failed'){
                    return ['status' => 'failed', 'message' => $res['message']];
                }
            }
        }
            
        if(isset($inputData[$tableName]['themeStatus']) && $inputData[$tableName]['themeStatus'] == 'active'){
            $extraSetsSql .= " , is_applied = 'yes' ";
        }

        // Build SQL
        $tempTableName = toSnakeCase($tableName);
        $setClause = implode(', ', $updateParts);
        $whereClause = "id = :id";
        $sql = "UPDATE $tempTableName SET $setClause {$extraSetsSql} WHERE $whereClause ".$sqlAdd;
    
        //error_log("Generated SQL: $sql");

        try {
            $pdo = $inputData['db']['dbApp'];
            $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
            $stmt = $pdo->prepare($sql);
    
            foreach ($bindParams as $param => $value) {
                $stmt->bindValue(":$param", $value);
                //error_log("Binding parameter :$param with value: " . print_r($value, true));
            }

    
            // Bind ID for WHERE clause
            $rowId = $inputData[$tableName][$idName . 'Id'] ?? null;
            if ($rowId === null) {
                $rowId = $inputData[$idName . 'Id'] ?? null;
            }
            if ($rowId === null) {
                return [
                    'status' => 'failed',
                    'message' => 'Missing '.$idName.'Id for WHERE clause'
                ];
            }
            if($inputData['actionType'] == 'delete'){
                if($inputData['checkParent'] == 1){
                    $stmt->bindValue(':id2', $rowId);
                }
            }
            
            $tempRes = "Not Run yet";

            if(isset($inputData[$tableName]['isApplied']) && $inputData[$tableName]['isApplied'] == 'yes'|| isset($inputData[$tableName]['themeStatus']) && $inputData[$tableName]['themeStatus'] == 'active'){
                if(in_array('isApplied', array_keys($columnMap))){    
                    if(in_array('themeStatus', array_keys($columnMap))){
                        $extraSqlToPass .= " , theme_status = 'draft', is_applied = 'no' ";
                    }
                    $tempRes = disableAnyApplied($inputData, $tempTableName, $extraSqlToPass);
                    if($tempRes['status'] == 'failed'){
                        return ['res' => $tempRes, 'SQL' => "hi"];
                    }
                }
            }

            if(isset($inputData[$tableName]['isActive']) && $inputData[$tableName]['isActive'] == 1 && $inputData['tableName'] != 'tenantDeliveryRules' ){
               $res = isActiveDisable($inputData, $tableName);
               if($res['status'] == 'failed'){
                    return ['status' => 'failed', 'message' => $res['message']];
                }
            }

            $stmt->bindValue(':id', $rowId);
            $stmt->execute();

            if ($stmt->rowCount() === 0) {
                return [
                    'status' => 'failed',
                    'message' => 'No rows updated. Data may be identical or '.$tableName.'Id not found.'
                ];
            }
    
            return [
                'status' => 'success',
                'message' => 'Update successful',
            ];
        } catch (\PDOException $e) {
            //$e->queryString = $sql ?? '';
            //$e->queryInput = $inputData[$tableName] ?? [];
            throw $e;
        }
    }
    function addTenantToParent($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
        $sql = "update tenant set parent_id = :parentId where id = :tenantId";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':parentId', $inputData['tenant']['parentId']);
        $stmt->bindParam(':tenantId', $inputData['tenant']['tenantId']);
        $stmt->execute();
        return [
            'status' => 'success',
            'message' => 'Tenant added to parent successfully'
        ];
    }
    function disableAnyApplied($inputData, $tableName, $extraSqlToPass){
        $tenantId = $inputData['tenantId'];
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

        // Step 1: check if there are any reccords that match our condition

        $sql = "select count(*) as count from $tableName where tenant_id = :tenantId and is_deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tenantId', $tenantId);
        $stmt->execute();
        $result = $stmt->fetch(\PDO::FETCH_ASSOC);
        $rowCount = $result['count'];
        if($rowCount == 0){
            return [
                'status' => 'success',
                'message' => 'No rows found.',
                'tenantId' => $tenantId,
                'tableName' => $tableName
            ];
        }else{
            // Step 2: update all recoreds to is_applied = 'no' where is_applied = 'yes' and tenant_id = :tenantId and status = 'draft'
            $sql = "update $tableName set is_applied = 'no' {$extraSqlToPass} where is_applied = 'yes' and tenant_id = :tenantId and is_deleted = 0";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':tenantId', $tenantId);
            $stmt->execute();
            // Step 3: count how many rows are updated
            $rowCount = $stmt->rowCount();
            if ($rowCount === 0) {
                return [
                    'status' => 'Success',
                    'message' => 'No rows updated. None match requierments.'
                ];
            }else{
                // rows updated successfully message
                return [
                    'status' => 'success',
                    'message' => 'Rows updated successfully.',
                    'rowCount' => $rowCount
                ];
            }


            return [
                'status' => 'success',
                'message' => 'Rows found.',
                'rowCount' => $rowCount
            ];
        }










        /*
        // check if count is grater than 1
        $sql = "select count(*) as count from $tableName where tenant_id = :tenantId and is_deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tenantId', $tenantId);
        $stmt->execute();
        $result = $stmt->fetch(\PDO::FETCH_ASSOC);
        $rowCount = $result['count'];
        if($rowCount > 1){
            $sql = "update $tableName set is_applied = 'no' {$extraSqlToPass}  where is_applied = 'yes' and tenant_id = :tenantId and is_deleted = 0";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':tenantId', $tenantId);
            $stmt->execute();
            // count how many rows are updated
            $rowCount = $stmt->rowCount();
            if ($rowCount === 0) {
                return [
                    'status' => 'failed',
                    'message' => 'No rows updated. Data may be identical or '.$tableName.'Id not found.'
                ];
            }
            return [
                'status' => 'success',
                'message' => 'Tenant added to parent successfully',
                'rowCount' => $rowCount
            ];
        }else{
            return [
                'status' => 'Success',
                'message' => 'No rows to updated.'
            ];
        }
        */
    }
    function isActiveDisableOnDelete($inputData, $tableName, $id){
        $tenantId = $inputData['tenantId'];
        $tableName = toSnakeCase($tableName);
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

       // update $tableName set is_active = 0 where tenant_id = :tenantId and is_active = 1
        $sql = "update $tableName set is_active = 0 where tenant_id = :tenantId and is_active = 1 and id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tenantId', $tenantId);
        $stmt->bindParam(':id', $id);
        $stmt->execute();
        // count how many rows are updated
        $rowCount = $stmt->rowCount();
        if ($rowCount === 0) {
            return [
                'status' => 'success',
                'message' => 'No rows updated. Data may be identical or '.$tableName.'Id not found.'
            ];
        }
        return [
            'status' => 'success',
            'message' => 'Tenant added to parent successfully',
            'rowCount' => $rowCount
        ];

    }
    function isActiveDisable($inputData, $tableName){
        $tenantId = $inputData['tenantId'];
        $tableName = toSnakeCase($tableName);
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);

       // update $tableName set is_active = 0 where tenant_id = :tenantId and is_active = 1
        $sql = "update $tableName set is_active = 0 where tenant_id = :tenantId and is_active = 1";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tenantId', $tenantId);
        $stmt->execute();
        // count how many rows are updated
        $rowCount = $stmt->rowCount();
        if ($rowCount === 0) {
            return [
                'status' => 'success',
                'message' => 'No rows updated. Data may be identical or '.$tableName.'Id not found.'
            ];
        }
        return [
            'status' => 'success',
            'message' => 'Tenant added to parent successfully',
            'rowCount' => $rowCount
        ];

    }
    function disableAccountOnTenantDelete($inputData){
        $tenantId = $inputData['tenantId'];
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
        // get all accounts that are linked to the tenant
        $sql = " Select pk_system_id from user_system where fk_tenant_id = :tenantId";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tenantId', $tenantId);
        $stmt->execute();
        $result = $stmt->fetch(\PDO::FETCH_ASSOC);
        if(empty($result)){
            return [
                'status' => 'failed',
                'message' => 'No system found.'
            ];
        }
       
        $systemId = $result['pk_system_id'];
        // disable all accounts that are linked to the system
        $sql = " update user_permissions set access_status = 'revoked' where fk_system_id = :systemId";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':systemId', $systemId);
        $stmt->execute();

        // disable the system
        $sql = " update user_system set isDeleted = 1 where pk_system_id = :systemId";
        $stmt = $pdo->prepare($sql);    
        $stmt->bindParam(':systemId', $systemId);
        $stmt->execute();

        return [
            'status' => 'success',
            'message' => 'Accounts disabled successfully.'
        ];
    }
    function disablePrimaryTenantContact($inputData){
        $tenantId = $inputData['tenantId'];
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
        // get all accounts that are linked to the tenant
            //check if is primary is set to yes for the same tenant and contact type and label then set it to no
        if ($inputData['tenantContact']['isPrimary'] == 'yes') {
            $updateSql = "UPDATE tenant_contact SET is_primary = 'no' WHERE tenant_id = :tenantId AND contact_type = :contactType AND label = :label AND is_primary = 'yes'";
            $updateStmt = $inputData['db']['dbApp']->prepare($updateSql);
            $updateStmt->bindParam(':tenantId',    $inputData['tenantId']);
            $updateStmt->bindParam(':contactType', $inputData['tenantContact']['contactType']);
            $updateStmt->bindParam(':label',       $inputData['tenantContact']['label']);
            $updateStmt->execute();
        } 
        return [
            'status' => 'success',
            'message' => 'Primary contact updated successfully.'
        ];
    }
?>