-- 1) Active table: 1 active pause row per tenant
CREATE TABLE IF NOT EXISTS tenant_pause_active (
  tenant_id             INT NOT NULL,
  pause_type            ENUM('UNTIL_CLOSED','MINUTES_15','HOURS_1','HOURS_2','CUSTOM') NOT NULL,
  is_closed_collection  BOOLEAN NOT NULL DEFAULT FALSE,
  is_closed_delivery    BOOLEAN NOT NULL DEFAULT FALSE,
  pause_start_at        DATETIME NOT NULL,
  pause_until           DATETIME NOT NULL,
  set_by_user_id        INT NULL,
  created_at            DATETIME DEFAULT CURRENT_TIMESTAMP,
  updated_at            DATETIME DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (tenant_id),
  INDEX idx_order_pause_active_pause_until (pause_until),
  INDEX idx_order_pause_active_tenant_until (tenant_id, pause_until)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;



ALTER TABLE tenant_history 
MODIFY action_type ENUM('updated','deleted','expired') NOT NULL;