# Frontend API Interface Specification

---

## Overview
This document outlines the frontend API contract required to interact with the backend PHP application. All operations are triggered via a single endpoint (function.php) using POST or GET requests, with the action defined in the action field. Role-based access is enforced via session variables.

---

## Role Definitions

```sql
INSERT INTO `user_role` (`pk_role_id`, `role_name`, `scope`) VALUES
(1, 'SystemAdmin', 'Platform'),
(2, 'SupportAgent', 'Platform'),
(3, 'ContentModerator', 'Platform'),
(4, 'BusinessOwner', 'Tenant'),
(5, 'BusinessManager', 'Tenant'),
(6, 'Staff', 'Tenant'),
(7, 'Operator', 'Tenant'),
(8, 'Customer', 'Public');
```

## API Summary Table

| Action                            | Method | Required Role      | Payload Object           | Description                                                            |
|-----------------------------------|--------|--------------------|--------------------------|------------------------------------------------------------------------|
| [`newTenant`](#newTenant)                       | POST   | 1                  | `tenant`                 | Create a new tenant                                                    |
| [`updateTenant`](#updateTenant)                    | POST   | 1, 3               | `tenant`                 | Update an existing tenant                                              |
| [`deleteTenant`](#deleteTenant)                    | POST   | 1                  | `tenant`                 | Soft-delete a tenant                                                   |
| [`viewTenantSysAdmin`](#viewTenantSysAdmin)              | GET    | 1, 2, 3            |                          | View tenant detail (sysadmin)                                          |
| [`viewTenantOwner`](#viewTenantOwner)                 | GET    | 4                  |                          | View tenant detail (owner view)                                        |
| [`viewTenantPublic`](#viewTenantPublic)                | GET    |                    |                          | View tenant detail (public view)                                       |
| [`addNewTenantTheme`](#addNewTenantTheme)               | POST   | 1, 2, 3, 4, 5      | `tenantTheme`            | Add a new theme to a tenant                                            |
| [`updateTenantTheme`](#updateTenantTheme)               | POST   | 1, 2, 3, 4, 5      | `tenantTheme`            | Update an existing theme                                               |
| [`viewThemeSysAdmin`](#viewThemeSysAdmin)               | GET    | 1, 2, 3            |                          | View all themes (sysadmin view)                                        |
| [`viewThemeOwner`](#viewThemeOwner)                  | GET    | 4, 5               | `themeId`                | View themes (owner view)                                               |
| [`viewThemePublic`](#viewThemePublic)                 | GET    | Any                | `themeId`                | View theme detail (public view)                                        |
| [`insertNewTenantContactBusiness`](#insertNewTenantContactBusiness)  | POST   | 1,2,3,4,5          | `tenantContact`          | Add a new tenant contact (Owner)                                       |
| [`insertNewTenantContactOwner`](#insertNewTenantContactOwner)     | POST   | 1, 2, 3            | `tenantContact`          | Add a new tenant contact (Admin)                                       |
| [`viewTenantContactBusiness`](#viewTenantContactBusiness)       | GET    | 1, 2, 3            |                          | View contacts (SysAdmin)                                               |
| [`viewTenantContactOwner`](#viewTenantContactOwner)          | GET    | 4, 5               |                          | View contacts (Owner)                                                  |
| [`viewTenantContactPublic`](#viewTenantContactPublic)         | GET    | Any                |                          | View public contact records                                            |
| [`updateTenantContact`](#updateTenantContact)             | POST   | 1, 2, 3, 4, 5      | `tenantContact`          | Update a tenant contact                                                |
| [`deleteTenantContact`](#deleteTenantContact)             | POST   | 1, 2, 3, 4, 5      | `tenantContact`          | Soft-delete a contact                                                  |
| [`insertNewBusinessHours`](#insertNewBusinessHours)          | POST   | 1, 2, 3, 4, 5      | `tenantBusinessHours`    | Insert or bulk insert business hours                                   |
| [`viewBusinessHoursPublic`](#viewBusinessHoursPublic)         | GET    | Any                |                          | Retrieve public business hours                                         |
| [`viewBusinessHoursOwner`](#viewBusinessHoursOwner)          | GET    | 4, 5, 6            |                          | View business hours (owner view)                                       |
| [`viewBusinessHoursSysAdmin`](#viewBusinessHoursSysAdmin)       | GET    | 1                  |                          | View business hours (sysadmin view)                                    |
| [`updateBusinessHours`](#updateBusinessHours)             | POST   | 2, 4, 5            | `tenantBusinessHours`    | Update business hours                                                  |
| [`deleteBusinessHours`](#deleteBusinessHours)             | POST   | 2, 4, 5            | `tenantBusinessHours`    | Soft-delete a business hour                                            |
| [`viewTenantChangeHistory`](#viewTenantChangeHistory)         | GET    | 1, 2, 3            |                          | View full change history of a tenant                                   |
| [`viewAllTenantsSuperAdmin`](#viewAllTenantsSuperAdmin)        | GET    | 1, 2, 3            |                          | View full view all tenants info high level                             |
| [`setTenantId`](#setTenantId)                     | POST   |                    |                          | Sets the tenantId based of domain need to run on fist run              |
| [`setTenantIdAdmin`](#setTenantIdAdmin)                | POST   | 1, 2, 3            |                          | Sets the tenantId based of domain need to run on fist run for admin    |
| [`clearTenantId`](#clearTenantId)                   | POST   |  1, 2, 3           |                          | Clears the tenantId Super Admin Only                                   |
| [`addNewTenantDeliveryRules`](#addNewTenantDeliveryRules)       | POST   |  1, 2, 3, 4, 5     | `tenantDeliveryRules`    | Sets up a new Delivery Rule                                            |
| [`updateTenantDeliveryRules`](#updateTenantDeliveryRules)       | POST   |  1, 2, 3, 4, 5     | `tenantDeliveryRules`    | Update up a Delivery Rule                                              |
| [`deleteTenantDeliveryRules`](#deleteTenantDeliveryRules)       | POST   |  1, 2, 3, 4, 5     | `tenantDeliveryRules`    | Delete up a Delivery Rule                                              |
| [`viewTenantDeliveryRulesSysAdmin`](#viewTenantDeliveryRulesSysAdmin) | GET    | 1, 2, 3            |                          | View Delivery Rules (SysAdmin)                                         |
| [`viewTenantDeliveryRulesOwner`](#viewTenantDeliveryRulesOwner)    | GET    | 4, 5               |                          | View Delivery Rules (Owner)                                            |
| [`viewTenantDeliveryRulesPublic`](#viewTenantDeliveryRulesPublic)   | GET    | Any                |                          | View public Delivery Rules                                             |
| [`insertTenantFees`](#insertTenantFees)                | POST   |  1, 2, 3           | `tenantAdminFees`        | Sets up a new Tenent Fee                                               |
| [`updateTenantFees`](#updateTenantFees)                | POST   |  1, 2, 3           | `tenantAdminFees`        | Update up a Tenent Fee                                                 |
| [`deleteTenantFees`](#deleteTenantFees)                | POST   |  1, 2, 3           | `tenantAdminFees`        | Delete up a Tenent Fee                                                 |
| [`viewTenantFeesSysAdmin`](#viewTenantFeesSysAdmin)          | GET    | 1, 2, 3            |                          | View Tenent Fee (SysAdmin)                                             |
| [`viewTenantFeesOwner`](#viewTenantFeesOwner)             | GET    | 4, 5               |                          | View Tenent Fee (Owner)                                                |
| [`viewTenantFeesPublic`](#viewTenantFeesPublic)            | GET    | Any                |                          | View public Tenent Fee                                                 |



---

## Payload Structures

<a id="newTenant"></a>
### `newTenant`
```json
{
  "action": "newTenant",
  "tenant": {
    "companyName": "string",
    "domain": "string",
    "companyNumber": "string",
    "foodHygieneId": "string",
    "primaryContactName": "string",
    "tenantStatus": "active|pending",
    "paymentProvider": "stripe|paypal|square|braintree" optional,
    "paymentApiKey": "String" optional,
    "parentId": optional,
    "minimumOrderAmount" : "int" optional,
    "smallOrderFee": "int" optional,
    "maxDistance": "float" optional
  }
}
```

<a id="updateTenant"></a>
### `updateTenant`
```json
{
  "action": "updateTenant",
  "tenant": {
    "companyName": optional,
    "domain": optional,
    "companyNumber": optional,
    "foodHygieneId": optional,
    "primaryContactName": optional,
    "tenantStatus": optional,
    "isDeleted": optional,
    "parentId": optional,
    "minimumOrderAmount" : "int" optional,
    "smallOrderFee": "int" optional
  }
}
```

<a id="deleteTenant"></a>
### `deleteTenant`
```json
{
  "action": "deleteTenant",
}
```

<a id="viewTenantSysAdmin"></a>
### `viewTenantSysAdmin`
```json
{
  "action": "viewTenantSysAdmin",
}
```

<a id="viewTenantOwner"></a>
### `viewTenantOwner`
```json
{
  "action": "viewTenantOwner",
}
```

<a id="viewTenantPublic"></a>
### `viewTenantPublic`
```json
{
  "action": "viewTenantPublic",
}
```

<a id="addNewTenantTheme"></a>
### `addNewTenantTheme`
```json
{
  "action": "addNewTenantTheme",
  "tenantTheme": {
    "themeName": "string",
    "primaryColor": "#000000",
    "secondaryColor": "#000000",
    "textColor": "#000000",
    "secondaryTextColor": "#000000",
    "accentColor": "#000000",
    "backgroundColor": "#000000",
    "buttonColor": "#000000"
  }
}
```

### `updateTenantTheme`
```json
{
  "action": "updateTenantTheme",
  "tenantTheme": {
    "themeId": int,
    "isApplied": "yes|no",
    "themeStatus": "active|draft|deleted",
    "isDeleted": optional
  }
}
```

### `viewThemeSysAdmin`
```json
{
  "action": "viewThemeSysAdmin",
}
```

### `viewThemeOwner`
```json
{
  "action": "viewThemeOwner",
}
```

### `viewThemePublic`
```json
{
  "action": "viewThemePublic",
  "themeId": int
}
```

### `insertNewTenantContactBusiness`
```json
{
  "action": "insertNewTenantContactBusiness",
  "tenantContact": {
    "label": "string",
    "contactType": "Email|Name|Phone|...",
    "contactValue": "string",
    "isPrimary": "yes|no"
  }
}
```

### `insertNewTenantContactOwner`
```json
{
  "action": "insertNewTenantContactOwner",
  "tenantContact": {
    "userId": int,
    "label": "string",
    "contactType": "string",
    "contactValue": "string",
    "isPrimary": "yes|no"
  }
}
```

### `viewTenantContactBusiness`
```json
{
  "action": "viewTenantContactBusiness",
}
```

### `viewTenantContactOwner`
```json
{
  "action": "viewTenantContactOwner",
}
```

### `viewTenantContactPublic`
```json
{
  "action": "viewTenantContactPublic",
}
```

### `updateTenantContact`
```json
{
  "action": "updateTenantContact",
  "tenantContact": {
    "contactId": int,
    "userId": optional,
    "label": "string",
    "contactType": "string",
    "contactValue": "string",
    "isPrimary": "yes|no"
  }
}
```

### `deleteTenantContact`
```json
{
  "action": "deleteTenantContact",
  "tenantContact": {
    "contactId": int,
    "userId": optional,
    "isDeleted": 1
  }
}
```

### `insertNewBusinessHours`
```json
{
  "action": "insertNewBusinessHours",
  "tenantBusinessHours": [
    {
      "hoursCategory": "store|delivery|special",
      "openingDay": "Monday|...",
      "openTime": "HH:MM:SS",
      "closeTime": "HH:MM:SS",
      "isClosed": optional,
      "specificDate": optional (for special)
    }
  ]
}
```

### `viewBusinessHoursPublic`
```json
{
  "action": "viewBusinessHoursPublic",
}
```

### `viewBusinessHoursOwner`
```json
{
  "action": "viewBusinessHoursOwner",
}
```

### `viewBusinessHoursSysAdmin`
```json
{
  "action": "viewBusinessHoursSysAdmin",
}
```

### `updateBusinessHours`
```json
{
  "action": "updateBusinessHours",
  "tenantBusinessHours": {
    "businessHoursId": int,
    "hoursCategory": "store|delivery|special",
    "openingDay": optional,
    "specificDate": optional,
    "openTime": optional,
    "closeTime": optional,
    "isClosed": optional,
    "isDeleted": optional
  }
}
```

### `deleteBusinessHours`
```json
{
  "action": "deleteBusinessHours",
  "tenantBusinessHours": {
    "businessHoursId": int,
    "isDeleted": 1
  }
}
```

### `viewTenantChangeHistory`
```json
{
  "action": "viewTenantChangeHistory",
}
```
### `viewAllTenantsSuperAdmin`
```json
{
  "action": "viewAllTenantsSuperAdmin"
}
```

### `setTenantIdAdmin`
```json
{
  "action": "setTenantIdAdmin"
  "setTenantId" : int optional (Needed if admin to set domain)
}
```

### `setTenantId`
```json
{
  "action": "setTenantId"
}
```

### `clearTenantId`
```json
{
  "action": "clearTenantId"
}
```

### `addNewTenantDeliveryRules`
```json
{
  "action": "addNewTenantDeliveryRules"
  "tenantDeliveryRules": {
    "minimumDeliveryAmount": decimal 
    "deliveryCharge": decimal 
    "isActive": int optional
  }
}
```

### `updateTenantDeliveryRules`
```json
{
"action" : "updateTenantDeliveryRules",
            "deliveryRulesId" : 2,
            "tenantDeliveryRules" : {
                "minimumDeliveryAmount" : decimal,
                "deliveryCharge" : decimal,
                "isActive" : 1,
            }
}
```

### `deleteTenantDeliveryRules`
```json
{
  "action": "deleteTenantDeliveryRules",
  "deliveryRulesId": int,
  "tenantDeliveryRules": {
    "isDeleted": int 1
  }
}
```

### `viewTenantDeliveryRulesPublic`
```json
{
  "action": "viewTenantDeliveryRulesPublic",
}
```

### `viewTenantDeliveryRulesOwner`
```json
{
  "action": "viewTenantDeliveryRulesOwner",
}
```


### `viewTenantDeliveryRulesSysAdmin`
```json
{
  "action": "viewTenantDeliveryRulesSysAdmin",
}
```


### `insertTenantFees`
```json
{
  "action": "insertTenantFees",
  "tenantAdminFees": {
    "customerAdminFee": decimal ,
    "tenantAdminFee": decimal, 
    "isActive": int optional
  }
}
```

### `updateTenantFees`
```json
{
"action" : "updateTenantFees",
            "tenantAdminFeesId" : 2,
            "tenantAdminFees" : {
                "customerAdminFee" : decimal,
                "tenantAdminFee" : decimal,
                "isActive" : 1,
            }
}
```

### `deleteTenantFees`
```json
{
  "action": "deleteTenantFees",
  "tenantAdminFeesId": int,
  "tenantAdminFees": {
    "isDeleted": int 1
  }
}
```

### `viewTenantFeesPublic`
```json
{
  "action": "viewTenantFeesPublic",
}
```

### `viewTenantFeesOwner`
```json
{
  "action": "viewTenantFeesOwner",
}
```


### `viewTenantFeesSysAdmin`
```json
{
  "action": "viewTenantFeesSysAdmin",
}
```

---

## Response Format

### Success
```json
{
  "status": "success",
  "message": "string",
  // additional data if applicable
}
```

### Failure
```json
{
  "status": "failed",
  "message": "Error message string"
}
```

---

## Frontend Implementation Notes

- Ensure session authentication is maintained
- Validate required fields before submission
- Show proper error/success messaging
- Use roleValue to determine UI behavior (edit/delete/submit availability)
- Display conditional components based on `isDeleted`, `isPrimary`, and `themeStatus`

---

_End of Document_

