<?php
    function selectTenantInfo($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $viewType = $inputData['view'];
        $tenantId = "";
        if(isset($inputData['tenantId'])){
            $tenantId = $inputData['tenantId'];
        }
        // Review how we can do suspended tenants
        // Determine base tenant query by view type
        switch ($viewType) {
            case 'restricted':
                $sql = "SELECT company_name, company_number, food_hygiene_id, tenant_status, minimum_order_amount, small_order_fee, max_distance
                        FROM tenant 
                        WHERE id = :tenantId AND tenant_status = 'active' AND is_deleted = 0";
                break;
            case 'owner':
                $sql = "SELECT company_name, company_number, domain, food_hygiene_id, tenant_status , minimum_order_amount, small_order_fee, max_distance
                        FROM tenant 
                        WHERE id = :tenantId AND is_deleted = 0";
                break;
            case 'sysAdmin':
                $sql = "SELECT * FROM tenant WHERE id = :tenantId";
                break;
            case 'superAdmin':
                $sql = "SELECT * FROM tenant";
                break;
            default:
                return ['status' => 'failed', 'message' => 'Invalid view type'];
        }

        // Execute base query
        $stmt = $pdo->prepare($sql);
        if($viewType !== 'superAdmin') {
            $stmt->bindParam(':tenantId', $tenantId);
        }
        $stmt->execute();
        if($viewType === 'superAdmin') {
            $tenant = $stmt->fetchAll(PDO::FETCH_ASSOC);
        } else {
            $tenant = $stmt->fetch(PDO::FETCH_ASSOC);
        }

        if (!$tenant || ($viewType === 'restricted' && $tenant['tenant_status'] !== 'active')) {
            return ['status' => 'failed', 'message' => 'Tenant not found'];
        }

        // Fetch children if applicable
        if (in_array($viewType, ['owner', 'sysAdmin'])) {
            $childSql = $viewType === 'sysAdmin'
                ? "SELECT * FROM tenant WHERE parent_id = :tenantId"
                : "SELECT id as tenant_id, company_name, company_number, domain, food_hygiene_id, tenant_status, minimum_order_amount, small_order_fee, max_distance
                FROM tenant 
                WHERE parent_id = :tenantId AND is_deleted = 0";

            $stmt = $pdo->prepare($childSql);
            $stmt->bindParam(':tenantId', $tenantId);
            $stmt->execute();
            $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

            $tenant['children'] = array_map(function($child) {
                // change to float for minimum_order_amount and small_order_fee for each child tenant
                $child['minimum_order_amount'] = (float)$child['minimum_order_amount'];
                $child['small_order_fee'] = (float)$child['small_order_fee'];
                // Convert keys to camelCase and rename id to tenantId
                return convertKeysToCamelCase(renameIdKeys($child, 'tenantId'));
            }, $rows);
        }
        if($viewType === 'superAdmin') {
            // Convert keys to camelCase and rename id to tenantId for each tenant
            $tenant = array_map(function($tenant) {
                // change to float for minimum_order_amount and small_order_fee
                $tenant['minimum_order_amount'] = (float)$tenant['minimum_order_amount'];
                $tenant['small_order_fee'] = (float)$tenant['small_order_fee'];
                // Convert keys to camelCase and rename id to tenantId
                return convertKeysToCamelCase(renameIdKeys($tenant, 'tenantId'));
            }, $tenant);
        }else{
            // Convert keys to camelCase and rename id to tenantId
            // change to float for minimum_order_amount and small_order_fee
            $tenant['minimum_order_amount'] = (float)$tenant['minimum_order_amount'];
            $tenant['small_order_fee'] = (float)$tenant['small_order_fee'];
            $tenant = convertKeysToCamelCase(renameIdKeys($tenant, 'tenantId'));
        }
       

        return [
            'status' => 'success',
            'message' => 'Tenant found',
            'tenant' => $tenant
        ];
    }
    function selectDataForHistory($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $sqlExtra = '';
        $tableName = toSnakeCase($inputData['tableName']);
        $data = [];
        $id = $inputData['id'];
        $parentCheck= $inputData['checkParent'];
        if($parentCheck == 1){
            $sqlExtra = " or parent_id = :id2";
        }
        $sql = "SELECT * FROM $tableName WHERE id = :id" . $sqlExtra;
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id);
        if($parentCheck == 1){
            $stmt->bindParam(':id2', $id);
        }
        $stmt->execute();

        // convert restuls to a json string to insert as one column in the history table
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $data[] = json_encode($row);
        }
        if ($data) {
                    $res['status'] = 'success';
                    $res['his'] = $data;
                    return $res;

        } else {
            return ['status' => 'failed', 'message' => 'No data found for history'];
        }
    }
    function checkIfAlreadyDeleted($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        $tableName = toSnakeCase($inputData['tableName']);
        $id = $inputData['id'];

        $sql = "SELECT * FROM $tableName WHERE id = :id AND is_deleted = 1";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':id', $id);
        $stmt->execute();

        // convert restuls to a json string to insert as one column in the history table
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
                    return ['status' => 'failed', 'message' => 'Tenant already deleted'];
        } else {
            return ['status' => 'success'];
        }
    }
    function checkIfTenantIdIsValid($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $tenantId = $inputData['tenantId'] ?? null;
        if ($tenantId === null) {
            return ['status' => 'failed', 'message' => 'tenantId is required'];
        }
        // Optional: validate that tenantId is numeric
        if (!is_numeric($tenantId)) {
            return ['status' => 'failed', 'message' => 'tenantId must be numeric'];
        }
        // Check if tenantId exists and is active
        $sql = "SELECT id 
                FROM tenant 
                WHERE id = :id 
                  AND tenant_status != 'deleted' 
                  AND tenant_status != 'suspended'";
    
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':id', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            return ['status' => 'success'];
        } else {
            return ['status' => 'failed', 'message' => 'tenantId is not valid'];
        }
    }
    function viewThemes($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
        $viewType = $inputData['view'] ?? null;
    
        // Validate view type
        if (!in_array($viewType, ['restricted', 'owner', 'sysAdmin'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }
    
        // Assign ID, with themeId taking priority
        $id = $inputData['themeId'] ?? $inputData['tenantId'] ?? null;
    
        // Check for required ID based on view type
        if ($viewType === 'restricted' && !isset($inputData['tenantId'])) {
            return ['status' => 'failed', 'message' => 'themeId is required for restricted view'];
        }
    
        if ($id === null) {
            return ['status' => 'failed', 'message' => 'Missing required Id(tenantId or themeId)'];
        }
    
        
        // Build SQL
        switch ($viewType) {
            case 'restricted':
                $sql = "SELECT theme_name, primary_color, secondary_color, text_color, 
                               secondary_text_color, accent_color, background_color, 
                               button_color, theme_status
                        FROM tenant_theme 
                        WHERE tenant_id = :id 
                          AND theme_status = 'active' 
                          AND is_applied = 'yes' 
                          AND is_deleted = 0";
                break;
    
            case 'owner':
                $sql = "SELECT theme_name, primary_color, secondary_color, text_color, 
                               secondary_text_color, accent_color, background_color, 
                               button_color, theme_status, is_applied, id
                        FROM tenant_theme 
                        WHERE tenant_id = :id 
                          AND is_deleted = 0";
                break;
    
            case 'sysAdmin':
                $sql = "SELECT * FROM tenant_theme WHERE tenant_id = :id";
                break;
        }
    
        // Execute query
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
    
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
        if (!$rows || ($viewType === 'restricted' && $rows[0]['theme_status'] !== 'active')) {
            return ['status' => 'failed', 'message' => 'Theme not found'];
        }
    
        // Convert each row
        $themes = array_map(function($row) {
            return convertKeysToCamelCase(renameIdKeys($row, 'themeId'));
        }, $rows);
    
        return [
            'status' => 'success',
            'message' => 'Theme(s) found',
            'theme' => $themes
        ];
    }
    function viewContact($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
        $viewType = $inputData['view'] ?? null;
    
        // Validate view type
        if (!in_array($viewType, ['restricted', 'owner', 'sysAdmin'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }
    
        // Assign ID, with themeId taking priority
        $id =  $inputData['tenantId'] ?? null;
    
        if ($id === null) {
            return ['status' => 'failed', 'message' => 'Missing required tenantId'];
        }
    
        // Build SQL
        switch ($viewType) {
            case 'restricted':
                $sql = "SELECT contact_type, label, contact_value
                        FROM tenant_contact 
                        WHERE tenant_id = :id 
                          AND is_primary = 'yes'
                          AND is_deleted = 0
                          AND user_Id is null";
                break;
    
            case 'owner':
                $sql = "SELECT contact_type, label, is_primary, user_id, contact_value,id
                        FROM tenant_contact 
                        WHERE tenant_id = :id 
                          AND is_deleted = 0";
                break;
    
            case 'sysAdmin':
                $sql = "SELECT * FROM tenant_contact WHERE tenant_id = :id";
                break;
        }
    
        // Execute query
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
    
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        //  || ($viewType === 'restricted'
        if (!$rows) {
            return ['status' => 'failed', 'message' => 'Contacts not found'];
        }
    
        // Convert each row
        $contact = array_map(function($row) {
            return convertKeysToCamelCase(renameIdKeys($row, 'contactId'));
        }, $rows);

        // loop though the contact if user id exist place in one array and if not place in another array
        $primaryContacts = [];
        $secondaryContacts = [];
        foreach ($contact as $c) {
            if (isset($c['userId']) && !empty($c['userId'])) {
                $primaryContacts[] = $c;
            } else {
                $secondaryContacts[] = $c;
            }
        }
        
        $contact = [];
        // If viewType is restricted, return only primary contacts
        if ($viewType === 'restricted') {
            $contact = $secondaryContacts;
        } else {
            // For owner and sysAdmin, return both primary and secondary contacts
        $contact = ['owner' => $primaryContacts, 'shop' => $secondaryContacts];
        }
    
        return [
            'status' => 'success',
            'message' => 'Contact(s) found',
            'contact' => $contact
        ];
    }
    function viewBusinessHours($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
        $viewType = $inputData['view'] ?? null;
    
        // Validate view type
        if (!in_array($viewType, ['restricted', 'owner', 'sysAdmin'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }
    
        // Assign ID, with themeId taking priority
        $id =  $inputData['tenantId'] ?? null;
    
        if ($id === null) {
            return ['status' => 'failed', 'message' => 'Missing required tenantId'];
        }
    
        // Build SQL
        switch ($viewType) {
            case 'restricted':
                $sql = "SELECT *
                        FROM tenant_upcoming_hours
                        WHERE tenant_id = :id";
                break;
    
            case 'owner':
                $sql = "SELECT id, hours_category, opening_day, specific_date, open_time, close_time, is_closed
                        FROM tenant_business_hours 
                        WHERE tenant_id = :id 
                          AND is_deleted = 0";
                break;
    
            case 'sysAdmin':
                $sql = "SELECT * FROM tenant_business_hours WHERE tenant_id = :id";
                break;
        }
    
        // Execute query
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
    
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        
        //  || ($viewType === 'restricted'
        if (!$rows) {
            return ['status' => 'failed', 'message' => 'No Business Hours found'];
        }
    
        // Convert each row
        $businessHours = array_map(function($row) {
            return convertKeysToCamelCase(renameIdKeys($row, 'businessHourId'));
        }, $rows);
    
        return [
            'status' => 'success',
            'message' => 'Business Hours found',
            'businessHour' => $businessHours
        ];
    }
    function viewHistory($inputData){
        // this is just a view for sysadmin to see the history of the tenant changes 
        // we may have 2 addtinal propertys to tenantId, which are startDate and endDate but this could be one or the other or both
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $tenantId = $inputData['tenantId'] ?? null;
        $startDate = $inputData['startDate'] ?? null;
        $endDate = $inputData['endDate'] ?? null;
        $tableName = "tenant_history";
        $data = [];
        if ($tenantId === null) {
            return ['status' => 'failed', 'message' => 'Missing required tenantId'];
        }
        // Build SQL
        $sql = "SELECT * FROM tenant_history WHERE tenant_id = :tenantId";
        if ($startDate !== null) {
            $sql .= " AND created_at >= :startDate";
        }
        if ($endDate !== null) {
            $sql .= " AND created_at <= :endDate";
        }
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tenantId', $tenantId);
        if ($startDate !== null) {
            $stmt->bindParam(':startDate', $startDate);
        }
        if ($endDate !== null) {
            $stmt->bindParam(':endDate', $endDate);
        }
        $stmt->execute();
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$rows) {
            return ['status' => 'failed', 'message' => 'No history found'];
        }
        // Convert each row
        $history = array_map(function($row) {
            return convertKeysToCamelCase(renameIdKeys($row, 'historyId'));
        }, $rows);
        return [
            'status' => 'success',
            'message' => 'History found',
            'history' => $history
        ];


    }
    function setTenantId($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $host = $_SERVER['HTTP_HOST'] ?? '';
        $host = strtolower($host);
        $parts = explode('.', $host);
        $cleanParts = array_filter($parts, fn($part) => $part !== 'admin');
        $cleanHost = implode('.', $cleanParts);
        $cleanUrl = 'https://' . $cleanHost;
        // strip www. if it exists
        $cleanUrl = preg_replace('/^https?:\/\/(www\.)?/', 'https://', $cleanUrl);

        // Build SQL
        $sql = "SELECT id FROM tenant WHERE domain = :http and is_deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':http', $cleanUrl);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $_SESSION['tenantId']       = $data['id'];
            return ['status' => 'success', 'message' => 'Tenant ID found'];
        } else {
            return ['status' => 'failed', 'message' => 'Tenant ID not found'];
        }
    }
    function viewTenatDomainCheck($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        if( !isset($inputData['tenant']['domain']) || empty($inputData['tenant']['domain'])) {
            return ['status' => 'failed', 'message' => 'Missing required tenant domain'];
        }

        $inputData['tenant']['domain'] = preg_replace('#^https?://#', '', rtrim($inputData['tenant']['domain'], '/'));
        $inputData['tenant']['domain'] = preg_replace('#^www\.#', '', $inputData['tenant']['domain']);  
        $domain = 'https://'.$inputData['tenant']['domain'] ?? null;

        // Build SQL
        $sql = "SELECT id FROM tenant WHERE domain = :domain and is_deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':domain', $domain);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            return ['status' => 'found', 'message' => 'Tenant ID found'];
        } else {
            return ['status' => 'notfound', 'message' => 'Tenant ID not found'];
        }
    }
    function viewTenantDeliveryRules($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $tenantId = $inputData['tenantId'] ?? null;
        if ($tenantId === null) {
            return ['status' => 'failed', 'message' => 'Missing required tenantId'];
        }
        // viewType can be restricted, owner, sysAdmin
        $viewType = $inputData['view'] ?? 'restricted';
        // Build SQL
        switch ($viewType) {
            case 'restricted':
                // if there is more than one selected the one with the lowest minimumDeliveryAmount will be returned 0 being the lowest
                $sql = "SELECT minimum_delivery_amount, delivery_charge FROM tenant_delivery_rules 
                        WHERE tenant_id = :tenantId 
                          AND is_deleted = 0 
                          AND is_active = 1
                        ORDER BY minimum_delivery_amount ASC 
                        LIMIT 1";
                break;
            case 'owner':
                $sql = "SELECT minimum_delivery_amount, delivery_charge, is_active, id FROM tenant_delivery_rules WHERE tenant_id = :tenantId AND is_deleted = 0";
                break;
            case 'sysAdmin':
                $sql = "SELECT * FROM tenant_delivery_rules WHERE tenant_id = :tenantId";
                break;
            default:
                return ['status' => 'failed', 'message' => 'Invalid view type'];
        }

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tenantId', $tenantId);
        $stmt->execute();
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$rows) {
            return ['status' => 'failed', 'message' => 'No delivery rules found'];
        }
        // Convert each row
        $deliveryRules = array_map(function($row) {
            // minimum_delivery_amount and delivery_charge set to float
            $row['minimum_delivery_amount'] = (float)$row['minimum_delivery_amount'];
            $row['delivery_charge'] = (float)$row['delivery_charge'];
            return convertKeysToCamelCase(renameIdKeys($row, 'deliveryRulesId'));
        }, $rows);

        // If viewType is restricted, return only minimum_order_amount delivery_charge 
        if ($viewType === 'restricted') {
            $deliveryRules = array_map(function($rule) {
                return [
                    'minimumDeliveryAmount' => $rule['minimumDeliveryAmount'],
                    'deliveryCharge' => $rule['deliveryCharge'],
                ];
            }, $deliveryRules);
            $deliveryRules = $deliveryRules[0] ?? [];
        }
        
        return [
            'status' => 'success',
            'message' => 'Delivery rules found',
            'deliveryRules' => $deliveryRules
        ];
    }
    function viewTenantFees($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $tenantId = $inputData['tenantId'] ?? null;
        if ($tenantId === null) {
            return ['status' => 'failed', 'message' => 'Missing required tenantId'];
        }
        // viewType can be restricted, owner, sysAdmin
        $viewType = $inputData['view'] ?? 'restricted';
        // Build SQL
        switch ($viewType) {
            case 'restricted':
                $sql = "SELECT customer_admin_fee FROM tenant_admin_fees 
                        WHERE tenant_id = :tenantId 
                          AND is_deleted = 0 
                          AND is_active = 1";
                break;
            case 'owner':
                $sql = "SELECT customer_admin_fee, tenant_admin_fee, is_active, id FROM tenant_admin_fees WHERE tenant_id = :tenantId AND is_deleted = 0";
                break;
            case 'sysAdmin':
                $sql = "SELECT * FROM tenant_admin_fees WHERE tenant_id = :tenantId order by is_active desc, is_deleted asc";
                break;
            default:
                return ['status' => 'failed', 'message' => 'Invalid view type'];
        }

        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':tenantId', $tenantId);
        $stmt->execute();
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$rows) {
            return ['status' => 'failed', 'message' => 'No fees found'];
        }
        // Convert each row
        $fees = array_map(function($row) {
            // customer_admin_fee && tenant_admin_fee set to float
            $row['customer_admin_fee'] = (float)$row['customer_admin_fee'];
            if(isset($row['tenant_admin_fee'])) {
                $row['tenant_admin_fee'] = (float)$row['tenant_admin_fee'];
            }
            return convertKeysToCamelCase(renameIdKeys($row, 'feesId'));
        }, $rows);

        // If viewType is restricted, return only service_fee 
        if ($viewType === 'restricted') {
            $fees = array_map(function($fee) {
                return [
                    'serviceFee' => $fee['customerAdminFee'],
                ];
            }, $fees);
            $fees = $fees[0] ?? [];
        }
        
        return [
            'status' => 'success',
            'message' => 'Tenant fees found',
            'fees' => $fees
        ];
    }
?>