<?php
    function genericUpdateStatment($inputData) {
        $tableName = $inputData['tableName'];
        $idName = $inputData['idName'];
        $tablesColumn = tableColumnMapping();
    
        if (!isset($tablesColumn[$tableName])) {
            return [
                'status' => 'failed',
                'message' => "Table mapping not found for: $tableName"
            ];
        }
    
        $columnMap = $tablesColumn[$tableName];
        $updateParts = [];
        $bindParams = [];
    
        foreach ($columnMap as $key => $meta) {
            if (isset($inputData[$tableName][$key]) && isset($meta['mapping'])) {
                $updateParts[] = "{$meta['mapping']} = :$key";
                $bindParams[$key] = $inputData[$tableName][$key];
                $meta['updateRole'] = array_unique($meta['updateRole']);
                $userRole = $inputData['roleId'] ?? null;
                if ($userRole !== null && !in_array($userRole, $meta['updateRole'])) {
                    return [
                        'status' => 'failed',
                        'message' => "User role $userRole not allowed to update $key"
                    ];
                }
                // Check if the value is empty and if the user role is not allowed to update it
            }
        }
    
        if (empty($updateParts)) {
            return [
                'status'    => 'failed',
                'message'   => 'No data to update',
                'columns'   => $columnMap,
                'input'     => $inputData[$tableName]
            ];
        }

        $sqlAdd = '';

        if($inputData['actionType'] == 'delete'){
            if($inputData['checkParent'] == 1){
               $sqlAdd = " or parent_id = :id2"; 
            }
        }
        $tempTableName = toSnakeCase($tableName);
        // Build SQL
        $setClause = implode(', ', $updateParts);
        $whereClause = "id = :id";
        $sql = "UPDATE $tempTableName SET $setClause WHERE $whereClause ".$sqlAdd;
    
        try {
            $pdo = $inputData['db']['dbApp'];
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $stmt = $pdo->prepare($sql);
    
            foreach ($bindParams as $param => $value) {
                $stmt->bindValue(":$param", $value);
            }

    
            // Bind ID for WHERE clause
            $rowId = $inputData[$tableName][$idName . 'Id'] ?? null;
            if ($rowId === null) {
                $rowId = $inputData[$idName . 'Id'] ?? null;
            }
            if ($rowId === null) {
                return [
                    'status' => 'failed',
                    'message' => 'Missing '.$idName.'Id for WHERE clause'
                ];
            }
            if($inputData['actionType'] == 'delete'){
                if($inputData['checkParent'] == 1){
                    $stmt->bindValue(':id2', $rowId);
                }
            }
    
            $stmt->bindValue(':id', $rowId);
            $stmt->execute();

            if ($stmt->rowCount() === 0) {
                return [
                    'status' => 'failed',
                    'message' => 'No rows updated. Data may be identical or '.$tableName.'Id not found.'
                ];
            }
    
            return [
                'status' => 'success'
            ];
        } catch (PDOException $e) {
            $e->queryString = $sql ?? '';
            $e->queryInput = $inputData[$tableName] ?? [];
            throw $e;
        }
    }

    function addTenantToParent($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $sql = "update tenant set parent_id = :parentId where id = :tenantId";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':parentId', $inputData['tenant']['parentId']);
        $stmt->bindParam(':tenantId', $inputData['tenant']['tenantId']);
        $stmt->execute();
        return [
            'status' => 'success',
            'message' => 'Tenant added to parent successfully'
        ];
    }

?>