<?php
// this should only be used for testing purposes
if (defined('TEST_ENV')) {
    //require_once __DIR__ . '/../../orbit-core/src/config.php';
    require_once __DIR__ . '\..\..\core\src\Fcors.php';
    require_once __DIR__ . '\..\..\tests\scripts\bootstrap.php';
    require_once __DIR__ . '\..\..\core\src\generic.php';
    $testInfo['0'] = ("\nFunction Running in Test Environment\n");
} else {
    // this is code for live environment Dev, Uat, Production
    require_once __DIR__ . "./../generic.php";
}

require_once __DIR__ . "/core.php";
require_once __DIR__ . "/view.php";
require_once __DIR__ . "/insert.php";
require_once __DIR__ . "/update.php";

$inputData = initializeGeneric();

$inputData['requiresAdmin'] = [ 
        'newTenant'                     => [1],             'viewTenantOwner'           => [4],         'viewTenantSysAdmin'        => [1,2,3], 
        'updateTenant'                  => [1,3],           'deleteTenant'              => [1],         'addNewTenantTheme'         => [1,2,3,4,5], 
        'updateTenantTheme'             => [1,2,3,4,5],     'viewThemeOwner'            => [4,5],       'viewThemeSysAdmin'         => [1,2,3],
        'insertNewTenantContactAdmin'   => [1,2,3],         'insertNewTenantContact'    => [4,5],       'viewTenantContactOwner'    => [4,5],
        'viewTenantContactSysAdmin'     => [1,2,3],         'viewTenantPublic'          => [1,2,3],     'updateTenantContact'       => [1,2,3,4,5],
        'deleteTenantContact'           => [1,2,3,4,5],     'insertNewBuisnessHours'    => [1,2,3,4,5], 'viewBusinessHoursOwner'    => [4,5,6],
        'updateBusinessHours'           => [2,4,5],         'deleteBusinessHours'       => [2,4,5],     'viewTenantChangeHistory'   => [1,2,3],
        'viewAllTenantsSuperAdmin'      => [1,2,3]      
];
$inputData['keepLive'] = checkLive();
$action = $inputData['action'];

// check if action need auth and if does check it valid otherwise move to swithc statments 
$security = SecurityCheck($inputData); // skip security for a bit 

if($security['security'] === '1'){
    switch ($action) {
        case "test":
            $out['status']   = 'success';
            $out['message']  = 'Test Passed';
            break;
        case "newTenant":
            $inputData['nextOperation'] = 'insertNewTenant';
            $out = executeDatabaseOperation($inputData);
            if($out['status'] === 'success' && isset($inputData['tenant']['parentId'])){
                $inputData['tenant']['tenantId'] = $out['tenantId'];
                $inputData['nextOperation'] = 'addTenantToParent';
                $out = executeDatabaseOperation($inputData);
            }
            break;
        case "viewTenantPublic":
            if(!isset($inputData['tenantId']) || empty($inputData['tenantId'])){
                $out['status']   = 'failed';
                $out['message']  = 'Tenant ID is required';
                break;
            }
            $inputData['view'] = 'restricted';
            $inputData['nextOperation'] = 'selectTenantInfo';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewTenantOwner":
            if(!isset($inputData['tenantId']) || empty($inputData['tenantId'])){
               $out['status']   = 'failed';
               $out['message']  = 'Tenant ID is required';
               break;
            }
            $inputData['view'] = 'owner';
            $inputData['nextOperation'] = 'selectTenantInfo';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewTenantSysAdmin":
            if(!isset($inputData['tenantId']) || empty($inputData['tenantId'])){
                $out['status']   = 'failed';
                $out['message']  = 'Tenant ID is required';
                break;
            }
            $inputData['view'] = 'sysAdmin';
            $inputData['nextOperation'] = 'selectTenantInfo';
            $out = executeDatabaseOperation($inputData);
            break;
        case "updateTenant":
            $inputData['tableName'] = 'tenant';
            $inputData['idName'] = 'tenant';
            $inputData['actionType'] = 'update';
            $out = updateContent($inputData);
            break;
        case "deleteTenant":
            $inputData['tableName'] = 'tenant';
            $inputData['idName'] = 'tenant';
            $inputData['actionType'] = 'delete';
            $inputData['tenant']['tenantStatus'] = 'deleted';
            $inputData['tenant']['isDeleted'] = 1;
            $out = updateContent($inputData);
            break;
        case "addNewTenantTheme":
            $inputData['nextOperation'] = 'insertNewTenantTheme';
            $out = checkTenantExists($inputData);
            break;
        case "updateTenantTheme":
            $inputData['tableName'] = 'tenantTheme';
            $inputData['idName'] = 'theme';
            $inputData['actionType'] = 'update';
            $out = updateContent($inputData);
            break;
        case "viewThemePublic":
            $inputData['view'] = 'restricted';
            $inputData['nextOperation'] = 'viewThemes';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewThemeOwner":
            $inputData['view'] = 'owner';
            $inputData['nextOperation'] = 'viewThemes';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewThemeSysAdmin":
            $inputData['view'] = 'sysAdmin';
            $inputData['nextOperation'] = 'viewThemes';
            $out = executeDatabaseOperation($inputData);
            break;
        case "insertNewTenantContactAdmin":
            $inputData['nextOperation'] = 'insertNewTenantContactAdmin';
            $out = checkTenantExists($inputData);
            break;
        case "insertNewTenantContact":
            $inputData['nextOperation'] = 'insertNewTenantContact';
            $out = checkTenantExists($inputData);
            break;
        case "viewTenantContactPublic":
            if(!isset($inputData['tenantId']) || empty($inputData['tenantId'])){
                $out['status']   = 'failed';
                $out['message']  = 'Tenant ID is required';
                break;
            }
            $inputData['view'] = 'restricted';
            $inputData['nextOperation'] = 'viewContact';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewTenantContactOwner":
            if(!isset($inputData['tenantId']) || empty($inputData['tenantId'])){
                $out['status']   = 'failed';
                $out['message']  = 'Tenant ID is required';
                break;
            }
            $inputData['view'] = 'owner';
            $inputData['nextOperation'] = 'viewContact';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewTenantContactSysAdmin":
            if(!isset($inputData['tenantId']) || empty($inputData['tenantId'])){
                $out['status']   = 'failed';
                $out['message']  = 'Tenant ID is required';
                break;
            }
            $inputData['view'] = 'sysAdmin';
            $inputData['nextOperation'] = 'viewContact';
            $out = executeDatabaseOperation($inputData);
            break;
        case "updateTenantContact":
            $inputData['tableName'] = 'tenantContact';
            $inputData['idName'] = 'contact';
            $inputData['actionType'] = 'update';
            $out = updateContent($inputData);
            break;
        case "deleteTenantContact":
            $inputData['tableName'] = 'tenantContact';
            $inputData['idName'] = 'contact';
            $inputData['actionType'] = 'delete';
            $out = updateContent($inputData);
            break;
        case "insertNewBuisnessHours":
            $inputData['nextOperation'] = 'insertNewBusinessHours';
            $out = checkTenantExists($inputData);
            break;
        case "viewBusinessHoursPublic":
            if(!isset($inputData['tenantId']) || empty($inputData['tenantId'])){
                $out['status']   = 'failed';
                $out['message']  = 'Tenant ID is required';
                break;
            }
            $inputData['view'] = 'restricted';
            $inputData['nextOperation'] = 'viewBusinessHours';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewBusinessHoursOwner":
            if(!isset($inputData['tenantId']) || empty($inputData['tenantId'])){
                $out['status']   = 'failed';
                $out['message']  = 'Tenant ID is required';
                break;
            }
            $inputData['view'] = 'owner';
            $inputData['nextOperation'] = 'viewBusinessHours';
            $out = executeDatabaseOperation($inputData);
            break;
        case "viewBusinessHoursSysAdmin":
            if(!isset($inputData['tenantId']) || empty($inputData['tenantId'])){
                $out['status']   = 'failed';
                $out['message']  = 'Tenant ID is required';
                break;
            }
            $inputData['view'] = 'sysAdmin';
            $inputData['nextOperation'] = 'viewBusinessHours';
            $out = executeDatabaseOperation($inputData);
            break;
        case "updateBusinessHours":
            $inputData['tableName'] = 'tenantBusinessHours';
            $inputData['idName'] = 'businessHours';
            $inputData['actionType'] = 'update';
            $out = updateContent($inputData);
            break;
        case "deleteBusinessHours":
            $inputData['tableName'] = 'tenantBusinessHours';
            $inputData['idName'] = 'businessHours';
            $inputData['actionType'] = 'delete';
            $out = updateContent($inputData);
            break;
        case "viewTenantChangeHistory":
            $inputData['nextOperation'] = 'viewHistory';
            $out = checkTenantExists($inputData);
            break;
        case "viewAllTenantsSuperAdmin":
            $inputData['view'] = 'superAdmin';
            $inputData['nextOperation'] = 'selectTenantInfo';
            $out = executeDatabaseOperation($inputData);
            break;
        default:
            $out['status']   = 'failed';
            $out['message']  = 'No Action Found';
            break;
    }
}else{
    $out = $security;
    if($security['security'] === '0'){
        unset($out['security']);
    }

}

if(defined('TEST_ENV')){
//    $out['testInfo']['1'] = $testInfo;
//    $out['testInfo']['2'] = $_GET;
//    $out['testInfo']['3'] = $_POST;
//      $out['inputData']     = $inputData;
      $out['security']      = $security;
      $out['action']        = $action;
}

echo json_encode(propagateStatusAndMessage($out));
?>
