<?php
    
    function updateBrand($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $updateStatementParts = [];
        $bindings = [];
        $fields = [
            'id' => PDO::PARAM_INT,
            'brandName' => PDO::PARAM_STR, 
            'brandImg' => PDO::PARAM_STR, 
            'brandOrder' => PDO::PARAM_INT,
            'enable' => PDO::PARAM_INT,
            'deleted' => PDO::PARAM_INT,
            'viewProductInfo' => PDO::PARAM_INT,
            'viewProductDetails' => PDO::PARAM_INT,
        ];
        foreach ($fields as $field => $pdoType) {
            if (isset($inputData[$field])) {
                $snakeCaseField = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                $updateStatementParts[] = "$snakeCaseField = :$field";
                $bindings[$field] = [
                    'value' => $inputData[$field], 
                    'type' => $pdoType
                ];
            }
        }
        $updateStatement = implode(', ', $updateStatementParts);
        $sql = "UPDATE brands SET $updateStatement WHERE id = :id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':id', $inputData['id'], PDO::PARAM_INT);
        foreach ($bindings as $key => $binding) {
            $stmt->bindValue(":$key", $binding['value'], $binding['type']);
        }
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $data['status'] = 'Success';
        } else {
            $data['status'] = 'Failed';
            $data['message'] = 'Record not updated';
        }
        return $data;
    }

    function update($inputData){     
        $data = [];
        $updateStatementParts = [];
        $pdo = $inputData['db']['dbApp'];
        $fields = [
            'brandId' => PDO::PARAM_INT, 
            'no' => PDO::PARAM_STR, 
            'decorCode' => PDO::PARAM_STR, 
            'core'  => PDO::PARAM_STR,
            'decorName' => PDO::PARAM_STR, 
            'decorGroup' => PDO::PARAM_STR, 
            'width' => PDO::PARAM_STR, 
            'isNew' => PDO::PARAM_INT, // TINYINT
            'isNotAvailable' => PDO::PARAM_INT, // TINYINT
            'dimensions' => PDO::PARAM_STR,
            'priceDelete' => PDO::PARAM_STR,
            'dimensionsDelete' => PDO::PARAM_STR,
            'imagesEdit' => PDO::PARAM_STR,
            'imagesDelete' => PDO::PARAM_STR,
        ];
        $bindings = [];
        foreach ($fields as $field => $pdoType) {
            if (isset($inputData[$field])) {
                $snakeCaseField1 = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                $snakeCaseField = preg_replace('/([0-9])/', '_$1', $snakeCaseField1);
               if($field == 'priceDelete'){
                    $id = $inputData['id']; // temp hold
                    foreach($inputData['priceDelete'] as $price){
                        $inputData['id'] = $price['id'];
                        $data['priceDelete'][] = deletePrice($inputData);
                    }
                    $inputData['id'] = $id; // reset
                } else if   ($field == 'dimensions'){
                    $data['dimensions'] = updateDimensions($inputData);
                } else if   ($field == 'dimensionsDelete'){
                    $inputData['action'] = 'dimensionDelete';
                    $currentID = $inputData['id'];
                    foreach($inputData['dimensionsDelete'] as $dimension){
                        $inputData['id'] = $dimension['id'];
                        $data['dimensionsDelete'][] = deleteDimension($inputData);
                    }
                    $inputData['id'] = $currentID;
                }else if($field == 'imagesEdit'){
                    $inputData['images'] = [];
                    $inputData['images'] = $inputData['imagesEdit'];
                    $data['images'] = updateImages($inputData);
                } else if($field == 'imagesDelete'){
                    $inputData['action'] = 'imageDelete';
                    $currentID = $inputData['id'];
                    foreach($inputData['imagesDelete'] as $image){
                        $inputData['id'] = $image['id'];
                        $data['imagesDelete'][] = deleteImage($inputData);
                    }
                    $inputData['id'] = $currentID;
                } else {
                    $value = $inputData[$field];
                }

                if($field != 'dimensions' && $field != 'priceDelete' && $field != 'dimensionsDelete'  && $field != 'imagesEdit' && $field != 'imagesDelete'){
                    $bindings[$field] = [
                        'type' => $pdoType,
                        'value' => $value
                    ];
                    $updateStatementParts[] = "$snakeCaseField = :$field";
                }
            }
        }

        $updateStatement = implode(', ', $updateStatementParts);
        // Determine which table to update
        $id = $inputData['productId'];
        $sql = "UPDATE product SET $updateStatement WHERE id = :id"; 

        // Prepare the statement
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':id', $id, PDO::PARAM_INT);

        // Bind the parameters with their specific types
        foreach ($bindings as $key => $binding) {
            $stmt->bindValue(":$key", $binding['value'], $binding['type']);
        }
        // if there is nothing in the updateStatement dont execute the statement
        if($updateStatement != ''){
            $stmt->execute();
            // Check if the update was successful
            if ($stmt->rowCount() > 0) {
                $data['status'] = 'Success';
            } else {
                $data['status'] = 'Failed';
                $data['message'] = 'Record not updated';
            }
        }else{
            $data['status'] = 'Success';
            $data['message'] = 'No data to update';
        }

        if ($data['status'] == 'Success' && isset($data['dimensions'])) {
            // Check if dimensions update failed
            if ($data['dimensions']['status'] == 'Failed') {
                $data['status'] = 'Failed';
                $data['message'] = 'Dimensions not updated';
            }
            // Check if price update failed
            elseif (isset($data['dimensions']['price']) && $data['dimensions']['price']['status'] == 'Failed') {
                $data['status'] = 'Failed';
                $data['message'] = 'Price not updated';
            }else {
                // If none failed, assume data was updated successfully
                $data['message'] = 'Data updated';
            }
        }
        
        // Store debugging information
        return $data;
    }

    function updateDimensions($inputData){
        $data = [];
        $dimensionsId = 0;
        $data['dimensions'] = [];
        $pdo = $inputData['db']['dbApp'];
        $fields = [
            'length'        => PDO::PARAM_STR,
            'width'         => PDO::PARAM_STR,
        ];
        if(isset($inputData['dimensions'])){
            foreach($inputData['dimensions'] as $dimension){
                // Prepare data array  
                if(isset($dimension['id'])){
                    $dimensionId = $dimension['id'];
                    // Update existing dimension
                    $updateStatementParts = [];
                    $bindings = [];
                    foreach ($fields as $field => $pdoType) {
                        if (isset($dimension[$field])) {
                            $snakeCaseField = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                            $updateStatementParts[] = "$snakeCaseField = :$field";
                            if($field != 'price' && $field != 'priceDelete'){
                                $bindings[$field] = [
                                    'value' => $dimension[$field], 
                                    'type' => $pdoType
                                ];
                            }
                        }
                    }
                    
                    $updateStatement = implode(', ', $updateStatementParts);
                    $sql = "UPDATE product_dimensions SET $updateStatement WHERE id = :id";
                    $stmt = $pdo->prepare($sql);
                    $stmt->bindValue(':id', $dimension['id'], PDO::PARAM_INT);
                    foreach ($bindings as $key => $binding) {
                        $stmt->bindValue(":$key", $binding['value'], $binding['type']);
                    }
                    $stmt->execute();
                    if ($stmt->execute()) {
                        $result['status'] = 'Success';
                        $result['id'] = $dimension['id'];
                    } else {
                        $result['id'] = $dimension['id'];
                        $result['status'] = 'Failed';
                        $result['message'] = 'Dimensions not updated';
                    }
                    $data['dimensions'][] = $result;
                } else {
                    // Insert new dimension
                    $insertStatementParts = [];
                    $bindings = [];
                    foreach ($fields as $field => $pdoType) {
                        if (isset($dimension[$field])) {
                            $snakeCaseField = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                            $insertStatementParts[] = "$snakeCaseField = :$field";
                            $bindings[$field] = [
                                'value' => $dimension[$field], 
                                'type' => $pdoType
                            ];
                        }
                    }
                    $insertStatementParts[] = "product_id = :product_id";
                    $insertStatement = implode(', ', $insertStatementParts);
                    $sql = "INSERT INTO product_dimensions SET $insertStatement";
                    $stmt = $pdo->prepare($sql);
                    foreach ($bindings as $key => $binding) {
                        $stmt->bindValue(":$key", $binding['value'], $binding['type']);
                    }
                    $stmt->bindValue(":product_id", $inputData['productId'], PDO::PARAM_INT);
                    $stmt->execute();
                    $dimensionId = $pdo->lastInsertId();
                    if ($stmt->rowCount() > 0) {
                        $result['status'] = 'Success';
                        $result['id'] = $dimensionId;
                    } else {
                        $result['status'] = 'Failed';
                        $result['message'] = 'New dimensions not inserted';
                    }
                    $data['dimensions'][] = $result;
                }

                if(isset($dimension['price'])){
                    $inputData1['dimensionsId'] = $dimensionId;
                    $inputData1['price'] = $dimension['price'];
                    $inputData1['db']['dbApp'] = $inputData['db']['dbApp'];
                    $data['price'] = updatePriceDimensions($inputData1);
                }
            }
        }

        return $data;
    }
    
    function updatePriceDimensions($inputData) {
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $fields = [
            'price' => PDO::PARAM_STR,
            'thickness' => PDO::PARAM_STR,
        ];
        if (isset($inputData['price'])) {
            foreach ($inputData['price'] as $price) {
                $updateStatementParts = [];
                $bindings = [];
                // Check if the price record has an 'id' field for updating
                if (isset($price['id'])) {
                    // Prepare the fields for the UPDATE statement
                    foreach ($fields as $field => $pdoType) {
                        if (isset($price[$field])) {
                            $snakeCaseField = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                            $updateStatementParts[] = "$snakeCaseField = :$field";
                            $bindings[$field] = [
                                'value' => $price[$field], 
                                'type' => $pdoType
                            ];
                        }
                    }
    
                    // Prepare and execute the UPDATE statement
                    $updateStatement = implode(', ', $updateStatementParts);
                    $sql = "UPDATE product_pricing SET $updateStatement WHERE id = :id";
                    $stmt = $pdo->prepare($sql);
                    $stmt->bindValue(':id', $price['id'], PDO::PARAM_INT);
                    
                    foreach ($bindings as $key => $binding) {
                        $stmt->bindValue(":$key", $binding['value'], $binding['type']);
                    }
                    $stmt->execute();
    
                    // Check if any rows were updated
                    if ($stmt->rowCount() > 0) {
                        $data['status'] = 'Success';
                    } else {
                        $data['status'] = 'Failed';
                        $data['message'] = 'Record not updated';
                    }
                } else {
                    // Prepare $inputData2 with the necessary fields for insertion
                    $inputData2 = [
                        'db' => $inputData['db'],
                        'dimensionsId' => $inputData['dimensionsId'],
                        'price' => [
                            "0" => [
                                'thickness' => $price['thickness'],
                                'price' => $price['price']
                            ]
                        ]
                    ];    
                    try {
                        // Call the insertPriceDimensions function with the new $inputData2
                        $insertData = insertPriceDimensions($inputData2);
                        if (!empty($insertData)) {
                            $data['status'] = 'Success';
                            $data['inserted_ids'] = $insertData;
                        } else {
                            $data['status'] = 'Failed';
                            $data['message'] = 'Insert failed';
                        }
                    } catch (Exception $e) {
                        // Handle any errors that occur in the insertPriceDimensions function
                        $data['status'] = 'Failed';
                        $data['message'] = $e->getMessage();
                    }
                }
            }
        }
    
        return $data;
    }
    
    function updatePrice($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $updateStatementParts = [];
        $bindings = [];
        $fields = [
            'id' => PDO::PARAM_INT,
            'price' => PDO::PARAM_STR,
            'thickness' => PDO::PARAM_STR,
        ];
        if(isset($inputData['price'])){
            foreach($inputData['price'] as $price){
                if(isset($price['id'])){
                    $updateStatementParts = [];
                    $bindings = [];
                    foreach ($fields as $field => $pdoType) {
                        if (isset($price[$field])) {
                            $snakeCaseField = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                            $updateStatementParts[] = "$snakeCaseField = :$field";
                            $bindings[$field] = [
                                'value' => $price[$field], 
                                'type' => $pdoType
                            ];
                        }
                    }
                    $updateStatement = implode(', ', $updateStatementParts);
                    $sql = "UPDATE product_pricing SET $updateStatement WHERE id = :id";
                    $stmt = $pdo->prepare($sql);
                    $stmt->bindValue(':id', $price['id'], PDO::PARAM_INT);
                    foreach ($bindings as $key => $binding) {
                        $stmt->bindValue(":$key", $binding['value'], $binding['type']);
                    }
                    $stmt->execute();
                    if ($stmt->rowCount() > 0) {
                        $data['status'] = 'Success';
                    } else {
                        $data['status'] = 'Failed';
                        $data['message'] = 'Record not updated';
                    }
                }else{
                    $updateStatementParts = [];
                    $bindings = [];
                    foreach ($fields as $field => $pdoType) {
                        if (isset($price[$field])) {
                            $snakeCaseField = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                            $updateStatementParts[] = "$snakeCaseField = :$field";
                            $bindings[$field] = [
                                'value' => $price[$field], 
                                'type' => $pdoType
                            ];
                        }
                    }
                    $updateStatementParts[] = "product_Id = :product_Id";
                    $updateStatement = implode(', ', $updateStatementParts);
                    $sql = "INSERT INTO product_pricing SET $updateStatement";
                    $stmt = $pdo->prepare($sql);
                    foreach ($bindings as $key => $binding) {
                        $stmt->bindValue(":$key", $binding['value'], $binding['type']);
                    }
                    $stmt->bindValue(":product_Id", $inputData['productId'], PDO::PARAM_INT);
                    $stmt->execute();
                    if ($stmt->rowCount() > 0) {
                        $data['status'] = 'Success';
                    } else {
                        $data['status'] = 'Failed';
                    }
                }
            }
        }
        return $data;
    }

    function updateImages($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $updateStatementParts = [];
        $bindings = [];
        $fields = [
            'no' => PDO::PARAM_INT,
            'image_path' => PDO::PARAM_STR,
            'image_location' => PDO::PARAM_STR,
        ];
        $inputData['images2'] = $inputData['images'];
        if(isset($inputData['images2'])){
            foreach($inputData['images2'] as $image){
                if(isset($image['id'])){
                    $updateStatementParts = [];
                    $bindings = [];
                    foreach ($fields as $field => $pdoType) {
                        if (isset($image[$field])) {
                            $snakeCaseField = strtolower(preg_replace('/[A-Z]/', '_$0', $field));
                            $updateStatementParts[] = "$snakeCaseField = :$field";
                            $bindings[$field] = [
                                'value' => $image[$field], 
                                'type' => $pdoType
                            ];
                        }
                    }
                    $updateStatement = implode(', ', $updateStatementParts);
                    $sql = "UPDATE product_images SET $updateStatement WHERE id = :id";
                    $stmt = $pdo->prepare($sql);
                    $stmt->bindValue(':id', $image['id'], PDO::PARAM_INT);
                    foreach ($bindings as $key => $binding) {
                        $stmt->bindValue(":$key", $binding['value'], $binding['type']);
                    }
                    $stmt->execute();
                    if ($stmt->rowCount() > 0) {
                        $data['status'] = 'Success';
                    } else {
                        $data['status'] = 'Failed';
                        $data['message'] = 'Record not updated';
                    }
                }else{
                    $inputData['images'] = [];
                    $inputData['images'][] = $image;
                    $data['images'][] = insertImage($inputData);
                }
            }
        }
                return $data;
    }

    function deleteBrand($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        if($inputData['action'] == 'brandDelete'){
            $id = $inputData['id'];
            $sql = "UPDATE brands set deleted = 1 where id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();
            // check if statement was successful
            if ($stmt->rowCount() > 0) {
                $data['status'] = 'Success';
            } else {
                $data['status'] = 'Failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
            $inputData['brand_id'] = $id;
            $data['products'] = deleteProduct($inputData);
    
        }else{
            // step one get all the brands that relate to the brand into a list called $brands_id
            $id = $inputData['brand_id'];
            $sql = "SELECT id FROM product WHERE brand_id = :brand_id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':brand_id', $inputData['id'], PDO::PARAM_INT);
            $stmt->execute();
            $brands_id = $stmt->fetchAll(PDO::FETCH_ASSOC);
            // loop through the list and call deleteProduct($id) for each brand
            foreach($brands_id as $brand){
                // delete all the products that relate to the brand
                $inputData['product_id'] = $brand['id'];
                $data['products'][] = deleteProduct($inputData);
            }
    
            $sql = "UPDATE brands set deleted = 1 where id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();
            // check if statement was successful
            if ($stmt->rowCount() > 0) {
                $data['status'] = 'Success';
            } else {
                $data['status'] = 'Failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
        }
        return $data;
    }
    
    function deleteProduct($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        if($inputData['action'] == 'productDelete'){
            $id = $inputData['id'];
            $sql = "UPDATE product set deleted = 1 where id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();
            // check if statement was successful
            if ($stmt->rowCount() > 0) {
                $data['status'] = 'Success';
            } else {
                $data['status'] = 'Failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
            $inputData['product_id'] = $id;
            $data['dimensions'] = deleteDimension($inputData);
            $data['images'] = deleteImage($inputData);
        }else{
            // step one get all the products that relate to the brand into a list called $products_id
            $id = $inputData['brand_id'];
            $sql = "SELECT id FROM product WHERE brand_id = :brand_id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':brand_id', $inputData['id'], PDO::PARAM_INT);
            $stmt->execute();
            $products_id = $stmt->fetchAll(PDO::FETCH_ASSOC);
            // loop through the list and call deleteDimension($id) for each product
            foreach($products_id as $product){
                // delete all the dimensions that relate to the product
                $inputData['product_id'] = $product['id'];
                $data['dimensions'][] = deleteDimension($inputData);
                $data['images'][] = deleteImage($inputData);
            }
    
            $sql = "UPDATE product set deleted = 1 where brand_id = :brand_id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':brand_id', $id, PDO::PARAM_INT);
            $stmt->execute();
            // check if statement was successful
            if ($stmt->rowCount() > 0) {
                $data['status'] = 'Success';
            } else {
                $data['status'] = 'Failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
        }
        
        return $data;
    }
    
    function deleteDimension($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        if($inputData['action'] == 'dimensionDelete'){
            $id = $inputData['id'];
            $sql = "UPDATE product_dimensions set deleted = 1 where id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();
            // check if statement was successful
            if ($stmt->rowCount() > 0) {
                $data['status'] = 'Success';
            } else {
                $data['status'] = 'Failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
            $inputData['dimensions_id'] = $id;
            $data['prices'] = deletePrice($inputData);
        }else{
            // step one get all the dimensions that relate to the product into a list called $dimensions_id
            $id = $inputData['product_id'];
            $sql = "SELECT id FROM product_dimensions WHERE product_id = :product_id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':product_id', $id, PDO::PARAM_INT);
            $stmt->execute();
            $idList = [];
            if ($stmt->rowCount() > 0) { 
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) { 
                    $idList['id'][]    = $row['id'];
                }
                // loop through the list and call deletePrice($id) for each dimension
                foreach($idList as $dimension){
                    foreach($dimension as $dim){
                    // delete all the prices that relate to the dimension
                        $inputData['dimensions_id'] = $dim;
                        $data['prices'][] = deletePrice($inputData);
                    }
                }
            }
    
            $sql = "UPDATE product_dimensions set deleted = 1 where product_id = :product_id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':product_id', $id, PDO::PARAM_INT);
            $stmt->execute();
            // check if statement was successful
            if ($stmt->rowCount() > 0) {
                $data['status'] = 'Success';
            } else {
                $data['status'] = 'Failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
        }
        
        return $data;
    }
    
    function deletePrice($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $id = $inputData['id'];
        $dimensions_id = $inputData['dimensions_id'];
       if($dimensions_id){
            $sql = "UPDATE product_pricing SET deleted = 1 WHERE dimensions_id = :dimensions_id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':dimensions_id', $dimensions_id, PDO::PARAM_INT);
            $stmt->execute();
            // check if statement was successful
            if ($stmt->rowCount() > 0) {
                $data['status'] = 'Success';
            } else {
                $data['status'] = 'Failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
        }else{
            $sql = "UPDATE product_pricing SET deleted = 1 WHERE id = :id";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':id', $id, PDO::PARAM_INT);
            $stmt->execute();
            // check if statement was successful
            if ($stmt->rowCount() > 0) {
                $data['status'] = 'Success';
            } else {
                $data['status'] = 'Failed';
                $data['message'] = 'Record not deleted';
                $data['id'] = $id;
            }
    
        }
        return $data;
    }

    function deleteImage($inputData){

            $data = [];
            $pdo = $inputData['db']['dbApp'];
            if($inputData['action'] == 'imageDelete'){
                $id = $inputData['id'];
                $sql = "UPDATE product_images set deleted = 1 where id = :id";
                $stmt = $pdo->prepare($sql);
                $stmt->bindParam(':id', $id, PDO::PARAM_INT);
                $stmt->execute();
                // check if statement was successful
                if ($stmt->rowCount() > 0) {
                    $data['status'] = 'Success';
                } else {
                    $data['status'] = 'Failed';
                    $data['message'] = 'Record not deleted';
                    $data['id'] = $id;
                }
            }else{
                // step one get all the images that relate to the product into a list called $images_id
                $id = $inputData['product_id'];
                $sql = "UPDATE product_images set deleted = 1 where product_id = :product_id";
                $stmt = $pdo->prepare($sql);
                $stmt->bindParam(':product_id', $id, PDO::PARAM_INT);
                $stmt->execute();
                // check if statement was successful
                if ($stmt->rowCount() > 0) {
                    $data['status'] = 'Success';
                } else {
                    $data['status'] = 'Failed';
                    $data['message'] = 'Record not deleted';
                    $data['id'] = $id;
                }
            }
        return $data;
    }
?>
