<?php

    function CheckBrandisNew($inputData){
        $pdo = $inputData['db']['dbApp'];
        $sql = "SELECT * FROM brands WHERE brand_name = :brandName and deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':brandName', $inputData['brandName']);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            $data['status'] = 'Failed';
            $data['message'] = 'Brand already exists';
        } else {
            $data['status'] = 'Success';
        }
        return $data;
    }

    function viewPageBrands($inputData) {
        $data['status'] = 'Success';
        $inputData['table'] = 'brands';
        $lastModified = getMaxDate($inputData);
        $and = ' and `enable` = 1 ';
        $userid = $inputData['userId'];
        $roleId = $inputData['roleId'];
        $admin = 0;
        if(isset($userid) && $userid != '' && $roleId == 1){
            $and = '  ';
            $admin= 1;
        }

        if(isset($inputData['lastModified']) && $inputData['lastModified'] == $lastModified){
            $data['status'] = 'Success';
            $data['message'] = 'Content is up to date';
        }else{
            $data = [];
            $pdo = $inputData['db']['dbApp'];
            $sql = "SELECT * FROM brands where deleted != 1 $and order by `order` asc";
            $stmt = $pdo->prepare($sql);
            $stmt->execute();
            if ($stmt->rowCount() > 0) { 
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) { 
                    $result['id']         = $row['id'];
                    $result['brands']     = $row['brand_name'];
                    $result['brandsImg'] = $row['brand_img'];
                    $result['brandFolder'] = $row['brand_folder'];
                    $result['order']      = $row['order'];
                    $result['viewProductInfo'] = $row['view_product_info'];
                    $result['viewProductDetails'] = $row['view_product_details'];
                    if($admin == 1){
                        $result['enable'] = $row['enable'];
                    }
                    $data['result'][] = $result;
                }
                $data['lastModified'] = $lastModified;


            } else {
                $data['status'] = 'Failed';
                $data['message'] = 'No content found';
            }
        }
        return $data;
    }

    function edgeBanding($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $brandId = $inputData['brandId'];
        $tableName = array();
        array_push($tableName, 'edge_banding');
        array_push($tableName, 'edge_thicknesses_prices');
        $inputData['table'] =  $tableName;
        $lastModified = getMaxDate($inputData);
        if(isset($inputData['lastModified']) && $inputData['lastModified'] == $lastModified){
            $data['status'] = 'Success';
            $data['message'] = 'Content is up to date';
        }else{
            $SQL = "SELECT * FROM edge_banding WHERE brand_id = :brandId and deleted = 0";
            $stmt = $pdo->prepare($SQL);
            $stmt->bindParam(':brandId', $brandId);
            $stmt->execute();
            if ($stmt->rowCount() > 0) { 
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) { 
                    $result['id'] = $row['id'];
                    $result['boardThickness'] = $row['board_thickness'];
                    $result['bandingDetails'] = $row['banding_details'];
                    $thinkness = $row['edge_thickness'];
                    $thicknessPart = explode('.', $thinkness);
                    if($thicknessPart[1] == '00'){
                        $result['edgeThickness'] = $thicknessPart[0];
                    }else{
                        $result['edgeThickness'] = $thinkness;
                    }
                    $result['bandingType'] = $row['banding_type'];
                    $inputData['productId'] = $row['id'];
                    $result['price'] = getEdgePriceInfo($inputData);
                    $data['result'][] = $result;
                }
                $rowCount = 1;
                $data['lastModified'] = $lastModified;
                $data['status'] = 'Success';
            } else {
                $data['status'] = 'Failed';
                $data['message'] = 'No content found';
            }
        }
        return $data;
    }

    function standardProduct($inputData){
        $data = [];
        $pdo = $inputData['db']['dbApp'];
        $brandId = $inputData['brandId'];
        $tableName = array();
        array_push($tableName, 'product');
        array_push($tableName, 'product_pricing');
        $inputData['table'] =  $tableName;
        $lastModified = getMaxDate($inputData);
        if(isset($inputData['lastModified']) && $inputData['lastModified'] == $lastModified){
            $data['status'] = 'Success';
            $data['message'] = 'Content is up to date';
        }else{
            $sql = "SELECT * FROM product WHERE brand_id = :brandId and deleted = 0";
            $stmt = $pdo->prepare($sql);
            $stmt->bindParam(':brandId', $brandId);
            $data = [];
            $pdo = $inputData['db']['dbApp'];
            $brandId = $inputData['brandId'];
            $stmt->execute();
            if ($stmt->rowCount() > 0) { 
                while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) { 
                    $result['id'] = $row['id'];
                    $result['no'] = $row['no'];
                    $result['decorCode'] = $row['decor_code'];
                    $result['decorName'] = $row['decor_name']; //  kill value 2 for some reason :(
                    $result['decorGroup'] = $row['decor_group'];
                    $result['core'] = $row['core'];
                    $result['isNew'] = $row['is_new'];
                    $result['isNotAvailable'] = $row['is_not_available'];
                    $inputData['productId'] = $row['id'];
                    $result['dimensions'] = getProductDimensions($inputData);
                    $result['images'] = getImageList($inputData);
                    $data['result'][] = $result;
                }
                $data['lastModified'] = $lastModified;
                $data['status'] = 'Success';
            } else {
                $data['status'] = 'Failed';
                $data['message'] = 'No content found';
            }   
        }
        return $data;
    }

    function getProductDimensions($inputData){
        $pdo = $inputData['db']['dbApp'];
        $product_id = $inputData['productId'];
        $sql = "SELECT * FROM product_dimensions WHERE product_id = :product_id and deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':product_id', $product_id);
        $stmt->execute();
        if ($stmt->rowCount() > 0) { 
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) { 
                $result['id'] = $row['id'];
                $result['length'] = $row['length'];
                $result['width'] = $row['width'];
                $inputData['dimensionsId'] = $row['id'];
                $result['price'] = getPriceInfoByDimensions($inputData);
                $data[] = $result;
            }
        } else {
            $result['length'] = 0;
            $result['width'] = 0;
            $result['price'] = [];
            $data[] = $result;
        }
        return $data;
    }

    function getPriceInfo($inputData){
        $pdo = $inputData['db']['dbApp'];
        $product_id = $inputData['productId'];
        $sql = "SELECT * FROM product_pricing  WHERE product_id = :product_id and deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':product_id', $product_id);
        $stmt->execute();
        if ($stmt->rowCount() > 0) { 
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) { 
                $result['id'] = $row['id'];
                $result['price'] = $row['price'];
                $thinkness = $row['thickness'];
                $thickness_part = explode('.', $thinkness);
                if($thickness_part[1] == '00'){
                    $result['thickness'] = $thickness_part[0];
                }else{
                    $result['thickness'] = $thinkness;
                }
                $data[] = $result;
            }
        } else {
            $result['price'] = 0;
            $result['thickness'] = 0;
            $data[] = $result;
        }
        return $data;        
    }

    function getPriceInfoByDimensions($inputData){
        $pdo = $inputData['db']['dbApp'];
        $dimensionsId = $inputData['dimensionsId'];
        $sql = "SELECT * FROM product_pricing  WHERE dimensions_id = :dimensions_id and deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':dimensions_id', $dimensionsId);
        $stmt->execute();
        if ($stmt->rowCount() > 0) { 
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) { 
                $result['id'] = $row['id'];
                $result['price'] = $row['price'];
                $thinkness = $row['thickness'];
                $thickness_part = explode('.', $thinkness);
                if($thickness_part[1] == '00'){
                    $result['thickness'] = $thickness_part[0];
                }else{
                    $result['thickness'] = $thinkness;
                }
                $data[] = $result;
            }
        } else {
            $result['price'] = 0;
            $result['thickness'] = 0;
            $data[] = $result;
        }
        return $data;        
    }

    function getEdgePriceInfo($inputData){
        $pdo = $inputData['db']['dbApp'];
        $product_id = $inputData['productId'];
        $sql = "SELECT * FROM edge_thicknesses_prices  WHERE edge_banding_id = :product_id";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':product_id', $product_id);
        $stmt->execute();
        if ($stmt->rowCount() > 0) { 
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) { 
                $result['id'] = $row['id'];
                $result['pricePerMeter'] = $row['price_per_meter'];
                $result['thicknessRange'] = $row['thickness_range'];
                $data[] = $result;
            }
        } else {
            $data['status'] = 'Failed';
            $data['message'] = 'No content found';
            $result['pricePerMeter'] = 0;
            $result['thicknessRange'] = 0;
            $data[] = $result;
        }
        return $data;
    }

    function getProductForHistory($inputData){
        $pdo = $inputData['db']['dbApp'];
        $productId = $inputData['productId'];
        $sqlJoin = "";
        $sql = "SELECT * FROM product ".$sqlJoin." WHERE product.id = :productId";
    
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':productId', $productId);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $result['productId']            = $row['product_id'];
                $result['brandId']              = $row['brand_id'];
                $result['no']                   = $row['no'];
                $result['decorCode']            = $row['decor_code'];
                $result['decorName']            = $row['decor_name'];
                $result['decorGroup']           = $row['decor_group'];
                $result['core']                 = $row['core'];
                $result['isNew']                = $row['is_new'];
                $result['isNotAvailable']       = $row['is_not_available'];
                $result['price']                = $row['price'] ?? null;
                $result['thickness']            = $row['thickness'] ?? null;
                $result['deleted']              = $row['deleted'];
                $result['images']               = getImageList($inputData);
                $result['dimensions']           = getProductDimensionHistory($inputData);
                $data['cms'] = $result;
            }
            $data['status'] = 'Success';
        } else {
            $data['status'] = 'Failed';
            $data['message'] = 'No content found';
        }
        return $data;
    }

    function getProductDimensionHistory($inputData){
        $pdo = $inputData['db']['dbApp'];
        $productId = $inputData['productId'];
        $sql = "SELECT * FROM product_dimensions WHERE product_id = :productId and deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':productId', $productId);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $result['id'] = $row['id'];
                $result['length'] = $row['length'];
                $result['width'] = $row['width'];
                $result['deleted'] = $row['deleted'];
                $inputData['dimensionId'] = $row['id'];
                $result['price'] = getPriceFromDimensionId($inputData);
                $data[] = $result;
            }
            $data['status'] = 'Success';
        } else {
            $data['status'] = 'Failed';
            $data['message'] = 'No content found';
        }
        return $data;
    }

    function getPriceFromDimensionId($inputData){
        $pdo = $inputData['db']['dbApp'];
        $dimensionId = $inputData['dimensionId'];
        $sql = "SELECT * FROM product_pricing WHERE dimensions_id = :dimensionId and deleted = 0";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':dimensionId', $dimensionId);
        $stmt->execute();
        if ($stmt->rowCount() > 0) {
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                $result['id'] = $row['id'];
                $result['price'] = $row['price'];
                $result['thickness'] = $row['thickness'];
                $result['deleted'] = $row['deleted'];
                $data[] = $result;
            }
            $data['status'] = 'Success';
        } else {
            $data['status'] = 'Failed';
            $data['message'] = 'No content found';
        }
        return $data;
    }

    function getMaxDate($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $data = 'Failed';
    
        if (is_array($inputData['table'])) {
            $tables = $inputData['table'];
            $subQueries = array_map(function($table) {
                return "(SELECT MAX(last_updated) FROM $table)";
            }, $tables);
            $sql = "SELECT GREATEST(" . implode(', ', $subQueries) . ") AS last_updated";
        } else {
            $table = $inputData['table'];
            $sql = "SELECT MAX(last_updated) as date FROM $table";
        }
    
        $stmt = $pdo->prepare($sql);
        $stmt->execute();
    
        if ($stmt->rowCount() > 0) {
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            $data = isset($row['last_updated']) ? $row['last_updated'] : $row['date'];
        }
    
        return $data;
    }

    function getProductByPriceId($inputData){
        $result = [];
        $db = $inputData['db']['dbApp'];
        $stmt = $db->prepare("select product_id from product_pricing where id = :priceId and deleted = 0");
        $stmt->bindParam(':priceId', $inputData['priceId']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['productId'] = $row !== false ? $row['product_id'] : 0;
            $result['status']    = 'Success';
        }else{
            $result['status']    = 'Failed';
            $result['msg']       = 'Product not found';
        }
        return  $result;
    }

    function getImageList($inputData){
        $result = [];
        $db = $inputData['db']['dbApp'];
        $stmt = $db->prepare("select id, `no`, lower(image_path) as image_path, image_location from product_images where product_id = :productId and deleted = 0 order by `no` asc");
        $stmt->bindParam(':productId', $inputData['productId']);
        $stmt->execute();
        if ($stmt->rowCount() > 0) { 
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) { 
                $result['id'] = $row['id'];
                $result['no'] = $row['no'];
                $result['imagePath'] = $row['image_path'];
                $result['imageLocation'] = $row['image_location'];
                $data[] = $result;
            }
        }else{
            $data = [];
        }
        return $data;
        
    }
?>
