<?php
// this should only be used for testing purposes
if (defined('TEST_ENV')) {
    //require_once __DIR__ . '/../../orbit-core/src/config.php';
    require_once __DIR__ . '\..\..\core\src\Fcors.php';
    require_once __DIR__ . '\..\..\tests\scripts\bootstrap.php';
    require_once __DIR__ . '\..\..\core\src\generic.php';
    echo("\nFunction Running in Test Environment\n");
} else {
    // this is code for live environment Dev, Uat, Production
    require_once __DIR__ . "./../error_monitor.php";
    require_once __DIR__ . "./../config.php";
    require_once __DIR__ . "./../Fcors.php";
    require_once __DIR__ . "./../db.php";
    require_once __DIR__ . "./../generic.php";
}

include_once("view.php");
include_once("insert.php");
include_once("update.php");
include_once("core.php");

$inputData = initializeGeneric();  // ✅ Ensures fresh initialization in each test

$inputData['requiresAdmin'] = ['test']; //['productUpdate', 'brandCreate', 'brandUpdate', 'brandDelete', 'productDelete', 'dimensionDelete', 'priceDelete']; //['newEvent', 'toggleEvent', 'brandDelete'];

$inputData['keepLive'] = checkLive();
// check if action need auth and if does check it valid otherwise move to swithc statments 
$data = SecurityCheck($inputData); // skip security for a bit 

if(!isset($inputData['action']) || empty($inputData['action'])){
    $out['status']   = 'failed';
    $out['message']  = 'No Action Found';
    return json_encode(propagateStatusAndMessage($out));
}

$action = $inputData['action'];

if($data['security'] === '1'){
    switch ($action) {
        case "productBrandView":
            $data = viewPageBrands($inputData);
            break;
        case "productInfoFromBrand":
            $data = viewProductInfoFromBrand($inputData);
            break;
        case "productUpdate":
            $inputData['nextOperation'] = 'contentChange';
            $inputData['type']          = 'update'; // type of change 
            $inputData['followUp']      = 'update'; // next operation to run 
            $data = executeDatabaseOperation($inputData);
            break;
        case "brandCreate":
            $data = newBrand($inputData);
            break;
        case "brandUpdate":
            $data = updateBrand($inputData);
            break;
        case "productCreate":
            $data = newProduct($inputData);
            break;
        case "brandDelete":
            $data = deleteBrand($inputData);
            break;
        case "productDelete":
            $inputData['nextOperation'] = 'contentChange';
            $inputData['type']          = 'delete'; // did not work as expected 
            $inputData['followUp']      = 'deleteProduct';
            $inputData['id']            = $inputData['productId'];
            $data = executeDatabaseOperation($inputData);
            //$data = deleteProduct($inputData); // revert if failes 
            break;
        case "dimensionDelete":
            $data = deleteDimension($inputData);
            break;
        case "priceDelete":
            $data = deletePrice($inputData);
            break;
        default:
            $data = failed($inputData);
            break;
    }
}

cleanUpOutputData($out);
echo json_encode(propagateStatusAndMessage($out));
?>
