<?php

function sendRequestEmail($inputData) {


    $companyInfo = getCompanyInfo();
    $companyName = $companyInfo['companyName'];
    
    // Handle preflight request
    if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Methods: POST");
        header("Access-Control-Allow-Headers: content-type");
        exit;
    }

    // Only allow POST requests
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        header("Allow: POST", true, 405);
        exit;
    }

    header("Access-Control-Allow-Origin: *");

    // Initialize response data
    $data = ['result' => []];

    // Validate and sanitize input data
    $name = htmlspecialchars(strip_tags($inputData['name']));
    $email = filter_var($inputData['email'], FILTER_VALIDATE_EMAIL);
    $phone = htmlspecialchars(strip_tags($inputData['phone']));
    $enquiry = htmlspecialchars(strip_tags($inputData['enquiry']));
    $location = htmlspecialchars(strip_tags($inputData['location']));
    $timescale = htmlspecialchars(strip_tags($inputData['timescale']));

    // Services
    $services2 = $inputData['services']; // Services data as a string
    $services3 = explode(',', $services2); // Split into array by commas
    $services = "";
    // Loop through each service and process it
    foreach ($services3 as $service4) {
        // Decode HTML entities and trim surrounding quotes and brackets
        $ser = trim(html_entity_decode($service4), '"');
        $ser2 = str_replace(["[", "]"], "", $ser); // Remove square brackets
        // Append each cleaned service to the final services string
        $services .= $ser2 . ", "; 
    }
    // Trim the final trailing comma and remove any extra quotes
    $services = rtrim($services, ", ");
    $services = str_replace('"', "", $services);

    // Image info

    $image_info = json_decode(stripslashes(html_entity_decode($inputData['imgList'])));
    $img_info = "</br><p><strong>Please see attached images<strong></p></br>";
    $i = 0;
    if (is_array($image_info)) {
        foreach ($image_info as $file) {
            if($i == 0){ $i++; }
            else{$img_info = $img_info . "</br>";}
            $img_info = $img_info . "<p><a href='".$file->url."' target='_blank'>Image ".$i."</a></p>";
            $i++;
        }
    }else{
        $img_info = "";
    }

    if (!$email) {
        // Handle invalid email
        http_response_code(400);
        $data['result']['status'] = 'failed';
        $data['result']['message'] = 'Invalid email address.';
        $data['result']['http_response_code'] = 400;
        return $data;
    }

    // Get server domain for the no-reply email address
    $domain = $_SERVER['HTTP_HOST'];
    $noreplyEmail = "no-reply@$domain";

    // Build admin email content
    $servicesList = $services ? "<p><strong>Services:</strong> " . $services . "</p>" : "";
    $conextra = $enquiry ? "<p><strong>Enquiry:</strong><br>" . nl2br($enquiry) . "</p>" : "";
    $phoneLink = $phone ? "<p><strong>Contact By Phone:</strong> <a href=\"tel:$phone\">$phone</a></p>" : "";
    $location1 = $location ? "<p><strong>Location:</strong> $location</p>" : "";
    $timescale1 = $timescale ? "<p><strong>Timescale:</strong> $timescale</p>" : "";

    $adminRecipient = $companyInfo['adminRecipient'];
    $adminSubject   = "New Enquiry";
    $adminHeaders   = "From: $noreplyEmail\r\n";
    $adminHeaders  .= "Reply-To: $email\r\n";
    $adminHeaders  .= "Content-type: text/html; charset=UTF-8\r\n";
    $adminHeaders  .= "Bcc:admin@prodigydesign.co.uk\r\n";

    $adminMessage = "
    <html>
    <head>
        <title>$adminSubject</title>
    </head>
    <body>
        <p>Hi Admin,</p>
        <p>We have a customer, <strong>$name</strong></p>
        $conextra
        $img_info
        $servicesList
        <p><strong>Contact By Email:</strong> $email</p>
        $phoneLink
        $location1
        $timescale1
        <p>Email generated from the website.</p>
        <p><em>Replies to this mailbox are not monitored.</em></p>
        <p>" . date('Y-m-d H:i:s') . "</p>
    </body>
    </html>
    ";

    // Send the admin email
    $adminSuccess = mail($adminRecipient, $adminSubject, $adminMessage, $adminHeaders);

    // Handle admin email success/failure
    if ($adminSuccess) {
        $data['result']['status'] = 'success';
        $data['result']['message'] = 'Admin email sent successfully.';
        $data['result']['http_response_code'] = 200;
    } else {
        $data['result']['status'] = 'failed';
        $data['result']['message'] = 'Failed to send admin email.';
        $data['result']['http_response_code'] = 500;
    }

    // Send thank you email to user
    $userSuccess = sendThankYouEmail($inputData, $companyName);

    return $data;
}

function sendThankYouEmail($inputData, $companyName) {
    // Get server domain for the no-reply email address
    $domain = $_SERVER['HTTP_HOST'];
    $noreplyEmail = "no-reply@$domain";

    // Extract user details from input data
    $name = htmlspecialchars(strip_tags($inputData['name']));
    $email = filter_var($inputData['email'], FILTER_VALIDATE_EMAIL);

    // Build user email content
    $userSubject = 'Thank you for your enquiry';
    $userHeaders = "From: $noreplyEmail\r\n";
    $userHeaders .= "Content-type: text/html; charset=UTF-8\r\n";

    $userMessage = "
    <html>
    <head>
        <title>$userSubject</title>
    </head>
    <body>
        <p>Dear $name,</p>
        <p>Thank you for your enquiry to $companyName. Someone from our team will be in contact with you soon.</p>
        <p><em>Replies to this mailbox are not monitored.</em></p>
    </body>
    </html>
    ";

    // Send the user email
    return mail($email, $userSubject, $userMessage, $userHeaders);
}
?>