<?php
    // this should only be used for testing purposes
    if (defined('TEST_ENV')) {
        //require_once __DIR__ . '/../../orbit-core/src/config.php';
        require_once __DIR__ . '\..\..\core\src\Fcors.php';
        require_once __DIR__ . '\..\..\tests\scripts\bootstrap.php';
        require_once __DIR__ . '\..\..\core\src\generic.php';
        $testInfo['0'] = ("\nFunction Running in Test Environment\n");
    } else {
        // this is code for live environment Dev, Uat, Production
        require_once __DIR__ . "./../error_monitor.php";
        require_once __DIR__ . "./../generic.php";
    }

    require_once __DIR__ . "/core.php";
    require_once __DIR__ . "/view.php";
    require_once __DIR__ . "/insert.php";
    require_once __DIR__ . "/update.php";

    $inputData = initializeGeneric();

    $inputData['requiresAdmin'] = [ 'insertMetaData'           =>  [1,2,3],     'viewMetaDataSuperAdmin'   =>  [1,2,3],     'updateMetaData' => [1,2,3]
                                  ];
    $inputData['keepLive'] = checkLive();
    
    if(!isset($inputData['action']) || empty($inputData['action'])){
        $out['status']   = 'failed';
        $out['message']  = 'No Action Found';
        echo json_encode(propagateStatusAndMessage($out));
exit;
    }

    $action = $inputData['action'];

    // check if action need auth and if does check it valid otherwise move to swithc statments 
    $security = SecurityCheck($inputData); // skip security for a bit 

    if(isset($inputData['tenantId']) == false || $inputData['tenantId'] == null ){
        setTenantId($inputData);
        reinitializeTenantId($inputData);
    }
    if($security['security'] === '1'){
        switch ($action) {
            //Test
                case "test":
                    $out['status']   = 'success';
                    $out['message']  = 'Test Passed';
                    break;
            case "insertMetaData":
                $inputData['table']                 = 'metaData';
                $inputData['metaData']['tenantId']  = $inputData['tenantId'];
                $inputData['nextOperation']         = 'insertData';
                $out = executeDatabaseOperation($inputData);
                break;
            case "viewMetaDataSuperAdmin":
                $inputData['nextOperation']         = 'viewMetaData';
                $inputData['viewType']              = 'superAdmin';
                $out = executeDatabaseOperation($inputData);
                break;
            case "viewMetaDataPublic":
                $inputData['nextOperation']         = 'viewMetaData';
                $inputData['viewType']              = 'public';
                $out = executeDatabaseOperation($inputData);
                break;
            case "updateMetaData":
                $inputData['table']                 = 'metaData';
                $inputData['metaData']['tenantId']  = $inputData['tenantId'];
                $inputData['nextOperation']         = 'updateData';
                $out = executeDatabaseOperation($inputData);
                break;
            default:
                $out['status']   = 'failed';
                $out['message']  = 'No Action Found';
                break;
        }
    }else{
        $out = $security;
        if($security['security'] === '0'){
            unset($out['security']);
        }

    }

    if(defined('TEST_ENV')){
    //    $out['testInfo']['1'] = $testInfo;
    //    $out['testInfo']['2'] = $_GET;
    //    $out['testInfo']['3'] = $_POST;
    //    $out['inputData']     = $inputData;
        $out['security']      = $security;
        $out['action']        = $action;
    }
    cleanUpOutputData($out);
    echo json_encode(propagateStatusAndMessage($out));
?>
