<?php
    function saveHistoryRecordStep($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $table              = 'meta_data_history';
        $changeType         = $inputData['recordType'];
        $toJsonhistoryData  = json_encode($inputData['historyData'], JSON_PRETTY_PRINT);
        $tableOfSource      = toSnakeCase($inputData['table']);
        $oldID              = $inputData['historyData']['id'] ?? null;

        $sql = "INSERT INTO {$table} (tenant_id, change_type, table_of_source, change_data, changed_by, meta_data_id) VALUES (:tenantId, :actionType, :tableOfSource, :historyData, :actionBy, :oldID)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':tenantId', $inputData['tenantId'], PDO::PARAM_INT);
        $stmt->bindValue(':oldID', $oldID, PDO::PARAM_INT);
        $stmt->bindValue(':actionType', $changeType, PDO::PARAM_STR);
        $stmt->bindValue(':tableOfSource', $tableOfSource, PDO::PARAM_STR);
        $stmt->bindValue(':historyData', $toJsonhistoryData, PDO::PARAM_STR);
        $stmt->bindValue(':actionBy', $inputData['userId'], PDO::PARAM_INT);
        $stmt->execute();
        $lastInsertId = $pdo->lastInsertId();
        return [
            'status' => 'success',
            'message' => 'History record saved successfully',
            'id' => $lastInsertId
        ];
    }
    function insertData($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $table = $inputData['table'] ?? null;
        $table = toSnakeCase($table);
        $roleId = $inputData['roleId'] ?? null;
        $dataKey = extractDataKeyFromTableName($inputData['table']);
        $data = $inputData[$dataKey] ?? [];
        
        if (!$table) {
            return ['status' => 'failed', 'message' => 'Table not specified'];
        }
        

        $map = menuTableColumnMapping($table, $roleId, "insert");

        $columnMap = $map['filtered'] ?? null;

        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'Invalid table or insufficient permissions', 'abc' => $table, 'map' => $map];
        }
        
        $insertData = [];
        $errors = [];
        
        foreach ($columnMap as $key => $meta) {
            // Skip if optionalInsert is null (e.g., auto-increment ID)
            if (array_key_exists('optionalInsert', $meta) && $meta['optionalInsert'] === null) {
                continue;
            }
            
            $dbField = $meta['mapping'] ?? null;
            if (!$dbField) {
                continue; // No valid mapping
            }
            
            if (!isset($data[$key]) || $data[$key] === '') {
                if (!empty($meta['optionalInsert']) && $meta['optionalInsert'] == 1) {
                    // Field is optional, allow skipping
                    continue;
                }
                // Field is required, error
                $errors[] = "$key is required";
            } else {
                $insertData[$dbField] = $data[$key];
            }
        }
        
        if (!empty($errors)) {
            return [
                'status' => 'failed',
                'message' => implode(', ', $errors)
            ];
        }
        
        if (empty($insertData)) {
            return [
                'status' => 'failed',
                'message' => 'No valid data to insert'
            ];
        }
        
        $columns = implode(', ', array_keys($insertData));
        $placeholders = implode(', ', array_map(fn($k) => ':' . $k, array_keys($insertData)));
        



        if($table == 'menu_menus'){
            if(isset($data['isActive']) && $data['isActive'] == 1){
                if(in_array('isActive', array_keys($columnMap))){    
                    $tempRes = disableAnyActive($inputData, $table); // empty string as may break update function
                    if($tempRes['status'] == 'failed'){  
                        return ['res' => $tempRes];
                    }
                }
                    
            }
        }
    
        $sql = "INSERT INTO {$table} ($columns) VALUES ($placeholders)";
        $stmt = $pdo->prepare($sql);

        foreach ($insertData as $key => $value) {
            // if table is foodOrderAddress then for fields x,y,z captilaise the first letter of each word, for a,b,c full upper case of value
            if ($table == 'food_order_address') {
                if (in_array($key, ['address_line_1', 'address_line_2', 'city', 'county'])) {
                    $value = $value = smartUcwords($value); // Capitalize first letter of each word
                } elseif (in_array($key, ['postal_code'])) {
                    $value = strtoupper($value); // Full uppercase for postcode
                } elseif (in_array($key, ['country'])) {
                    $value = countryToShortCode($value); // Remove non-numeric characters
                }
            }
            $stmt->bindValue(":$key", $value);
        }

        $stmt->execute();
        $lastInsertId = $pdo->lastInsertId();

        return [
            'status' => 'success',
            'message' => 'Record inserted successfully',
            'id' => $lastInsertId
        ];
    }
?>