<?    
    function menuTableColumnMapping($table = null, $roleId = null, $actionType = null) {
       $allMappings = [
            'example_example' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                              'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'tenantId'              => ['mapping' => 'tenant_id',                       'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => null,       'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'metaKey'               => ['mapping' => 'meta_key',                        'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => null,       'optionalUpdate' => 0, 'dataType' => 'string', 'expectedValue' => null],
                    'metaValue'             => ['mapping' => 'meta_value',                      'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'isActive'              => ['mapping' => 'is_active',                       'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'boolean','expectedValue' => [0,1]],
                    'isDeleted'             => ['mapping' => 'is_deleted',                      'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'boolean','expectedValue' => [0,1]],
                    'createdAt'             => ['mapping' => 'created_at',                      'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'datetime','expectedValue' => null],
                    'updatedAt'             => ['mapping' => 'updated_at',                      'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],            'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'datetime','expectedValue' => null],
                ],
                'relationships' => [['table' => 'example_example_item', 'foreignKey' => 'orderId']],
            ],
            'example_example_item' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'orderId'               => ['mapping' => 'order_id',                'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuItemId'            => ['mapping' => 'menu_item_id',            'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'itemName'              => ['mapping' => 'item_name',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'string', 'expectedValue' => null],
                    'itemBasePrice'         => ['mapping' => 'item_base_price',         'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedPrice'     => ['mapping' => 'item_modified_price',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedReason'    => ['mapping' => 'item_modified_reason',    'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemQuantity'          => ['mapping' => 'item_quantity',           'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemNote'              => ['mapping' => 'item_note',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemStatus'            => ['mapping' => 'item_status',             'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','prepared','served','cancelled']],
                    'itemTenantComment'     => ['mapping' => 'item_tenant_comment',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_extra', 'foreignKey' => 'itemId']],
            ],
        ];
        
        if (!$table) {
            return $allMappings;
        }
    
        $table = toSnakeCase($table);
        if (!isset($allMappings[$table])) {
            return null;
        }
    
        if ($roleId === null) {
            return $allMappings[$table];
        }
    
        $filtered = [];
        foreach ($allMappings[$table]['fields'] as $key => $meta) {
            if ($actionType === 'update' && isset($meta['updateRole'])) {
                if (in_array($roleId, $meta['updateRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'insert' && isset($meta['insertRole'])) {
                if (in_array($roleId, $meta['insertRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'view' && isset($meta['viewRole'])) {
                if (in_array($roleId, $meta['viewRole'])) {
                    $filtered[$key] = $meta;
                }
            }
        }

    
        return ['filtered' => $filtered, 'abc' => $table, 'roleId' => $roleId];
    }
    function findIdInData($data, $primaryKey) {
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                // Recurse into sub-arrays
                $found = findIdInData($value, $primaryKey);
                if ($found !== null) {
                    return $found;
                }
            } else {
                if ($key === $primaryKey) {
                    return $value;
                }
            }
        }
        return null;
    }
    function executeDatabaseOperation(&$inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function convertKeysToCamelCase($array) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Convert snake_case to camelCase
            $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
                return strtoupper($matches[1]);
            }, $key);

            // Lowercase first character to enforce camelCase
            $camelKey = lcfirst($camelKey);

            // Recursively handle nested arrays
            if (is_array($value)) {
                $converted[$camelKey] = convertKeysToCamelCase($value);
            } else {
                $converted[$camelKey] = $value;
            }
        }

        return $converted;
    }
    function toSnakeCase($input) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
    }
    function renameIdKeys($array, $newKeyName) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Recursively handle nested arrays
            if (is_array($value)) {
                $value = renameIdKeys($value, $newKeyName);
            }

            if ($key === 'id') {
                $converted[$newKeyName] = $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }
    function extractDataKeyFromTableName($tableName) {
        $parts = explode('_', $tableName, 2);
        $base = $parts[1] ?? $tableName;
    
        $baseParts = explode('_', $base);
    
        $camelCase = array_shift($baseParts);
    
        foreach ($baseParts as $part) {
            $camelCase .= ucfirst($part);
        }
    
        return $camelCase;
    }
    ?>