Create table meta_data(
    id INTEGER PRIMARY KEY AUTOINCREMENT,
    tenant_id INTEGER NOT NULL,
    meta_key TEXT NOT NULL,
    meta_value TEXT,
    is_active BOOLEAN DEFAULT 1,
    is_deleted BOOLEAN DEFAULT 0,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
    updated_at DATETIME DEFAULT CURRENT_TIMESTAMP
)

CREATE TABLE meta_data_history (
    id INT AUTO_INCREMENT PRIMARY KEY,
    tenant_id INT NOT NULL,
    meta_data_id INT NOT NULL,
    change_type ENUM('create', 'update', 'delete', 'refund') NOT NULL,
    change_data JSON NOT NULL,
    table_of_source VARCHAR(255) NOT NULL, -- Name of the table where the change occurred
    changed_by INT NOT NULL, -- User ID of the person who made the change
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (meta_data_id) REFERENCES meta_data(id) ON DELETE CASCADE
)ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
