<?php    
    function menuTableColumnMapping($table = null, $roleId = null, $actionType = null) {
       $allMappings = [
            'meta_data' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',           'insertRole'    => [1,2,3],    'updateRole' => [1,2,3],  'optionalInsert' => null,  'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'tenantId'              => ['mapping' => 'tenant_id',    'insertRole'    => [1,2,3],    'updateRole' => [1,2,3],  'optionalInsert' => 0,     'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'metaKey'               => ['mapping' => 'meta_key',     'insertRole'    => [1,2,3],    'updateRole' => [1,2,3],  'optionalInsert' => 0,     'optionalUpdate' => 0, 'dataType' => 'string', 'expectedValue' => null],
                    'metaValue'             => ['mapping' => 'meta_value',   'insertRole'    => [1,2,3],    'updateRole' => [1,2,3],  'optionalInsert' => 0,     'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'isActive'              => ['mapping' => 'is_active',    'insertRole'    => [1,2,3],    'updateRole' => [1,2,3],  'optionalInsert' => 1,     'optionalUpdate' => 1, 'dataType' => 'boolean','expectedValue' => [0,1]],
                    'isDeleted'             => ['mapping' => 'is_deleted',   'insertRole'    => [1,2,3],    'updateRole' => [1,2,3],  'optionalInsert' => 1,     'optionalUpdate' => 1, 'dataType' => 'boolean','expectedValue' => [0,1]],
                    'createdAt'             => ['mapping' => 'created_at',   'insertRole'    => [1,2,3],    'updateRole' => [1,2,3],  'optionalInsert' => 1,     'optionalUpdate' => 1, 'dataType' => 'datetime','expectedValue' => null],
                    'updatedAt'             => ['mapping' => 'updated_at',   'insertRole'    => [1,2,3],    'updateRole' => [1,2,3],  'optionalInsert' => 1,     'optionalUpdate' => 1, 'dataType' => 'datetime','expectedValue' => null],
                ],
                'relationships' => [],
            ],
        ];
        
        if (!$table) {
            return $allMappings;
        }
    
        $table = toSnakeCase($table);
        if (!isset($allMappings[$table])) {
            return null;
        }
    
        if ($roleId === null) {
            return $allMappings[$table];
        }
    
        $filtered = [];
        //foreach ($allMappings[$table] as $key => $meta) {
        foreach ($allMappings[$table]['fields'] as $key => $meta) {
            if (in_array($roleId, $meta['updateRole'])) {
                $filtered[$key] = $meta;
            }
        }
    
        return ['filtered' => $filtered];
    }
    function findIdInData($data, $primaryKey) {
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                // Recurse into sub-arrays
                $found = findIdInData($value, $primaryKey);
                if ($found !== null) {
                    return $found;
                }
            } else {
                if ($key === $primaryKey) {
                    return $value;
                }
            }
        }
        return null;
    }
    function executeDatabaseOperation(&$inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function convertKeysToCamelCase($array) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Convert snake_case to camelCase
            $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
                return strtoupper($matches[1]);
            }, $key);

            // Lowercase first character to enforce camelCase
            $camelKey = lcfirst($camelKey);

            // Recursively handle nested arrays
            if (is_array($value)) {
                $converted[$camelKey] = convertKeysToCamelCase($value);
            } else {
                $converted[$camelKey] = $value;
            }
        }

        return $converted;
    }
    function toSnakeCase($input) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
    }
    function renameIdKeys($array, $newKeyName) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Recursively handle nested arrays
            if (is_array($value)) {
                $value = renameIdKeys($value, $newKeyName);
            }

            if ($key === 'id') {
                $converted[$newKeyName] = $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }
    function extractDataKeyFromTableName($tableName) {
        $parts = explode('_', $tableName, 2);
        $base = $parts[1] ?? $tableName;
    
        $baseParts = explode('_', $base);
    
        $camelCase = array_shift($baseParts);
    
        foreach ($baseParts as $part) {
            $camelCase .= ucfirst($part);
        }
    
        return $camelCase;
    }
    function updateContent($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stage = [];
        try {
            $pdo->beginTransaction(); // Start transaction
            $tableName = toSnakeCase($inputData['table']) ?? null;
            $inputData['dataKey'] = extractDataKeyFromTableName($tableName);
            $changeType = $inputData['recordType'] ?? null;
            // ✅ Check if the extracted data block actually exists
            if (!isset($inputData['dataKey']) || empty($inputData['dataKey'])) {
                $pdo->rollback(); // Rollback transaction
                return ['status' => 'failed', 'message' => "Missing data block for table: {$tableName}"];
            }
            $stage[] = '00: Validate ID, prepare $inputData with idField, id, checkParent';
            // 00: Validate ID, prepare $inputData with idField, id, checkParent
            $res = validateUpdateInputStep($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }

            $stage[] = '01: check item is not marked as deleted no update is possible';
            // 01: check item is not marked as deleted no update is possible
            $inputData['nextOperation'] = 'checkIfDeleted';
            $res = executeDatabaseOperation($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
    

        if($changeType === 'delete' || $changeType === 'update') {
            $stage[] = '02: Fetch existing history data (before change)';
            // 02: Fetch existing history data (before change)
            $inputData['nextOperation'] = 'getDataForHistory';
            $res = executeDatabaseOperation($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
            $inputData['historyData'] = $res['historyData'] ?? null;

            $stage[] = '03: Insert history record into history table';
            // 03: Insert history record into history table
            $inputData['nextOperation'] = 'saveHistoryRecordStep';
            $res = executeDatabaseOperation($inputData);

            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
        }
            $stage[] = '04: check if this is an update or a delete action';
            // 04: check if this is an update or a delete action
            
            if($changeType === 'delete') {
                // check if premission to delete is allowed
                $inputData['nextOperation'] = 'deleteContent';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '05: check if this is an update or a duplicate action';
            // 05: check if this is an update or a delete action
            if($changeType === 'update') {
                $inputData['nextOperation'] = 'updateData';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '06: check if this is a duplicate action';
            // 06: check if this is a duplicate action
            if($changeType === 'duplicate') {
                $inputData['nextOperation'] = 'duplicateRecored';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '07: check if the delete or update was successful';
            // 07: check if the delete or update was successful
            if($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
           }
            $pdo->commit();
            return [ 'status' => 'success','message' => 'Update completed successfully'];
        } catch (Exception $e) {
            $pdo->rollback(); // Rollback transaction on error
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                return ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    
            } else {
                error_log("Error in updateContent: " . $e->getMessage());
                return ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
    }
    function validateUpdateInputStep(&$inputData) {
        // reminder if the dataKey is causing issues it probably means we need to change the name slighlty try and remove the first word
        // metaData => data
        // menuTable => table
        // foodOrderMenu => orderMenu

        $table = $inputData['table'] ?? null;
        $tableName = toSnakeCase($table);
        $roleId = $inputData['roleId'] ?? null;
        $dataKey = $inputData['dataKey'];

        if (!$tableName) {
            return ['status' => 'failed', 'message' => 'Table name not specified in input'];
        }
    
        if (!$dataKey) {
            return ['status' => 'failed', 'message' => 'Data key not extracted from table name'];
        }


        $tableData = $inputData[$dataKey] ?? [];
            
        $map = menuTableColumnMapping($tableName, $roleId);

        $columnMap = $map['filtered'] ?? null;
        
        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'No column mapping found for table: '. $tableName];
        }
    
        // 🆕 Find the primary key field
        $primaryKey = null;
        foreach ($columnMap as $key => $meta) {
            if (isset($meta['mapping']) && strtolower($meta['mapping']) === 'id') {
                $primaryKey = $key;
                break;
            }
        }
    
        if (!$primaryKey) {
            return ['status' => 'failed', 'message' => "No primary key (id) field found for table: {$tableName}"];
        }
    
        // 🆕 Recursively search for the ID value
        $idValue = findIdInData($tableData, $primaryKey);
    
        if ($idValue === null || $idValue === '') {
            return ['status' => 'failed', 'message' => "Missing required Id field: {$primaryKey} key: {$tableName}"];
        }
    
        // Set ID info for future steps
        $inputData['idField'] = $primaryKey;
        $inputData['id'] = $idValue;
    
        // Set checkParent flag
        $inputData['checkParent'] = array_key_exists('parentId', $columnMap) ? 1 : 0;

        return ['status' => 'success'];
    }
?>