<?php

    function idList(){
        $idList = ['auth' => 'tenantId', 'tenantTheme' => 'themeId', 'tenantContact' => 'contactId', 'tenantBusinessHours' => 'businessHoursId'];
        return $idList;
    }
    function tableColumnMapping(){
        $tablesColumn = [
            'auth' => [
                'id' => ['mapping' => 'id', 'updateRole' => ['admin']],
                'tenantId' => ['mapping' => 'tenant_id', 'updateRole' => ['admin']],
                'name' => ['mapping' => 'name', 'updateRole' => ['admin']],
                'email' => ['mapping' => 'email', 'updateRole' => ['admin']],
                'password' => ['mapping' => 'password', 'updateRole' => ['admin']],
            ],
        ];
        return $tablesColumn;
    }
    function updateContent($inputData) {
        $pdo = $inputData['db']['dbApp'];
        // 00 Check if tableid is present in the input data
        $tableName = $inputData['tableName'];
        $idName = $inputData['idName'];
        if(!isset($inputData[$tableName][$idName.'Id']) || empty($inputData[$tableName][$idName.'Id'])){
            $result['status'] = 'failed';
            $result['message'] = 'Missing '.$idName.'Id';
            return $result;
        }

        // 01 Check for the id field related to the table from the idList function
        $idList = idList();
        $tablesColumn = tableColumnMapping();
        if(array_key_exists($inputData['tableName'], $idList)){
            $inputData['id'] = $inputData[$inputData['tableName']][$idList[$inputData['tableName']]];
        }
        if(array_key_exists('parentId', $tablesColumn[$tableName])){
            $inputData['checkParent'] = 1;
        }else{
            $inputData['checkParent'] = 0;
        }

        // 02 Check if the id field is present in the input data
        if(!isset($inputData['id']) || empty($inputData['id'])){
            $result['status'] = 'failed';
            $result['message'] = 'Missing '.$inputData['idName'].'Id';
            return $result;
        }
        //03 begin transaction
        $pdo->beginTransaction();
        try {

            // 04 Get history data for the id field related to the table from the idList function
            $inputData['nextOperation'] = 'selectDataForHistory';
            $res = executeDatabaseOperation($inputData);
            if($res['status'] == 'failed'){ // if the selectDataForHistory fails, return the error
                $result['output'] = $res;
                $result['message'] = 'No content found for the id '.$inputData['id'];
                $result['status'] = 'failed';
                //04.b Rollback transaction
                $pdo->rollback();
                return $result;
            }
            // 04.a check history for children if the tenant is deleted
                // TO BUILD


            $inputData['his'] = $res['his'];
            // 05 insert history data into the history table
            $inputData['nextOperation'] = 'insertHistoryRecord';
            $res = executeDatabaseOperation($inputData);
 
            // 06 check if the action is delete and if so check if not already deleted
            if($inputData['actionType'] == 'delete'){
                $inputData['nextOperation'] = 'checkIfAlreadyDeleted';
                $res = executeDatabaseOperation($inputData);
                if($res['status'] == 'failed'){ // if the selectDataForHistory fails, return the error
                    //04.b Rollback transaction
                    $pdo->rollback();
                    return $res;
                }
            }

            // 07 make chanage that is requierd to be made to the table
            $inputData['nextOperation'] = 'genericUpdateStatment';
            $res = executeDatabaseOperation($inputData);
            if($res['status'] == 'failed'){ // if the selectDataForHistory fails, return the error
                //04.b Rollback transaction
                $pdo->rollback();
                return $res;
            }
            // 08 commit the transaction
            $pdo->commit();
        } catch (Exception $e) {
            // 09 Rollback transaction on error
            $pdo->rollback();
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // 10 Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
            return $results;
        }

        return $out = [
            'status' => 'success'
        ];
    }
    function executeDatabaseOperation( $inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function convertKeysToCamelCase($array) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Convert snake_case to camelCase
            $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
                return strtoupper($matches[1]);
            }, $key);

            // Lowercase first character to enforce camelCase
            $camelKey = lcfirst($camelKey);

            // Recursively handle nested arrays
            if (is_array($value)) {
                $converted[$camelKey] = convertKeysToCamelCase($value);
            } else {
                $converted[$camelKey] = $value;
            }
        }

        return $converted;
    }
    function toSnakeCase($input) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
    }
    function renameIdKeys($array, $newKeyName) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Recursively handle nested arrays
            if (is_array($value)) {
                $value = renameIdKeys($value, $newKeyName);
            }

            if ($key === 'id') {
                $converted[$newKeyName] = $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }
?>