<?php
    function checkIfDeleted($inputData) {
        $table = $inputData['table'];
        $table = toSnakeCase($table);
        $id = $inputData['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT id FROM $table WHERE id = :id and is_deleted = 1");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($data) {
                        return ['status' => 'failed', 'message' => 'Record already deleted'];
            } else {
                return ['status' => 'success'];
            }
    }
    function getDataForHistory($inputData) {
        $table = $inputData['table'];
        $table = toSnakeCase($table);
        $id = $inputData['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT * FROM $table WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        // convert result to json with column names as keys
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        json_encode($data);
        if ($data) {
            return ['status' => 'success', 'historyData' => $data];
        } else {
            return ['status' => 'failed', 'message' => 'Record not found'];
        }
    }
    function viewContentMenus($inputData) {
        $roleId = $inputData['roleId'];
        // role is system admin,
        $viewType = $inputData['view'];

        if (!in_array($viewType, ['sysAdmin', 'owner', 'staff', 'guest'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }

        if ($viewType === 'sysAdmin') {
            $sql = "SELECT * FROM menu_menus WHERE tenant_id = :tenantId order by is_deleted, id desc";
        } elseif ($viewType === 'owner') {
            $sql = "SELECT `id`, `menu_name`, `menu_description`, is_active FROM menu_menus WHERE tenant_id = :tenantId AND is_deleted = 0 order by is_active, id desc";
        } else {
            $sql = "SELECT `menu_name`, `menu_description` FROM menu_menus WHERE tenant_id = :tenantId AND is_deleted = 0 and is_active = 1 order by is_deleted, id desc";
        }

        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':tenantId', $inputData['tenantId'], PDO::PARAM_INT);
        $stmt->execute();

        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
        if (!$rows || ($viewType === 'restricted' && $rows[0]['is_active'] !== 1)) {
            return ['status' => 'failed', 'message' => 'Menu not found'];
        }

        $menu = array_map(function($row) {
            return convertKeysToCamelCase(renameIdKeys($row, 'menuId'));
        }, $rows);

        if ($menu) {
            return ['status' => 'success', 'menuMenus' => $menu];
        } else {
            return ['status' => 'failed', 'message' => 'Record not found'];
        }
    }
    function checkDuplicateRecord($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $table = $inputData['table'] ?? null;
        $table = toSnakeCase($table);
        $dataKey = extractDataKeyFromTableName($inputData['table']);
        $data = $inputData[$dataKey] ?? [];

        if (!$table) {
            return ['status' => 'failed', 'message' => 'Table not specified'];
        }

        $map = menuTableColumnMapping($table, $inputData['roleId'] ?? 0);
        $columnMap = $map['filtered'] ?? null;

        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'Invalid table or insufficient permissions'];
        }

        // Define which fields make the record unique (you may want to pass this in $inputData)
        $uniqueFields = $inputData['uniqueFields'];
        $whereClauses = [];
        $params = [];

        foreach ($uniqueFields as $fieldKey) {
            $meta = $columnMap[$fieldKey] ?? null;
            $dbField = $meta['mapping'] ?? null;

            if (!$dbField || !isset($data[$fieldKey])) {
                return ['status' => 'failed', 'message' => "$fieldKey is required"];
            }

            $whereClauses[] = "$dbField = :$fieldKey";
            $params[$fieldKey] = $data[$fieldKey];
        }

        // Add soft delete clause
        $whereClauses[] = "is_deleted = 0";

        $whereSql = implode(' AND ', $whereClauses);
        $sql = "SELECT id FROM $table WHERE $whereSql";
        $stmt = $pdo->prepare($sql);
        foreach ($params as $key => $value) {
            $stmt->bindValue(":$key", $value);
        }
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($result) {
            return ['status' => 'failed', 'message' => 'Record already exists'];
        }

        return ['status' => 'success'];
    }  
    function getMenuView($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $viewType = $inputData['viewType'] ?? 'restricted'; // default to restricted view
        if (!in_array($viewType, ['sysAdmin', 'owner', 'restricted'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }
        $tenantId = "";
        if(isset($inputData['tenantId'])){
            $tenantId = $inputData['tenantId'];
        }
        if ($viewType === 'sysAdmin') {
            $sql = "SELECT * FROM menu_menus WHERE tenant_id = :tenantId order by is_deleted, id desc";
        } elseif ($viewType === 'owner') {
            $sql = "SELECT `id`, `menu_name`, `menu_description`, is_active FROM menu_menus WHERE tenant_id = :tenantId AND is_deleted = 0 order by is_active, id desc";
        } else {
            $sql = "SELECT `menu_name`, `menu_description`, is_active FROM menu_menus WHERE tenant_id = :tenantId AND is_deleted = 0 and is_active = 1 order by is_deleted, id desc";
        }
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':tenantId', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$rows || ($viewType === 'restricted' && $rows[0]['is_active'] !== 1)) {
            return ['status' => 'failed', 'message' => 'Menu not found'];
        }
        // if the viewType is restricted, we only return the active menus and remove the is_active column
        if ($viewType === 'restricted') {
            foreach ($rows as &$row) {
                unset($row['is_active']);
            }
        }       
        // loop through the rows for category and items
        
        $menu = array_map(function($row) {
            return convertKeysToCamelCase(renameIdKeys($row, 'menuId'));
        }, $rows);

        if ($menu) {
            return ['status' => 'success', 'menuMenus' => $menu];
        } else {
            return ['status' => 'failed', 'message' => 'Record not found'];
        }
    }    
?>