# Menu API Interface Specification

---

## Overview

This document outlines the API contract for managing menu configurations in the system. It includes endpoints for creating, updating, deleting, viewing, and duplicating menu entries (`menu_menus`). All requests are processed through a single PHP entry point (`function.php`) using `POST` requests, with operations determined by the `action` field in the payload.

---

## API Summary Table

| Action                        | Method | Auth Required | Payload Object     | Description                                                  |
|-------------------------------|--------|---------------|--------------------|--------------------------------------------------------------|
| `insertIntoMenuMenus`         | POST      | Yes           | `menuMenus`        | Insert a new menu item                                       |
| `insertIntoMenuCategories`    | POST      | Yes           | `menuCategories`   | Insert a new Categories                                      |
| `insertItemIntoMenu`          | POST      | Yes           | `menuItems`        | Insert a new Categories                                      |
| `insertItemIntoMenuCategory`  | POST      | Yes           | `menuCategoryItems`| Insert a link between an item and a Category                 |
| `updateMenuMenus`             | POST      | Yes           | `menuMenus`        | Update an existing menu item                                 |
| `updateMenuCategories`        | POST      | Yes           | `categories`       | Update an existing Categories                                |
| `updateMenuItems`             | POST      | Yes           | `items`            | Update an existing item                                      |
| `updateMenuCategoryItems`     | POST      | Yes           | `categoryItems`    | Update the active status                                     |
| `deleteMenuMenus`             | POST      | Yes           | `menuMenus`        | Soft-delete a menu                                           |
| `deleteMenuCategories`        | POST      | Yes           | `categories`       | Soft-delete a menu Categories items                          |
| `deleteMenuItems`             | POST      | Yes           | `items`            | Soft-delete a items                                          |
| `deleteMenuCategoryItems`     | POST      | Yes           | `categoryItems`    | Soft-delete a category Items                                 |
| ~~`viewMenuMenus`~~            |~~ GET ~~ | ~~No~~        | —                  | ~~View menu items available to the user's role and tenant~~  |
| `viewSuperAdminMenus`         | GET       | Yes           | —                  | View Menu  (Not Implemented)                                 |
| `viewAdminMenus`              | GET       | Yes           | —                  | View Menu  (Not Implemented)                                 |
| `viewPublicMenus`             | GET       | No            | —                  | View Menu  (Not Implemented)                                 |
| `duplicateMenuMenus`          | POST      | Yes           | `menuMenus`        | Duplicate a menu by ID (Owner only)   (Not Implemented)      |

---

## Payload Structures

### `insertIntoMenuMenus`
```json
{
  "action": "insertIntoMenuMenus",
  "menuMenus": {
    "name": "Main Menu",
    "description": "Primary navigation",
    "isActive": 1,
  }
}
```

### `insertIntoMenuCategories`
```json
{
  "action": "insertIntoMenuCategories",
  "menuCategories": {
    "menuId":       int,
    "parentId":     int optional,
    "name":         string,
    "description":  string,
    "isActive" :    int (0,1),
    "sortOrder" :   int optional,
    "isDeleted" :   int (0,1) optional
  }
}
```

### `insertItemIntoMenu`
```json
{
  "action": "insertItemIntoMenu", // Suggested otherwise this item is not linked to a menu and will be need to be linked another way
  "menuItems": {
    "menuId":           int,
    "categoryId":       int,
    "itemName":         string,
    "itemDescription":  string,
    "basePrice" :       decimal,
    "isActive" :        int optional,
  }
}
```

### `insertItemIntoMenuCategory`
```json
{
  "action": "insertItemIntoMenuCategory",
  "menuCategoryItems": {
    "categoryId": int,
    "itemId":     int
  }
}
```

### `updateMenuMenus`
```json
{
  "action": "updateMenuMenus",
  "menuMenus": {
    "id":           int,
    "name":         string optional,
    "description":  string optional,
    "isActive":     int    optional,
  }
}
```

### `updateMenuCategories`
```json
{
  "action": "updateMenuCategories",
  "categories": {
    "id":           int,
    "menuId":       int    optional,  
    "parentId":     int    optional,
    "name":         string optional,
    "description":  string optional,
    "sortOrder" :   int    optional,
  }
}
```

### `updateMenuItems`
```json
{
  "action": "updateMenuItems",
  "items": {
    "id":               int,
    "categoryId":       int     optional,
    "itemName":         string  optional,
    "itemDescription":  string  optional,
    "basePrice" :       decimal optional,
    "isActive" :        int     optional,
  }
}
```

### `updateMenuCategoryItems`
```json
{
  "action": "updateMenuCategoryItems",
  "categoryItems": {
    "id":       int,
    "isActive": int (0|1),
  }
}
```

### `deleteMenuMenus`
```json
{
  "action": "deleteMenuMenus",
  "menuMenus": {
    "id": int
  }
}
```

### `deleteMenuCategories`
```json
{
  "action": "deleteMenuCategories",
  "categoryItems": {
    "id": int
  }
}
```

### `deleteMenuItems`
```json
{
  "action": "deleteMenuItems",
  "items": {
    "id": int
  }
}
```

### `deleteMenuCategoryItems`
```json
{
  "action": "deleteMenuCategoryItems",
  "categories": {
    "id": int
  }
}
```

### `viewSuperAdminMenus`
```json
{
  "action": "viewSuperAdminMenus"
}
```

### `viewAdminMenus`
```json
{
  "action": "viewAdminMenus"
}
```

### `viewPublicMenus`
```json
{
  "action": "viewPublicMenus"
}
```

### `viewMenuMenus`
```json
{
  "action": "viewMenuMenus"
}
```

### `duplicateMenuMenus`
```json
{
  "action": "duplicateMenuMenus",
  "menuMenus": {
    "menueId": 7
  }
}
```

---

## Response Format

### Success
```json
{
  "status": "success",
  "message": "Record inserted successfully"
}
```

### Failure
```json
{
  "status": "failed",
  "message": "Access denied: insufficient permissions"
}
```

---

## Permissions and Role Behavior

| Role         | Can Insert | Can Update | Can Delete | Can View | Can Duplicate |
|--------------|------------|------------|------------|----------|---------------|
| Owner (4)    | ✅         | ✅         | ✅         | ✅       | ✅            |
| SysAdmin (1) | ❌         | ❌         | ❌         | ✅       | ❌            |
| Public (0)   | ❌         | ❌         | ❌         | ✅ (limited) | ❌        |

- All actions require the user to be authenticated and belong to a valid tenant.
- Insert/update/delete actions log entries into `menu_history` for auditing.

---

## Notes

- Menu items are soft-deleted by setting the `is_deleted` flag.
- `themeStatus` is optional and only used when applicable.
- Update and delete operations require the `id` field.
- Owner role has full CRUD access; other roles have restrictions.
- Returned timestamps (`createdAt`, `updatedAt`) are dynamic and ISO formatted.
- Duplicate and insert actions will return specific error messages if permissions are insufficient.

---

_End of Document_
