
# Orbit Menu Database Schema (Markdown ERD)

This document outlines the full schema for the `orbit-menu` module, including all table names, columns, data types, and foreign key relationships.

---

## 📦 `menu_menus`

| Column         | Type         | Description                        | Links To         |
|----------------|--------------|------------------------------------|------------------|
| `id`           | INT (PK)     | Unique menu ID                     |                  |
| `tenant_id`    | INT          | Tenant that owns the menu          | `tenants.id`     |
| `name`         | VARCHAR(255) | Name of the menu                   |                  |
| `description`  | TEXT         | Optional description               |                  |
| `is_active`    | BOOLEAN      | Only one active per tenant         |                  |
| `created_at`   | TIMESTAMP    |                                    |                  |
| `updated_at`   | TIMESTAMP    |                                    |                  |

---

## 📁 `menu_categories`

| Column         | Type         | Description                        | Links To               |
|----------------|--------------|------------------------------------|------------------------|
| `id`           | INT (PK)     | Unique category ID                 |                        |
| `menu_id`      | INT          | Related menu                       | `menu_menus.id`        |
| `parent_id`    | INT (NULL)   | For nested categories              | `menu_categories.id`   |
| `name`         | VARCHAR(255) | Category name                      |                        |
| `description`  | TEXT         | Optional                           |                        |
| `sort_order`   | INT          | UI ordering                        |                        |
| `is_active`    | BOOLEAN      | Display toggle                     |                        |
| `created_at`   | TIMESTAMP    |                                    |                        |
| `updated_at`   | TIMESTAMP    |                                    |                        |

---

## 🍽️ `menu_items`

| Column             | Type            | Description                        | Links To               |
|--------------------|-----------------|------------------------------------|------------------------|
| `id`               | INT (PK)        | Unique item ID                     |                        |
| `menu_id`          | INT             | Menu it belongs to                 | `menu_menus.id`        |
| `category_id`      | INT             | Group/category                     | `menu_categories.id`   |
| `parent_id`        | INT (NULL)      | Nested menu items (optional)       | `menu_items.id`        |
| `name`             | VARCHAR(255)    | Item name                          |                        |
| `description`      | TEXT            | Item description                   |                        |
| `base_price`       | DECIMAL(8,2)    | Starting price                     |                        |
| `image_url`        | VARCHAR(500)    | URL of item photo                  |                        |
| `sort_order`       | INT             | Display order                      |                        |
| `is_available`     | BOOLEAN         | In stock toggle                    |                        |
| `available_from`   | TIME (NULL)     | Time-based availability            |                        |
| `available_to`     | TIME (NULL)     |                                    |                        |
| `available_days`   | VARCHAR(50)     | e.g., "Mon,Tue,Fri"                |                        |
| `visibility_rule`  | ENUM            | 'public', 'registered', 'staff'    |                        |
| `context_tags`     | TEXT            | e.g., ["mobile", "kiosk"]          |                        |
| `calories`         | INT             | Nutritional info                   |                        |
| `protein_grams`    | DECIMAL(5,2)    |                                    |                        |
| `fat_grams`        | DECIMAL(5,2)    |                                    |                        |
| `carbs_grams`      | DECIMAL(5,2)    |                                    |                        |
| `sugar_grams`      | DECIMAL(5,2)    |                                    |                        |
| `salt_grams`       | DECIMAL(5,2)    |                                    |                        |
| `tags`             | TEXT            | JSON or CSV tags                   |                        |
| `created_at`       | TIMESTAMP       |                                    |                        |
| `updated_at`       | TIMESTAMP       |                                    |                        |

---

## 🧾 `menu_item_variants`

| Column         | Type           | Description                | Links To         |
|----------------|----------------|----------------------------|------------------|
| `id`           | INT (PK)       |                            |                  |
| `item_id`      | INT            | Related menu item          | `menu_items.id`  |
| `name`         | VARCHAR(100)   | e.g., “Large”              |                  |
| `price_adjustment` | DECIMAL(8,2) | Added to base price        |                  |
| `is_default`   | BOOLEAN        | Default variant toggle      |                  |
| `created_at`   | TIMESTAMP      |                            |                  |

---

## ⚠️ `menu_allergens`

| Column        | Type         | Description                  |
|---------------|--------------|------------------------------|
| `id`          | INT (PK)     |                              |
| `name`        | VARCHAR(100) | "Milk", "Peanuts", etc.      |
| `description` | TEXT         |                              |
| `icon_url`    | VARCHAR(255) | Optional icon                |
| `created_at`  | TIMESTAMP    |                              |
| `updated_at`  | TIMESTAMP    |                              |

---

## ❗ `menu_item_allergens`

| Column       | Type      | Description            | Links To                 |
|--------------|-----------|------------------------|--------------------------|
| `item_id`    | INT       | Menu item              | `menu_items.id`          |
| `allergen_id`| INT       | Allergen               | `menu_allergens.id`      |

---

## ❗ `menu_history`

| Column            | Type          | Description               | Links To      |
|-------------------|---------------|---------------------------|---------------|
| `id`              | INT           | History Id                |               |
| `tenant_id`       | INT           | tenant_id                 |               |
| `action_type`     | ENUM          | updated or deleted        |               |
| `table_of_source` | VARCHAR(50)   | Table Name of history     |               |
| `old_value`       | TEXT          | Old values in Json form   |               |
| `action_by`       | INT           | User_id                   |  login_user   |
| `action_at`       | DATETIMR      | Current_TimeStamp         |               |