<?php
    function checkIfDeleted($inputData) {
        $table = $inputData['table'];
        $table = toSnakeCase($table);
        $id = $inputData['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT id FROM $table WHERE id = :id and is_deleted = 1");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($data) {
                        return ['status' => 'failed', 'message' => 'Record already deleted'];
            } else {
                return ['status' => 'success'];
            }
    }
    function getDataForHistory($inputData) {
        $table = $inputData['table'];
        $table = toSnakeCase($table);
        $id = $inputData['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT * FROM $table WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        // convert result to json with column names as keys
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        json_encode($data);
        if ($data) {
            return ['status' => 'success', 'historyData' => $data];
        } else {
            return ['status' => 'failed', 'message' => 'Record not found'];
        }
    }
    function viewContentMenus($inputData) {
        $roleId = $inputData['roleId'];
        // role is system admin,
        $viewType = $inputData['view'];

        if (!in_array($viewType, ['sysAdmin', 'owner', 'staff', 'guest'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }

        if ($viewType === 'sysAdmin') {
            $sql = "SELECT * FROM menu_menus WHERE tenant_id = :tenantId order by is_deleted, id desc";
        } elseif ($viewType === 'owner') {
            $sql = "SELECT `id`, `menu_name`, `menu_description`, is_active FROM menu_menus WHERE tenant_id = :tenantId AND is_deleted = 0 order by is_active, id desc";
        } else {
            $sql = "SELECT `menu_name`, `menu_description` FROM menu_menus WHERE tenant_id = :tenantId AND is_deleted = 0 and is_active = 1 order by is_deleted, id desc";
        }

        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':tenantId', $inputData['tenantId'], PDO::PARAM_INT);
        $stmt->execute();

        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
        if (!$rows || ($viewType === 'restricted' && $rows[0]['is_active'] !== 1)) {
            return ['status' => 'failed', 'message' => 'Menu not found'];
        }

        $menu = array_map(function($row) {
            return convertKeysToCamelCase(renameIdKeys($row, 'menuId'));
        }, $rows);

        if ($menu) {
            return ['status' => 'success', 'menuMenus' => $menu];
        } else {
            return ['status' => 'failed', 'message' => 'Record not found'];
        }
    }
    function checkDuplicateRecord($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $table = $inputData['table'] ?? null;
        $table = toSnakeCase($table);
        $dataKey = extractDataKeyFromTableName($inputData['table']);
        $data = $inputData[$dataKey] ?? [];

        if (!$table) {
            return ['status' => 'failed', 'message' => 'Table not specified'];
        }

        $map = menuTableColumnMapping($table, $inputData['roleId'] ?? 0);
        $columnMap = $map['filtered'] ?? null;

        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'Invalid table or insufficient permissions'];
        }

        // Define which fields make the record unique (you may want to pass this in $inputData)
        $uniqueFields = $inputData['uniqueFields'];
        $whereClauses = [];
        $params = [];

        foreach ($uniqueFields as $fieldKey) {
            $meta = $columnMap[$fieldKey] ?? null;
            $dbField = $meta['mapping'] ?? null;

            if (!$dbField || !isset($data[$fieldKey])) {
                return ['status' => 'failed', 'message' => "$fieldKey is required"];
            }

            $whereClauses[] = "$dbField = :$fieldKey";
            $params[$fieldKey] = $data[$fieldKey];
        }

        // Add soft delete clause
        $whereClauses[] = "is_deleted = 0";

        $whereSql = implode(' AND ', $whereClauses);
        $sql = "SELECT id FROM $table WHERE $whereSql";
        $stmt = $pdo->prepare($sql);
        foreach ($params as $key => $value) {
            $stmt->bindValue(":$key", $value);
        }
        $stmt->execute();
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($result) {
            return ['status' => 'failed', 'message' => 'Record already exists'];
        }

        return ['status' => 'success'];
    }  
    function getMenuView($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $viewType = $inputData['viewType'] ?? 'restricted'; // default to restricted view
        if (!in_array($viewType, ['sysAdmin', 'owner', 'restricted'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }
        $tenantId = "";
        if(isset($inputData['tenantId'])){
            $tenantId = $inputData['tenantId'];
        }
        if ($viewType === 'sysAdmin') {
            $sql = "SELECT * FROM menu_menus WHERE tenant_id = :tenantId order by is_deleted, id desc";
        } elseif ($viewType === 'owner') {
            $sql = "SELECT `id`, `menu_name`, `menu_description`, is_active FROM menu_menus WHERE tenant_id = :tenantId AND is_deleted = 0 order by is_active desc, id desc";
        } else {
            $sql = "SELECT `id`, `menu_name`, `menu_description`, is_active FROM menu_menus WHERE tenant_id = :tenantId AND is_deleted = 0 and is_active = 1 order by is_active desc, is_deleted asc, id desc";
        }
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':tenantId', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$rows || ($viewType === 'restricted' && $rows[0]['is_active'] !== 1)) {
            return ['status' => 'failed', 'message' => 'Menu not found'];
        }
        // if the viewType is restricted, we only return the active menus and remove the is_active column
      

        foreach ($rows as &$row) {
            // convert keys to camelCase and rename id to menuId
            $row = convertKeysToCamelCase(renameIdKeys($row, 'menuId'));
            $menuId = $row['menuId'];
            $inputData['menuId'] = $menuId;
            // fetch categories for this menu
            $cat = getMenuCategories($inputData);
            $row['categories'] = $cat['data'] ?? [];
            if ($cat['status'] === 'failed') {
                // if categories fetch failed, we still return the menu but with empty categories
                //$row['categories'] = [];
            }   
            if ($viewType === 'restricted') {
                unset($row['isActive']);
                unset($row['menuId']);
            } 
        }

        // loop through the rows for category and items
        
        //$menu = array_map(function($row) {
            //return convertKeysToCamelCase(renameIdKeys($row, 'menuId'));
        //}, $rows);

        $menu = $rows;

        if ($menu) {
            return ['status' => 'success', 'menuMenus' => $menu];
        } else {
            return ['status' => 'failed', 'message' => 'Record not found'];
        }
    }
    function getMenuCategories($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $menuId = $inputData['menuId'] ?? null;
        if (!$menuId) {
            return ['status' => 'failed', 'message' => 'Menu ID not specified'];
        }

        $viewType = $inputData['viewType'] ?? 'restricted';
        if (!in_array($viewType, ['sysAdmin', 'owner', 'restricted'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }

        // Define select columns and filters based on view type
        $columns = ($viewType === 'sysAdmin') ? '*' : 'id, category_name, category_description, is_active, parent_id';
        $conditions = 'menu_id = :menuId';
        if ($viewType === 'owner') {
            $conditions .= ' AND is_deleted = 0';
        } elseif ($viewType === 'restricted') {
            $conditions .= ' AND is_deleted = 0 AND is_active = 1';
        }

        // Fetch all relevant categories
        $sql = "SELECT $columns FROM menu_categories WHERE $conditions ORDER BY id ASC, parent_id ASC";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':menuId', $menuId, PDO::PARAM_INT);
        $stmt->execute();
        $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (!$categories) {
            return ['status' => 'failed', 'message' => 'Categories not found'];
        }

        // Group categories by parent_id
        $tree = [];
        $map = [];

        foreach ($categories as &$cat) {
            $catId = $cat['id'];
            $parentId = $cat['parent_id'] ?? 0;

            // Optional: Remove 'is_active' from restricted view
            if ($viewType === 'restricted') {
                unset($cat['is_active']);
                unset($cat['id']);
                unset($cat['parent_id']);
            }

            $map[$catId] = &$cat;

            $inputData['categoryId'] = $catId;

            $items = getMenuCategoryItems($inputData);
            if ($items['status'] === 'success') {
                $cat['items'] = $items['data'];
            }

            if (empty($parentId) || !isset($map[$parentId])) {
                $tree[] = &$cat;
            } else {
                $map[$parentId]['subCategories'][] = &$cat;
            }

        }

        $tree = array_map(function($tree) {
            return convertKeysToCamelCase(renameIdKeys($tree, 'categoryId'));
        }, $tree);

        return ['status' => 'success', 'data' => $tree];
    }
    function getMenuCategoryItems($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $categoryId = $inputData['categoryId'] ?? null;
        if (!$categoryId) {
            return ['status' => 'failed', 'message' => 'Category ID not specified'];
        }
        $viewType = $inputData['viewType'] ?? 'restricted';
        if (!in_array($viewType, ['sysAdmin', 'owner', 'restricted'])) {
            return ['status' => 'failed', 'message' => 'Invalid view type'];
        }
        // Define select columns and filters based on view type

        if ($viewType === 'sysAdmin') {
            $columns = "mi.*, mci.id as category_item_id, mci.is_active as category_item_is_active, mci.is_deleted as category_item_is_deleted";
        } elseif ($viewType === 'owner') {
            $columns = "mi.id as id, mi.item_name as item_name, mi.item_description as item_description, mi.is_active as is_active, mi.base_price as base_price";
        } else {
            $columns = "mi.id as id, mi.item_name as item_name, mi.item_description as item_description, mi.is_active as is_active, mi.base_price as base_price";
        }

        
        $conditions = 'category_id = :categoryId';
        if ($viewType === 'owner') {
            $conditions .= ' AND mi.is_deleted = 0 and mci.is_deleted = 0';
        } elseif ($viewType === 'restricted') {
            $conditions .= ' AND mi.is_deleted = 0 AND mi.is_active = 1 and mci.is_active = 1 and mci.is_deleted = 0';
        }
        // Fetch all relevant items
        $sql = "SELECT $columns FROM menu_items mi left join menu_category_items mci on mi.id = mci.item_id WHERE $conditions ORDER BY mi.is_active desc, mci.is_active desc, mi.is_deleted, mci.is_deleted,  mi.id ASC";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':categoryId', $categoryId, PDO::PARAM_INT);
        $stmt->execute();
        $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$items) {
            return ['status' => 'failed', 'message' => 'Items not found'];
        }
        // Optional: Remove 'is_active' from restricted view
        if ($viewType === 'restricted') {
            foreach ($items as &$item) {
                unset($item['is_active']);
            }
        }
        // Convert keys to camelCase and rename id to itemId
        $items = array_map(function($item) {
            return convertKeysToCamelCase(renameIdKeys($item, 'itemId'));
        }, $items);
        return ['status' => 'success', 'data' => $items];
    }   
?>