<?php
    namespace Azui\Orbit\Login;

    function updateValidateEmail($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];

        if($inputData['noPasswordFlag'] == 1){
            $stmt = $db->prepare("update user_login set fk_user_status_id = 2, one_time_code = null, user_password = :pass  where user_email = :email and one_time_code = :otc and fk_user_status_id = 1 and user_password = 'noPassword'");
            $stmt->bindParam(':pass', $inputData['passwordHash']);
        }else{
            $stmt = $db->prepare("update user_login set fk_user_status_id = 2, one_time_code = null  where user_email = :email and one_time_code = :otc and fk_user_status_id = 1 and user_password <> 'noPassword'");
        }

        $stmt->bindParam(':email', $inputData['email']);
        $stmt->bindParam(':otc', $inputData['otc']);
        $stmt->execute();
        if ($stmt->rowCount() > 0){
            $result['message'] = "Email has been validated";
            $result['status']  = 'success';
            return $result;
        }else{
            $result['status']  = 'failed';
            $result['message'] =  'Email failed to be validated';
            return $result;
        }
    }
    function updateForGotPassPart1($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("update user_login set fk_user_status_id = 4, one_time_code = :otc  where user_email = :email");
        $stmt->bindParam(':email', $inputData['email']);
        $stmt->bindParam(':otc', $inputData['oneTimeCode']);
        $stmt->execute();
        if ($stmt->rowCount() > 0){
            $result['message'] = "Password marked for reset, Please check your email";
            $result['status']  = 'success';
            return $result;
        }else{
            $result['status']  = 'failed';
            $result['message'] =  'Email failed to be validated';
            return $result;
        }
    }
    function updateForGotPassPart2($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("update user_login set fk_user_status_id = 2, one_time_code = null, user_password = :pass  where user_email = :email and one_time_code = :otc and fk_user_status_id = 4");
        $stmt->bindParam(':email',  $inputData['email']);
        $stmt->bindParam(':otc',    $inputData['otc']);
        $stmt->bindParam(':pass',   $inputData['passwordHash']);
        $stmt->execute();
        if ($stmt->rowCount() > 0){
            $result['message'] = "Password reset";
            $result['status']  = 'success';
            return $result;
        }else{
            $result['status']  = 'failed';
            $result['message'] =  'Email failed to be validated';
            return $result;
        }
    }
    function updatePassword($inputData) {
        try {
            $pdo = $inputData['db']['dbLogin'];
            $pdo->setAttribute(\PDO::ATTR_ERRMODE, \PDO::ERRMODE_EXCEPTION);
    
            $userID = $_SESSION['id']; // Assuming session is active
            $passwordHash = $inputData['passwordHash'];
    
            $stmt = $pdo->prepare("
                UPDATE user_login 
                SET user_password = :pass 
                WHERE pk_user_id = :userID
            ");
            $stmt->bindParam(':userID', $userID);
            $stmt->bindParam(':pass', $passwordHash);
            $stmt->execute();
    
            if ($stmt->rowCount() > 0) {
                return ['status' => 'success', 'message' => 'Password Updated'];
            } else {
                return ['status' => 'failed', 'message' => 'Password not updated'];
            }
    
        } catch (\PDOException $e) {
            if (isset($inputData['debug']) && $inputData['debug'] === 'CSD') {
                echo "Error: " . $e->getMessage();
            }
            return ['status' => 'error', 'message' => $e->getMessage()];
        }
    }
?>