<?php
    ini_set('error_log', 'php://stderr');
    error_log("Something went wrong");
    use PHPUnit\Framework\TestCase;
    
    //require_once __DIR__ . '/../../core/unit-test/scripts/bootstrap.php'; // ✅ Use shared mock DB
    //require_once __DIR__ . '/../src/function.php';
    echo "\n>>>>>>>>>>>>>>>>>>>>>>>>>====<<<<<<<<<<<<<<<<<<<<<<<<<\n";
    echo "\nT05_LoginTest.php\n";
    // Print list of table that exist in the database
    //$tables = $GLOBALS['mockPdo']->query("SELECT name FROM sqlite_master WHERE type='table';")->fetchAll(\PDO::FETCH_COLUMN);
    //echo("\n🔍 Tables: " . implode(', ', $tables). "\n");  
    class T05_LoginTest extends TestCase
    {
        private $mockPdo;
        private static $lastModified;
    protected function setUp(): void
    {
        // ✅ Use the shared mock database connection
        $_SESSION = [];
        $_GET = [];
        $_POST = [];
        $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
        $_SERVER['HTTP_REFERER'] = 'http://localhost/test';
        unset($_SERVER['HTTP_HOST']);
        $this->mockPdo = $GLOBALS['mockPdo'];
        if (session_status() !== PHP_SESSION_ACTIVE) {
            if (session_status() !== PHP_SESSION_ACTIVE && !headers_sent()) {
                session_start();
            }
        }
    }
    private function executeFunctionPhp(): array {
        ob_start();
        // Flexible path resolution for module function.php
        if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php')) {
            require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php';
        } else {
            require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'function.php';
        }
        $output = ob_get_clean();
        // ✅ Ensure only valid JSON output
        $decodedOutput = json_decode($output, true);
        if (json_last_error() !== JSON_ERROR_NONE) {
            throw new Exception("Invalid JSON output: " . json_last_error_msg() . "\nOutput: " . $output);
        }
        return [$output, $decodedOutput];
    }
    
    public function test001DummyTest(): void
    {
        $this->assertTrue(true);
    }
    // no action
    /*
    public function test002NoAction(): void{
        $this->assertEquals(0, count($_SESSION));
        $_POST = [
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('No Action Found', $decodedOutput['message']);
    }
    */
    // invalid action
    public function test003InvalidAction(): void{
        $this->assertEquals(0, count($_SESSION));
        $_POST = [
            'action' => 'invalid',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp(); 
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput, true);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Invalid Action', $decodedOutput['message']);
    }
    // checkEmailT
    public function test004CheckEmailMissingEmail(): void{
        $this->assertEquals(0, count($_SESSION));
        $_POST = [
            'action' => 'checkEmail',
            'email' => ''
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Invalid email address.', $decodedOutput['message']);
    }
    public function test005CheckEmailNoEmail(): void{
        $this->assertEquals(0, count($_SESSION));
        $_POST = [
            'action' => 'checkEmail',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Invalid email address.', $decodedOutput['message']);
    }
    public function test006CheckEmailInvalid(): void{
        $_POST = [
            'action' => 'checkEmail',
            'email' => 'test@test.com',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        // 0 means email found
        $this->assertEquals(0, $decodedOutput['email']);
    }
    public function test007CheckEmailValid(): void{
        $_POST = [
            'action' => 'checkEmail',
            'email' => 'test00@test.com'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals(1, $decodedOutput['email']);
        $this->assertEquals('Email Already Exists', $decodedOutput['message']);
    }
    // addUser
    public function test008AddUserMissingEmail(): void{
        $this->assertEquals(0, count($_SESSION));
        $_POST = [
            'action' => 'addUser',
            'email' => '',
            'password' => 'xxxxxxxx',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Invalid or missing Inputs.', $decodedOutput['message']);
    }
    public function test009AddUserMissingPassword(): void{
        $_POST = [
            'action' => 'addUser',
            'email' => 'test@test.com',
            'password' => '',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
         //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Invalid or missing Inputs.', $decodedOutput['message']);
    }
    public function test010AddUserMissingAttributes(): void{
        $_POST = [
            'action' => 'addUser',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Invalid or missing Inputs.', $decodedOutput['message']);
    }
    public function test011AddNewUser(){
        $_POST = [
            'action' => 'addUser',
            'email' => 'test05@test.co.uk',
            'password' => 'xxxxxxxx',
            'firstName' => 'test',
            'lastName' => 'test',
            'phoneNumber' => '00123456789',
            'debug' => 'csd'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Account created successfully. Please check your email to verify your account.', $decodedOutput['message']);
    }
    public function test012AddNewUserDuplicate(){
        $_POST = [
            'action' => 'addUser',
            'email' => 'test05@test.co.uk',
            'password' => 'xxxxxxxx',
            'firstName' => 'test',
            'lastName' => 'test',
            'phoneNumber' => '00123456789',
            'debug' => 'csd'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Email Already Exists', $decodedOutput['message']);
    }
    public function test013AddNewUserAndValidate(){
        $_POST = [
            'action' => 'addUser',
            'email' => 'test06@test.co.uk',
            'password' => 'xxxxxxxx',
            'firstName' => 'test',
            'lastName' => 'test',
            'phoneNumber' => '00123456789',
            'debug' => 'csd'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Account created successfully. Please check your email to verify your account.', $decodedOutput['message']);
    
        $_POST = [];

        $_POST = [
            'action' => 'validNewUser',
            'email' => 'test06@test.co.uk',
            'otc' => $decodedOutput['oneTimeCode'],
            'debug' => 'csd'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);

        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Email has been validated', $decodedOutput['message']);

    }
    public function test014AddNewUserAndValidateAndRevalidate(){
        $_POST = [
            'action' => 'addUser',
            'email' => 'test07@test.co.uk',
            'password' => 'xxxxxxxx',
            'firstName' => 'test',
            'lastName' => 'test',
            'phoneNumber' => '00123456789',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Account created successfully. Please check your email to verify your account.', $decodedOutput['message']);
        $otc = $decodedOutput['oneTimeCode'];
        $_POST = [];
        $_POST = [
            'action' => 'validNewUser',
            'email' => 'test07@test.co.uk',
            'otc' => $otc,
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Email has been validated', $decodedOutput['message']);
        $_POST = [];
        $_POST = [
            'action' => 'validNewUser',
            'email' => 'test07@test.co.uk',
            'otc' => $otc,
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Email allready validated', $decodedOutput['message']);

    }
    public function test015AddNewUserThenLoginAndThenValidate(){
        $_POST = [
            'action' => 'addUser',
            'email' => 'test08@test.co.uk',
            'password' => 'xxxxxxxx',
            'firstName' => 'test',
            'lastName' => 'test',
            'phoneNumber' => '00123456789',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Account created successfully. Please check your email to verify your account.', $decodedOutput['message']);
        $otc = $decodedOutput['oneTimeCode'];
        
        // Test login
        $_POST = [];
        $_POST = [
            'action'    =>  'login',
            'email'     =>  'test08@test.co.uk',
            'password'  =>  'xxxxxxxx',
            'debug'     =>  'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Please validate your email', $decodedOutput['message']);
        
        // Validate email
        $_POST = [];
        $_POST = [
            'action'    => 'validNewUser',
            'email'     => 'test08@test.co.uk',
            'otc'       => $otc,
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Email has been validated', $decodedOutput['message']);
        
    }
    public function test016LoginUnkownAccount(){
        $_POST = [
            'action'    => 'login',
            'email'     => 'test09@test.com',
            'password'  => 'xxxxxxXx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Email or Password incorrect', $decodedOutput['message']);
    }
    public function test017LoginIncorrectPassword(){
        $_POST = [
            'action'    => 'login',
            'email'     => 'test07@test.com',
            'password'  => 'xxxxxxx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Email or Password incorrect', $decodedOutput['message']);
    }
    public function test018LoginNeedValidation(){
        $_POST = [
            'action'    => 'login',
            'email' => 'test01@test.com',
            'password' => 'xxxxxxxx',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Please validate your email', $decodedOutput['message']);
    }
    public function test019LoginType3(){
        $_POST = [
            'action'    => 'login',
            'email'     => 'test02@test.com',
            'password'  => 'xxxxxxxx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Account Locked', $decodedOutput['message']);
    }
    public function test020LoginType4(){
        $_POST = [
            'action'    => 'login',
            'email'     => 'test03@test.com',
            'password'  => 'xxxxxxxx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Email or Password incorrect', $decodedOutput['message']);
    }
    public function test021SuccessLogin(){
        $_SERVER['HTTP_HOST'] = 'admin.waitron.uk';
        $_POST = [
            'action'    => 'login',
            'email'     => 'test00@test.com',
            'password'  => 'xxxxxxxx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals(1, $decodedOutput['role']);

    }
    public function test022SuccessLoginRole5(){
        $_SERVER['HTTP_HOST'] = 'admin.waitron.uk';
        $_POST = [
            'action'    => 'login',
            'email'     => 'test04@test.com',
            'password'  => 'xxxxxxxx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals(5, $decodedOutput['role']);

    }
    public function test023LogOut(){
        $_POST = [
            'action'    => 'logout',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test024CheckLiveNoLogin(){
        $_POST = [
            'action'    => 'checkLive',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test025CheckLiveWithLogin(){
        $_SERVER['HTTP_HOST'] = 'admin.waitron.uk';
        $_POST = [
            'action'    => 'login',
            'email'     => 'test00@test.com',
            'password'  => 'xxxxxxxx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals(1, $decodedOutput['role']);

        $_POST = [];

        $_POST = [
            'action'    => 'checkLive',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);

        $_POST = [];
        $_POST = [
            'action'    => 'logout',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test026PasswordResetMissingEmail(){
        $_POST = [
            'action'    => 'setupPasswordReset',
            'email'     => '',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Email failed to be validated', $decodedOutput['message']);
    }   
    public function test027PasswordResetWithEmail(){
        $_POST = [
            'action'    => 'setupPasswordReset',
            'email'     => 'test04@test.com',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Password marked for reset, Please check your email', $decodedOutput['message']);
        $this->assertArrayHasKey('oneTimeCode', $decodedOutput);
    }   
    public function test028PasswordResetWithEmailDuplicate(){
        $_POST = [
            'action'    => 'setupPasswordReset',
            'email'     => 'test04@test.com',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Password marked for reset, Please check your email', $decodedOutput['message']);
        $this->assertArrayHasKey('oneTimeCode', $decodedOutput);
    }
    public function test029PasswordResetWithEmailAndInccorectOneTimeCode(){
        $_POST = [
            'action'    => 'setupPasswordReset',
            'email'     => 'test04@test.com',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Password marked for reset, Please check your email', $decodedOutput['message']);
        $this->assertArrayHasKey('oneTimeCode', $decodedOutput);
        $otc = $decodedOutput['oneTimeCode'];

        $_POST = [];

        $_POST = [
            'action'    => 'passwordResetRequest',
            'email'     => 'test04@test.com',
            'password'  => 'ZZZZZZZZZZZZ',
            'otc'       => '123456',
            'debug'     => 'csd'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Email failed to be validated', $decodedOutput['message']);

    }
    public function test030PasswordResetWithIncorrectEmailAndCorrectOneTimeCode(){
        $_POST = [
            'action'    => 'setupPasswordReset',
            'email'     => 'test04@test.com',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Password marked for reset, Please check your email', $decodedOutput['message']);
        $this->assertArrayHasKey('oneTimeCode', $decodedOutput);
        $otc = $decodedOutput['oneTimeCode'];

        $_POST = [];

        $_POST = [
            'action'    => 'passwordResetRequest',
            'email'     => 'test05@test.com',
            'password'  => 'ZZZZZZZZZZZZ',
            'otc'       =>  $otc,
            'debug'     => 'csd'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Email failed to be validated', $decodedOutput['message']);
        
    }
    public function test031PasswordResetWithEmailOneTimeCode(){
        $_POST = [
            'action'    => 'setupPasswordReset',
            'email'     => 'test04@test.com',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Password marked for reset, Please check your email', $decodedOutput['message']);
        $this->assertArrayHasKey('oneTimeCode', $decodedOutput);
        $otc = $decodedOutput['oneTimeCode'];

        $_POST = [];

        $_POST = [
            'action'    => 'passwordResetRequest',
            'email'     => 'test04@test.com',
            'password'  => 'ZZZZZZZZZZZZ',
            'otc'       =>  $otc,
            'debug'     => 'csd'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Password reset', $decodedOutput['message']);
    }
    public function test032LoginWithNewPassword(){
        $_SERVER['HTTP_HOST'] = 'admin.waitron.uk';
        $_POST = [
            'action'    => 'login',
            'email'     => 'test04@test.com',
            'password'  => 'ZZZZZZZZZZZZ',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals(5, $decodedOutput['role']);

    }  
    public function test033UpdatePassWrongSessionId(){
        $_SESSION['id'] = 0;
        $_POST = [
            'action'    => 'updatePass',
            'email'     => '',
            'oldPassword' => 'ZZZZZZZZZZZZ',
            'password'  => 'xxxxxxxx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test034UpdatePass(){
        $_SESSION['id'] = 5;
        $_POST = [
            'action'    => 'updatePass',
            'oldPassword' => 'ZZZZZZZZZZZZ',
            'password'  => 'xxxxxxxx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Password Updated', $decodedOutput['message']);
    }
    public function test035UpdatePassWrongOldPassword(){
        $_SESSION['id'] = 5;
        $_POST = [
            'action'    => 'updatePass',
            'oldPassword' => 'ZZZZZZZZZZZZ',
            'password'  => 'xxxxxxxx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Old password incorrect', $decodedOutput['message']);
    }
    public function test036UpdatePassMissingOldPassword(){
        $_SESSION['id'] = 5;
        $_POST = [
            'action'    => 'updatePass',
            'oldPassword' => '',
            'password'  => 'xxxxxxxx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Old password incorrect', $decodedOutput['message']);
    }
    public function test037UpdatePassMissingNewPassword(){
        $_SESSION['id'] = 5;
        $_POST = [
            'action'    => 'updatePass',
            'oldPassword' => 'ZZZZZZZZZZZZ',
            'password'  => '',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Password not set', $decodedOutput['message']);
    }
    public function test038UpdatePassMissingAttributeNewPassword(){
        $_SESSION['id'] = 5;
        $_POST = [
            'action'    => 'updatePass',
            'oldPassword' => 'ZZZZZZZZZZZZ',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Password not set', $decodedOutput['message']);
    }
    public function test039UpdatePassMissingAttributeNewLenghToShort(){
        $_SESSION['id'] = 5;
        $_POST = [
            'action'    => 'updatePass',
            'oldPassword' => 'ZZZZZZZZZZZZ',
            'password'  => 'xxxxx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Password must be at least 8 characters', $decodedOutput['message']);
    }
    public function test040UpdatePassOldAndNewMustNotMatch(){
        $_SESSION['id'] = 5;
        $_POST = [
            'action'    => 'updatePass',
            'oldPassword' => 'xxxxxxxx',
            'password'  => 'xxxxxxxx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Password must be different from the old password', $decodedOutput['message']);
    }
    public function test041LookUpUser(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 2;
        $_POST = [
            'action'        => 'lookupUser',
            'lookupUserId'  => 1,
            'debug'         => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals(1, $decodedOutput['lookup']['userId']);
        $this->assertEquals('test00@test.com', $decodedOutput['lookup']['email']);
        $this->assertEquals('', $decodedOutput['lookup']['fName']);
        $this->assertEquals('', $decodedOutput['lookup']['lName']);
        $this->assertEquals('00000000000', $decodedOutput['lookup']['phoneNumber']);
    }
    public function test042InsertNewSystemToTenant(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 2;
        $_POST = [
            'action'            => 'setUpNewSystem',
            'systemName'        => 'testSystem',
            'tenantBaseUrl'     => 'testBaseUrl',
            'systemDescription' => 'testDescription',
            'debug'             => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test043InsertSetUserToSystem(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 2;
        $_POST = [
            'action'            => 'setUserToSystem',
            'systemName'        => 'testSystem',
            'registerUser'      => 8,
            'requestedRoleId'   => '5',
            'debug'             => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test044InsertSetUserToSystemDuplicated(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 2;
        $_POST = [
            'action'            => 'setUserToSystem',
            'systemName'        => 'testSystem',
            'registerUser'      => 8,
            'requestedRoleId'   => '5',
            'debug'             => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('User already has permissions for this system', $decodedOutput['message']);
    }
    public function test045GetRoleListAviable1(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action'    => 'getAvailableRoles',
            'debug'     => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedRoles = [
            'roles' => [
                ['roleId' => 1, 'roleName' => 'SystemAdmin'],
                ['roleId' => 2, 'roleName' => 'SupportAgent'],
                ['roleId' => 3, 'roleName' => 'ContentModerator'],
                ['roleId' => 4, 'roleName' => 'BusinessOwner'],
                ['roleId' => 5, 'roleName' => 'BusinessManager'],
                ['roleId' => 6, 'roleName' => 'Staff'],
                ['roleId' => 7, 'roleName' => 'Operator'],
                ['roleId' => 8, 'roleName' => 'Customer'],
            ],
            'status' => 'success',
            'action' => 'getAvailableRoles'
        ];
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals($expectedRoles, $decodedOutput);
    }
    public function test046GetRoleListAviable2(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 2;
        $_POST = [
            'action'    => 'getAvailableRoles',
            'debug'     => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedRoles = [
            'roles' => [
                ['roleId' => 4, 'roleName' => 'BusinessOwner'],
                ['roleId' => 5, 'roleName' => 'BusinessManager'],
                ['roleId' => 6, 'roleName' => 'Staff'],
                ['roleId' => 7, 'roleName' => 'Operator'],
                ['roleId' => 8, 'roleName' => 'Customer'],
            ],
            'status' => 'success',
            'action' => 'getAvailableRoles'
        ];
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals($expectedRoles, $decodedOutput);
    }
    public function test047GetRoleListAviableRole4(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 4;
        $_POST = [
            'action'    => 'getAvailableRoles',
            'debug'     => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        $expectedRoles = [
            'roles' =>[
                ['roleId' => 5, 'roleName' => 'BusinessManager'],
                ['roleId' => 6, 'roleName' => 'Staff'],
                ['roleId' => 7, 'roleName' => 'Operator'],
                ['roleId' => 8, 'roleName' => 'Customer'],
            ],
            'status' => 'success',
            'action' => 'getAvailableRoles'
        ];
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals($expectedRoles, $decodedOutput);
    }
    public function test048GetRoleListAviableRole0(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 0;
        $_POST = [
            'action'    => 'getAvailableRoles',
            'debug'     => 'CSD'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test049AddNewUserWithRole(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 2;
        
        $_POST = [
            'action' => 'addUserWithRole',
            'email' => 'test10@test.co.uk',
            'firstName' => 'test',
            'lastName' => 'test',
            'phoneNumber' => '00123456789',
            'requestedRoleId' => 4,
            'debug' => 'csd'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Account created successfully. Please check your email to verify your account.', $decodedOutput[0]['message']);
    }
    public function test050AddNewUserWithRoleNoRole(){
        $_SESSION['id'] = 5;
        $_SESSION['tenantId'] = 2;
        
        $_POST = [
            'action' => 'addUserWithRole',
            'email' => 'test10@test.co.uk',
            'firstName' => 'test',
            'lastName' => 'test',
            'phoneNumber' => '00123456789',
            'requestedRoleId' => 4,
            'debug' => 'csd'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test051AddNewUserWithRoleWithValidation(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 2;
        
        $_POST = [
            'action' => 'addUserWithRole',
            'email' => 'test11@test.co.uk',
            'firstName' => 'test',
            'lastName' => 'test',
            'phoneNumber' => '00123456789',
            'requestedRoleId' => 4,
            'debug' => 'csd'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
        $this->assertEquals('Account created successfully. Please check your email to verify your account.', $decodedOutput[0]['message']);


        // Try to login with the new user
        unset($_SESSION['id']);
        unset($_SESSION['roleValue']);
        unset($_SESSION['tenantId']);

        $otc = $decodedOutput[0]['oneTimeCode'];
        
        $_POST = [];
        $_POST = [
            'action'    =>  'login',
            'email'     =>  'test11@test.co.uk',
            'password'  =>  'xxxxxxxx',
            'debug'     =>  'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Please validate your email', $decodedOutput['message']);

        // Validate email using old method missing password
        $_POST = [];
        $_POST = [
            'action'    => 'validNewUserWithPass',
            'email'     => 'test11@test.co.uk',
            'otc'       => $otc,
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Invalid or missing Inputs.', $decodedOutput['message']);
        
        // Validate email using new method with password
        $_POST = [];
        $_POST = [
            'action'    => 'validNewUserWithPass',
            'email'     => 'test11@test.co.uk',
            'otc'       => $otc,
            'password'  => 'xxxxxxxx',
            'debug'     => 'csd'
        ];

        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test052SearchUserByEmail(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 2;
        
        $_POST = [
            'action' => 'searchUserWithEmail',
            'email' => 'test10@test.co.uk'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test053SearchUserByEmailNoRole(){
        $_SESSION['id'] = 5;
        $_SESSION['tenantId'] = 2;
        
        $_POST = [
            'action' => 'searchUserWithEmail',
            'email' => 'test10@test.co.uk'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test054SearchUserByEmailNoRoleNoTenant(){
        $_SESSION['id'] = 5;
        
        $_POST = [
            'action' => 'searchUserWithEmail',
            'email' => 'test10@test.co.uk'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test055SearchUserByEmailNoTenant(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 1;
        
        $_POST = [
            'action' => 'searchUserWithEmail',
            'email' => 'test10@test.co.uk'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test056SearchUserByEmailBadRole(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 6;
        
        $_POST = [
            'action' => 'searchUserWithEmail',
            'email' => 'test12@test.co.uk'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test057SearchUserByEmailBadEmail(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 1;
        
        $_POST = [
            'action' => 'searchUserWithEmail',
            'email' => 'test12@test.co.uk'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('User not found', $decodedOutput['message']);
    }     
    public function test058ViewTenantUsersNoRole(){
        $_SESSION['id'] = 5;
        $_POST = [
            'action' => 'viewTenantUsers',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);

    }
    public function test059ViewTenantUsersNoTenant(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'viewTenantUsers',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Invalid or missing Inputs.', $decodedOutput['message']);
    }
    public function test060ViewTenantUsers(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 1;
        $_SESSION['tenantId'] = 2;
        $_POST = [
            'action' => 'viewTenantUsers',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    // insert a superadmin user
    public function test061InsertSuperAdminUser(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 1;
        
        $_POST = [
            'action' => 'newSuperAdmin',
            'email' => 'superadmin@test.co.uk',
            'firstName' => 'super',
            'lastName' => 'admin',
            'phoneNumber' => '00123456789',
            'password' => 'SuperAdmin123!',
            'requestedRoleId' => '2',
            'debug' => 'csd'
        ];
         list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);

    }
    // insert a superadmin user
    public function test062InsertSuperAdminUserRoleValueFour(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 4;
        
        $_POST = [
            'action' => 'newSuperAdmin',
            'email' => 'superadmin@test.co.uk',
            'firstName' => 'super',
            'lastName' => 'admin',
            'phoneNumber' => '00123456789',
            'password' => 'SuperAdmin123!',
            'requestedRoleId' => '2',
            'debug' => 'csd'
        ];
         list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test063InsertSuperAdminUserRoleValueThreeNewRoleTwo(){
        // clear session 
        session_unset();
        $_SESSION['id'] = 7;
        $_SESSION['roleValue'] = 3;
        
        $_POST = [
            'action' => 'newSuperAdmin',
            'email' => 'superadmin+0@test.co.uk',
            'firstName' => 'super',
            'lastName' => 'admin',
            'phoneNumber' => '00123456789',
            'password' => 'SuperAdmin123!',
            'requestedRoleId' => '2',
            'debug' => 'csd'
        ];
         list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
    }
    public function test064InsertSuperAdminUserRoleValueTwoNewRoleTwo(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 2;
        
        $_POST = [
            'action' => 'newSuperAdmin',
            'email' => 'superadmin+1@test.co.uk',
            'firstName' => 'super',
            'lastName' => 'admin',
            'phoneNumber' => '00123456789',
            'password' => 'SuperAdmin123!',
            'requestedRoleId' => '2',
            'debug' => 'csd'
        ];
         list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test065ViewSuperAdminListNoRole(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 4;
        $_POST = [
            'action' => 'viewSysAdmins',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('failed', $decodedOutput['status']);
        $this->assertEquals('Access denied: insufficient permissions', $decodedOutput['message']);
    }
    public function test066ViewSuperAdminList(){
        $_SESSION['id'] = 5;
        $_SESSION['roleValue'] = 1;
        $_POST = [
            'action' => 'viewSysAdmins',
            'debug' => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['status']);
    }
    public function test067SuccesspublicLogin(){
        $_SERVER['HTTP_HOST'] = 'admin.waitron.uk';
        $_POST = [
            'action'    => 'publicLogin',
            'email'     => 'test00@test.com',
            'password'  => 'xxxxxxxx',
            'debug'     => 'csd'
        ];
        list($output, $decodedOutput) = $this->executeFunctionPhp();
        $decodedOutput = json_decode($output, true);
        //echo print_r($decodedOutput);
        $this->assertEquals('success', $decodedOutput['publicLogin']['status']);
        $this->assertEquals(0, $decodedOutput['publicLogin']['role']);
        $this->assertEquals('test00@test.com', $decodedOutput['userDetails']['userEmail']);
        $this->assertEquals('00000000000', $decodedOutput['userDetails']['phoneNumber']);


    }
}

?>