<?php
    function logMeIn($inputData){
        $res['emailCheck']  = emailCheck($inputData);
        $_SESSION['id'] = 0;
        $results['status']  = 'failed';
        $inputData['status'] = 'failed';
        $inputData['message'] = 'Login Failed - Email not found';
        $inputData['userId'] = 0;
        if($res['emailCheck']['UserExists']   != 'failed' && $res['emailCheck']['UserExists'] > 0 &&  $res['emailCheck']['userStatus'] == 2){
            $int['pass']            =  getPassword($inputData);
            if(password_verify($inputData['password'], $int['pass']) === true){
                $_SESSION['id'] = $res['emailCheck']['UserExists'];
                $results['status']  = 'success';
                $out = getSysyemIdFromDomain($inputData);
                if($out['status'] == 'success'){
                    $inputData['systemId'] = $out['systemId'];
                    //$results['systemId'] = $out['systemId'];    // For Error testing
                }
                userType($inputData);
                if($_SESSION['roleValue'] == 0){
                   checkIfAdmin($inputData);
                }
                $results['role'] = $_SESSION['roleValue'];


                if($results['role'] == 0){
                    $host = $_SERVER['HTTP_HOST'] ?? '';
                    // Optional: Normalize to lowercase for consistent checks
                    $host = strtolower($host);

                    // Check if 'admin.' appears anywhere in the domain (e.g., dev.admin.abc.com)
                    if (stripos($host, 'admin.') !== false) {
                        $inputData['message'] = "Access Denied";
                        $results['message'] = "Access Denied";
                        $results['status'] = 'failed';
                        killSessions();
                    }
                }

                $inputData['userId'] = $_SESSION['id'];
                $inputData['status'] = 'success';
                $inputData['message'] = 'Login Success';
                
                $loginType = $inputData['loginType'] ?? 'standard';
                if($loginType == 'public'){
                    $results['message'] = "Public Login Success";
                    $results['role'] = 0;
                    $_SESSION['roleValue'] = 0;
                }
            }else{
                $inputData['message'] = "password incorrect";
                $results['message'] = "Email or Password incorrect";
            }
        }else{
            $inputData['message'] = "User checks failed";
            $results['message'] = "Email or Password incorrect";
        }
        
        if(isset($res['emailCheck']['userStatus'])){
            if($res['emailCheck']['userStatus'] == 1){
                $results['message'] = "Please validate your email";
                $inputData['message'] = "Please validate your email";
                
            }
        
            if($res['emailCheck']['userStatus'] == 3){
                $results['message'] = "Account Locked";
                $inputData['message'] = "Account Locked";
            }
        }
    
        logOfLogin($inputData);
        return $results;
    }
    function passwordHashing($passwordIn){
        return  password_hash($passwordIn, PASSWORD_DEFAULT);
    }
    function oneTimeCode(){
        return random_int(100000, 999999);
    }
    function emailCheckSanatize($inputData){
        $int['emailCheck']  =  emailCheck($inputData);
        if($int['emailCheck']['UserExists']   != 'failed' && $int['emailCheck']['UserExists'] > 0){
            $res['message']     =   'Email Already Exists';
            $res['email']       =   '1';
            $res['status']     = 'failed';
        }else{
            $res['email']       =   '0';
            $res['status']     = 'success';
        }
        return $res;
    }
    function newUser($inputData){  
        $emailCheck = emailCheckSanatize($inputData);
        if($emailCheck['email'] == 0){
            if($inputData['noPasswordFlag'] == 0){
                $inputData['passwordHash'] = passwordHashing($inputData['password']);
            }
            $inputData['oneTimeCode']  = oneTimeCode();
            $res = addnewuser($inputData);
            if($res['status'] == 'success'){
                if(defined('TEST_ENV')){
                    $res['oneTimeCode'] = $inputData['oneTimeCode'];
                    $res['status'] = 'success';
                }else{
                    validationEmail($inputData);
                }
            }
        }else{
            $res = $emailCheck;
        }

        return $res;
    }
    function validationEmail($inputData) {
        // Handle preflight request
        if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
            header("Access-Control-Allow-Origin: *");
            header("Access-Control-Allow-Methods: POST");
            header("Access-Control-Allow-Headers: content-type");
            exit;
        }

        // Only allow POST requests
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            header("Allow: POST", true, 405);
            exit;
        }

        $email = filter_var($inputData['email'], FILTER_VALIDATE_EMAIL);
        header("Access-Control-Allow-Origin: *");

        if (!$email) {
            http_response_code(400);
            return [
                'result' => [
                    'email' => [
                        'status'             => 'failed',
                        'message'            => 'Invalid email address.',
                        'http_response_code' => 400,
                    ]
                ]
            ];
        }

        // Domain setup
        $domain       = $_SERVER['HTTP_HOST'];
        $noreplyEmail = "no-reply@$domain";

        $adminRecipient = $email;
        $adminSubject   = "Validate Your Email Address";
        $adminHeaders   = "From: $noreplyEmail\r\n";
        $adminHeaders  .= "Reply-To: $noreplyEmail\r\n";
        $adminHeaders  .= "Content-type: text/html; charset=UTF-8\r\n";

        $action = '?action=validNewUser&email=' . rawurlencode($email) . '&oneTimeCode=' . $inputData['oneTimeCode'];
        if (!empty($inputData['noPasswordFlag']) && $inputData['noPasswordFlag'] == 1) {
            $action = '-withPassword?action=validNewUserWithPass&email=' . rawurlencode($email) . '&oneTimeCode=' . $inputData['oneTimeCode'];
        }

        $validationUrl = "https://$domain/authentication$action";

        // Nicely formatted HTML email
        $message = '
        <html>
        <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>Email Validation</title>
        </head>
        <body style="margin:0; padding:0; font-family:Arial, sans-serif; background-color:#f4f4f4;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
            <tr>
            <td align="center" style="padding:20px 0;">
                <table border="0" cellpadding="0" cellspacing="0" width="600" style="background:#ffffff; border-radius:8px; overflow:hidden; box-shadow:0 2px 5px rgba(0,0,0,0.1);">
                <tr>
                    <td style="padding:30px; text-align:left;">
                    <h2 style="margin-top:0; color:#333333;">Hi ' . htmlspecialchars($inputData['firstName']) . ',</h2>
                    <p style="color:#555555; font-size:15px; line-height:1.5;">
                        Thank you for registering with us. Please use the code below and click the button to validate your email address.
                    </p>
                    <p style="margin:20px 0; font-size:18px; font-weight:bold; color:#000000;">
                        One Time Code: ' . htmlspecialchars($inputData['oneTimeCode']) . '
                    </p>
                    <p style="text-align:center; margin:30px 0;">
                        <a href="' . $validationUrl . '" 
                        style="background:#007BFF; color:#ffffff; padding:12px 24px; text-decoration:none; font-size:16px; border-radius:5px; display:inline-block;">
                        Validate Email
                        </a>
                    </p>
                    <p style="color:#555555; font-size:13px; line-height:1.4;">
                        If the button above does not work, please copy and paste this link into your browser:
                    </p>
                    <p style="color:#007BFF; font-size:13px; word-break:break-all;">
                        ' . $validationUrl . '
                    </p>
                    <p style="color:#999999; font-size:12px; margin-top:30px;">
                        This is an automated message from ' . $domain . '. Please do not reply.
                    </p>
                    </td>
                </tr>
                </table>
            </td>
            </tr>
        </table>
        </body>
        </html>';

        $adminSuccess = mail($adminRecipient, $adminSubject, $message, $adminHeaders);

        if ($adminSuccess) {
            return [
                'result' => [
                    'admin_status'              => 'success',
                    'admin_message'             => 'Admin email sent successfully.',
                    'admin_http_response_code'  => 200
                ]
            ];
        } else {
            return [
                'result' => [
                    'admin_status'              => 'failed',
                    'admin_message'             => 'Failed to send admin email.',
                    'admin_http_response_code'  => 500
                ]
            ];
        }
    }
    function resetpasswordEmailSend($inputData) {
        // get domain from server
        $domain = $_SERVER['HTTP_HOST'];

        $to      = $inputData['email'];
        $subject = "Password Reset Request";

        $action        = '?action=passwordResetRequest&email=' . rawurlencode($inputData['email']) . '&oneTimeCode=' . $inputData['oneTimeCode'];
        $resetUrl      = "https://$domain/password-reset$action";
        $oneTimeCode   = htmlspecialchars($inputData['oneTimeCode']);

        $message = '
        <html>
        <head>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
        <title>Password Reset</title>
        </head>
        <body style="margin:0; padding:0; font-family:Arial, sans-serif; background-color:#f4f4f4;">
        <table role="presentation" border="0" cellpadding="0" cellspacing="0" width="100%">
            <tr>
            <td align="center" style="padding:20px 0;">
                <table border="0" cellpadding="0" cellspacing="0" width="600" style="background:#ffffff; border-radius:8px; overflow:hidden; box-shadow:0 2px 5px rgba(0,0,0,0.1);">
                <tr>
                    <td style="padding:30px; text-align:left;">
                    <h2 style="margin-top:0; color:#333333;">Hi,</h2>
                    <p style="color:#555555; font-size:15px; line-height:1.5;">
                        We received a request to reset your password. Please use the code below or click the button to set a new password.
                    </p>
                    <p style="margin:20px 0; font-size:18px; font-weight:bold; color:#000000;">
                        One Time Code: ' . $oneTimeCode . '
                    </p>
                    <p style="text-align:center; margin:30px 0;">
                        <a href="' . $resetUrl . '" 
                        style="background:#007BFF; color:#ffffff; padding:12px 24px; text-decoration:none; font-size:16px; border-radius:5px; display:inline-block;">
                        Reset Password
                        </a>
                    </p>
                    <p style="color:#555555; font-size:13px; line-height:1.4;">
                        If the button above does not work, copy and paste this link into your browser:
                    </p>
                    <p style="color:#007BFF; font-size:13px; word-break:break-all;">
                        ' . $resetUrl . '
                    </p>
                    <p style="color:#999999; font-size:12px; margin-top:30px;">
                        This reset link will expire in 2 hours.<br>
                        If you did not request this change, you can safely ignore this email.
                    </p>
                    </td>
                </tr>
                </table>
            </td>
            </tr>
        </table>
        </body>
        </html>';

        $headers  = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=UTF-8\r\n";
        $headers .= "From: No-Reply <$domain>\r\n";
        $headers .= "Reply-To: No-Reply <$domain>\r\n";

        mail($to, $subject, $message, $headers);

        return $action;
    }
    function validateEmail($inputData){
        // check if email exists 
        $simpleEmailCheck = simpleEmailCheck($inputData);
        if ($simpleEmailCheck['status'] == 'success' && $simpleEmailCheck['userId'] != 0) {
            // check if email is allready validated
            $inputData['userId'] = $simpleEmailCheck['userId'];
            $userStatusCheck = checkStatusOfUser($inputData);
            if($userStatusCheck['status'] == 'success' && $userStatusCheck['userStatus'] == 1){
                if($inputData['noPasswordFlag'] == 1){
                    $inputData['passwordHash'] = passwordHashing($inputData['password']);
                }

                $res = updateValidateEmail($inputData);
            }else{
                $res['status']      = 'failed';
                $res['message']     = 'Email allready validated';
            }
        }else{
            $res = $simpleEmailCheck;
        }
        return $res;
    }
    function setupPasswordReset($inputData){
        $inputData['oneTimeCode']  = oneTimeCode();
        $res =  updateForGotPassPart1($inputData);
        if($res['status'] == 'success'){
            if(defined('TEST_ENV')){
                $res['oneTimeCode'] = $inputData['oneTimeCode'];
                $res['status'] = 'success';
            }else{
                resetpasswordEmailSend($inputData);
            }
        }
        return $res;
    }
    function passwordResetRequest($inputData){
        $inputData['passwordHash'] = passwordHashing($inputData['password']);
        $res = updateForGotPassPart2($inputData);
        if($res['status'] == 'success'){
        //    $res['html'] = validatedMessage('p');
        }
        return $res; 
    }
    function updatePass($inputData){
       
       // if password is less tha 8 char return error
       // if password is the same as the old password return error
      // if password is not set return error
        
        if(!isset($inputData['password']) || $inputData['password'] == ''){
            $res['status']  = 'failed';
            $res['message'] = 'Password not set';
            return $res;
        }
        if(strlen($inputData['password']) < 8){
          $res['status']  = 'failed';
          $res['message'] = 'Password must be at least 8 characters';
          return $res;
        }
        if($inputData['password'] == $inputData['oldPassword']){
            $res['status']  = 'failed';
            $res['message'] = 'Password must be different from the old password';
            return $res;
        }

        $email      = getEmailAddress($inputData);
        if($email['status'] == 'success'){    
            $inputData['email']     = $email['user_email'];
            $int['pass']            = getPassword($inputData);
            if(password_verify($inputData['oldPassword'], $int['pass']) === true){
                $inputData['passwordHash'] = passwordHashing($inputData['password']);
                $res = updatePassword($inputData);
            }else{
                $res['status']  = 'failed';
                $res['message'] = 'Old password incorrect';
            }
        }else{
            $res = $email;
        }
        return $res;
    }
    function executeDatabaseOperation( $inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function setupNewSystem($inputData){
        
        // check tenant exists
        $inputData['nextOperation'] = 'checkIfTenantInSystem';
        $out = executeDatabaseOperation($inputData);
        if($out['status'] == 'found'){
            $out['message'] = 'Tenant already exists';
            $out['status'] = 'failed';
            return $out; 
        }
        /*  Tempory Removed Delete this code when ready later
            // check user exists
            $inputData['lookupUserId'] = $inputData['newOwnerId'];
            $inputData['nextOperation'] = 'lookupUser';
            $out = executeDatabaseOperation($inputData);
            if($out['lookup']['status'] == 'failed'){
                $out['message'] = 'User not found';
                $out['status'] = 'failed';
                return $out; 
            }
        */
        // Insert new system id with tenant id
        $inputData['nextOperation'] = 'insertNewSystemToTenant';
        $out = executeDatabaseOperation($inputData);
        if($out['status'] == 'failed'){
            $out['message'] = 'Failed to insert new system to tenant';
            $out['status'] = 'failed';
            return $out; 
        }
        $inputData['systemId'] = $out['systemId'];

        /*
        $inputData['nextOperation'] = 'insertNewUserPermissions';
        $out = executeDatabaseOperation($inputData);
        */

        
        return $out;
    }
    function setUserToSystem($inputData){
        
        // check tenant exists
        $inputData['nextOperation'] = 'checkIfTenantInSystem';
        $out = executeDatabaseOperation($inputData);
        if($out['status'] == 'notfound'){
            $out['message'] = 'Tenant not found';
            $out['status'] = 'failed';
            return $out; 
        }
        
        // check user exists
        $inputData['lookupUserId'] = $inputData['registerUser'];
        $inputData['nextOperation'] = 'lookupUser';
        $out = executeDatabaseOperation($inputData);
        if($out['lookup']['status'] == 'failed'){
            $out['message'] = 'User not found';
            $out['status'] = 'failed';
            return $out; 
        }

        // get system id from tenant id
        $inputData['nextOperation'] = 'getSysyemIdFromTenantId';
        $out = executeDatabaseOperation($inputData);
        if($out['status'] == 'failed'){
            $out['message'] = 'Failed to get system id from tenant id';
            $out['status'] = 'failed';
            return $out; 
        }
        $inputData['systemId'] = $out['systemId'];
        

        $inputData['nextOperation'] = 'checkPermissionsNotPreSet';
        $out = executeDatabaseOperation($inputData);
        if($out['status'] == 'found'){
            $out['message'] = 'User already has permissions for this system';
            $out['status'] = 'failed';
            return $out; 
        }

        $inputData['nextOperation'] = 'insertNewUserPermissions';
        $out = executeDatabaseOperation($inputData);
    
        return $out;
    }
    function newSuperAdmin($inputData){ // create a new super admin
        // begin transaction
        $db = $inputData['db']['dbLogin'];
        $db->beginTransaction();
        // check if the current users role is equal or grater than the user they are trying to create
        // 1 = highest privilege. Block if the new role is "higher" (smaller number) than the caller's role.
        if ((int)$inputData['requestedRoleId'] < (int) $inputData['roleId']) {
            $db->rollBack();
            return ['status' => 'failed', 'message' => 'You do not have permission to create this user'];
        }
       
        // check if user exists by email
        $inputData['nextOperation'] = 'searchUserWithEmail';
        $out = executeDatabaseOperation($inputData);
        if($out['status'] == 'success' && isset($out['userId'])){
            $db->rollBack();
            return ['status' => 'failed', 'message' => 'User with this email already exists'];
        }

        // hash the password
        $inputData['passwordHash'] = passwordHashing($inputData['password']);
        $inputData['nextOperation'] = 'addSuperUser';
        $out = executeDatabaseOperation($inputData);
        if($out['status'] == 'failed'){
            $db->rollBack();
            if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $out['message'] = 'Failed to create new user: '.$out['message'];
            }
            return ['status' => 'failed', 'message' => 'Failed to create new user'];
        }

        if($out['status'] == 'success'){
            $inputData['lookupUserId']      = $out['userId'];
            $inputData['systemId']          = 1; // Super Admin system
            $inputData['nextOperation'] = 'insertNewUserPermissions';
            $out = executeDatabaseOperation($inputData);
        }

        if($out['status'] == 'failed'){
            $db->rollBack();
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $out['message'] = 'Failed to set permissions for new user: '.$out['message'];
            }
            return ['status' => 'failed', 'message' => 'Failed to set permissions for new user', 'output' => $out];
        }
        $db->commit();
        return ['status' => 'success', 'message' => 'New super admin created'];
    }
    
?>
