# Login API Interface Specification

---

## Overview
This document outlines the API contract for user authentication and management, including login, registration, password reset, and session validation. All operations are triggered via a single endpoint (`function.php`) using `POST` or `GET` requests, with the operation determined by the `action` field in the payload.

---

## API Summary Table

| Action                      | Method | Auth Required | Payload Object             | Description                                                         |
|-----------------------------|--------|---------------|----------------------------|---------------------------------------------------------------------|
| `checkEmail`                | POST   | No            | `email`                    | Check if an email exists                                            |
| `addUser`                   | POST   | No            | `user`                     | Register a new user                                                 |
| `validNewUser`              | POST   | No            | `email`, `otc`             | Confirm user registration                                           |
| `login`                     | POST   | No            | `email`, `password`        | Authenticate user credentials                                       |
| `logout`                    | POST   | Yes           | —                          | Log the user out                                                    |
| `checkLive`                 | GET    | Optional      | —                          | Validate user session                                               |
| `setupPasswordReset`        | POST   | No            | `email`                    | Start password reset process                                        |
| `passwordResetRequest`      | POST   | No            | `email`, `otc`, `password` | Complete password reset                                             |
| `updatePass`                | POST   | Yes           | `oldPassword`, `password`  | Change password                                                     |
| `lookupUser`                | GET    | Yes           | `lookupUserId`             | Lookup a user (admin only)                                          |
| `setUpNewSystem`            | POST   | Yes           |  —                         |Set up a new system (admin only)                                     |
| `setUserToSystem`           | POST   | Yes           |  —                         | Add a user to a new system Roles(1-5)                               | 
| `getAvailableRoles`         | GET    | Yes           |  —                         | Get a list of roles that you can set                                |
| `addUserWithRole`           | POST   | Yes           |  —                         | Post a new user with there role, needs to be within a tenants space |
| `validNewUserWithPass`      | POST   | Yes           |  —                         | Post validate user account's with onetimeCode and password          |
| `searchUserWithEmail`       | GET    | Yes           |  —                         | Get userId based on email                                           |
| `viewTenantUsers`           | GET    | Yes           |  —                         | Get user list based on tenant id                                    |
| `newSuperAdmin`             | POST   | Yes           |  newUser                   | Set up a new Super User Account Role 1 or 2 or 3                    |
| `viewSysAdmins`             | GET    | Yes           |  View List                 | List of super admin users                                           |


---

## Payload Structures

### `checkEmail`
```json
{
  "action": "checkEmail",        // Action to perform
  "email": "test@example.com"     // Email to check
}
```

### `addUser`
```json
{
  "action": "addUser",            // Registration trigger
  "email": "test@example.com",    // Email address
  "password": "********",         // Password
  "firstName": "John",            // First name
  "lastName": "Doe",              // Last name
  "phoneNumber": "0123456789"     // Optional phone
}
```

### `validNewUser`
```json
{
  "action": "validNewUser",      // Validation trigger
  "email": "test@example.com",    // Email address
  "otc": "123456"                 // One-time code sent to email
}
```

### `login`
```json
{
  "action": "login",              // Login request
  "email": "test@example.com",    // Email
  "password": "********"          // Password
}
```

### `logout`
```json
{
  "action": "logout"              // Logout current session
}
```

### `checkLive`
```json
{
  "action": "checkLive"           // Check if session is active
}
```

### `setupPasswordReset`
```json
{
  "action": "setupPasswordReset", // Trigger password reset
  "email": "test@example.com"     // User email
}
```

### `passwordResetRequest`
```json
{
  "action": "passwordResetRequest", // Finalize reset
  "email": "test@example.com",       // Email
  "password": "NewPass123!",        // New password
  "otc": "123456"                    // One-time code
}
```

### `updatePass`
```json
{
  "action": "updatePass",          // Password update
  "oldPassword": "OldPass123!",    // Current password
  "password": "NewPass123!"         // New password
}
```

### `lookupUser`
```json
{
  "action": "lookupUser",          // Admin lookup
  "lookupUserId": 123               // ID of user to retrieve
}
```

### `setUpNewSystem`
```json
{
  "action": "setUpNewSystem",
  "tenantId"          : int,
  "systemName"        : string "Company Name",
  "tenantBaseUrl"     : string "BaseUrl",
  "systemDescription" : string "Description"
}
```

### `setUserToSystem`
```json
{
  "action": "setUserToSystem",
  "systemName"        : string "Company Name",
  "registerUser"      : int,
  "requestedRoleId"   : int
}
```

### `getAvailableRoles`
```json
{
  "action": "getAvailableRoles",          // Admin lookup
}
```

### `addUserWithRole`
```json
{
  "action": "addUserWithRole",    // Registration trigger
  "email": "test@example.com",    // Email address
  "firstName": "John",            // First name
  "lastName": "Doe",              // Last name
  "phoneNumber": "0123456789",    // Optional phone
  "requestedRoleId": 4            // Role Owner 
}
```


### `validNewUserWithPass`
```json
{
  "action": "validNewUserWithPass", // Registration trigger
  "email": "test@example.com",      // Email address
  "password": "********",           // Password
  "otc" : int
}
```

### `validNewUserWithPass`
```json
{
  "action": "validNewUserWithPass", // Registration trigger
  "email": "test@example.com",      // Email address
  "password": "********",           // Password
  "otc" : int
}
```

### `searchUserWithEmail`
```json
{
  "action": "searchUserWithEmail", // Registration trigger
  "email": "test@example.com"      // Email address
}
```

### `viewTenantUsers`
```json
{
  "action": "viewTenantUsers"  
}
```

### `newSuperAdmin`
```json
{
  "action": "newSuperAdmin",
    "email"       : string,
    "firstName"   : "John",            // First name
    "lastName"    : "Doe",              // Last name
    "phoneNumber" : "0123456789",     // Optional phone
    "password"    : string,
    "requestedRoleId": int // [1,2,3]
}
```
### `viewSysAdmins`
```json
{
  "action": "viewSysAdmins"
}

---

## Response Format

### Success
```json
{
  "status": "success",
  "message": "Description of result"
}
```

### Failure
```json
{
  "status": "failed",
  "message": "Error message"
}
```

---

## Notes
- Email validation is required for login.
- Passwords must be at least 8 characters.
- The same password cannot be reused.
- One-time codes (OTCs) are used for validation and password reset.
- Session state is maintained via `$_SESSION`.

---

_End of Document_

