<?php


function addNewUser($inputData){
    $result = [];
    $db = $inputData['db']['dbLogin'];
    $stmt = $db->prepare("insert into user_login (user_email, f_name, l_name, user_password, one_time_code) values(:email, :fname, :lname, :pass, :otc)");
    $stmt->bindParam(':email', $inputData['email']);
    $stmt->bindParam(':fname', $inputData['firstName']);
    $stmt->bindParam(':lname', $inputData['lastName']);
    $stmt->bindParam(':pass', $inputData['passwordHash']);
    $stmt->bindParam(':otc', $inputData['oneTimeCode']);
    $stmt->execute();
    $userid = $db->lastInsertId();
    if ($stmt->rowCount() > 0){
        $result['userId']   = $userid;
        $result['message']  = 'Account created successfully please check your email to verify your account';
        $result['status']   = 'success';
        return $result;
    }else{
        $result['status'] = 'failed';
        $result['userId'] =  '0';
        return $result;
    }
}

function logOfLogin($inputData){
    $result = [];
    $db = $inputData['db']['dbLogin'];

    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
    
    $stmt = $db->prepare("insert into user_login_log (user_id, email_address, login_date, login_time, login_ip, useragent, status, msg) values(:userId, :emailAddress, :loginDate, :loginTime, :loginIp, :userAgent, :status, :msg)");
    $stmt->bindParam(':userId', $inputData['userId']);
    $stmt->bindParam(':emailAddress', $inputData['email']);
    $stmt->bindParam(':loginDate', date('Y-m-d'));
    $stmt->bindParam(':loginTime', date('H:i:s'));
    $stmt->bindParam(':loginIp', $_SERVER['REMOTE_ADDR']);
    $stmt->bindParam(':userAgent', $userAgent);
    $stmt->bindParam(':status', $inputData['status']);
    $stmt->bindParam(':msg', $inputData['msg']);
    // can we get the users location 
    $stmt->execute();
    return;
}

?>
