<?php
// this should only be used for testing purposes
if (defined('TEST_ENV')) {
    //require_once __DIR__ . '/../../orbit-core/src/config.php';
    require_once __DIR__ . '\..\..\core\src\Fcors.php';
    require_once __DIR__ . '\..\..\tests\scripts\bootstrap.php';
    require_once __DIR__ . '\..\..\core\src\generic.php';
    $testInfo['0'] = ("\nFunction Running in Test Environment\n");
} else {
    // this is code for live environment Dev, Uat, Production
    require_once __DIR__ . "./../generic.php";
}
    
    require_once __DIR__ . "/core.php";
    require_once __DIR__ . "/view.php";
    require_once __DIR__ . "/insert.php";
    require_once __DIR__ . "/update.php";


    $inputData = initializeGeneric();  // ✅ Ensures fresh initialization in each test
    $action = $inputData['action'];
    
// ==========================================Login=================================================
    if (isset($action)) {
        switch ($action) {
            case "login":
                $out = logMeIn($inputData);
                break;

            case "checkLive":
                $out = checkLive();
                break;

            case "logout":
                killSessions();
                $out['status'] = 'success';
                break;

            case "checkEmail":
                $out = emailCheckSanatize($inputData);
                break;

            case "addUser":
                $out = newUser($inputData);
                break;

            case "validateEmail":
                $out = validateEmail($inputData);
                break;

            case "setupPasswordReset":
                $out = setupPasswordReset($inputData);
                break;

            case "passwordResetRequest":
                $out = passwordResetRequest($inputData);
                break;

            case "updatePass":
                $out = updatePass($inputData);
                break;

            default:
                $out['status']      = 'failed';
                $out['message']     = 'Invalid Action';
                $out['inputData']   = $inputData;
                break;
        }
    } else {
        $out['status']      = 'failed';
        $out['message']     = 'No Action Found';
        $out['inputData']   = $inputData;
    }

    if(defined('TEST_ENV')){
        //    $out['testInfo']['1'] = $testInfo;
        //    $out['testInfo']['2'] = $_GET;
        //    $out['testInfo']['3'] = $_POST;
        //    $out['inputData'] = $inputData;
        //    $out['security'] = $security;
              $out['action'] = $action;
    }

    echo json_encode(propagateStatusAndMessage($out));
?>