<?php
    function emailCheck($inputData) { // Upgraded
        $result = [];
        try {
            $db = $inputData['db']['dbLogin'];
            $stmt = $db->prepare("SELECT pk_user_id, fk_user_status_id FROM user_login WHERE UPPER(user_email) = UPPER(:email)");
            $stmt->bindValue(':email', $inputData['email']);
            $stmt->execute();
            $row = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($row) {
                $result['UserExists'] = $row['pk_user_id'];
                $result['userStatus'] = $row['fk_user_status_id'];
            } else {
                $result['UserExists'] = 'failed';
                $result['email'] = $inputData['email'];
            }
        } catch (PDOException $e) {
            if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugMode']) {
                // Output the error message
                $result['message'] = $e->getMessage();
                $result['status'] = 'failed';
            }else{
                $result['status'] = 'error';
                $result['message'] = 'Database error:';
            }
        }
        return $result;
    }
    function userType($inputData){
        $userID = $_SESSION['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("select fk_role_id, fk_tenant_id 
                                from `user_permissions` up 
                                left join user_system us on us.pk_system_id = up.fk_system_id 
                                where fk_user_id = :userId
                                and fk_system_id = :systemId 
                                and access_status = 'active'");
        $stmt->bindParam(':userId', $userID);
        $stmt->bindParam('systemId',$inputData['systemId']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $roleValue = $row !== false ? $row['fk_role_id'] : 0;
            $tenantId = $row !== false ? $row['fk_tenant_id'] : 0;
        }else{
            $roleValue = 0;
            $tenantId = 0;
        }
        $_SESSION['roleValue'] = is_numeric($roleValue) ? (int)$roleValue : null;
        $_SESSION['roleTenantId'] = $tenantId;
        return;        
    }
    function checkIfAdmin($inputData){
        $userID = $_SESSION['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("select fk_role_id from `user_permissions` where fk_user_id = :userId and fk_role_id in (1,2,3) and access_status = 'active'");
        $stmt->bindParam(':userId', $userID);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $roleValue = $row !== false ? $row['fk_role_id'] : 0;
            $_SESSION['roleSysAdminTenantId'] = 1;
        }else{
            $roleValue = 0;
            $_SESSION['roleSysAdminTenantId'] = 0;
        }
        $_SESSION['roleValue'] = is_numeric($roleValue) ? (int)$roleValue : null;
        return;        
    }
    function emailCheckWithID($inputData){
        $result = [];
        $userID =  $_SESSION['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("Select fk_user_status_id from user_login where pk_user_id = :userId");
        $stmt->bindParam(':userId', $userID);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['userStatus'] = $row !== false ? $row['fk_user_status_id'] : null;
            $result['status']    = 'success';

        }else{
            $result['UserExists']   = 'failed';
            $result['status']       = 'ignor';

        //    $result['emailCheck1']  = $stmt;
        //    $result['emailCheck2']  = $stmt->errorInfo();
        }        
        return  $result;
    }
    function getPassword($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT user_password FROM user_login WHERE UPPER(user_email) = UPPER(:email)");
        $stmt->bindParam(':email', $inputData['email']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row && isset($row['user_password'])) {
            return $row['user_password']; // Just return password directly if found
        }
        $result['email'] = $inputData['email'];
        $result['user_password'] = 'failed';
        return $result;
    }
    function getEmailAddress($inputData){
        $result = [];
        $userID =  $_SESSION['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("select user_email from user_login where pk_user_id = :userId");
        $stmt->bindParam(':userId', $userID);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['user_email'] = $row !== false ? $row['user_email'] : null;
            $result['status']    = 'success';
        }else{
            $result['status']    = 'failed';
        //    $result['getPassword1']     = $stmt;
        //    $result['getPassword2']     = $stmt->errorInfo();
        //    $result['id'] =  $_SESSION['id'];
        }
        return  $result;
    }
    function simpleEmailCheck($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("Select pk_user_id from user_login where upper(user_email) = upper(:email)");
        $stmt->bindParam(':email', $inputData['email']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['userId'] = $row !== false ? $row['pk_user_id'] : 0;
            $result['status']    = 'success';
        }else{
            $result['status']    = 'failed';
            $result['message']       = 'Email not found';
        }        
        return  $result;
    }
    function checkStatusOfUser($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("select fk_user_status_id from user_login where pk_user_id = :userId");
        $stmt->bindParam(':userId', $inputData['userId']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['userStatus'] = $row !== false ? $row['fk_user_status_id'] : 0;
            $result['status']    = 'success';
        }else{
            $result['status']    = 'failed';
            $result['message']       = 'User not found';
        }
        return  $result;
    }
    function lookupUser($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT pk_user_id, user_email, f_name, l_name, phone_number FROM user_login WHERE pk_user_id = :userId");
        $stmt->bindParam(':userId', $inputData['lookupUserId']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $lookup['status']       = 'success';
            $lookup['email']        = $row['user_email'];
            $lookup['userId']       = $row['pk_user_id'];
            $lookup['fName']        = $row['f_name'];
            $lookup['lName']        = $row['l_name'];
            $lookup['phoneNumber']  = $row['phone_number'];
        }else{
            $lookup['status']    = 'failed';
            $lookup['message']       = 'User not found';
        }
        return  $result = [ 'lookup' => $lookup];
    }
    function checkIfTenantInSystem($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT pk_system_id FROM user_system WHERE fk_tenant_id = :tenantId");
        $stmt->bindParam(':tenantId', $inputData['tenantId']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['status']    = 'found';
        }else{
            $result['status']    = 'notfound';
        }
        return  $result;
    }
    function lookupRoleByName($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT pk_role_id FROM user_role WHERE role_name = :roleName");
        $stmt->bindParam(':roleName', $inputData['requestedRole']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['status']    = 'success';
            $result['requestedRoleId']    = $row['pk_role_id'];
        }else{
            $result['status']    = 'failed';
            $result['message']       = 'Role not found';
        }
        return  $result;
    }
    function getSysyemIdFromTenantId($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT pk_system_id FROM user_system WHERE fk_tenant_id = :tenantId");
        $stmt->bindParam(':tenantId', $inputData['tenantId']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['status']    = 'success';
            $result['systemId']  = $row['pk_system_id'];
        }else{
            $result['status']    = 'failed';
            $result['message']       = 'System not found';
        }
        return  $result;
    }
    function viewRoles($inputData){
        $db     = $inputData['db']['dbLogin'];
        $roleId = $inputData['roleId'] ?? 0;

        // 1) Fetch from DB
        $stmt = $db->prepare("
            SELECT pk_role_id, role_name
            FROM user_role
            WHERE scope != 'Platform'
            AND pk_role_id > :roleId
            ORDER BY pk_role_id
        ");
        $stmt->bindParam(':roleId', $roleId, PDO::PARAM_INT);
        $stmt->execute();
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // 2) Build your list
        $roles = [];

        // if they passed in roleId==1, pre-seed the “system” roles
        if ($roleId === 1) {
            $roles = [
                ['roleId' => 1, 'roleName' => 'SystemAdmin'],
                ['roleId' => 2, 'roleName' => 'SupportAgent'],
                ['roleId' => 3, 'roleName' => 'ContentModerator'],
            ];
        }

        // append whatever came back from the database
        foreach ($rows as $row) {
            $roles[] = [
                'roleId'   => (int)$row['pk_role_id'],
                'roleName' => $row['role_name'],
            ];
        }

        // 3) Return a structured response
        if (!empty($roles)) {
            return [
                'status' => 'success',
                'roles'  => $roles,
            ];
        }

        return [
            'status' => 'failed',
            'message'    => 'Role not found',
        ];
    }
    function getSysyemIdFromDomain($inputData){
        $result = [];
        $host = $_SERVER['HTTP_HOST'] ?? '';
        $host = strtolower($host);
        $parts = explode('.', $host);
        $cleanParts = array_filter($parts, fn($part) => $part !== 'admin');
        $cleanHost = implode('.', $cleanParts);
        $cleanUrl = 'https://' . $cleanHost;
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT pk_system_id FROM user_system WHERE tenant_base_url = :tenantBaseUrl and isDeleted = 0");
        $stmt->bindParam(':tenantBaseUrl', $cleanUrl);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['status']    = 'success';
            $result['systemId']  = $row['pk_system_id'];
        }else{
            $result['status']    = 'failed';
            $result['message']   = 'System not found';
        }
        return  $result;
    }
    function viewUsersAttachedToTennant($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT pk_user_id, user_email, f_name, l_name, phone_number FROM user_login WHERE fk_tenant_id = :tenantId");
        $stmt->bindParam(':tenantId', $inputData['tenantId']);
        $stmt->execute();
        $row = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if ($row) { 
            foreach($row as $key => $value){
                $result[$key]['userId']       = $value['pk_user_id'];
                $result[$key]['userEmail']    = $value['user_email'];
                $result[$key]['fName']        = $value['f_name'];
                $result[$key]['lName']        = $value['l_name'];
                $result[$key]['phoneNumber']  = $value['phone_number'];
            }
            $result['status']    = 'success';
        }else{
            $result['status']    = 'failed';
            $result['message']       = 'User not found';
        }
        return  $result;
    }
    function searchUserWithEmail($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT pk_user_id, f_name, l_name, us.status_name  FROM user_login ul left join user_status us on ul.fk_user_status_id = us.pk_user_status_id WHERE UPPER(user_email) like UPPER(:email) limit 1");
        $stmt->bindValue(':email', $inputData['email']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['userId']       = $row['pk_user_id'];
            $result['fName']        = $row['f_name'];
            $result['lName']        = $row['l_name'];
            $result['statusName']   = $row['status_name'];
            $result['status']    = 'success';
        }else{
            $result['status']    = 'failed';
            $result['message']   = 'User not found';
        }
        return  $result;
    }
    function viewTenantUsers($inputData){
        // 1) Validate input
        if (empty($inputData['tenantId'])) {
            return [
                'status'  => 'failed',
                'message' => 'Invalid or missing Inputs.'
            ];
        }
        $tenantId = (int) $inputData['tenantId'];
    
        // 2) Prepare & run query
        $db  = $inputData['db']['dbLogin'];
        $sql = "
            SELECT
                ul.pk_user_id,
                ul.user_email,
                ul.f_name,
                ul.l_name,
                ul.phone_number,
                up.access_status,
                ur.role_name,
                ust.status_name
            FROM user_login ul
            JOIN user_permissions up
              ON up.fk_user_id = ul.pk_user_id
            JOIN user_system us
              ON us.pk_system_id = up.fk_system_id
            LEFT JOIN user_role ur
              ON ur.pk_role_id = up.fk_role_id
            LEFT JOIN user_status ust  
            	ON ust.pk_user_status_id = ul.fk_user_status_id
            WHERE us.fk_tenant_id = :tenantId
              AND up.fk_role_id BETWEEN 4 AND 6
            ORDER BY ul.pk_user_id";
        $stmt = $db->prepare($sql);
        $stmt->bindValue(':tenantId', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
        // 3) Build output
        if (empty($rows)) {
            return [
                'status'  => 'failed',
                'message' => 'User not found'
            ];
        }
    
        $users = array_map(function(array $r): array {
            return [
                'userId'       => (int)   $r['pk_user_id'],
                'userEmail'    =>         $r['user_email'],
                'firstName'    =>         $r['f_name'],
                'lastName'     =>         $r['l_name'],
                'phoneNumber'  =>         $r['phone_number'],
                'roleName'     =>         $r['role_name'],
                'accessStatus' =>         $r['access_status'],
                'userStatus'   =>         $r['status_name'],
            ];
        }, $rows);
    
        // 4) Return
        return [
            'status' => 'success',
            'users'  => $users,
        ];
    }
    function checkPermissionsNotPreSet($inputData){
        $result = [];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT pk_permission_id 
                                from  user_permissions 
                                where access_status != 'revoked'
                                AND fk_user_id = :userId 
                                AND fk_system_id = :systemId
                                AND fk_role_id = :roleId");
        $stmt->bindParam(':userId',         $inputData['lookupUserId']);
        $stmt->bindParam(':systemId',       $inputData['systemId']);
        $stmt->bindParam(':roleId',         $inputData['requestedRoleId']);
        $stmt->execute();
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($row) { 
            $result['status']    = 'found';
            $result['userId']    = $row['pk_permission_id'];
        }else{
            $result['status']    = 'notfound';
            $result['message']   = 'User not found';
        }
        return  $result;
    }
    
?>