<?php
function addNewUser($inputData) {
    $result = [];

    try {
        $db = $inputData['db']['dbLogin'];

        $stmt = $db->prepare("
            INSERT INTO user_login 
                (user_email, f_name, l_name, phone_number, user_password, one_time_code) 
            VALUES 
                (:email, :fname, :lname, :phoneNumber, :pass, :otc)");
        $stmt->bindValue(':email',       $inputData['email']);
        $stmt->bindValue(':fname',       $inputData['firstName']);
        $stmt->bindValue(':lname',       $inputData['lastName']);
        $stmt->bindValue(':phoneNumber', $inputData['phoneNumber']);
        if($inputData['noPasswordFlag'] == 0){
            $stmt->bindValue(':pass',        $inputData['passwordHash']);
        }else{
            $stmt->bindValue(':pass',        'noPassword');
        }
        $stmt->bindValue(':otc',         $inputData['oneTimeCode']);
        $stmt->execute();
        $userId = $db->lastInsertId();

        if ($stmt->rowCount() > 0) {
            $result['userId']  = $userId;
            $result['message'] = 'Account created successfully. Please check your email to verify your account.';
            $result['status']  = 'success';
        } else {
            $result['status'] = 'failed';
            $result['userId'] = '0';
        }
    } catch (PDOException $e) {
        $result['status']  = 'error';
        $result['message'] = 'Database error: ' . $e->getMessage();
        $result['userId']  = '0';
    }

    

    return $result;
}
function logOfLogin($inputData){
    $db = $inputData['db']['dbLogin'];

    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
    $loginIp = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $userId = $inputData['userId'] ?? 0;
    $loginDate = date('Y-m-d');
    $loginTime = date('H:i:s');
    
    $stmt = $db->prepare("insert into user_login_log (user_id, email_address, login_date, login_time, login_ip, useragent, status, msg) values(:userId, :emailAddress, :loginDate, :loginTime, :loginIp, :userAgent, :status, :msg)");
    $stmt->bindParam(':userId',         $userId);
    $stmt->bindParam(':emailAddress',   $inputData['email']);
    $stmt->bindParam(':loginDate',      $loginDate);
    $stmt->bindParam(':loginTime',      $loginTime);
    $stmt->bindParam(':loginIp',        $loginIp);
    $stmt->bindParam(':userAgent',      $userAgent);
    $stmt->bindParam(':status',         $inputData['status']);
    $stmt->bindParam(':msg',            $inputData['message']);
    // can we get the users location 
    $stmt->execute();
    return;
}
function insertNewSystemToTenant($inputData){
    $db = $inputData['db']['dbLogin'];
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    // check if all values are set
    $requiredFields = ['tenantId', 'tenantBaseUrl', 'systemName', 'systemDescription'];
    $missingFields = [];
    
    foreach ($requiredFields as $field) {
        if (empty($inputData[$field])) {
            $missingFields[] = $field;
        }
    }
    
    if (!empty($missingFields)) {
        return [
            'status' => 'failed',
            'message' => 'Invalid or missing inputs: ' . implode(', ', $missingFields) . '.'
        ];
    }

    $stmt = $db->prepare("insert into user_system (fk_tenant_id, tenant_base_url, system_name, system_description) values(:tenantId, :tenantBaseUrl, :systemName, :systemDescription)");
    $stmt->bindParam(':tenantId',           $inputData['tenantId']);
    $stmt->bindParam(':tenantBaseUrl',      $inputData['tenantBaseUrl']);
    $stmt->bindParam(':systemName',         $inputData['systemName']);
    $stmt->bindParam(':systemDescription',  $inputData['systemDescription']);
    $stmt->execute();
    
    $insertedId = $db->lastInsertId();
    if ($insertedId) {
        $result['status'] = 'success';
        $result['systemId'] = $insertedId;
    } else {
        $result['status'] = 'failed';
        $result['systemId'] = '0';
    }

    return $result;
}
function insertNewUserPermissions($inputData){
    $db = $inputData['db']['dbLogin'];
    $stmt = $db->prepare("insert into user_permissions (fk_user_id, fk_system_id, fk_role_id, access_status) values(:userId, :systemId, :roleId, 'active')");
    $stmt->bindParam(':userId',         $inputData['lookupUserId']);
    $stmt->bindParam(':systemId',       $inputData['systemId']);
    $stmt->bindParam(':roleId',         $inputData['requestedRoleId']);
    $stmt->execute();
    
    $requestedRoleId = $db->lastInsertId();
    if ($requestedRoleId) {
        return [
            'status' => 'success'
            //,'requestedRoleId' => $requestedRoleId
        ];
    } else {
        return [
            'status' => 'failed',
            'requestedRoleId' => '0'
        ];
    }
}
?>
