<?php


function addNewUser($inputData) {
    $result = [];

    try {
        $db = $inputData['db']['dbLogin'];

        $stmt = $db->prepare("
            INSERT INTO user_login 
                (user_email, f_name, l_name, phone_number, user_password, one_time_code) 
            VALUES 
                (:email, :fname, :lname, :phoneNumber, :pass, :otc)
        ");
        $stmt->bindValue(':email',       $inputData['email']);
        $stmt->bindValue(':fname',       $inputData['firstName']);
        $stmt->bindValue(':lname',       $inputData['lastName']);
        $stmt->bindValue(':phoneNumber', $inputData['phoneNumber']);
        $stmt->bindValue(':pass',        $inputData['passwordHash']);
        $stmt->bindValue(':otc',         $inputData['oneTimeCode']);
        $stmt->execute();
        $userId = $db->lastInsertId();

        if ($stmt->rowCount() > 0) {
            $result['userId']  = $userId;
            $result['message'] = 'Account created successfully. Please check your email to verify your account.';
            $result['status']  = 'success';
        } else {
            $result['status'] = 'failed';
            $result['userId'] = '0';
        }
    } catch (PDOException $e) {
        $result['status']  = 'error';
        $result['message'] = 'Database error: ' . $e->getMessage();
        $result['userId']  = '0';
    }

    return $result;
}


function logOfLogin($inputData){
    $db = $inputData['db']['dbLogin'];

    $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? 'unknown';
    $loginIp = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $loginDate = date('Y-m-d');
    $loginTime = date('H:i:s');
    
    $stmt = $db->prepare("insert into user_login_log (user_id, email_address, login_date, login_time, login_ip, useragent, status, msg) values(:userId, :emailAddress, :loginDate, :loginTime, :loginIp, :userAgent, :status, :msg)");
    $stmt->bindParam(':userId',         $inputData['userId']);
    $stmt->bindParam(':emailAddress',   $inputData['email']);
    $stmt->bindParam(':loginDate',      $loginDate);
    $stmt->bindParam(':loginTime',      $loginTime);
    $stmt->bindParam(':loginIp',        $loginIp);
    $stmt->bindParam(':userAgent',      $userAgent);
    $stmt->bindParam(':status',         $inputData['status']);
    $stmt->bindParam(':msg',            $inputData['message']);
    // can we get the users location 
    $stmt->execute();
    return;
}

?>
