# Frontend API Interface Specification

---

## Overview
This document outlines the frontend API contract required to interact with the backend PHP application. All operations are triggered via a single endpoint (function.php) using POST or GET requests, with the action defined in the action field. Role-based access is enforced via session variables.

---

## Role Definitions

```sql
INSERT INTO `user_role` (`pk_role_id`, `role_name`, `scope`) VALUES
(1, "SystemAdmin", "Platform"),
(2, "SupportAgent", "Platform"),
(3, "ContentModerator", "Platform"),
(4, "BusinessOwner", "Tenant"),
(5, "BusinessManager", "Tenant"),
(6, "Staff", "Tenant"),
(7, "Operator", "Tenant"),
(8, "Customer", "Public");
```

## API Summary Table

| Action                            | Method | Required Role      | Payload Object           | Description                                                            |
|-----------------------------------|--------|--------------------|--------------------------|------------------------------------------------------------------------|
| [`getPreAuthPayments`](#getPreAuthPayments)              | GET    |  2,4,5,6           |                          | Get a list of pre auth payment to decided to accept or reject          |
| [`acceptedRejectPreAuthPayment`](#acceptedRejectPreAuthPayment)    | POST   |  2,4,5,6           | foodOrder                | From a list of pre auth payment to decided to accept or reject         |
| [`getOrderList`](#getOrderList)                    | GET    |  2,4,5,6           |                          | View all orders that are active and any completed up to 2 hours old    |
| [`viewOrderDetails`](#viewOrderDetails)                | GET    |  2,4,5,6           |                          | View order details                                                     |
| [`updateStatusOrder`](#updateStatusOrder)               | POST   |  2,4,5,6           | foodOrder                | Update the Order Status                                                |
| [`updateStatusItem`](#updateStatusItem)                | POST   |  2,4,5,6           | foodOrderItem            | Update the Order Item Status                                           |
| [`fullRefund`](#fullRefund)                      | POST   |  1,2,4,5,6         |                          | Full Refund of an order                                                |
| [`partialRefundStaticAmount`](#partialRefundStaticAmount)       | POST   |  1,2,4,5,6         |                          | Partial Refund of an order with a static amount set                    |
| [`itemBasedRefund`](#itemBasedRefund)                 | POST   |  1,2,4,5,6         |                          | Item Refund list of individual items                                   |
| [`getFullOrderListPaginated`](#getFullOrderListPaginated)       | GET    |  1,2,3,4,5         |                          | View of all orders with many filter options at the sql level           |
| [`dashboardData`](#dashboardData)                   | GET    |  4,5               |                          | View Dashboard Data                                                    |
| [`insertNewTerms`](#insertNewTerms)                   | POST    |  1,2,3,              |                          | Insert a new Terms of service                                                    |
| [`viewLatestTerms`](#viewLatestTerms)                   | GET    |                 |                          | View Latest Terms                                                    |
| [`viewAllTerms`](#viewAllTerms)                   | GET    |  1,2,3             |                          | View All Terms                                                    |
| [`setActiveTerms`](#setActiveTerms)                   | POST    |  1,2,3,              |                          | View All Terms                                                    |

<a id="getPreAuthPayments"></a>
### `getPreAuthPayments`
```json
    "action" : "getPreAuthPayments",
```

<a id="acceptedRejectPreAuthPayment"></a>
### `acceptedRejectPreAuthPayment`
```json
    "action" : "acceptedRejectPreAuthPayment",
    "foodOrder'" : 
            [
                "id" : "int",
                "accepted" : int [1: Accept, 0:reject]
            ]
```

<a id="getOrderList"></a>
### `getOrderList`
```json
    "action" : "getOrderList",
```

<a id="viewOrderDetails"></a>
### `viewOrderDetails`
```json
    "action" : "viewOrderDetails",
    "orderId": "int" 
```

<a id="viewLatestTerms"></a>
### `viewLatestTerms`
```json
    "action" : "viewLatestTerms",
```

<a id="viewAllTerms"></a>
### `viewAllTerms`
```json
    "action" : "viewAllTerms",
```

<a id="updateStatusOrder"></a>
### `updateStatusOrder`
```json
    "action" : "updateStatusOrder",
    "foodOrder" : [
        "id":"int", orderId
        "orderStatus":"string" ["cooking", "delivery", "completed"]
    ]
```

<a id="updateStatusItem"></a>
### `updateStatusItem`
```json
    "action" : "updateStatusItem",
    "foodOrderItem" : [
        "id":"int", itemId
        "itemStatus":"string" ["prepared", "served", "cancelled"]
    ]
```

<a id="setActiveTerms"></a>
### `setActiveTerms`
```json
    "action" : "setActiveTerms",
    "termId" : int
    ]
```


<a id="fullRefund"></a>
### `fullRefund`
```json
    "action" : "fullRefund",
    "orderId": int
    "comment":string,
```

<a id="partialRefundStaticAmount"></a>
### `partialRefundStaticAmount`
```json
    "action" : "partialRefundStaticAmount",
    "orderId": int,
    "refundAmount": float 
    "comment": string,
```

<a id="insertNewTerms"></a>
### `insertNewTerms`
```json
    "action" : "insertNewTerms",
    "foodOrderTermsOfService" =>[
                "tenantId"      => 1,
                "versions"      => "1.1",
                "content"       => "Sample terms and conditions content.",
                "effectiveDate" => "yyyy-mm-dd" // this can be same day or a day in the future
                "isActive"      => "[1 | 0]"
    ]
```

<a id="itemBasedRefund"></a>
### `itemBasedRefund`
```json
    "action" : "itemBasedRefund",
    "orderId": int,
    "comment": string,
    'orderItems' :[
        ['id':7,'qty':2],
        ['id':8,'qty':1],
        S['id'=>10]
```

### ``
```json
    "action"            : "getFullOrderListPaginated",
    "startDate"         : "date" optional,
    "endDate"           : "date" optional,
    "limit"             : "int" optional, 
    "offset"            : "int" optional, -- the start of of the next set of data
    "orderBy"           : "[ASC,DESC]" optional,
    "orderType"         : "['delivery', 'pickup', 'dine-in', 'collection']" optional,
    "orderStatus"       : "['pending', 'confirmed', 'cooking', 'delivery', 'completed', 'cancelled']" optional,
    "paymentStatus"     : "['unpaid', 'payment_intent', 'paid', 'refunded', 'partial_refund', 'payment_pre_auth']" optional,
```

###``
```json
    "action"            : "dashboardData"
```


## Payload Structures
