# Frontend API Interface Specification

---

## Overview
This document outlines the frontend API contract required to interact with the backend PHP application. All operations are triggered via a single endpoint (function.php) using POST or GET requests, with the action defined in the action field. Role-based access is enforced via session variables.

---

## Role Definitions

```sql
INSERT INTO `user_role` (`pk_role_id`, `role_name`, `scope`) VALUES
(1, "SystemAdmin", "Platform"),
(2, "SupportAgent", "Platform"),
(3, "ContentModerator", "Platform"),
(4, "BusinessOwner", "Tenant"),
(5, "BusinessManager", "Tenant"),
(6, "Staff", "Tenant"),
(7, "Operator", "Tenant"),
(8, "Customer", "Public");
```

## API Summary Table

| Action                            | Method | Required Role      | Payload Object           | Description                                                            |
|-----------------------------------|--------|--------------------|--------------------------|------------------------------------------------------------------------|
| `getPreAuthPayments`              | GET    |  2,4,5,6           |                          | Get a list of pre auth payment to decided to accept or reject          |
| `acceptedRejectPreAuthPayment`    | POST   |  2,4,5,6           | foodOrder                | From a list of pre auth payment to decided to accept or reject         |
| `getOrderList`                    | GET    |  2,4,5,6           |                          | View all orders that are active and any completed up to 2 hours old    |
| `viewOrderDetails`                | GET    |  2,4,5,6           |                          | View order details                                                     |
| `updateStatusOrder`               | POST   |  2,4,5,6           | foodOrder                | Update the Order Status                                                |
| `updateStatusItem`                | POST   |  2,4,5,6           | foodOrderItem            | Update the Order Item Status                                           |
| `fullRefund`                      | POST   |  1,2,4,5,6         |                          | Full Refund of an order                                                |
| `partialRefundStaticAmount`       | POST   |  1,2,4,5,6         |                          | Partial Refund of an order with a static amount set                    |
| `itemBasedRefund`                 | POST   |  1,2,4,5,6         |                          | Item Refund list of individual items                                   |
| `getFullOrderListPaginated`       | GET    |  1,2,3,4,5         |                          | View of all orders with many filter options at the sql level           |
| `dashboardData`                   | GET    |  4,5               |                          | View Dashboard Data                                                    |


### `getPreAuthPayments`
```json
    "action" : "getPreAuthPayments",
```

### `acceptedRejectPreAuthPayment`
```json
    "action" : "acceptedRejectPreAuthPayment",
    "foodOrder'" : 
            [
                "id" : "int",
                "accepted" : int [1: Accept, 0:reject]
            ]
```

### `getOrderList`
```json
    "action" : "getOrderList",
```

### `viewOrderDetails`
```json
    "action" : "viewOrderDetails",
    "orderId": "int" 
```

### `updateStatusOrder`
```json
    "action" : "updateStatusOrder",
    "foodOrder" : [
        "id":"int", orderId
        "orderStatus":"string" ["cooking", "delivery", "completed"]
    ]
```

### `updateStatusItem`
```json
    "action" : "updateStatusItem",
    "foodOrderItem" : [
        "id":"int", itemId
        "itemStatus":"string" ["prepared", "served", "cancelled"]
    ]
```

### `fullRefund`
```json
    "action" : "fullRefund",
    "orderId": int
    "comment":string,
```

### `partialRefundStaticAmount`
```json
    "action" : "partialRefundStaticAmount",
    "orderId": int,
    "refundAmount": float 
    "comment": string,
```

### `itemBasedRefund`
```json
    "action" : "itemBasedRefund",
    "orderId": int,
    "comment": string,
    'orderItems' :[
        ['id':7,'qty':2],
        ['id':8,'qty':1],
        S['id'=>10]
```

### ``
```json
    "action"            : "getFullOrderListPaginated",
    "startDate"         : "date" optional,
    "endDate"           : "date" optional,
    "limit"             : "int" optional, 
    "offset"            : "int" optional, -- the start of of the next set of data
    "orderBy"           : "[ASC,DESC]" optional,
    "orderType"         : "['delivery', 'pickup', 'dine-in', 'collection']" optional,
    "orderStatus"       : "['pending', 'confirmed', 'cooking', 'delivery', 'completed', 'cancelled']" optional,
    "paymentStatus"     : "['unpaid', 'payment_intent', 'paid', 'refunded', 'partial_refund', 'payment_pre_auth']" optional,
```

###``
```json
    "action"            : "dashboardData"
```


## Payload Structures
