<?php
    function menuTableColumnMapping($table = null, $roleId = null, $actionType = null) {
       $allMappings = [
            'food_order' => [
                'fields' => [
                    'id'                        => ['mapping' => 'id',                          'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => null,         'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'userId'                    => ['mapping' => 'user_id',                     'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'guestUserId'               => ['mapping' => 'guest_user_id',               'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'tenantId'                  => ['mapping' => 'tenant_id',                   'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'deliveryAddressId'         => ['mapping' => 'delivery_address_id',         'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'billingAddressId'          => ['mapping' => 'billing_address_id',          'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'orderStatus'               => ['mapping' => 'order_status',                'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5, 6],         'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','confirmed','cooking','delivery','completed','cancelled']],
                    'orderType'                 => ['mapping' => 'order_type',                  'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['delivery','pickup','dine-in','collection']],
                    'paymentStatus'             => ['mapping' => 'payment_status',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['unpaid','paid','refunded','partial_refund','payment_intent','payment_pre_auth']],
                    'deliveryFee'               => ['mapping' => 'delivery_fee',                'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'orderFee'                  => ['mapping' => 'order_fee',                   'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'smallOrderFee'             => ['mapping' => 'small_order_fee',             'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'currency'                  => ['mapping' => 'currency',                    'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'transactionId'             => ['mapping' => 'transaction_id',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'paymentIntentId'           => ['mapping' => 'payment_intent_id',           'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'refundedId'                => ['mapping' => 'refunded_id',                   'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'comment'                   => ['mapping' => 'comment',                     'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'tenantComment'             => ['mapping' => 'tenant_comment',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'totalOrderPrice'           => ['mapping' => 'total_order_price',           'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedPrice'   => ['mapping' => 'total_order_modified_price',  'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedReason'  => ['mapping' => 'total_order_modified_reason', 'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_item', 'foreignKey' => 'orderId']],
            ],
            'food_order_item' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'orderId'               => ['mapping' => 'order_id',                'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuItemId'            => ['mapping' => 'menu_item_id',            'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'itemName'              => ['mapping' => 'item_name',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'string', 'expectedValue' => null],
                    'itemBasePrice'         => ['mapping' => 'item_base_price',         'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedPrice'     => ['mapping' => 'item_modified_price',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedReason'    => ['mapping' => 'item_modified_reason',    'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemQuantity'          => ['mapping' => 'item_quantity',           'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemNote'              => ['mapping' => 'item_note',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemStatus'            => ['mapping' => 'item_status',             'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','prepared','served','cancelled']],
                    'itemTenantComment'     => ['mapping' => 'item_tenant_comment',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_extra', 'foreignKey' => 'itemId']],
            ],
            'food_order_extra' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemId'                => ['mapping' => 'item_id',                 'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuExtraId'           => ['mapping' => 'menu_extra_id',           'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 1,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'extraName'             => ['mapping' => 'extra_name',              'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'extraPrice'            => ['mapping' => 'extra_price',             'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                ],
                'relationships' => [],
            ],
            'food_order_guest_user' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'fName'                 => ['mapping' => 'f_name',                  'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'lName'                 => ['mapping' => 'l_name',                  'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'phoneNumber'           => ['mapping' => 'phone_number',            'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'userEmail'             => ['mapping' => 'user_email',              'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order', 'foreignKey' => 'guestUserId']],
            ],
            'food_order_address' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'addressLine1'          => ['mapping' => 'address_line_1',          'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [0, 2, 4, 5],    'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'addressLine2'          => ['mapping' => 'address_line_2',          'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'city'                  => ['mapping' => 'city',                    'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'county'                => ['mapping' => 'county',                  'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'country'               => ['mapping' => 'country',                 'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'postalCode'            => ['mapping' => 'postal_code',             'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'checkSum'              => ['mapping' => 'check_sum',               'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [
                    ['table' => 'food_order', 'foreignKey' => 'deliveryAddressId'],
                    ['table' => 'food_order', 'foreignKey' => 'billingAddressId'],
                ],
            ],
            'food_order_user_address' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'userId'                => ['mapping' => 'user_id',                 'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'addressId'             => ['mapping' => 'address_id',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [0, 2, 4, 5],    'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'isDefault'             => ['mapping' => 'is_default',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'isActive'              => ['mapping' => 'is_active',               'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'isDeleted'             => ['mapping' => 'is_deleted',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                ],
                // No relationships for this table
                'relationships' => [],
            ],
        ];
        
        if (!$table) {
            return $allMappings;
        }
    
        $table = toSnakeCase($table);
        if (!isset($allMappings[$table])) {
            return null;
        }
    
        if ($roleId === null) {
            return $allMappings[$table];
        }
    
        $filtered = [];
        foreach ($allMappings[$table]['fields'] as $key => $meta) {
            if ($actionType === 'update' && isset($meta['updateRole'])) {
                if (in_array($roleId, $meta['updateRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'insert' && isset($meta['insertRole'])) {
                if (in_array($roleId, $meta['insertRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'view' && isset($meta['viewRole'])) {
                if (in_array($roleId, $meta['viewRole'])) {
                    $filtered[$key] = $meta;
                }
            }
        }

    
        return ['filtered' => $filtered, 'abc' => $table, 'roleId' => $roleId];
    }
    function updateContent(&$inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $inputData['step'][] = [];
        try {
            $pdo->beginTransaction(); // Start transaction
            $tableName = toSnakeCase($inputData['table']) ?? null;
            $inputData['dataKey'] = $inputData['table'];
            $changeType = $inputData['recordType'] ?? null;
            // ✅ Check if the extracted data block actually exists
            if (!isset($inputData['dataKey']) || empty($inputData['dataKey'])) {
                $pdo->rollback(); // Rollback transaction
                return ['status' => 'failed', 'message' => "Missing data block for table: {$tableName}"];
            }
            $inputData['step'][] = '00: Validate ID, prepare $inputData with idField, id, checkParent';
            // 00: Validate ID, prepare $inputData with idField, id, checkParent
            $res = validateUpdateInputStep($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res = ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
                }
                return $res;
            }

            $inputData['step'][] = '01: check item is not marked as deleted no update is possible';
            
    

        if($changeType === 'update') {
            $inputData['step'][] = '02: Fetch existing history data (before change)';
            // 02: Fetch existing history data (before change)
            $inputData['nextOperation'] = 'getDataForHistory';
            $res = executeDatabaseOperation($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res = ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
                }
                return $res;
            }
            if(isset($inputData['flagHistoryType']) && $inputData['flagHistoryType'] == 'refund'){
                $res['historyData']['id'] = $inputData['orderId'];
            }
            $inputData['historyData'] = $res['historyData'] ?? null;

            $inputData['step'][] = '03: Insert history record into history table';
            // 03: Insert history record into history table
            $inputData['nextOperation'] = 'saveHistoryRecordStep';
            $res = executeDatabaseOperation($inputData);

            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res = ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
                }
                return $res;
            }
        }
            $inputData['step'][] = '04: check if this is an update or a delete action';
            // 04: check if this is an update or a delete action

            $inputData['step'][] = '05: check if this is an update or a duplicate action';
            // 05: check if this is an update or a delete action
            if($changeType === 'update') {

                $inputData['nextOperation'] = 'updateMenuTable';
                $res = executeDatabaseOperation($inputData);
            }

            $inputData['step'][] = '06: check if this is a duplicate action';
            // 06: check if this is a duplicate action
            if($changeType === 'duplicate') {
                $inputData['nextOperation'] = 'duplicateRecored';
                $res = executeDatabaseOperation($inputData);
            }

            $inputData['step'][] = '07: check if the delete or update was successful';
            // 07: check if the delete or update was successful
            if($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res = ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step'], 'preparedStatement' => $res['preparedStatement'] ?? null];
                }
                return $res;
           }
            $pdo->commit();
            return [ 'status' => 'success','message' => 'Update completed successfully'];
        } catch (Exception $e) {
            $pdo->rollback(); // Rollback transaction on error
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                return ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $errorMessage, 'step' => $inputData['step']];
            } else {
                error_log("Error in updateContent: " . $e->getMessage());
                return ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
    }
    function validateUpdateInputStep(&$inputData) {
        $table = $inputData['table'] ?? null;
        $tableName = toSnakeCase($table);
        $roleId = $inputData['roleId'] ?? null;
        $dataKey = $inputData['table'];
        $actionType = $inputData['recordType'] ?? null;
    
        if (!$tableName) {
            return ['status' => 'failed', 'message' => 'Table name not specified in input'];
        }
    
        if (!$dataKey) {
            return ['status' => 'failed', 'message' => 'Data key not extracted from table name'];
        }


        $tableData = $inputData[$dataKey] ?? [];
            
        $map = menuTableColumnMapping($tableName, $roleId, $actionType);

        $columnMap = $map['filtered'] ?? null;
        
        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'No column mapping found for table: '. $tableName . ' table: ' .$table];
        }
    
        // 🆕 Find the primary key field
        $primaryKey = null;
        foreach ($columnMap as $key => $meta) {
            if (isset($meta['mapping']) && strtolower($meta['mapping']) === 'id') {
                $primaryKey = $key;
                break;
            }
        }
    
        if (!$primaryKey) {
            return ['status' => 'failed', 'message' => "No primary key (id) field found for table: {$tableName}"];
        }
    
        // 🆕 Recursively search for the ID value
        $idValue = findIdInData($tableData, $primaryKey);
    
        if ($idValue === null || $idValue === '') {
            return ['status' => 'failed', 'message' => "Missing required Id field: {$primaryKey} key: {$tableName}"];
        }
    
        // Set ID info for future $inputData['step'][]s
        $inputData['idField'] = $primaryKey;
        $inputData['id'] = $idValue;
    
        // Set checkParent flag
        $inputData['checkParent'] = array_key_exists('parentId', $columnMap) ? 1 : 0;

        return ['status' => 'success'];
    }
    function findIdInData($data, $primaryKey) {
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                // Recurse into sub-arrays
                $found = findIdInData($value, $primaryKey);
                if ($found !== null) {
                    return $found;
                }
            } else {
                if ($key === $primaryKey) {
                    return $value;
                }
            }
        }
        return null;
    }
    function executeDatabaseOperation(&$inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
            // get the prepared statement if exists
            $preparedStatement = $inputData['preparedStatement'] ?? null;
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage, 'preparedStatement' => $preparedStatement];
            }else{
                error_log("Error in executeDatabaseOperation ({$operation}): " . $e->getMessage());
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function convertKeysToCamelCase($array) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Convert snake_case to camelCase
            $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
                return strtoupper($matches[1]);
            }, $key);

            // Lowercase first character to enforce camelCase
            $camelKey = lcfirst($camelKey);

            // Recursively handle nested arrays
            if (is_array($value)) {
                $converted[$camelKey] = convertKeysToCamelCase($value);
            } else {
                $converted[$camelKey] = $value;
            }
        }

        return $converted;
    }
    function toSnakeCase($input) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
    }
    function renameIdKeys($array, $newKeyName) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Recursively handle nested arrays
            if (is_array($value)) {
                $value = renameIdKeys($value, $newKeyName);
            }

            if ($key === 'id') {
                $converted[$newKeyName] = $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }
    function extractDataKeyFromTableName($tableName) {
        $parts = explode('_', $tableName, 2);
        $base = $parts[1] ?? $tableName;
    
        $baseParts = explode('_', $base);
    
        $camelCase = array_shift($baseParts);
    
        foreach ($baseParts as $part) {
            $camelCase .= ucfirst($part);
        }
    
        return $camelCase;
    }
    function roleViewType($roleId) {
        if(in_array($roleId, [1, 2, 3])) {
            return 'sysAdmin';
        } elseif($roleId == 4) {
            return 'owner';
        } elseif($roleId == 5) {
            return 'manager';
        } elseif($roleId == 6) {
            return 'staff';
        } else{
            return 'guest';
        }
    }
    function generateChecksum(array $data): string{
        // Sort the array by key (alphabetically)
        ksort($data);

        // Normalize values (e.g., trim and cast to string)
        $normalizedValues = array_map(function ($value) {
            return is_null($value) ? '' : trim((string)$value);
        }, $data);

        // Join values with a consistent separator (e.g., pipe)
        $inputString = implode('|', $normalizedValues);

        // Generate checksum (SHA-256)
        return hash('sha256', $inputString);
    }
    function acceptedPreAuthPayment($inputData){
        // check if the id is set
        $inputData['step'][] = 'acceptedPreAuthPayment()';

        if (isset($inputData['foodOrder']) && is_array($inputData['foodOrder'])) {
            if (isset($inputData['foodOrder'][0]) && is_array($inputData['foodOrder'][0])) {
                $inputData['foodOrder'] = $inputData['foodOrder'][0];
            }
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - validation';
        if(!isset($inputData['foodOrder']['id']) || empty($inputData['foodOrder']['id'])) {
            return ['status' => 'failed', 'message' => 'Order ID is required for pre-auth payment.'];
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - check accepted or rejected';
        //check if accepted or rejected 1 or 0 is set
        if(!isset($inputData['foodOrder']['accepted']) || !in_array($inputData['foodOrder']['accepted'], [0, 1])) {
            return ['status' => 'failed', 'message' => 'Accepted value is required for pre-auth payment.'];
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - set order status';
        // unset the accepted key
        if($inputData['foodOrder']['accepted'] == 0) {
            // if accepted is 0, then we will cancel the order
            $inputData['foodOrder']['orderStatus'] = 'cancelled';
            $inputData['step'][] = 'acceptedPreAuthPayment() - order status set to cancelled';
        }else{
            // if accepted is 1, then we will confirm the order
            $inputData['foodOrder']['orderStatus'] = 'confirmed';
            $inputData['step'][] = 'acceptedPreAuthPayment() - order status set to confirmed';
        }

        // unset the accepted key
        $inputData['step'][] = 'acceptedPreAuthPayment() - unsetting accepted key';
        unset($inputData['foodOrder']['accepted']);



        // get the payment intent id from the order
        $inputData['step'][] = 'acceptedPreAuthPayment() - getting payment intent id from order';
        $inputData['nextOperation'] = 'viewPaymentIntentOrderById';
        $inputData['id'] = $inputData['foodOrder']['id'];
        $res = executeDatabaseOperation($inputData);

        $inputData['step'][] = 'acceptedPreAuthPayment() - getting payment intent id from order';
        if($res['status'] !== 'success') {
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
            }
            return ['status' => 'failed', 'message' => $res['message']];
        }


        // check if the payment intent id is set
        if(!isset($res['data']['paymentIntentId']) || empty($res['data']['paymentIntentId'])) {
            // if debug mode is on, return the error
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => 'Payment intent ID is missing from the order.', 'step' => $inputData['step']];
            }else{
                return ['status' => 'failed', 'message' => 'Payment intent ID is missing from the order.'];
            }
        }
        
        // set the payment intent id in the inputData
        $inputData['step'][] = 'acceptedPreAuthPayment() - payment intent id found';
        $inputData['secure']['paymentIntentId'] = $res['data']['paymentIntentId'];


        // get the payment Account Id from tenant info
        $inputData['step'][] = 'acceptedPreAuthPayment() - getting tenant API key';
        $inputData['nextOperation'] = 'viewTenantInfo';
        $res = executeDatabaseOperation($inputData);

        if($res['status'] !== 'success') {
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
            }
            return ['status' => 'failed', 'message' => $res['message']];
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - tenant API key found';
        $inputData['secure']['stripeAccountKey'] = $res['tenantInfo']['paymentApiKey'] ?? null;


        $inputData['step'][] = 'acceptedPreAuthPayment() - stripe secret key found';
        if($inputData['foodOrder']['orderStatus'] == 'cancelled') {
            // if the order is cancelled, we will cancel the payment intent
            $inputData['step'][] = 'acceptedPreAuthPayment() - cancelling payment intent';
            $res = cancelPayment($inputData);
            if($res['status'] !== 'success') {
                if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
                }
                return ['status' => 'failed', 'message' => $res['message']];
            }
            $inputData['order']['stripe'] = $inputData['stripe'];


             $res = sendEmailCancelled($inputData);
                if($res['status'] !== 'success') {
                    if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                        return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step'], 'res' => $res];
                    }
                    return ['status' => 'failed', 'message' => $res['message']];
                }
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - processing confirmed order';
        if($inputData['foodOrder']['orderStatus'] == 'confirmed') {
            $inputData['step'][] = 'acceptedPreAuthPayment() - charging payment intent';
            // if the order is confirmed, we will charge the payment intent
            $res = chargePayment($inputData);
            if($res['status'] !== 'success') {
                if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
                }
                return ['status' => 'failed', 'message' => $res['message']];
            }

            $inputData['orderId'] = $inputData['foodOrder']['id'];

            $res = setUpReceipt($inputData);
            if($res['status'] !== 'success') {
                if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
                }
                return ['status' => 'failed', 'message' => $res['message']];
            }
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - updating order status';
        // set the next operation to update the order

        $res = updateSuccessful($inputData);
        $inputData['step'][] = 'acceptedPreAuthPayment() - order status updated';

        if($res['status'] !== 'success') {
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
            }
            return ['status' => 'failed', 'message' => $res['message']];
        }


        if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
            return ['status' => 'success', 'message' => 'Order pre-auth payment accepted successfully.', 'step' => $inputData['step'], 'data' => $inputData];
        }
        return ['status' => 'success', 'message' => 'Order pre-auth payment accepted successfully.', 'data' => $res['data']];
    }
    function chargePayment($inputData, $captureAmountInPence = null) {
        if (empty($inputData['secure']['paymentIntentId'])) {
            return ['status' => 'failed', 'message' => 'Payment intent ID is required'];
        }

        if (defined('TEST_ENV') && TEST_ENV) {
            return ['status' => 'success', 'message' => 'Test environment – not charging'];
        }

        require_once __DIR__ . '/../vendor/autoload.php';
        if (!class_exists('\Stripe\Stripe')) {
            return ['status' => 'failed', 'message' => 'Stripe dependency not available'];
        }
        \Stripe\Stripe::setApiKey($inputData['secure']['stripeSecretKey']);
        \Stripe\Stripe::setAccountId($inputData['secure']['stripeAccountKey'] ?? null);
        $piId = $inputData['secure']['paymentIntentId'];

        try {
            $pi = \Stripe\PaymentIntent::retrieve($piId);

            if ($pi->status === 'requires_confirmation') {
                $pi = $pi->confirm(); // only if client didn’t confirm
            }

            if ($pi->status === 'requires_capture') {
                $captureParams = [];
                if (is_int($captureAmountInPence)) {
                    $captureParams['amount_to_capture'] = max(1, $captureAmountInPence);
                }
                $pi = $pi->capture($captureParams);
            }

            if ($pi->status === 'succeeded') {
                // last charge ID is available in the PaymentIntent object
                $inputData['secure']['chargeId'] = $pi->latest_charge;
                // url of receipt
                $inputData['secure']['receiptUrl'] = $pi->charges->data[0]->receipt_url ?? null;


                $res = updateWithChargeId($inputData);
                if ($res['status'] !== 'success') {
                    return ['status' => 'failed', 'message' => $res['message']];
                }

                return ['status' => 'success', 'message' => 'Payment charged successfully'];

            }

            return ['status' => 'failed', 'message' => "Cannot charge payment in status '{$pi->status}'"];
        } catch (\Stripe\Exception\ApiErrorException $e) {
            return ['status' => 'failed', 'message' => $e->getMessage()];
        }
    }
    function cancelPayment(&$inputData, $cancellationReason = 'abandoned') {
        // Validate
        if (empty($inputData['secure']['paymentIntentId'])) {
            return ['status' => 'failed', 'message' => 'Payment intent ID is required for cancelling payment.'];
        }

        // Respect test mode
        if (defined('TEST_ENV') && TEST_ENV) {
            return ['status' => 'success', 'message' => 'Test environment – not cancelling.'];
        }

        require_once __DIR__ . '/../vendor/autoload.php';
        if (!class_exists('\Stripe\Stripe')) {
            return ['status' => 'failed', 'message' => 'Stripe dependency not available'];
        }

        \Stripe\Stripe::setApiKey($inputData['secure']['stripeSecretKey']);
        \Stripe\Stripe::setAccountId($inputData['secure']['stripeAccountKey'] ?? null);
        $piId = $inputData['secure']['paymentIntentId'];

        // If you created the PI on a connected account directly, set this:
        // $opts = ['stripe_account' => $inputData['secure']['shopStripeAccountId']];
        $opts = [];

        try {
            /** @var \Stripe\PaymentIntent $pi */
            $pi = \Stripe\PaymentIntent::retrieve($piId, $opts);

            // If already cancelled, we're done
            if ($pi->status === 'canceled') {
                return ['status' => 'success', 'message' => 'Payment already canceled (hold released).'];
            }

            // Allowed-to-cancel (releases the hold) — do NOT refund
            $cancellable = [
                'requires_capture',       // auth placed, waiting for capture
                'requires_confirmation',  // not confirmed yet
                'requires_payment_method',
                'requires_action',
                'processing',             // may cancel depending on timing/method
            ];

            if (in_array($pi->status, $cancellable, true)) {
                $pi = $pi->cancel(['cancellation_reason' => $cancellationReason], $opts);

                $inputData['orderId'] = $inputData['foodOrder']['id'] ?? null;
                $inputData['receipt'] = "enabled";
                $res = viewFullOrderDetails($inputData);
                if ($res['status'] !== 'success') {
                    return ['status' => 'failed', 'message' => $res['message']];
                }
                $order = $res['orderDetails'][0] ?? null;
                $inputData['order']   = $order;
                $inputData['stripe']  = $pi;

                return ['status' => 'success', 'message' => 'Authorization hold released (payment canceled).'];
            }

            // If already captured, do NOT refund (per your rule)
            if ($pi->status === 'succeeded') {

                $res = updateCancelled($inputData);
                if ($res['status'] !== 'success') {
                    return ['status' => 'failed', 'message' => $res['message']];
                }

                // If already captured, do NOT refund (per your rule)
                return [
                    'status'  => 'failed',
                    'message' => 'Payment already captured; cannot release hold without refund (refunds are disabled).'
                ];
            }
            
            $inputData['stripe']    = $pi;

            // Any other odd status
            return [
                'status'  => 'failed',
                'message' => "Cannot cancel payment in status '{$pi->status}'."
            ];
        } catch (\Stripe\Exception\ApiErrorException $e) {
            return ['status' => 'failed', 'message' => 'Stripe error: ' . $e->getMessage()];
        } catch (\Exception $e) {
            return ['status' => 'failed', 'message' => 'Error: ' . $e->getMessage()];
        }
    }
    function money($n): string { 
        return '£' . number_format((float)($n ?? 0), 2, '.', ''); 
    }
    function aget(array $arr, string $key, $default = null) { 
        return array_key_exists($key, $arr) ? $arr[$key] : $default; 
    }
    function currentHost(): string {
        return preg_replace('#^https?://#i', '', (string)($_SERVER['HTTP_HOST'] ?? $_SERVER['SERVER_NAME'] ?? 'localhost'));
    }
    function apexDomain(string $host): string {
        $h = strtolower(preg_replace('/[^a-z0-9.\-]/i', '', $host));
        $parts = array_values(array_filter(explode('.', $h)));
        $n = count($parts);
        if ($n < 2) return $h ?: 'localhost';
        $tld = $parts[$n-1];
        $sld = $parts[$n-2];
        $ukLike = ($tld === 'uk' && in_array($sld, ['co','org','ac','gov','ltd','plc','net'], true));
        $keep = $ukLike && $n >= 3 ? 3 : 2;
        return implode('.', array_slice($parts, -$keep));
    }
    if (!function_exists('str_contains')) {
        function str_contains(string $haystack, string $needle): bool {
            return $needle === '' || strpos($haystack, $needle) !== false;
        }
    }
    if (!function_exists('str_starts_with')) {
        function str_starts_with(string $haystack, string $needle): bool {
            return $needle === '' || strpos($haystack, $needle) === 0;
        }
    }
    if (!function_exists('str_ends_with')) {
        function str_ends_with(string $haystack, string $needle): bool {
            if ($needle === '') return true;
            $len = strlen($needle);
            return substr($haystack, -$len) === $needle;
        }
    }
    if (!function_exists('esc')) {
        function esc($s): string {
            return htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
        }
    }
    if (!function_exists('money_major')) {
        function money_major(int $minor, string $currency = 'GBP'): string {
            $sign  = $minor < 0 ? '-' : '';
            $abs   = abs($minor);
            $major = number_format($abs / 100, 2, '.', ',');
            // Simple currency symbol map; extend if needed
            $sym = [
                'GBP' => '£', 'USD' => '$', 'EUR' => '€'
            ][$currency] ?? '';
            return "{$sign}{$sym}{$major}";
        }
    }
    if (!function_exists('money_static')) {
        function money_static(float $major, string $currency = 'GBP'): string {
            $sign  = $major < 0 ? '-' : '';
            // make sure the formmat is correct with 2 decimal places but the value could be passed as 79 or 79.5 or 79.00
            $major = number_format($major, 2, '.', ',');
            // Simple currency symbol map; extend if needed
            $sym = [
                'GBP' => '£', 'USD' => '$', 'EUR' => '€'
            ][$currency] ?? '';
            return "{$sign}{$sym}{$major}";
        }
    }
    if (!function_exists('deriveCustomerEmail')) {
        function deriveCustomerEmail(array $inputData): ?string {
            // Try the most likely keys first; extend as needed for your payloads
            $candidates = [
                $inputData['order']['customerEmail'] ?? null,
                $inputData['order']['email'] ?? null,
                $inputData['order']['customer']['email'] ?? null,
                $inputData['customerEmail'] ?? null,
                $inputData['customer']['email'] ?? null,
                $inputData['email'] ?? null,
                $inputData['secure']['customerEmail'] ?? null,
                $inputData['order']['userEmail'] ?? null,
                $inputData['userEmail'] ?? null
            ];
            foreach ($candidates as $e) {
                $e = is_string($e) ? trim($e) : '';
                if ($e !== '') return $e;
            }
            return null;
        }
    }
    function normalizePounds(string $v): string {
        // Remove £, commas, spaces; ensure exactly 2 dp
        $s = preg_replace('/[£,\s]/', '', trim((string)$v));
        if ($s === '' || $s === '.') return '0.00';
        if (strpos($s, '.') === false) $s .= '.00';
        [$i, $d] = array_pad(explode('.', $s, 2), 2, '0');
        $d = substr(str_pad($d, 2, '0'), 0, 2);
        if ($i === '' || $i === '-') $i .= '0';
        return ltrim($i, '+') . '.' . $d;
    }
    function money_add(string $a, string $b): string {
        if (function_exists('bcadd')) return bcadd(normalizePounds($a), normalizePounds($b), 2);
        // fallback: do safe integer math behind the scenes (still returns string)
        return money_int_to_str(money_str_to_int($a) + money_str_to_int($b));
    }
    function money_sub(string $a, string $b): string {
        if (function_exists('bcsub')) return bcsub(normalizePounds($a), normalizePounds($b), 2);
        return money_int_to_str(money_str_to_int($a) - money_str_to_int($b));
    }
    function money_mul(string $a, int $qty): string {
        if (function_exists('bcmul')) return bcmul(normalizePounds($a), (string)$qty, 2);
        return money_int_to_str(money_str_to_int($a) * $qty);
    }
    // fallback integer converters (hidden, no "minor" naming in your app)
    function money_str_to_int(string $v): int {
        $s = normalizePounds($v);
        [$i,$d] = explode('.', $s, 2);
        $neg = str_starts_with($i, '-');
        $i = ltrim($i, '-');
        $n = (int)($i . $d);
        return $neg ? -$n : $n;
    }
    function money_int_to_str(int $n): string {
        $neg = $n < 0 ? '-' : '';
        $n = abs($n);
        $i = intdiv($n, 100);
        $d = $n % 100;
        return $neg . $i . '.' . str_pad((string)$d, 2, '0', STR_PAD_LEFT);
    }
    // Display helper (keeps your currency flag; symbol optional)
    function format_pounds_str(string $v, string $currency = ''): string {
        $n = normalizePounds($v);
        if ($currency === 'GBP') return '£' . $n; // or "GBP $n" if you prefer codes
        return $n; // default: bare number "79.00"
    }
    function build_delivery_address_html(array $order): string{
        // Try normalized array
        $addr = $order;

        // If JSON string (possibly HTML-escaped), decode it
        if (!$addr && !empty($order['delivery_address_json'])) {
            $json = html_entity_decode((string)$order['delivery_address_json'], ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
            $decoded = json_decode($json, true);
            if (is_array($decoded)) $addr = $decoded;
        }

        if (!$addr || !is_array($addr)) return '';

        $parts = array_filter([
            $addr['streetAddress'] ?? $addr['line1'] ?? null,
            $addr['line2'] ?? null,
            implode(', ', array_filter([$addr['city'] ?? null, $addr['county'] ?? null])),
            $addr['postcode'] ?? null,
            $addr['country'] ?? null,
        ], fn($x) => (string)$x !== '');

        if (!$parts) return '';

        $lines = implode("<br>", array_map('esc', $parts));

        return <<<HTML
            <h3 style="margin:24px 0 8px;">Delivery Address</h3>
            <p style="margin:0 0 12px;line-height:1.5;">{$lines}</p>
            HTML;
    }
    function computeNoReplyFrom(?string $fallbackDomain = null): string {
        $host = currentHost();
        $apex = apexDomain($host);
        if ($apex === 'localhost') $apex = ($fallbackDomain ?: 'example.com');
        return "no-reply@{$apex}";
    }
    function computeBaseUrl(): string {
        $https  = $_SERVER['HTTPS'] ?? '';
        $scheme = (!empty($https) && strtolower($https) !== 'off') ? 'https' : 'http';
        return $scheme . '://' . currentHost();
    }
    function absolutizeUrl(string $url, string $base): string {
        if (preg_match('#^https?://#i', $url)) return $url;
        if (strpos($url, '//') === 0) {
            $scheme = parse_url($base, PHP_URL_SCHEME) ?: 'https';
            return $scheme . ':' . $url;
        }
        return rtrim($base, '/') . '/' . ltrim($url, '/');
    }
    function buildTrackUrl(array $order, ?string $baseUrl = null): string {
        $base = $baseUrl ?: computeBaseUrl();
        // strip admin. subdomain if present
        $updatedBase = preg_replace('/admin\./i', '', $base);
        if ($updatedBase) $base = $updatedBase;
        // build query
        $q = http_build_query([
            'orderId' => aget($order, 'id', ''),
            'email'   => aget($order, 'userEmail', ''),
        ]);
        return rtrim($base, '/') . '/order-confirmed?' . $q;
    }
    function buildAddressHtml(array $order): string {
        if (strtolower((string)aget($order, 'orderType', '')) !== 'delivery') return '';
        $d = (array) aget($order, 'delivery', []);
        if (!$d) return '';

        return '
        <table style="width:100%;border-collapse:collapse;">
        <tr>
            <td style="padding:12px 0 0">
            <h3 style="margin:0 0 8px;font-size:16px;color:#111">Delivery Address</h3>
            <p style="margin:0;line-height:1.5;color:#444">'.
                esc(aget($d,'address_line_1','')).'<br>'.
                (aget($d,'address_line_2') ? esc(aget($d,'address_line_2')).'<br>' : '').
                esc(aget($d,'city','')).(aget($d,'county') ? ', '.esc(aget($d,'county')) : '').'<br>'.
                esc(aget($d,'postal_code','')).'<br>'.
                esc(aget($d,'country','')).'
            </p>
            </td>
        </tr>
        </table>';
    }
    function buildItemsHtml(array $order): string {
        $items = (array) aget($order, 'details', []);
        if (!$items) return '<tr><td style="padding:8px 0;color:#666">No items.</td></tr>';
        $html = '';
        foreach ($items as $item) {
            $extrasHtml = '';
            $extras = (array) aget($item, 'extras', []);
            if ($extras) {
                $parts = array_map(function($ex){
                    return '<div>+ '.esc(aget($ex,'extraName','')).' (x'.((int)aget($ex,'extraQuantity',1)).', '.money(aget($ex,'extraPrice',0)).')</div>';
                }, $extras);
                $extrasHtml = '<div style="margin-top:4px;color:#666;font-size:13px">'.implode('', $parts).'</div>';
            }
            $html .= '
            <tr><td style="padding:8px 0;border-bottom:1px solid #eee;">
            <div style="display:flex;justify-content:space-between;gap:12px">
                <div><div style="font-weight:600;color:#111">'.esc(aget($item,'itemQuantity',1)).' × '.esc(aget($item,'itemName','')).'</div>'.$extrasHtml.'</div>
                <div style="white-space:nowrap">'.money(aget($item,'itemModifiedPrice',0)).'</div>
            </div>
            </td></tr>';
        }
        return $html;
    }
    function buildTotalsHtml(array $order): array {     
        $grandTotal    = (float) aget($order, 'totalOrderModifiedPrice', 0);
        $deliveryFee   = (float) aget($order, 'deliveryFee', 0);
        $serviceFee    = (float) aget($order, 'orderFee', 0);
        $smallOrderFee = (float) aget($order, 'smallOrderFee', 0);
        $subtotal      = $grandTotal - $deliveryFee - $serviceFee - $smallOrderFee;

        $rows = [
            ['Subtotal', $subtotal, true],
            ['Delivery Fee', $deliveryFee, $deliveryFee > 0],
            ['Service Fee', $serviceFee, $serviceFee > 0],
            ['Small Order Fee', $smallOrderFee, $smallOrderFee > 0],
        ];
        $html = '';
        foreach ($rows as [$label,$value,$show]) {
            if (!$show) continue;
            $html .= '<tr><td style="padding:6px 0;color:#444">'.esc($label).'</td><td style="padding:6px 0;text-align:right;color:#444">'.money($value).'</td></tr>';
        }
        $html .= '<tr><td style="padding-top:10px;border-top:1px solid #ddd;font-weight:700;color:#111">Total</td><td style="padding-top:10px;border-top:1px solid #ddd;text-align:right;font-weight:700;color:#111">'.money($grandTotal).'</td></tr>';
        return [$html, $grandTotal];
    }
    function buildEmailReceiptHtml(array $order, array $brand = []): string{
        $brandName    = aget($brand, 'companyName', '');
        $companyName  = aget($brand, 'companyName', '');
        $companyNumber = aget($brand, 'companyNumber', '');
        $addressPlain  = aget($brand, 'addressPlain', '');

        $supportEmail = aget($brand, 'supportEmail', 'support@example.com');
        $orderId      = aget($order, 'id', aget($order, 'order_id', ''));

        if($order['orderType'] === 'delivery'){
            $order['deliveryAddressHtml'] = buildAddressHtml($order);
        } else{
            $order['deliveryAddressHtml'] = '';
        }

        // --- Total (GBP string) ---
        $rawTotal = aget($order, 'totalOrderModifiedPrice', aget($order, 'total', '0.00'));
        $total    = normalizePounds($rawTotal);

        // --- Build items ---
        $items = [];
        if (!empty($order['details']) && is_array($order['details'])) {
            foreach ($order['details'] as $row) {
                $items[] = [
                    'name'     => aget($row, 'itemName', ''),
                    'price'    => normalizePounds(aget($row, 'itemModifiedPrice', '0.00')),
                    'quantity' => (int) aget($row, 'itemQuantity', 1),
                    'note'     => aget($row, 'itemNote', ''),
                    // add 'extras' here if you want them displayed
                ];
            }
        }

        //error_log(print_r($order, true));

        // --- Context for renderer ---
        $ctx = [
            'companyAddress'    => $addressPlain,
            'currency'          => '', // suppress symbols
            'tenant'            => [
                'companyName'       => $companyName, 
                'companyNumber'     => $companyNumber,
                'companyAddress'    => $addressPlain,
                'companyVat'        => aget($brand, 'companyVat', ''),
                'companyEmail'      => aget($brand, 'supportEmail', ''),
                'companyPhone'      => aget($brand, 'supportPhone', ''),
            ],
            'order'             => [
                'deliveryAddressHtml'   => $order['deliveryAddressHtml'] ?? '',
                'userEmail'             => aget($order, 'userEmail', ''),
                'id'                    => $orderId,
                'total'                 => $total,
                'type'                  => aget($order, 'orderType', ''),
                'deliveryFee'           => normalizePounds(aget($order,'deliveryFee','0.00')),
                'smallOrderFee'         => normalizePounds(aget($order,'smallOrderFee','0.00')),
                'orderFee'              => normalizePounds(aget($order,'orderFee','0.00')), // service fee
                'items'                 => $items,
            ],
            'paymentId'    => $order['paymentId'] ?? null,
            'plan' => [],
        ];
        //error_log(print_r($order, true));

        return renderEmail('receipt', $ctx);
    }
    function generateReceiptEmailFromOrder(array $order, array $brand = [], ?string $tenantReplyTo = null): array {
        return [
            'from'     => computeNoReplyFrom(),                                 // e.g. no-reply@yourdomain.tld
            'to'       => (string) aget($order,'userEmail',''),
            'subject'  => 'Your receipt for Order #'.(string) aget($order,'id',''),
            'html'     => buildEmailReceiptHtml($order, $brand),
            'replyTo'  => $tenantReplyTo,                                       // optional
            'fromName' => aget($brand,'name','Waitron'),
        ];
    }
    function setUpReceipt(array &$inputData): array {
        $inputData['step'][] = 'setUpReceipt()';
        if (empty($inputData['orderId'])) {
            return ['status' => 'failed', 'message' => 'Order ID is required.'];
        }

        $inputData['receipt']   = 'enabled';
        $inputData['viewLevel'] = 'full';
        $orderRes = viewFullOrderDetails($inputData); // <-- your function

        $inputData['step'][] = 'setUpReceipt() - order details fetched';
        if (!is_array($orderRes) || ($orderRes['status'] ?? 'failed') !== 'success') {
            return ['status' => 'failed', 'message' => $orderRes['message'] ?? 'Order lookup failed.'];
        }

        $inputData['step'][] = 'setUpReceipt() - order details found';
        $orderList = $orderRes['orderDetails'][0] ?? $orderRes['data']['orderDetails'][0] ?? [];
        $order     = is_array($orderList) ? ($orderList ?? []) : (array)$orderList;
        if (!$order) {
            return ['status' => 'failed', 'message' => 'Order not found.'];
        }

        $inputData['step'][] = 'setUpReceipt() - generating email payload';
        // Pass brand + reply-to via $inputData (consistent with your pattern)


        $res = getTenantDetails($inputData);
        if ($res['status'] !== 'success') {
            return ['status' => 'failed', 'message' => $res['message'] ?? 'Failed to get tenant details'];
        }

        $res = shopAddress($inputData);
        if ($res['status'] !== 'success') {
            return ['status' => 'failed', 'message' => $res['message'] ?? 'Failed to get shop address'];
        }

        $address = $res['data']['contact_value'];

        $formattedAddress = formatShopAddressForEmail($address);
        // replace $formattedAddress <br> with , space for plain text version
        $formattedAddressPlain = str_replace('<br>', ', ', $formattedAddress); 
        // formatted address lines

        $brand = [
            'name'          => aget($inputData,'brandName','Waitron'),
            'color'         => aget($inputData,'brandColor','#0b5fff'),
            'logo'          => aget($inputData,'brandLogo','/images/logo.png'),
            'companyName'   => $inputData['tenantDetails']['companyName'],
            'companyNumber' => $inputData['tenantDetails']['companyNumber'],
            'addressPlain'  => $formattedAddressPlain,
            'paymentId'     => $inputData['secure']['paymentIntentId'] ?? null,
        ];

        $orderList['paymentId'] = $inputData['secure']['paymentIntentId'] ?? null;

        $inputData['step'][] = 'setUpReceipt() - brand info prepared';
        $tenantReplyTo = aget($inputData,'tenantReplyTo',null);


        $inputData['step'][] = 'setUpReceipt() - generating email payload';
        $emailPayload = generateReceiptEmailFromOrder($orderList, $brand, $tenantReplyTo);
        // error log the payload of the email for debugging
        //error_log('Receipt email payload: ' . print_r($emailPayload, true));

        // Send email (choose method as per your setup)
        // if test mode, skip sending
        if (defined('TEST_ENV') && TEST_ENV) {
            $inputData['step'][] = 'setUpReceipt() - test environment, skipping email send';
            $emailSent = false;
        } else {
            $inputData['step'][] = 'setUpReceipt() - sending email via cPanel SMTP';
            $send = sendEmailGeneric(
                $emailPayload['to'],
                $emailPayload['subject'],
                $emailPayload['html'],
                [
                    'fromName'  => $emailPayload['fromName'] ?? 'Your Shop',
                    'fromEmail' => $emailPayload['from']     ?? computeNoReplyFrom(),
                    'replyTo'   => $emailPayload['replyTo']  ?? ($emailPayload['from'] ?? computeNoReplyFrom()),
                ]
            );
        }

        $inputData['step'][] = 'setUpReceipt() - email send attempted';

        return [
            'status'       => 'success',
            'message'      => 'Receipt built.',
            'data'         => $orderRes,
            'emailPayload' => $emailPayload,
        ];
    }
    function sendEmailCancelled(array $inputData): array {
        try {
            // ── Enrich PLAN for the cancelled block (optional but nice)
            // Pull authReleaseDays from tenant or payload (1–10) if available
            $days = (int) (aget($inputData, 'tenant.authReleaseDays', 0)
                        ?: aget($inputData, 'cancelEmailOpts.authReleaseDays', 0));
            if ($days >= 1 && $days <= 10) {
                $inputData['plan']['authReleaseDays'] = $days;
            }

            // If we have a Stripe PI (from cancelPayment), surface amount/currency/reason
            if (isset($inputData['stripe']) && is_object($inputData['stripe'])) {
                $pi = $inputData['stripe']; // \Stripe\PaymentIntent
                if (isset($pi->amount))   $inputData['plan']['authorisedMinor'] = (int)$pi->amount;     // minor
                if (isset($pi->currency)) $inputData['order']['currency']       = strtoupper($pi->currency);
                if (isset($pi->cancellation_reason) && !isset($inputData['plan']['reason'])) {
                    $inputData['plan']['reason'] = (string)$pi->cancellation_reason;
                }
            }

            // Ensure we at least have an order id + recipient
            $orderId = (string) ($inputData['order']['id']
                    ?? $inputData['foodOrder']['id']
                    ?? $inputData['orderId']
                    ?? '');
            if ($orderId === '') return ['status'=>'failed','message'=>'Order ID is required for cancelled email'];

            $to = deriveCustomerEmail($inputData);
            if (!$to) return ['status'=>'failed','message'=>'No customer email'];

            // Build brand (company info + address) for header/footer
            $res = getTenantDetails($inputData);
            if (($res['status'] ?? '') !== 'success') return ['status'=>'failed','message'=>$res['message'] ?? 'Failed to get tenant details'];
            $tenant = $res['tenantDetails'] ?? [];

            $adr = shopAddress($inputData);
            if (($adr['status'] ?? '') !== 'success') return ['status'=>'failed','message'=>$adr['message'] ?? 'Failed to get shop address'];
            $formattedAddressPlain = str_replace('<br>', ', ', formatShopAddressForEmail($adr['data']['contact_value'] ?? ''));

            $inputData['plan']['paymentId'] = $inputData['secure']['paymentIntentId'];

            $brand = [
                'companyName'   => $tenant['companyName']   ?? '',
                'companyNumber' => $tenant['companyNumber'] ?? '',
                'addressPlain'  => $formattedAddressPlain,
                'supportEmail'  => $tenant['supportEmail']  ?? '',
                'supportPhone'  => $tenant['phone']         ?? '',
                'companyVat'    => $tenant['companyVat']    ?? '',
                'name'          => $tenant['companyName']   ?? 'Waitron',
            ];

            // Assemble the pipeline ctx (minimal order is fine)
            $ctx = [
                'brand'        => $brand['companyName'],
                'companyAddress'=> $brand['addressPlain'],
                'tenant'       => $brand,
                'order'        => [
                    'id'       => $orderId,
                    'currency' => $inputData['order']['currency'] ?? 'GBP',
                    // include an optional cancel reason if you have one in the payload
                    'cancellation' => ['reason' => aget($inputData, 'order.cancellation.reason', '')],
                ],
                'plan'         => $inputData['plan'] ?? [],
                'currency'     => $inputData['order']['currency'] ?? 'GBP',
                'timezone'     => $inputData['tenant']['timezone'] ?? 'Europe/London',
                'paymentId'    => $inputData['plan']['paymentId'] ?? ($inputData['order']['payment']['stripePaymentIntent'] ?? null),

            ];

            $html     = renderEmail('cancelled', $ctx);
            $subject  = "Order #{$orderId} cancelled – " . ($brand['companyName'] ?: 'Your Restaurant');

            return sendEmailGeneric(
                $to,
                $subject,
                $html,
                [
                    'fromName'  => $brand['companyName'] ?: 'Your Shop',
                    'fromEmail' => computeNoReplyFrom(),
                    'replyTo'   => $brand['supportEmail'] ?: computeNoReplyFrom(),
                ]
            );
        } catch (Throwable $e) {
            error_log('[Email Cancelled] '.$e->getMessage());
            return ['status' => 'failed', 'message' => 'Exception: '.$e->getMessage()];
        }
    }
    function buildPaymentSummaryCancelled(array $data, array $opts = []): string {
        $currency   = aget($data, 'totals.currency', 'GBP');
        $symbol     = $currency === 'USD' ? '$' : ($currency === 'EUR' ? '€' : '£');

        $subtotal   = (float) aget($data, 'totals.subtotal', 0);
        $delivery   = (float) aget($data, 'totals.delivery', 0);
        $service    = (float) aget($data, 'totals.serviceFee', 0);
        $discount   = (float) aget($data, 'totals.discount', 0);

        // Authorised amount, if known; fallback to totals.total; otherwise null (unknown)
        $authAmount = aget($data, 'payment.authorisedAmount', null);
        if ($authAmount === null && isset($data['totals']['total'])) {
            $authAmount = (float) $data['totals']['total'];
        }

        $showBreakdown = (bool) aget($opts, 'showBreakdown', false);

        $authDaysOpt  = aget($opts, 'authReleaseDays');
        if (is_numeric($authDaysOpt) && $authDaysOpt >= 1 && $authDaysOpt <= 10) {
            $releaseMsg = "Your bank typically releases card holds within {$authDaysOpt} working days.";
        } else {
            $releaseMsg = "Your bank typically releases card holds within 3–10 working days.";
        }

        $money = function($n) use ($symbol) {
            return $symbol . number_format((float)$n, 2);
        };

        $breakdownRows = '';
        if ($showBreakdown) {
            $breakdownRows = '
                <tr><td style="padding:6px 0;color:#444">Items</td>
                    <td style="padding:6px 0;text-align:right;color:#111">'.$money($subtotal).'</td></tr>'
                . ($delivery ? '
                <tr><td style="padding:6px 0;color:#444">Delivery</td>
                    <td style="padding:6px 0;text-align:right;color:#111">'.$money($delivery).'</td></tr>' : '')
                . ($service ? '
                <tr><td style="padding:6px 0;color:#444">Service fee</td>
                    <td style="padding:6px 0;text-align:right;color:#111">'.$money($service).'</td></tr>' : '')
                . ($discount ? '
                <tr><td style="padding:6px 0;color:#444">Discounts</td>
                    <td style="padding:6px 0;text-align:right;color:#111">-'.$money($discount).'</td></tr>' : '');
        }

        $authRow = $authAmount !== null
            ? '<tr><td style="padding:4px 0;color:#444">Card authorisation</td>
                <td style="padding:4px 0;text-align:right;color:#444">'.$money($authAmount).'</td></tr>'
            : '';

        return '
        <h3 style="margin:0 0 8px;font-size:16px;color:#111">Payment status</h3>
        <table role="presentation" width="100%" cellspacing="0" cellpadding="0" style="border-collapse:collapse">
        '.$breakdownRows.'
        <tr>
            <td style="padding:8px 0;font-weight:bold;color:#111">Total charged</td>
            <td style="padding:8px 0;text-align:right;font-weight:bold;color:#111">'.$money(0).'</td>
        </tr>
        '.$authRow.'
        </table>
        <p style="margin:8px 0 0;line-height:1.5;color:#444">
        No payment was captured. The authorisation hold has been cancelled; '.$releaseMsg.'
        </p>';
    }
    function sendCancelledEmail_viaMail(array $inputData, ?string $html = null): array{
        if (defined('TEST_ENV') && TEST_ENV) {
            error_log('[Email] Skipped sending cancelled/refund (TEST_ENV=true)');
            return ['status' => 'success', 'message' => 'Test environment – email not sent'];
        }

        $customerEmail = deriveCustomerEmail($inputData);
        if (!$customerEmail) {
            error_log('[Email] No customer email found in inputData for cancelled/refund');
            return ['status' => 'failed', 'message' => 'No customer email'];
        }

        $orderId   = $inputData['order']['id'] ?? '';
        $brand     = $inputData['tenant']['companyName'] ?? 'Your Shop';
        $type      = $inputData['refundType'] ?? 'cancelled';
        $subjectMap = [
            'full'      => "Your full refund for order #{$orderId} – {$brand}",
            'partial'   => "Your partial refund for order #{$orderId} – {$brand}",
            'itemBased' => "Item refund for order #{$orderId} – {$brand}",
            'cancelled' => "Order #{$orderId} cancelled – {$brand}",
        ];
        $subject   = $subjectMap[$type] ?? "Update on order #{$orderId} – {$brand}";
        $fromName  = $brand;
        $fromEmail = $inputData['tenant']['noreplyEmail'] ?? ($inputData['tenant']['supportEmail'] ?? 'no-reply@example.com');

        $html = $html ?? buildCancelledEmail_FromInputData($inputData);

        //error_log(sprintf('[Email] Sending %s email to %s for order #%s', $type, $customerEmail, (string)$orderId));
        $res = sendEmailGeneric(
            $customerEmail,
            $subject,
            $html,
            [
                'fromName'  => $fromName,
                'fromEmail' => $fromEmail,
                'replyTo'   => ($inputData['tenant']['supportEmail'] ?? $fromEmail),
            ]
        );

        if (($res['status'] ?? 'failed') !== 'success') {
            error_log('[Email] Cancelled/refund send failed: ' . ($res['message'] ?? 'unknown'));
        } else {
            //error_log('[Email] Cancelled/refund sent OK');
        }

        return $res;
    }
    function formatShopAddressForEmail(string $raw, bool $asHtml = true): string{
        // 1) Turn &quot; etc. into real characters
        $json = html_entity_decode($raw, ENT_QUOTES | ENT_HTML5, 'UTF-8');

        // 2) Decode JSON -> array
        $data = json_decode($json, true);
        if (!is_array($data)) {
            // Fallback: return the raw string safely
            return $asHtml
                ? htmlspecialchars($raw, ENT_QUOTES | ENT_HTML5, 'UTF-8')
                : preg_replace('/\s+/', ' ', strip_tags($raw));
        }

        // 3) Pull + trim fields
        $street  = trim((string)($data['streetAddress'] ?? ''));
        $city    = trim((string)($data['city'] ?? ''));
        $county  = trim((string)($data['county'] ?? ''));
        $pc      = strtoupper(trim((string)($data['postcode'] ?? '')));
        $country = trim((string)($data['country'] ?? ''));

        // 4) UK postcode: ensure correct space (e.g., "PO29HF" -> "PO2 9HF")
        if ($pc !== '') {
            $pc = preg_replace('/^([A-Z]{1,2}\d{1,2}[A-Z]?)\s*(\d[A-Z]{2})$/i', '$1 $2', $pc);
        }

        // 5) Build lines (skip empties)
        $lines = array_values(array_filter([$street, $city, $county, $pc, $country], fn($v) => $v !== ''));

        // 6) Output for email
        if ($asHtml) {
            // escape each line for HTML emails
            $safeLines = array_map(fn($v) => htmlspecialchars($v, ENT_QUOTES | ENT_HTML5, 'UTF-8'), $lines);
            return implode('<br>', $safeLines);
        }
        return implode("\n", $lines);
    }
    function calculateRefundPlan(&$inputData) {
        // 0) Basic presence checks
        if (empty($inputData['orderId'])) {
            return ['status' => 'failed', 'message' => 'Order ID is required'];
        }

        //error_log('[Refund] Starting refund for order ID ' . $inputData['orderId']);
        $inputData['id'] = $inputData['orderId'];

        // 1) Fetch payment intent id for this order
        $res = viewPaymentIntentOrderById($inputData);
        if (($res['status'] ?? 'failed') !== 'success') {
            return ['status' => 'failed', 'message' => $res['message'] ?? 'Failed to get order details'];
        }
        $piId = $res['data']['paymentIntentId'] ?? null;
        if (empty($piId)) {
            return ['status' => 'failed', 'message' => 'Payment intent ID is required'];
        }

        // 2) Tenant (connected account) info
        $res = viewTenantInfo($inputData);
        if (($res['status'] ?? 'failed') !== 'success') {
            return ['status' => 'failed', 'message' => $res['message'] ?? 'Failed to get tenant details'];
        }
        $connectedAccount = $res['tenantInfo']['paymentApiKey'] ?? null;

        // 3) Keys present?
        if (empty($inputData['secure']['stripeSecretKey'])) {
            return ['status' => 'failed', 'message' => 'Stripe secret key is required'];
        }
        if (empty($connectedAccount)) {
            return ['status' => 'failed', 'message' => 'Stripe account key is required'];
        }

        // 4) Determine refund type
        $refundType = $inputData['refundType'] ?? 'full';

        // 4a) Item-based -> just normalize for now (no amount calc yet)
        if ($refundType === 'itemBased') {
            $items = $inputData['orderItems'] ?? null;
           
            if (!is_array($items)) {
                return ['status' => 'failed', 'message' => 'orderItems must be an array of {id, qty} objects'];
            }
            $validated = [];

            $totalRefundAmount = 0.00;

            $messageForRefund = '';

            foreach ($items as $entry) {
                if (!isset($entry['id'])) {
                    return ['status' => 'failed', 'message' => 'Each order item must contain an "id"'];
                }
                $id  = (string)$entry['id'];
                $qty = $entry['qty'] ?? 1; // default 1
                if (!ctype_digit($id) || !ctype_digit($qty)) {
                    return ['status' => 'failed', 'message' => 'id and qty must be integers'];
                }
                $id  = (int)$id;
                $qty = (int)$qty;
                if ($id <= 0 || $qty <= 0) {
                    return ['status' => 'failed', 'message' => 'id and qty must be positive integers'];
                }
                // validate the item exists in the order and qty is not more than ordered
                $found = false;
                $inputData['itemValidation']['id'] = $id;
                $inputData['itemValidation']['qty'] = $qty;
                $inputData['itemValidation']['orderId'] = $inputData['orderId'];
                $res = validateOrderItemForRefund($inputData);
                if (($res['status'] ?? 'failed') !== 'success') {
                    return ['status' => 'failed', 'message' => $res['message'] ?? 'Failed to validate order item'];
                }

                $itemModifiedPrice      = $inputData['itemValidation']['itemModifiedPrice']    ?? null;
                $itemOrderQty           = $inputData['itemValidation']['orderedQty']           ?? null;  
                $itemBasePrice          = $inputData['itemValidation']['itemBasePrice']        ?? null;
                $itemModifiedReason     = $inputData['itemValidation']['itemModifiedReason']   ?? null;
                $refundQty              = $inputData['itemValidation']['refundQty']            ?? null;

                // calculate refund amount as we now have item price/qty
                $refundAmount        = (int) round($qty * $itemBasePrice);

                if ($itemModifiedPrice !== null && $refundAmount > $itemModifiedPrice) {
                    return ['status' => 'failed', 'message' =>
                        "Requested refund amount (£" . number_format($refundAmount / 100, 2) .
                        ") exceeds remaining refundable (£" . number_format($itemModifiedPrice / 100, 2) .
                        ") for Item ID $id"];
                }

                // set a new modified price if itemModifiedPrice is set (partial refund of item)
                if ($itemModifiedPrice !== null && $itemOrderQty > $qty) {
                    $itemModifiedPrice = $itemModifiedPrice - $refundAmount;
                    $message = ' - Partial refund of base price £' . number_format($itemBasePrice / 100, 2) . ' x ' . $qty . ' = £' . number_format($refundAmount / 100, 2) . ' orginal quantity ' . $itemOrderQty ;
                    $itemModifiedReason .= $message;
                    $messageForRefund .= "| Item ID $id: " . trim($message);

                } else {
                    $itemModifiedPrice = 0.00; // full refund of this item
                    $message = ' - Full refund of item £' . number_format($itemBasePrice / 100, 2) . ' x ' . $qty . ' = £' . number_format($refundAmount / 100, 2) . ' original quantity ' . $itemOrderQty;
                    $itemModifiedReason .= $message;
                    $messageForRefund .= "| Item ID $id: " . trim($message);
                }

                $newQty = $itemOrderQty - $qty;

                $totalRefundAmount += $refundAmount;

                $validated[] = [
                                    'id'                    => $id, 
                                    'qty'                   => $newQty,
                                    'newModifiedPrice'      => $itemBasePrice           ?? null,
                                    'itemModifiedReason'    => $itemModifiedReason      ?? null,
                                    'itemName'              => $inputData['itemValidation']['itemName'] ?? null,
                                    'refundQty'             => $refundQty               ?? null,
                                ];
            }
            if (empty($validated)) {
                return ['status' => 'failed', 'message' => 'No valid order items found'];
            }

            $inputData['totalRefundAmount'] = $totalRefundAmount;
            $inputData['refundMessage'] = trim($messageForRefund);
            $inputData['validatedItems'] = $validated;

            return [
                'status' => 'success',
                'plan' => [
                    'type' => 'partial',                    // ← treat item-based as partial
                    'subtype' => 'itemBased',               // ← keep a hint if you need it later
                    'paymentIntentId' => $piId,
                    'connectedAccount' => $connectedAccount,
                    'amountMinor' => $totalRefundAmount,          // ← pence
                    'refundApplicationFee' => false,
                    'appFeeRefundMinor' => 0,
                    'normalizedItems' => $validated,
                ],
            ];
        }

        // 4b) Partial → validate amount, cap to current order amount
        if ($refundType === 'partial') {
            if (empty($inputData['refundAmount']) || !is_numeric($inputData['refundAmount']) || $inputData['refundAmount'] <= 0) {
                return ['status' => 'failed', 'message' => 'Valid refund amount is required for partial refunds'];
            }

            // get currency/amount charged from your helper (populates $inputData['currentOrderAmount'])
            viewCurrentOrderAmounts($inputData);

            $refundAmount = (float)$inputData['refundAmount'];
            $orderAmount  = (float)($inputData['currentOrderAmount'] ?? 0);
            if ($refundAmount > $orderAmount) {
                return ['status' => 'failed', 'message' => 'Refund amount cannot be greater than the total charged'];
            }

            $amountMinor = (int)round(((float)number_format($refundAmount, 2, '.', '')) * 100);

            return [
                'status' => 'success',
                'plan' => [
                    'type' => 'partial',
                    'paymentIntentId' => $piId,
                    'connectedAccount' => $connectedAccount,
                    'amountMinor' => $amountMinor,
                    'refundApplicationFee' => false, // keep your platform app fee by default
                    'appFeeRefundMinor' => 0,        // set >0 if you want to refund some of your fee on partial
                ],
            ];
        }

        // get the full order amount for logging/debugging
        viewCurrentOrderAmounts($inputData);


        // 4c) Full
        return [
            'status' => 'success',
            'plan' => [
                'type' => 'full',
                'paymentIntentId' => $piId,
                'connectedAccount' => $connectedAccount,
                'amountMinor' => null,             // omit to let Stripe refund full amount
                'refundApplicationFee' => false,   // keep your platform app fee
                'appFeeRefundMinor' => 50,         // example: refund 50p of your platform fee (adjust/drive from DB later)
            ],
        ];
    }
    function performStripeRefund($inputData, array $plan) {
        // Short-circuit for tests before touching Stripe
        if (defined('TEST_ENV') && TEST_ENV) {
            return ['status' => 'success', 'message' => 'Test environment – not refunding'];
        }
    
        // 0) Stripe setup
        require_once __DIR__ . '/../vendor/autoload.php';
        if (!class_exists('\Stripe\Stripe')) {
            return ['status' => 'failed', 'message' => 'Stripe dependency not available'];
        }
    
        // Inputs (platform key + connected acct + PI on connected acct)
        $secretKey        = $inputData['secure']['stripeSecretKey'] ?? null; // sk_...
        $connectedAccount = $plan['connectedAccount'] ?? null;               // acct_...
        $piId             = $plan['paymentIntentId'] ?? null;
    
        if (empty($secretKey) || empty($connectedAccount) || empty($piId)) {
            return ['status' => 'failed', 'message' => 'Missing Stripe configuration or payment intent id'];
        }
    
        \Stripe\Stripe::setApiKey($secretKey); // use platform key
    
        try {
            // 1) Retrieve PI from the CONNECTED account
            $pi = \Stripe\PaymentIntent::retrieve(
                $piId,
                ['stripe_account' => $connectedAccount] // scope matters
            );
    
            if (!isset($pi->id)) {
                return ['status' => 'failed', 'message' => 'Could not retrieve PaymentIntent on connected account scope.'];
            }
            if (($pi->status ?? '') !== 'succeeded') {
                return ['status' => 'failed', 'message' => "PaymentIntent not succeeded (status: {$pi->status})"];
            }
    
            // 2) Build refund params (refund by payment_intent to avoid charge object pitfalls)
            $refundParams = [
                'payment_intent' => $piId,
            ];
    
            // refund_application_fee only applies to destination/Connect charges; keep your flag
            if (isset($plan['refundApplicationFee'])) {
                $refundParams['refund_application_fee'] = (bool)$plan['refundApplicationFee'];
            }
    
            // Partial amounts (minor units) for 'partial' or 'itemBased'
            $isPartial = (($plan['type'] ?? '') === 'partial') || (($plan['subtype'] ?? '') === 'itemBased');
            if ($isPartial) {
                $amountMinor = (int) ($plan['amountMinor'] ?? 0);
                if ($amountMinor <= 0) {
                    return ['status' => 'failed', 'message' => 'Refund amount must be greater than zero'];
                }
    
                // Optional defensive check: ensure amount <= refundable left
                // We’ll compute refundableLeft by listing a charge (without relying on expanded objects)
                $charges = \Stripe\Charge::all(
                    ['payment_intent' => $piId, 'limit' => 1],
                    ['stripe_account' => $connectedAccount]
                );
                $firstCharge = $charges->data[0] ?? null;
                if ($firstCharge) {
                    $alreadyRefunded = (int) ($firstCharge->amount_refunded ?? 0);
                    $refundableLeft  = ((int)$firstCharge->amount) - $alreadyRefunded;
                    if ($amountMinor > $refundableLeft) {
                        return ['status' => 'failed', 'message' => 'Refund amount exceeds refundable balance'];
                    }
                }
                // If we didn’t find a charge, Stripe will still validate at creation
                $refundParams['amount'] = $amountMinor;
            }
    
            // 3) Idempotency on the refund request
            $idemKey = $inputData['idempotencyKey']
                            ?? ('refund_' . $piId . '_' . ($plan['type'] ?? 'full') . '_' . ($plan['subtype'] ?? 'none')
                                . '_' . bin2hex(random_bytes(6)));

            // 4) Create the refund ON THE CONNECTED ACCOUNT
            $refund = \Stripe\Refund::create(
                $refundParams,
                ['stripe_account' => $connectedAccount, 'idempotency_key' => $idemKey]
            );
    
            // 5) Optionally: partial refund of PLATFORM application fee (non-fatal best effort)
            // This must run at the PLATFORM scope (no stripe_account on these calls).
            if (($plan['appFeeRefundMinor'] ?? 0) > 0) {
                try {
                    // We need the charge ID to look up the application fee.
                    // refund->charge should be present even when created via payment_intent.
                    $chargeIdForFee = $refund->charge ?? null;
    
                    if (!$chargeIdForFee) {
                        // As a fallback, fetch latest charge by PI again
                        $chargesForFee = \Stripe\Charge::all(['payment_intent' => $piId, 'limit' => 1], ['stripe_account' => $connectedAccount]);
                        $chargeIdForFee = $chargesForFee->data[0]->id ?? null;
                    }
    
                    if ($chargeIdForFee) {
                        $platformClient = new \Stripe\StripeClient($secretKey);
                        $fees = $platformClient->applicationFees->all(['charge' => $chargeIdForFee, 'limit' => 1]);
                        $feeId = $fees->data[0]->id ?? null;
                        if ($feeId) {
                            $platformClient->applicationFees->createRefund($feeId, ['amount' => (int)$plan['appFeeRefundMinor']]);
                        } else {
                            //error_log("[Refund] No application fee found for charge {$chargeIdForFee}; skipping fee refund.");
                        }
                    } else {
                        //error_log("[Refund] No charge ID available to locate application fee; skipping fee refund.");
                    }
                } catch (\Stripe\Exception\ApiErrorException $e) {
                    //error_log('[Refund] App fee refund failed: ' . $e->getMessage());
                }
            }
    
            // 6) Return outcome
            if (($refund->status ?? '') === 'succeeded') {
                return [
                    'status'  => 'success',
                    'message' => $isPartial ? 'Partial refund processed' : 'Full refund processed',
                    'data'    => [
                        'refundId'      => $refund->id ?? null,
                        'refundStatus'  => 'succeeded',
                        'refundedMinor' => $refundParams['amount'] ?? null, // null for full refunds (Stripe sets actual)
                        'paymentIntent' => $piId,
                    ],
                ];
            }
    
            return [
                'status'  => 'failed',
                'message' => "Refund status: {$refund->status}",
                'data'    => [
                    'refundId'     => $refund->id ?? null,
                    'refundStatus' => $refund->status ?? null,
                    'paymentIntent'=> $piId,
                ],
            ];
    
        } catch (\Stripe\Exception\ApiErrorException $e) {
            // Stripe API surfaced an error
            return ['status' => 'failed', 'message' => $e->getMessage()];
        } catch (\Throwable $e) {
            // Any other runtime issue
            return ['status' => 'failed', 'message' => 'Unexpected error: ' . $e->getMessage()];
        }
    }
    function processRefund($inputData) {
        $planRes = calculateRefundPlan($inputData);
        if (($planRes['status'] ?? 'failed') !== 'success') {
            return $planRes;
        }
        $inputData['id']   = $inputData['orderId'];

        $stripeRes = performStripeRefund($inputData, $planRes['plan']);

        // Only write to DB if Stripe actually succeeded in refunding // allow for testing
        if (($stripeRes['status'] ?? '') === 'success'
            && ($stripeRes['data']['refundStatus'] ?? null) === 'succeeded'
            && !empty($stripeRes['data']['refundId'])) {

            $inputData['secure']['refundId'] = $stripeRes['data']['refundId'];
            $save = updateWithRefundId($inputData);
            if (($save['status'] ?? 'failed') !== 'success') {
                return [
                    'status'  => 'failed',
                    'message' => 'Refund succeeded but failed to save refund ID: ' . ($save['message'] ?? ''),
                    //'data'    => ['refundId' => $stripeRes['data']['refundId'], 'inputData' => $inputData, 'save' => $save]
                ];
            }
        }

        // check if in test mode and override status/message
        if (defined('TEST_ENV') && TEST_ENV) {
            $inputData['secure']['refundId'] = 'test_refund_id_12345';
            $save = updateWithRefundId($inputData);
            if (($save['status'] ?? 'failed') !== 'success') {
                return [
                    'status'  => 'failed',
                    'message' => 'Refund succeeded but failed to save refund ID: ' . ($save['message'] ?? ''),
                    //'data'    => ['save' => $save],
                ];
            }
        }

        $tenant = getTenantDetails($inputData);
        if (($tenant['status'] ?? 'failed') !== 'success') {
            error_log('[Refund Email] Failed to get tenant details: ' . ($tenant['message'] ?? 'unknown'));
            $tenant['tenantDetails'] = [];
        } else {
            $inputData['tenant'] = $inputData['tenantDetails'] ?? [];
            $inputData['tenantDetails'] = ""; // clear to avoid confusion
        }

        $order = viewOrderContact($inputData);
        if (($order['status'] ?? 'failed') !== 'success') {
            error_log('[Refund Email] Failed to get order details: ' . ($order['message'] ?? 'unknown'));
            $order['orderDetails'] = [];
        }

        $shopAddress = shopAddress($inputData);
        if (($shopAddress['status'] ?? 'failed') !== 'success') {
            error_log('[Refund Email] Failed to get shop address: ' . ($shopAddress['message'] ?? 'unknown'));
            $shopAddress['addressPlain'] = '';
        }

        // format the shop address for email
        $formattedAddressPlain = str_replace('<br>', ', ', formatShopAddressForEmail($shopAddress['data']['contact_value'] ?? ''));
        $inputData['companyAddress'] = $formattedAddressPlain;

        $inputData['plan']['paymentId'] = $inputData['secure']['refundId'];

        if($inputData['refundType'] === 'full'){
            $inputData['plan']['totalRefundMinor'] = ($inputData['currentOrderAmount'] * 100) ?? null;
        }

        if(isset($inputData['refundAmount'])){
            $inputData['plan']['partialRefundMinor'] = $inputData['refundAmount'];
        }

        //error_log(print_r($inputData, true));
        
        $emailRes = sendRefundEmail($inputData);
        if (($emailRes['status'] ?? 'failed') !== 'success') {
            error_log('[Refund Email] Sending refund email failed: ' . ($emailRes['message'] ?? 'unknown'));
        }

        // Return both plan and result if you like
        if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return [
                    'calculatedPlan' => $planRes,
                    'refundResult'   => $stripeRes,
                    'status'         => $stripeRes['status'] ?? 'failed',
                    'message'        => $stripeRes['message'] ?? null,
            ];
        }else{
            return [
                'status'  => $stripeRes['status'] ?? 'failed',
                'message' => $stripeRes['message'] ?? null,
            ];
        }
    }
    function sendEmailGeneric(string $to, string $subject, string $html, array $headersExtra = []): array{
        // Basic safety
        if (!$to || !$subject || !$html) {
            return ['status' => 'failed', 'message' => 'Missing to/subject/html'];
        }

        // Default headers
        $headers = [
            'MIME-Version: 1.0',
            'Content-Type: text/html; charset=UTF-8',
        ];

        // Optional From/Reply-To (pull from $headersExtra or fall back to safe defaults)
        $fromName  = $headersExtra['fromName']  ?? '';
        $fromEmail = $headersExtra['fromEmail'] ?? 'no-reply@waitron.uk';
        $replyTo   = $headersExtra['replyTo']   ?? $fromEmail;

        $headers[] = 'From: ' . sprintf('"%s" <%s>', esc($fromName), esc($fromEmail));
        $headers[] = 'Reply-To: ' . esc($replyTo);

        // Allow arbitrary headers (e.g., List-Unsubscribe, X-Tracking)
        if (!empty($headersExtra['raw'])) {
            foreach ((array)$headersExtra['raw'] as $h) {
                if (is_string($h) && trim($h) !== '') {
                    $headers[] = $h;
                }
            }
        }

        $ok = @mail($to, $subject, $html, implode("\r\n", $headers));
        if (!$ok) {
            return ['status' => 'failed', 'message' => 'mail() transport failed'];
        }

        return ['status' => 'success'];
    }
    function renderEmail(string $type, array $ctx): string{
        // Normalize/defensive defaults
        $brand          = $ctx['brand']             ?? ($ctx['tenant']['companyName'] ?? '');
        $companyAddress = $ctx['companyAddress']    ?? ($ctx['tenant']['companyAddress'] ?? '');
        $companyName    = $ctx['companyName']       ?? ($ctx['tenant']['companyName'] ?? '');
        $companyNumber  = $ctx['companyNumber']     ?? ($ctx['tenant']['companyNumber'] ?? '');
        $companyVat     = $ctx['companyVat']        ?? ($ctx['tenant']['companyVat'] ?? '');
        $companyEmail   = $ctx['companyEmail']      ?? ($ctx['tenant']['companyEmail'] ?? '');
        $companyPhone   = $ctx['companyPhone']      ?? ($ctx['tenant']['companyPhone'] ?? '');


        $currency = $ctx['currency'] ?? ($ctx['order']['currency'] ?? ''); 
        $order        = $ctx['order']        ?? [];
        $tenant       = $ctx['tenant']       ?? [];
        $plan         = $ctx['plan']         ?? [];
        $tz           = $ctx['timezone']     ?? ($tenant['timezone'] ?? 'Europe/London');



        $piNumber = $ctx['paymentId'] ?? 'xxxxxxxxxxx';

        $piNumberHtml = <<<HTML
                            <div style="margin-top:16px;padding:8px 12px;background:#f0f0f0;border-radius:8px;font-size:12px;color:#666;text-align:center;">
                                <div style="margin-top:16px;padding:8px 12px;background:#f0f0f0;border-radius:8px;font-size:12px;color:#666;text-align:center;">
                                    <div style="margin-top:16px;padding:8px 12px;background:#f0f0f0;border-radius:8px;font-size:12px;color:#666;text-align:center;">
                                        Payment reference: <strong>{$piNumber}</strong>
                                    </div>
                                </div>
                            </div>
                        HTML;

        // Choose body block by type
        switch ($type) {
            case 'full':
                $body = renderBlockFullRefund($order, $plan, $currency);
                break;
            case 'partial':
                $body = renderBlockPartialRefund($order, $plan, $currency);
                break;
            case 'itemBased':
                $body = renderBlockItemBasedRefund($order, $plan, $currency);
                break;
            case 'cancelled':
                $body = renderBlockCancelled($order, $plan, $currency);
                break;
            default: // 'receipt' or fallback
                $body = renderBlockReceipt($order, $plan, $currency);
                break;
        }

        // Shared wrapper
        $header = <<<HTML
            <div style="padding:24px 0;text-align:center;">
            <div style="font-size:20px;font-weight:600;">{$brand}</div>
            </div>
        HTML;

        // Vat
        $vat = "";
        if($companyVat !== ''){
            $vat = " | VAT: {$companyVat}";
        }

        // contact info
        if($companyEmail !== '' || $companyPhone !== ''){
            $contact = ' | ';
            if($companyEmail !== ''){
                $contact .= "Email: <a href='mailto:{$companyEmail}'>{$companyEmail}</a>";
            }
            if($companyEmail !== '' && $companyPhone !== ''){
                $contact .= ' | ';
            }
            if($companyPhone !== ''){
                $contact .= "Phone: <a href='tel:{$companyPhone}'>{$companyPhone}</a>";
            }
            $contact .= '<br>';
        }else{
            $contact = '';
        }

        // Footer (support/contact)
        $footer = <<<HTML
            <div style="margin-top:32px;padding-top:16px;border-top:1px solid #eee;font-size:12px;color:#666;">
                Company Name: {$companyName} | Company Number: {$companyNumber} <br> Company Address: {$companyAddress} {$vat} <br>
                {$contact}
                This is an automated message, please do not reply directly to this email.<br>
                <div style="margin-top:8px;">
                    <div style="font-weight:600;">
                        Powered by <a href="https://waitron.uk" style="color:#666;text-decoration:none;">Waitron</a>.
                    </div>
                </div>
            </div>
        HTML;

        // Frame
        $html = <<<HTML
        <div style="font-family:system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial,sans-serif;background:#f7f7f8;padding:20px;">
        <div style="max-width:640px;margin:0 auto;background:#fff;border:1px solid #eee;border-radius:12px;padding:24px;">
            {$header}
            <div>{$body}</div>
            {$footer}
        </div>
            {$piNumberHtml}
        </div>
        HTML;

        return $html;
    }
    function renderBlockFullRefund(array $order, array $plan, string $currency): string{
        $totalRefundMinor = (int)($plan['totalRefundMinor'] ?? 0);
        $amount           = money_major($totalRefundMinor, $currency);
        $orderIdEsc       = esc($order['id'] ?? '');
        return <<<HTML
                <h2 style="margin:0 0 12px;">Your order has been fully refunded</h2>
                <p style="margin:0 0 12px;">We've issued a full refund for your order <strong>#{$orderIdEsc}</strong>.</p>
                <p style="margin:0 0 12px;">Total refunded: <strong>{$amount}</strong>.</p>
                <p style="margin:0;">Refunds typically appear within 5-10 business days depending on your bank.</p>
                HTML;
    }
    function renderBlockPartialRefund(array $order, array $plan, string $currency): string{
        $partialRefundMinor = (float)($plan['partialRefundMinor'] ?? ($plan['totalRefundMinor'] ?? 0));
        $amount             = money_static($partialRefundMinor, $currency);

        $orderIdEsc = esc($order['id'] ?? '');
        $reasonRaw  = (string)($plan['reason'] ?? 'A partial refund has been applied.');
        $reasonEsc  = esc(trim($reasonRaw)); // use nl2br(...) here if you want to preserve line breaks

        return <<<HTML
            <h2 style="margin:0 0 12px;">A partial refund has been applied</h2>
            <p style="margin:0 0 12px;">Order <strong>#{$orderIdEsc}</strong></p>
            <p style="margin:0 0 12px;">{$reasonEsc}</p>
            <p style="margin:0;">Amount refunded: <strong>{$amount}</strong>.</p>
            <p style="margin:0;">Refunds typically appear within 5-10 business days depending on your bank.</p>
        HTML;
    }
    function renderBlockItemBasedRefund(array $order, array $plan, string $currency): string{
        $totalRefundMinor = (int)($plan['totalRefundMinor'] ?? 0);
        $amount           = money_major($totalRefundMinor, $currency);
        $orderIdEsc       = esc($order['id'] ?? '');

        $rows = '';
        foreach ((array)($plan['refundedItems'] ?? []) as $r) {
            $name    = esc($r['itemName'] ?? 'Item');
            $qty     = (int)($r['refundQty'] ?? ($r['refundQty'] ?? 0));
            $lineMn  = (int)($r['newModifiedPrice'] ?? ($r['newModifiedPrice'] ?? 0));
            $lineAmt = money_major($lineMn, $currency);

            $rows .= '<tr>'
                . '<td style="padding:6px 0;">' . $name . '</td>'
                . '<td style="padding:6px 0; width:60px; text-align:center;">×' . $qty . '</td>'
                . '<td style="padding:6px 0; text-align:right;">' . $lineAmt . '</td>'
                . '</tr>';
        }

        $itemsTbl = $rows
            ? '<table style="width:100%;border-collapse:collapse;">' . $rows . '</table>'
            : '<p>No item details provided.</p>';

        return <<<HTML
                <h2 style="margin:0 0 12px;">Refund for items in your order</h2>
                <p style="margin:0 0 12px;">Order <strong>#{$orderIdEsc}</strong></p>
                {$itemsTbl}
                <p style="margin:12px 0 0;">Total refunded: <strong>{$amount}</strong>.</p>
                <p style="margin:0;">Refunds typically appear within 5-10 business days depending on your bank.</p>
            HTML;
    }
    function renderBlockCancelled(array $order, array $plan, string $currency): string{
        // Order id (may be the only thing we have)
        $orderIdEsc = esc($order['id'] ?? '');

        // Currency + helpers
        $currency = strtoupper($currency ?: ($order['currency'] ?? ($order['totals']['currency'] ?? 'GBP')));
        $moneyInt = fn(int $minor) => money_major($minor, $currency);

        // Try to show the authorised amount if we can infer it
        $authMinor = null;
        if (isset($plan['authorisedMinor'])) {
            $authMinor = (int)$plan['authorisedMinor'];
        } elseif (isset($order['payment']['authorisedMinor'])) {
            $authMinor = (int)$order['payment']['authorisedMinor'];
        } elseif (isset($order['payment']['authorisedAmount'])) {           // major string/float
            $authMinor = money_str_to_int((string)$order['payment']['authorisedAmount']);
        } elseif (isset($order['totals']['total'])) {                        // major string/float
            $authMinor = money_str_to_int((string)$order['totals']['total']);
        } elseif (isset($order['totalOrderModifiedPrice'])) {                // major string/float
            $authMinor = money_str_to_int((string)$order['totalOrderModifiedPrice']);
        }

        // Optional reason (prefer plan.reason, then order.cancellation.reason)
        $rawReason = $plan['reason'] ?? ($order['cancellation']['reason'] ?? '');
        $reason    = (is_string($rawReason) && trim($rawReason) !== '')
            ? '<p style="margin:8px 0 0;color:#444"><strong>Reason:</strong> '.esc($rawReason).'</p>'
            : '';

        // Authorisation release messaging
        $days = (int)($plan['authReleaseDays'] ?? 0);
        $releaseText = ($days >= 1 && $days <= 10)
            ? "Your bank typically releases card holds within {$days} working days."
            : "Your bank typically releases card holds within 3–10 working days.";

        $authRow = ($authMinor !== null)
            ? '<tr><td style="padding:4px 0;color:#444">Card authorisation</td>'
            . '<td style="padding:4px 0;text-align:right;color:#444">'.$moneyInt($authMinor).'</td></tr>'
            : '';

        return <<<HTML
                <h2 style="margin:0 0 12px;">Your order has been cancelled</h2>
                <p style="margin:0 0 8px;line-height:1.5;">
                    Order <strong>#{$orderIdEsc}</strong> was cancelled by the restaurant. We're sorry for the inconvenience.
                    For further information, please contact the restaurant.
                </p>
                {$reason}

                <h3 style="margin:16px 0 8px;font-size:16px;color:#111">Payment status</h3>
                <table style="width:100%;border-collapse:collapse">
                    <tr>
                        <td style="padding:8px 0;font-weight:700;color:#111">Total charged</td>
                        <td style="padding:8px 0;text-align:right;font-weight:700;color:#111">{$moneyInt(0)}</td>
                    </tr>
                    {$authRow}
                </table>
                <p style="margin:8px 0 0;line-height:1.5;color:#444">
                    No payment was captured. The authorisation hold has been cancelled. {$releaseText}
                </p>
            HTML;
    }
    function renderBlockReceipt(array $order, array $plan, string $currency): string {
        // ── meta
        $orderIdEsc = esc($order['id'] ?? '');
        $orderType  = strtolower((string)($order['type'] ?? $order['order_type'] ?? '')) === 'delivery' ? 'Delivery' : 'Collection';
        $status     = ucfirst(strtolower((string)($order['orderStatus'] ?? $order['order_status'] ?? '')));
        $payment    = ucfirst(strtolower((string)($order['paymentStatus'] ?? $order['payment_status'] ?? 'Paid')));

        // placed time (prefer preformatted)
        $placed = $order['createdAtDisplay'] ?? null;
        if (!$placed && !empty($order['createdAt'])) {
            $placed = esc(date('Y-m-d H:i:s', strtotime($order['createdAt'])));
        } elseif (!$placed && !empty($order['created_at'])) {
            $placed = esc(date('Y-m-d H:i:s', strtotime($order['created_at'])));
        }

        // Track URL
        $trackUrl = '#';
        if (function_exists('buildTrackUrl')) {
            $trackUrl = buildTrackUrl($order);
        } elseif (!empty($order['trackUrl'])) {
            $trackUrl = (string)$order['trackUrl'];
        }

        //error_log(print_r($trackUrl, true));

        // ── amounts (strings only, 2dp)
        $total = normalizePounds(
            $order['totalOrderModifiedPrice']
            ?? $order['total_order_modified_price']
            ?? $order['total']
            ?? '0.00'
        );

        //error_log(print_r($order, true));

        $deliveryFee   = normalizePounds($order['deliveryFee']   ?? $order['delivery_fee']   ?? '0.00');
        $serviceFee    = normalizePounds($order['orderFee']      ?? $order['order_fee']      ?? '0.00');
        $smallOrderFee = normalizePounds($order['smallOrderFee'] ?? $order['small_order_fee']?? '0.00');

        // ── items (camelCase from your payload)
        $itemsHtml     = '';
        $subtotal      = '0.00';
        $details = (array)($order['items'] ?? $order['details'] ?? []);
        

        if ($details) {
            $rows = '';
            foreach ($details as $r) {
                $name = esc($r['name'] ?? $r['itemName'] ?? 'Item');
                $qty  = (int)($r['qty'] ?? $r['itemQuantity'] ?? $r['quantity'] ?? 1);

                // unit and optional explicit line total
                $unit = normalizePounds($r['price'] ?? $r['price'] ?? '0.00');
                $line = isset($r['total']) || isset($r['price'])
                    ? normalizePounds($r['total'] ?? $r['price'])
                    : money_mul($unit, $qty);

                $subtotal = money_add($subtotal, $line);

                $rows .= '<tr>'
                    . '<td style="padding:6px 0;">' . $qty . ' × ' . $name . '</td>'
                    . '<td style="padding:6px 0;text-align:right;">' . format_pounds_str($line, $currency) . '</td>'
                    . '</tr>';
            }
            $itemsHtml = '<table style="width:100%;border-collapse:collapse;">' . $rows . '</table>';
        } else {
            // fallback subtotal: total - fees (string math)
            $fees = money_add(money_add($deliveryFee, $serviceFee), $smallOrderFee);
            $calc = money_sub($total, $fees);
            // avoid negative just in case
            $subtotal = money_sub(max(money_str_to_int($calc), 0) ? $calc : '0.00', '0.00');
            $itemsHtml = '<p style="margin:0;">Items not available.</p>';
        }

        // ── address (delivery)
        $deliveryAddressHtml = '';
        if ((strtolower((string)$orderType) === 'delivery') || !empty($order['delivery'])) {
            $deliveryAddressHtml = $order['deliveryAddressHtml'] ?? '';
        }

        // ── meta line
        $badge = $status ? '<span style="display:inline-block;font-size:12px;padding:2px 8px;border-radius:999px;background:#eef3ff;color:#3b5bdb;vertical-align:middle;">'
                        . esc($status) . '</span>' : '';

        $metaBits = [];
        if ($orderIdEsc !== '') $metaBits[] = 'Order <strong>#'.$orderIdEsc.'</strong>';
        if ($orderType)         $metaBits[] = 'Type <strong>'.$orderType.'</strong>';
        if ($placed)            $metaBits[] = 'Placed <strong>'.$placed.'</strong>';
        if ($payment)           $metaBits[] = 'Payment <strong>'.$payment.'</strong>';
        $metaLine = implode(' · ', $metaBits);

        // ── summary rows (strings)
        $summaryRows =
            '<tr><td>Subtotal</td><td style="text-align:right;">' . format_pounds_str($subtotal, $currency) . '</td></tr>'
            . (normalizePounds($deliveryFee)   !== '0.00' ? '<tr><td>Delivery Fee</td><td style="text-align:right;">' . format_pounds_str($deliveryFee, $currency) . '</td></tr>' : '')
            . (normalizePounds($serviceFee)    !== '0.00' ? '<tr><td>Service Fee</td><td style="text-align:right;">'  . format_pounds_str($serviceFee, $currency) . '</td></tr>' : '')
            . (normalizePounds($smallOrderFee) !== '0.00' ? '<tr><td>Small Order Fee</td><td style="text-align:right;">' . format_pounds_str($smallOrderFee, $currency) . '</td></tr>' : '');

        $totalRow =
            '<tr><td style="padding-top:8px;border-top:1px solid #eee;"><strong>Total</strong></td>'
            . '<td style="padding-top:8px;border-top:1px solid #eee;text-align:right;"><strong>' . format_pounds_str($total, $currency) . '</strong></td></tr>';

        // Track button
        $trackBtn = $trackUrl && $trackUrl !== '#'
            ? '<a href="'.esc($trackUrl).'" style="display:inline-block;background:#2a6ef1;color:#fff;text-decoration:none;padding:10px 14px;border-radius:8px;font-weight:600;">Track your order</a>'
            : '';

        return <<<HTML
                <h2 style="margin:0 0 12px;">Thank you for your order! {$badge}</h2>
                <p style="margin:0 0 16px;">{$metaLine}</p>
                {$trackBtn}

                <!-- Delivery Address -->
                {$deliveryAddressHtml}

                <!-- Items -->
                <h3 style="margin:24px 0 8px;">Items</h3>
                {$itemsHtml}

                <!-- Summary -->
                <h3 style="margin:24px 8px 8px;">Summary</h3>
                <table style="width:100%;border-collapse:collapse;">
                {$summaryRows}
                {$totalRow}
                </table>
            HTML;
    }
    function buildRefundEmail_FromInputData(array $inputData, string $type = null): string {
        // Allow override, else use payload's refundType, else default 'full'
        $type = $type ?: ($inputData['refundType'] ?? 'full');
        if (!in_array($type, ['full','partial','itemBased'], true)) {
            $type = 'full';
        }

        $ctx = [
            'brand'        => $inputData['tenant']['companyName'] ?? null,
            'supportEmail' => $inputData['tenant']['supportEmail'] ?? null,
            'supportPhone' => $inputData['tenant']['supportPhone'] ?? null,

            'currency'     => $inputData['order']['currency'] ?? ($inputData['currency'] ?? 'GBP'),
            'timezone'     => $inputData['tenant']['timezone'] ?? 'Europe/London',

            'order'        => $inputData['order'] ?? [],
            'tenant'       => $inputData['tenant'] ?? [],
            'plan'         => $inputData['plan']  ?? [],
        ];

        // If Stripe PI details were attached, surface currency if missing
        if (isset($inputData['stripe']) && is_object($inputData['stripe'])) {
            $pi = $inputData['stripe']; // \Stripe\PaymentIntent
            if (isset($pi->currency) && empty($ctx['order']['currency'])) {
                $ctx['order']['currency'] = strtoupper((string)$pi->currency);
            }
        }

        return renderEmail($type, $ctx);
    }
    function generateRefundEmailFromOrder(array $order, array $brand = [], ?string $tenantReplyTo = null, array $plan = [], string $type = 'full'): array {
        // Normalise type
        if (!in_array($type, ['full','partial','itemBased'], true)) {
            $type = 'full';
        }

        $currency = strtoupper($order['currency'] ?? 'GBP');

        // Subject line variants
        $orderId    = (string)($order['id'] ?? $order['order_id'] ?? '');
        $brandName  = $brand['companyName'] ?? ($brand['name'] ?? 'Your Restaurant');
        $subjectMap = [
            'full'      => "Order #{$orderId} fully refunded – {$brandName}",
            'partial'   => "Order #{$orderId} partially refunded – {$brandName}",
            'itemBased' => "Order #{$orderId} refund issued – {$brandName}",
        ];
        $subject = $subjectMap[$type];

        // Build HTML via the unified renderer
        $ctx = [
            'brand'             => $brand['companyName'] ?? null,
            'supportEmail'      => $brand['supportEmail'] ?? null,
            'supportPhone'      => $brand['supportPhone'] ?? null,
            'currency'          => $currency,
            'timezone'          => $brand['timezone'] ?? 'Europe/London',
            'order'             => $order,
            'tenant'            => ['companyName' => $brand['companyName'] ?? null] + $brand,
            'plan'              => $plan,
            'companyAddress'    => $brand['companyAddress'] ?? null,
            'paymentId'         => $plan['paymentId'] ?? ($order['payment']['stripePaymentIntent'] ?? null),
        ];
        $html = renderEmail($type, $ctx);

        // Work out recipient using your helper
        $toEmail = deriveCustomerEmail([
            'order' => $order,
            'customerEmail' => $order['userEmail'] ?? null,
        ]) ?: (string)($order['userEmail'] ?? '');

        return [
            'from'     => computeNoReplyFrom(),
            'to'       => $toEmail,
            'subject'  => $subject,
            'html'     => $html,
            'replyTo'  => $tenantReplyTo,
            'fromName' => $brand['name'] ?? ($brand['companyName'] ?? 'Waitron'),
        ];
    }
    function sendRefundEmail(array $inputData, ?string $overrideType = null, ?string $html = null): array {
        try {
            if (defined('TEST_ENV') && TEST_ENV) {
                error_log('[Email] Skipped sending refund email (TEST_ENV=true)');
                return ['status' => 'success', 'message' => 'Test environment – email not sent'];
            }

            $type   = $overrideType ?: ($inputData['refundType'] ?? 'full');
            if (!in_array($type, ['full','partial','itemBased'], true)) {
                $type = 'full';
            }

            // get tenant details for branding
            //$tenant = getTenantDetails($inputData);
            $tenant = $inputData['tenant'] ?? [];

            $tenant['companyAddress'] = $inputData['companyAddress'] ?? '';

            //error_log(print_r($inputData, true));           

            // Need to add adress formmat to email once we know where to place it >


            $order  = (array)($inputData['order']  ?? []);
            $plan   = (array)($inputData['plan']   ?? []);

            // Optional: lift currency/reason from Stripe PI if attached
            if (isset($inputData['stripe']) && is_object($inputData['stripe'])) {
                $pi = $inputData['stripe']; // \Stripe\PaymentIntent
                if (isset($pi->currency) && empty($order['currency'])) {
                    $order['currency'] = strtoupper((string)$pi->currency);
                }
            }
            
            // if refund is item based, ensure plan has refunded items
            if($type === 'itemBased'){
                $plan['refundedItems'] = $inputData['validatedItems'] ?? [];
                $plan['totalRefundMinor'] = $inputData['totalRefundAmount'] ?? 0;
            }

            //error_log(print_r($inputData, true));
            //error_log("-----------------------------------------------");
            //error_log(print_r($plan, true));
            //error_log("-----------------------------------------------");

            // Build payload
            $emailPayload = generateRefundEmailFromOrder(
                $order,
                $tenant,                        // brand info comes from tenant array in your codebase
                "no-reply@waitron.uk",          // reply-to
                $plan,
                $type
            );

            // Allow explicit HTML override
            if ($html !== null && $html !== '') {
                $emailPayload['html'] = $html;
            }

            // Who are we sending to?
            $to = $emailPayload['to'];
            if (!$to) {
                return ['status' => 'failed', 'message' => 'No recipient email found for refund email'];
            }

            

            // Fire
            return sendEmailGeneric(
                $to,
                (string)$emailPayload['subject'],
                (string)$emailPayload['html'],
                [
                    'fromName'  => (string)($emailPayload['fromName'] ?? 'Waitron'),
                    'from'      => (string)($emailPayload['from']     ?? "no-reply@waitron.uk"),
                    'replyTo'   => (string)($emailPayload['replyTo']  ?? ($emailPayload['from'] ?? "no-reply@waitron.uk")),
                ]
            );
        } catch (Throwable $e) {
            error_log('[Email] Refund email failed: '.$e->getMessage());
            return ['status' => 'failed', 'message' => 'Failed to send refund email'];
        }
    }
?>