<?php
    // this should only be used for testing purposes
    if (defined('TEST_ENV')) {
        //require_once __DIR__ . '/../../orbit-core/src/config.php';
        require_once __DIR__ . '\..\..\core\src\Fcors.php';
        require_once __DIR__ . '\..\..\tests\scripts\bootstrap.php';
        require_once __DIR__ . '\..\..\core\src\generic.php';
        $testInfo['0'] = ("\nFunction Running in Test Environment\n");
    } else {
        // this is code for live environment Dev, Uat, Production
        require_once __DIR__ . "./../error_monitor.php";
        require_once __DIR__ . "./../generic.php";
    }

    require_once __DIR__ . "/core.php";
    require_once __DIR__ . "/view.php";
    require_once __DIR__ . "/insert.php";
    require_once __DIR__ . "/update.php";

    $inputData = initializeGeneric();

    $inputData['requiresAdmin'] = [ 'getPreAuthPayments' =>  [2,4,5,6]];
    $inputData['keepLive'] = checkLive();
    $action = $inputData['action'];

    // check if action need auth and if does check it valid otherwise move to swithc statments 
    $security = SecurityCheck($inputData); // skip security for a bit 

    if(isset($inputData['tenantId']) == false || $inputData['tenantId'] == null ){
        setTenantId($inputData);
        reinitializeTenantId($inputData);
    }
    if($security['security'] === '1'){
        switch ($action) {
            case "getPreAuthPayments":
                $inputData['nextOperation'] = 'viewPreAuthPayments';
                $out = executeDatabaseOperation($inputData);
                break;
            case "acceptedPreAuthPayment":
                $out = acceptedPreAuthPayment($inputData);
                break;
            case "test":
                $out['status']   = 'success';
                $out['message']  = 'Test Passed';
                break;
            
            default:
                $out['status']   = 'failed';
                $out['message']  = 'No Action Found';
                break;
        }
    }else{
        $out = $security;
        if($security['security'] === '0'){
            unset($out['security']);
        }

    }

    if(defined('TEST_ENV')){
    //    $out['testInfo']['1'] = $testInfo;
    //    $out['testInfo']['2'] = $_GET;
    //    $out['testInfo']['3'] = $_POST;
    //      $out['inputData']     = $inputData;
        $out['security']      = $security;
        $out['action']        = $action;
    }

    echo json_encode(propagateStatusAndMessage($out));
?>
