<?php
    function checkIfDeleted($inputData) {
        $table = $inputData['table'];
        $table = toSnakeCase($table);
        $id = $inputData['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT id FROM $table WHERE id = :id and is_deleted = 1");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
            if ($data) {
                        return ['status' => 'failed', 'message' => 'Record already deleted'];
            } else {
                return ['status' => 'success'];
            }
    }
    function getDataForHistory($inputData) {
        $table = $inputData['table'];
        $table = toSnakeCase($table);
        $id = $inputData['id'];
        $db = $inputData['db']['dbLogin'];
        $stmt = $db->prepare("SELECT * FROM $table WHERE id = :id");
        $stmt->bindParam(':id', $id, PDO::PARAM_INT);
        $stmt->execute();
        // convert result to json with column names as keys
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        json_encode($data);
        if ($data) {
            return ['status' => 'success', 'historyData' => $data];
        } else {
            return ['status' => 'failed', 'message' => 'Record not found'];
        }
    }
    function setTenantId($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $host = $_SERVER['HTTP_HOST'] ?? '';
        $host = strtolower($host);
        $parts = explode('.', $host);
        $cleanParts = array_filter($parts, fn($part) => $part !== 'admin');
        $cleanHost = implode('.', $cleanParts);
        $cleanUrl = 'https://' . $cleanHost;

        // Build SQL
        $sql = "SELECT id FROM tenant WHERE domain = :http";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':http', $cleanUrl);
        $stmt->execute();
        $data = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($data) {
            $_SESSION['tenantId']       = $data['id'];
            return ['status' => 'success', 'message' => 'Tenant ID found'];
        } else {
            return ['status' => 'failed', 'message' => 'Tenant ID not found'];
        }
    }
    function viewPreAuthPayments($inputData) {
        $db = $inputData['db']['dbLogin'];
        $tenantId = $inputData['tenantId'];
        $stmt = $db->prepare("SELECT distinct id, `total_order_modified_price` as `totalOrderModifiedPrice`, `order_status` as `orderStatus`, `updated_at` as `updatedAt` FROM `food_order` 
                                where	`payment_status` 	= 'payment_pre_auth'
                                AND 	`tenant_id`			= :tenant_id
                                order by updated_at desc");
                                    
        $stmt->bindParam(':tenant_id', $tenantId, PDO::PARAM_INT);
        $stmt->execute();
        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!$data) {
            return ['status' => 'failed', 'message' => 'No pre-auth payments found'];
        }
        

        foreach ($data as &$payment) {
            $payment['totalOrderModifiedPrice'] = number_format($payment['totalOrderModifiedPrice'], 2, '.', '');
        }

        $group = [];
        unset($payment); // break the reference!

        foreach ($data as $payment) {
            $status = $payment['orderStatus'];
            $group[$status][] = $payment;
        }

        $data = $group; // replace the flat array with the grouped one

        // convert to cammelCase
        foreach ($data as $status => $payments) {
            foreach ($payments as &$payment) {
                $payment = convertKeysToCamelCase($payment);
            }
            unset($payment); // break the reference!
        }       

        return ['status' => 'success', 'preAuthPayments' => $data];
    }

    function viewOrders($inputData) {
        $db = $inputData['db']['dbLogin'];
        $tenantId = $inputData['tenantId'];
    }


?>
