<?php
    function menuTableColumnMapping($table = null, $roleId = null, $actionType = null) {
       $allMappings = [
            'food_order' => [
                'fields' => [
                    'id'                        => ['mapping' => 'id',                          'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => null,         'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'userId'                    => ['mapping' => 'user_id',                     'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'guestUserId'               => ['mapping' => 'guest_user_id',               'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'tenantId'                  => ['mapping' => 'tenant_id',                   'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'deliveryAddressId'         => ['mapping' => 'delivery_address_id',         'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'billingAddressId'          => ['mapping' => 'billing_address_id',          'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'orderStatus'               => ['mapping' => 'order_status',                'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5, 6],         'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','completed','cancelled']],
                    'orderType'                 => ['mapping' => 'order_type',                  'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['delivery','pickup','dine-in','collection']],
                    'paymentStatus'             => ['mapping' => 'payment_status',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['unpaid','paid','refunded','partial_refund','payment_intent','payment_pre_auth']],
                    'deliveryFee'               => ['mapping' => 'delivery_fee',                'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'orderFee'                  => ['mapping' => 'order_fee',                   'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'smallOrderFee'             => ['mapping' => 'small_order_fee',             'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'currency'                  => ['mapping' => 'currency',                    'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'transactionId'             => ['mapping' => 'transaction_id',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'paymentIntentId'           => ['mapping' => 'payment_intent_id',           'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'comment'                   => ['mapping' => 'comment',                     'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'tenantComment'             => ['mapping' => 'tenant_comment',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'totalOrderPrice'           => ['mapping' => 'total_order_price',           'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedPrice'   => ['mapping' => 'total_order_modified_price',  'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedReason'  => ['mapping' => 'total_order_modified_reason', 'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_item', 'foreignKey' => 'orderId']],
            ],
            'food_order_item' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'orderId'               => ['mapping' => 'order_id',                'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuItemId'            => ['mapping' => 'menu_item_id',            'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'itemName'              => ['mapping' => 'item_name',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'string', 'expectedValue' => null],
                    'itemBasePrice'         => ['mapping' => 'item_base_price',         'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedPrice'     => ['mapping' => 'item_modified_price',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedReason'    => ['mapping' => 'item_modified_reason',    'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemQuantity'          => ['mapping' => 'item_quantity',           'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemNote'              => ['mapping' => 'item_note',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemStatus'            => ['mapping' => 'item_status',             'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','prepared','served','cancelled']],
                    'itemTenantComment'     => ['mapping' => 'item_tenant_comment',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_extra', 'foreignKey' => 'itemId']],
            ],
            'food_order_extra' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemId'                => ['mapping' => 'item_id',                 'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuExtraId'           => ['mapping' => 'menu_extra_id',           'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 1,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'extraName'             => ['mapping' => 'extra_name',              'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'extraPrice'            => ['mapping' => 'extra_price',             'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                ],
                'relationships' => [],
            ],
            'food_order_guest_user' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'fName'                 => ['mapping' => 'f_name',                  'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'lName'                 => ['mapping' => 'l_name',                  'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'phoneNumber'           => ['mapping' => 'phone_number',            'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'userEmail'             => ['mapping' => 'user_email',              'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order', 'foreignKey' => 'guestUserId']],
            ],
            'food_order_address' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'addressLine1'          => ['mapping' => 'address_line_1',          'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [0, 2, 4, 5],    'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'addressLine2'          => ['mapping' => 'address_line_2',          'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'city'                  => ['mapping' => 'city',                    'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'county'                => ['mapping' => 'county',                  'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'country'               => ['mapping' => 'country',                 'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'postalCode'            => ['mapping' => 'postal_code',             'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'checkSum'              => ['mapping' => 'check_sum',               'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [
                    ['table' => 'food_order', 'foreignKey' => 'deliveryAddressId'],
                    ['table' => 'food_order', 'foreignKey' => 'billingAddressId'],
                ],
            ],
            'food_order_user_address' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'userId'                => ['mapping' => 'user_id',                 'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'addressId'             => ['mapping' => 'address_id',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [0, 2, 4, 5],    'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'isDefault'             => ['mapping' => 'is_default',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'isActive'              => ['mapping' => 'is_active',               'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'isDeleted'             => ['mapping' => 'is_deleted',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                ],
                // No relationships for this table
                'relationships' => [],
            ],
        ];
        
        if (!$table) {
            return $allMappings;
        }
    
        $table = toSnakeCase($table);
        if (!isset($allMappings[$table])) {
            return null;
        }
    
        if ($roleId === null) {
            return $allMappings[$table];
        }
    
        $filtered = [];
        foreach ($allMappings[$table]['fields'] as $key => $meta) {
            if ($actionType === 'update' && isset($meta['updateRole'])) {
                if (in_array($roleId, $meta['updateRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'insert' && isset($meta['insertRole'])) {
                if (in_array($roleId, $meta['insertRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'view' && isset($meta['viewRole'])) {
                if (in_array($roleId, $meta['viewRole'])) {
                    $filtered[$key] = $meta;
                }
            }
        }

    
        return ['filtered' => $filtered, 'abc' => $table, 'roleId' => $roleId];
    }
    function updateContent(&$inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stage = [];
        try {
            $pdo->beginTransaction(); // Start transaction
            $tableName = toSnakeCase($inputData['table']) ?? null;
            $inputData['dataKey'] = $inputData['table'];
            $changeType = $inputData['recordType'] ?? null;
            // ✅ Check if the extracted data block actually exists
            if (!isset($inputData['dataKey']) || empty($inputData['dataKey'])) {
                $pdo->rollback(); // Rollback transaction
                return ['status' => 'failed', 'message' => "Missing data block for table: {$tableName}"];
            }
            $stage[] = '00: Validate ID, prepare $inputData with idField, id, checkParent';
            // 00: Validate ID, prepare $inputData with idField, id, checkParent
            $res = validateUpdateInputStep($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }

            $stage[] = '01: check item is not marked as deleted no update is possible';
            
    

        if($changeType === 'update') {
            $stage[] = '02: Fetch existing history data (before change)';
            // 02: Fetch existing history data (before change)
            $inputData['nextOperation'] = 'getDataForHistory';
            $res = executeDatabaseOperation($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
            $inputData['historyData'] = $res['historyData'] ?? null;

            $stage[] = '03: Insert history record into history table';
            // 03: Insert history record into history table
            $inputData['nextOperation'] = 'saveHistoryRecordStep';
            $res = executeDatabaseOperation($inputData);

            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
        }
            $stage[] = '04: check if this is an update or a delete action';
            // 04: check if this is an update or a delete action

            $stage[] = '05: check if this is an update or a duplicate action';
            // 05: check if this is an update or a delete action
            if($changeType === 'update') {
                $inputData['nextOperation'] = 'updateMenuTable';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '06: check if this is a duplicate action';
            // 06: check if this is a duplicate action
            if($changeType === 'duplicate') {
                $inputData['nextOperation'] = 'duplicateRecored';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '07: check if the delete or update was successful';
            // 07: check if the delete or update was successful
            if($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
           }
            $pdo->commit();
            return [ 'status' => 'success','message' => 'Update completed successfully'];
        } catch (Exception $e) {
            $pdo->rollback(); // Rollback transaction on error
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                return ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $errorMessage, 'stage' => $stage];
            } else {
                error_log("Error in updateContent: " . $e->getMessage());
                return ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
    }
    function validateUpdateInputStep(&$inputData) {
        $table = $inputData['table'] ?? null;
        $tableName = toSnakeCase($table);
        $roleId = $inputData['roleId'] ?? null;
        $dataKey = $inputData['table'];
        $actionType = $inputData['recordType'] ?? null;
    
        if (!$tableName) {
            return ['status' => 'failed', 'message' => 'Table name not specified in input'];
        }
    
        if (!$dataKey) {
            return ['status' => 'failed', 'message' => 'Data key not extracted from table name'];
        }


        $tableData = $inputData[$dataKey] ?? [];
            
        $map = menuTableColumnMapping($tableName, $roleId, $actionType);

        $columnMap = $map['filtered'] ?? null;
        
        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'No column mapping found for table: '. $tableName];
        }
    
        // 🆕 Find the primary key field
        $primaryKey = null;
        foreach ($columnMap as $key => $meta) {
            if (isset($meta['mapping']) && strtolower($meta['mapping']) === 'id') {
                $primaryKey = $key;
                break;
            }
        }
    
        if (!$primaryKey) {
            return ['status' => 'failed', 'message' => "No primary key (id) field found for table: {$tableName}"];
        }
    
        // 🆕 Recursively search for the ID value
        $idValue = findIdInData($tableData, $primaryKey);
    
        if ($idValue === null || $idValue === '') {
            return ['status' => 'failed', 'message' => "Missing required Id field: {$primaryKey} key: {$tableName}"];
        }
    
        // Set ID info for future steps
        $inputData['idField'] = $primaryKey;
        $inputData['id'] = $idValue;
    
        // Set checkParent flag
        $inputData['checkParent'] = array_key_exists('parentId', $columnMap) ? 1 : 0;

        return ['status' => 'success'];
    }
    function findIdInData($data, $primaryKey) {
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                // Recurse into sub-arrays
                $found = findIdInData($value, $primaryKey);
                if ($found !== null) {
                    return $found;
                }
            } else {
                if ($key === $primaryKey) {
                    return $value;
                }
            }
        }
        return null;
    }
    function executeDatabaseOperation(&$inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function convertKeysToCamelCase($array) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Convert snake_case to camelCase
            $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
                return strtoupper($matches[1]);
            }, $key);

            // Lowercase first character to enforce camelCase
            $camelKey = lcfirst($camelKey);

            // Recursively handle nested arrays
            if (is_array($value)) {
                $converted[$camelKey] = convertKeysToCamelCase($value);
            } else {
                $converted[$camelKey] = $value;
            }
        }

        return $converted;
    }
    function toSnakeCase($input) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
    }
    function renameIdKeys($array, $newKeyName) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Recursively handle nested arrays
            if (is_array($value)) {
                $value = renameIdKeys($value, $newKeyName);
            }

            if ($key === 'id') {
                $converted[$newKeyName] = $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }
    function extractDataKeyFromTableName($tableName) {
        $parts = explode('_', $tableName, 2);
        $base = $parts[1] ?? $tableName;
    
        $baseParts = explode('_', $base);
    
        $camelCase = array_shift($baseParts);
    
        foreach ($baseParts as $part) {
            $camelCase .= ucfirst($part);
        }
    
        return $camelCase;
    }
    function roleViewType($roleId) {
        if(in_array($roleId, [1, 2, 3])) {
            return 'sysAdmin';
        } elseif($roleId == 4) {
            return 'owner';
        } elseif($roleId == 5) {
            return 'manager';
        } elseif($roleId == 6) {
            return 'staff';
        } else{
            return 'guest';
        }
    }
    function generateChecksum(array $data): string{
        // Sort the array by key (alphabetically)
        ksort($data);

        // Normalize values (e.g., trim and cast to string)
        $normalizedValues = array_map(function ($value) {
            return is_null($value) ? '' : trim((string)$value);
        }, $data);

        // Join values with a consistent separator (e.g., pipe)
        $inputString = implode('|', $normalizedValues);

        // Generate checksum (SHA-256)
        return hash('sha256', $inputString);
    }
    function acceptedPreAuthPayment($inputData){
        // check if the id is set
        $inputData['step'][] = 'acceptedPreAuthPayment()';

        if (isset($inputData['foodOrder']) && is_array($inputData['foodOrder'])) {
            if (isset($inputData['foodOrder'][0]) && is_array($inputData['foodOrder'][0])) {
                $inputData['foodOrder'] = $inputData['foodOrder'][0];
            }
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - validation';
        if(!isset($inputData['foodOrder']['id']) || empty($inputData['foodOrder']['id'])) {
            return ['status' => 'failed', 'message' => 'Order ID is required for pre-auth payment.'];
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - check accepted or rejected';
        //check if accepted or rejected 1 or 0 is set
        if(!isset($inputData['foodOrder']['accepted']) || !in_array($inputData['foodOrder']['accepted'], [0, 1])) {
            return ['status' => 'failed', 'message' => 'Accepted value is required for pre-auth payment.'];
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - set order status';
        // unset the accepted key
        if($inputData['foodOrder']['accepted'] == 0) {
            // if accepted is 0, then we will cancel the order
            $inputData['foodOrder']['orderStatus'] = 'cancelled';
            $inputData['step'][] = 'acceptedPreAuthPayment() - order status set to cancelled';
        }else{
            // if accepted is 1, then we will confirm the order
            $inputData['foodOrder']['orderStatus'] = 'confirmed';
            $inputData['step'][] = 'acceptedPreAuthPayment() - order status set to confirmed';
        }

        // unset the accepted key
        $inputData['step'][] = 'acceptedPreAuthPayment() - unsetting accepted key';
        unset($inputData['foodOrder']['accepted']);



        // get the payment intent id from the order
        $inputData['step'][] = 'acceptedPreAuthPayment() - getting payment intent id from order';
        $inputData['nextOperation'] = 'viewPaymentIntentOrderById';
        $inputData['id'] = $inputData['foodOrder']['id'];
        $res = executeDatabaseOperation($inputData);

        $inputData['step'][] = 'acceptedPreAuthPayment() - getting payment intent id from order';
        if($res['status'] !== 'success') {
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
            }
            return ['status' => 'failed', 'message' => $res['message']];
        }


        // check if the payment intent id is set
        if(!isset($res['data']['paymentIntentId']) || empty($res['data']['paymentIntentId'])) {
            // if debug mode is on, return the error
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => 'Payment intent ID is missing from the order.', 'step' => $inputData['step']];
            }else{
                return ['status' => 'failed', 'message' => 'Payment intent ID is missing from the order.'];
            }
        }
        
        // set the payment intent id in the inputData
        $inputData['step'][] = 'acceptedPreAuthPayment() - payment intent id found';
        $inputData['secure']['paymentIntentId'] = $res['data']['paymentIntentId'];


        // get the payment Account Id from tenant info
        $inputData['step'][] = 'acceptedPreAuthPayment() - getting tenant API key';
        $inputData['nextOperation'] = 'viewTenantInfo';
        $res = executeDatabaseOperation($inputData);

        if($res['status'] !== 'success') {
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
            }
            return ['status' => 'failed', 'message' => $res['message']];
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - tenant API key found';
        $inputData['secure']['stripeAccountKey'] = $res['tenantInfo']['paymentApiKey'] ?? null;


        $inputData['step'][] = 'acceptedPreAuthPayment() - stripe secret key found';
        if($inputData['foodOrder']['orderStatus'] == 'cancelled') {
            // if the order is cancelled, we will cancel the payment intent
            $inputData['step'][] = 'acceptedPreAuthPayment() - cancelling payment intent';
            $res = cancelPayment($inputData);
            if($res['status'] !== 'success') {
                if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
                }
                return ['status' => 'failed', 'message' => $res['message']];
            }

            $inputData['stripe'] = $res['data'];

            // send cancel email:
             $res = sendEmailCancelled($inputData);

                if($res['status'] !== 'success') {
                    if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                        return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step'], 'res' => $res];
                    }
                    return ['status' => 'failed', 'message' => $res['message']];
                }
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - processing confirmed order';
        if($inputData['foodOrder']['orderStatus'] == 'confirmed') {
            $inputData['step'][] = 'acceptedPreAuthPayment() - charging payment intent';
            // if the order is confirmed, we will charge the payment intent
            $res = chargePayment($inputData);
            if($res['status'] !== 'success') {
                if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
                }
                return ['status' => 'failed', 'message' => $res['message']];
            }

            $inputData['orderId'] = $inputData['foodOrder']['id'];

            $res = setUpReceipt($inputData);
            if($res['status'] !== 'success') {
                if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
                }
                return ['status' => 'failed', 'message' => $res['message']];
            }
        }

        $inputData['step'][] = 'acceptedPreAuthPayment() - updating order status';
        // set the next operation to update the order

        $res = updateSuccessful($inputData);
        $inputData['step'][] = 'acceptedPreAuthPayment() - order status updated';

        if($res['status'] !== 'success') {
            if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $res['message'], 'step' => $inputData['step']];
            }
            return ['status' => 'failed', 'message' => $res['message']];
        }


        if(isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
            return ['status' => 'success', 'message' => 'Order pre-auth payment accepted successfully.', 'step' => $inputData['step'], 'data' => $inputData];
        }
        return ['status' => 'success', 'message' => 'Order pre-auth payment accepted successfully.', 'data' => $res['data']];
    }
    function chargePayment($inputData, $captureAmountInPence = null) {
        if (empty($inputData['secure']['paymentIntentId'])) {
            return ['status' => 'failed', 'message' => 'Payment intent ID is required'];
        }

        if (defined('TEST_ENV') && TEST_ENV) {
            return ['status' => 'success', 'message' => 'Test environment – not charging'];
        }

        require_once __DIR__ . '/../vendor/autoload.php';
        if (!class_exists('\Stripe\Stripe')) {
            return ['status' => 'failed', 'message' => 'Stripe dependency not available'];
        }
        \Stripe\Stripe::setApiKey($inputData['secure']['stripeSecretKey']);
        \Stripe\Stripe::setAccountId($inputData['secure']['stripeAccountKey'] ?? null);
        $piId = $inputData['secure']['paymentIntentId'];

        try {
            $pi = \Stripe\PaymentIntent::retrieve($piId);

            if ($pi->status === 'requires_confirmation') {
                $pi = $pi->confirm(); // only if client didn’t confirm
            }

            if ($pi->status === 'requires_capture') {
                $captureParams = [];
                if (is_int($captureAmountInPence)) {
                    $captureParams['amount_to_capture'] = max(1, $captureAmountInPence);
                }
                $pi = $pi->capture($captureParams);
            }

            if ($pi->status === 'succeeded') {
                // last charge ID is available in the PaymentIntent object
                $inputData['secure']['chargeId'] = $pi->latest_charge;
                // url of receipt
                $inputData['secure']['receiptUrl'] = $pi->charges->data[0]->receipt_url ?? null;


                $res = updateWithChargeId($inputData);
                if ($res['status'] !== 'success') {
                    return ['status' => 'failed', 'message' => $res['message']];
                }

                return ['status' => 'success', 'message' => 'Payment charged successfully'];

            }

            return ['status' => 'failed', 'message' => "Cannot charge payment in status '{$pi->status}'"];
        } catch (\Stripe\Exception\ApiErrorException $e) {
            return ['status' => 'failed', 'message' => $e->getMessage()];
        }
    }
    function cancelPayment(&$inputData, $cancellationReason = 'abandoned') {
        // Validate
        if (empty($inputData['secure']['paymentIntentId'])) {
            return ['status' => 'failed', 'message' => 'Payment intent ID is required for cancelling payment.'];
        }

        // Respect test mode
        if (defined('TEST_ENV') && TEST_ENV) {
            return ['status' => 'success', 'message' => 'Test environment – not cancelling.'];
        }

        require_once __DIR__ . '/../vendor/autoload.php';
        if (!class_exists('\Stripe\Stripe')) {
            return ['status' => 'failed', 'message' => 'Stripe dependency not available'];
        }

        \Stripe\Stripe::setApiKey($inputData['secure']['stripeSecretKey']);
        \Stripe\Stripe::setAccountId($inputData['secure']['stripeAccountKey'] ?? null);
        $piId = $inputData['secure']['paymentIntentId'];

        // If you created the PI on a connected account directly, set this:
        // $opts = ['stripe_account' => $inputData['secure']['shopStripeAccountId']];
        $opts = [];

        try {
            /** @var \Stripe\PaymentIntent $pi */
            $pi = \Stripe\PaymentIntent::retrieve($piId, $opts);

            // If already cancelled, we're done
            if ($pi->status === 'canceled') {
                return ['status' => 'success', 'message' => 'Payment already canceled (hold released).'];
            }

            // Allowed-to-cancel (releases the hold) — do NOT refund
            $cancellable = [
                'requires_capture',       // auth placed, waiting for capture
                'requires_confirmation',  // not confirmed yet
                'requires_payment_method',
                'requires_action',
                'processing',             // may cancel depending on timing/method
            ];

            if (in_array($pi->status, $cancellable, true)) {
                $pi = $pi->cancel(['cancellation_reason' => $cancellationReason], $opts);

                $inputData['orderId'] = $inputData['foodOrder']['id'] ?? null;
                $inputData['receipt'] = "enabled";
                $res = viewFullOrderDetails($inputData);
                if ($res['status'] !== 'success') {
                    return ['status' => 'failed', 'message' => $res['message']];
                }
                $order = $res['orderDetails'][0] ?? null;
                $inputData['order']   = $order;
                $inputData['stripe']  = $pi;

                return ['status' => 'success', 'message' => 'Authorization hold released (payment canceled).', 'data' => $pi, 'input' => $inputData];
            }

            // If already captured, do NOT refund (per your rule)
            if ($pi->status === 'succeeded') {

                $res = updateCancelled($inputData);
                if ($res['status'] !== 'success') {
                    return ['status' => 'failed', 'message' => $res['message']];
                }

                // If already captured, do NOT refund (per your rule)
                return [
                    'status'  => 'failed',
                    'message' => 'Payment already captured; cannot release hold without refund (refunds are disabled).'
                ];
            }
            
            $inputData['stripe']    = $pi;

            // Any other odd status
            return [
                'status'  => 'failed',
                'message' => "Cannot cancel payment in status '{$pi->status}'."
            ];
        } catch (\Stripe\Exception\ApiErrorException $e) {
            return ['status' => 'failed', 'message' => 'Stripe error: ' . $e->getMessage()];
        } catch (\Exception $e) {
            return ['status' => 'failed', 'message' => 'Error: ' . $e->getMessage()];
        }
    }
    function esc($v): string { 
        return htmlspecialchars((string)$v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); 
    }
    function money($n): string { 
        return '£' . number_format((float)($n ?? 0), 2, '.', ''); 
    }
    function aget(array $arr, string $key, $default = null) { 
        return array_key_exists($key, $arr) ? $arr[$key] : $default; 
    }
    function currentHost(): string {
        return preg_replace('#^https?://#i', '', (string)($_SERVER['HTTP_HOST'] ?? $_SERVER['SERVER_NAME'] ?? 'localhost'));
    }
    function apexDomain(string $host): string {
        $h = strtolower(preg_replace('/[^a-z0-9.\-]/i', '', $host));
        $parts = array_values(array_filter(explode('.', $h)));
        $n = count($parts);
        if ($n < 2) return $h ?: 'localhost';
        $tld = $parts[$n-1];
        $sld = $parts[$n-2];
        $ukLike = ($tld === 'uk' && in_array($sld, ['co','org','ac','gov','ltd','plc','net'], true));
        $keep = $ukLike && $n >= 3 ? 3 : 2;
        return implode('.', array_slice($parts, -$keep));
    }
    if (!function_exists('str_contains')) {
        function str_contains(string $haystack, string $needle): bool {
            return $needle === '' || strpos($haystack, $needle) !== false;
        }
    }
    if (!function_exists('str_starts_with')) {
        function str_starts_with(string $haystack, string $needle): bool {
            return $needle === '' || strpos($haystack, $needle) === 0;
        }
    }
    if (!function_exists('str_ends_with')) {
        function str_ends_with(string $haystack, string $needle): bool {
            if ($needle === '') return true;
            $len = strlen($needle);
            return substr($haystack, -$len) === $needle;
        }
    }
    function computeNoReplyFrom(?string $fallbackDomain = null): string {
        $host = currentHost();
        $apex = apexDomain($host);
        if ($apex === 'localhost') $apex = ($fallbackDomain ?: 'example.com');
        return "no-reply@{$apex}";
    }
    function computeBaseUrl(): string {
        $https  = $_SERVER['HTTPS'] ?? '';
        $scheme = (!empty($https) && strtolower($https) !== 'off') ? 'https' : 'http';
        return $scheme . '://' . currentHost();
    }
    function absolutizeUrl(string $url, string $base): string {
        if (preg_match('#^https?://#i', $url)) return $url;
        if (strpos($url, '//') === 0) {
            $scheme = parse_url($base, PHP_URL_SCHEME) ?: 'https';
            return $scheme . ':' . $url;
        }
        return rtrim($base, '/') . '/' . ltrim($url, '/');
    }
    function buildTrackUrl(array $order, ?string $baseUrl = null): string {
        $base = $baseUrl ?: computeBaseUrl();
        $q = http_build_query([
            'orderId' => aget($order, 'id', ''),
            'email'   => aget($order, 'userEmail', ''),
        ]);
        return rtrim($base, '/') . '/order-confirmed?' . $q;
    }
    function buildAddressHtml(array $order): string {
        if (strtolower((string)aget($order, 'orderType', '')) !== 'delivery') return '';
        $d = (array) aget($order, 'delivery', []);
        if (!$d) return '';
        return '
        <tr><td style="padding:12px 0 0">
        <h3 style="margin:0 0 8px;font-size:16px;color:#111">Delivery Address</h3>
        <p style="margin:0;line-height:1.5;color:#444">'.
            esc(aget($d,'address_line_1','')).'<br>'.
            (aget($d,'address_line_2') ? esc(aget($d,'address_line_2')).'<br>' : '').
            esc(aget($d,'city','')).(aget($d,'county') ? ', '.esc(aget($d,'county')) : '').'<br>'.
            esc(aget($d,'postal_code','')).'<br>'.
            esc(aget($d,'country','')).'
        </p>
        </td></tr>';
    }
    function buildItemsHtml(array $order): string {
        $items = (array) aget($order, 'details', []);
        if (!$items) return '<tr><td style="padding:8px 0;color:#666">No items.</td></tr>';
        $html = '';
        foreach ($items as $item) {
            $extrasHtml = '';
            $extras = (array) aget($item, 'extras', []);
            if ($extras) {
                $parts = array_map(function($ex){
                    return '<div>+ '.esc(aget($ex,'extraName','')).' (x'.((int)aget($ex,'extraQuantity',1)).', '.money(aget($ex,'extraPrice',0)).')</div>';
                }, $extras);
                $extrasHtml = '<div style="margin-top:4px;color:#666;font-size:13px">'.implode('', $parts).'</div>';
            }
            $html .= '
            <tr><td style="padding:8px 0;border-bottom:1px solid #eee;">
            <div style="display:flex;justify-content:space-between;gap:12px">
                <div><div style="font-weight:600;color:#111">'.esc(aget($item,'itemQuantity',1)).' × '.esc(aget($item,'itemName','')).'</div>'.$extrasHtml.'</div>
                <div style="white-space:nowrap">'.money(aget($item,'itemModifiedPrice',0)).'</div>
            </div>
            </td></tr>';
        }
        return $html;
    }
    function buildTotalsHtml(array $order): array {
        $subtotal      = (float) aget($order, 'totalOrderModifiedPrice', 0);
        $deliveryFee   = (float) aget($order, 'deliveryFee', 0);
        $serviceFee    = (float) aget($order, 'orderFee', 0);
        $smallOrderFee = (float) aget($order, 'smallOrderFee', 0);
        $grandTotal    = $subtotal + $deliveryFee + $serviceFee + $smallOrderFee;

        $rows = [
            ['Subtotal', $subtotal, true],
            ['Delivery Fee', $deliveryFee, $deliveryFee > 0],
            ['Service Fee', $serviceFee, $serviceFee > 0],
            ['Small Order Fee', $smallOrderFee, $smallOrderFee > 0],
        ];
        $html = '';
        foreach ($rows as [$label,$value,$show]) {
            if (!$show) continue;
            $html .= '<tr><td style="padding:6px 0;color:#444">'.esc($label).'</td><td style="padding:6px 0;text-align:right;color:#444">'.money($value).'</td></tr>';
        }
        $html .= '<tr><td style="padding-top:10px;border-top:1px solid #ddd;font-weight:700;color:#111">Total</td><td style="padding-top:10px;border-top:1px solid #ddd;text-align:right;font-weight:700;color:#111">'.money($grandTotal).'</td></tr>';
        return [$html, $grandTotal];
    }
    function buildEmailReceiptHtml(array $order, array $brand = []): string {
        $brandName   = aget($brand,'name','Your Shop');
        $brandColor  = aget($brand,'color','#0b5fff');
        $brandLogo   = aget($brand,'logo',null);
        $supportLine = aget($brand,'support','Reply to this email if you have any questions.');
        $baseUrl     = computeBaseUrl();
        if ($brandLogo) $brandLogo = absolutizeUrl((string)$brandLogo, $baseUrl);

        $status = ucfirst((string) aget($order,'orderStatus','Pending'));
        $pay    = ucfirst((string) aget($order,'paymentStatus','Unpaid'));
        $pillBg = '#eef4ff'; $pillFg = $brandColor;

        $trackUrl     = buildTrackUrl($order, $baseUrl);
        $addressHtml  = buildAddressHtml($order);
        $itemsHtml    = buildItemsHtml($order);
        [$totalsHtml] = buildTotalsHtml($order);

        $id   = esc((string) aget($order,'id','—'));
        $type = ucfirst(esc((string) aget($order,'orderType','')));
        $when = esc((string) aget($order,'createdAtDisplay','—'));

        $custNote   = trim((string) aget($order,'comment',''));
        $tenantNote = trim((string) aget($order,'tenantComment',''));

        return '
                <!doctype html><html lang="en"><head>
                <meta charset="utf-8"><meta name="viewport" content="width=device-width, initial-scale=1"/>
                <title>Order Receipt</title>
                <style>@media(max-width:600px){.container{padding:16px!important}h2{font-size:20px!important}} a{color:'.esc($brandColor).';}</style>
                </head><body style="margin:0;background:#f6f7fb;font-family:Segoe UI,Roboto,Helvetica,Arial,sans-serif;">
                <table role="presentation" width="100%" cellspacing="0" cellpadding="0" style="background:#f6f7fb;padding:20px 0"><tr><td align="center">
                <table role="presentation" width="640" class="container" cellspacing="0" cellpadding="0" style="width:640px;max-width:100%;background:#fff;border-radius:12px;padding:24px;box-shadow:0 4px 18px rgba(18,38,63,.08)">
                <tr><td style="text-align:center;padding:8px 0 18px">'.
                    ($brandLogo ? '<img src="'.esc($brandLogo).'" alt="'.esc($brandName).'" style="max-width:180px;height:auto;display:block;margin:0 auto 8px">' : '').
                    '<div style="font-size:12px;color:#888">'.esc($brandName).'</div></td></tr>
                <tr><td>
                    <div style="display:flex;justify-content:space-between;align-items:center;gap:12px;flex-wrap:wrap">
                    <h2 style="margin:0;color:#111;font-size:22px">Thank you for your order!</h2>
                    <span style="display:inline-block;background:'.$pillBg.';color:'.$pillFg.';font-weight:600;font-size:12px;padding:6px 10px;border-radius:999px;letter-spacing:.3px">'.esc($status).'</span>
                    </div>
                    <p style="margin:10px 0 0;color:#444;line-height:1.5"><strong>Order #</strong> '.$id.' · <strong>Type</strong> '.$type.' · <strong>Placed</strong> '.$when.' · <strong>Payment</strong> '.esc($pay).'</p>
                    <div style="margin:16px 0 0"><a href="'.esc($trackUrl).'" style="display:inline-block;text-decoration:none;background:'.esc($pillFg).';color:#fff;font-weight:600;padding:10px 16px;border-radius:8px" target="_blank" rel="noopener">Track your order</a></div>
                </td></tr>'.
                $addressHtml.
                '<tr><td style="padding:18px 0 6px"><h3 style="margin:0;font-size:16px;color:#111">Items</h3></td></tr>
                <tr><td><table role="presentation" width="100%" cellspacing="0" cellpadding="0">'.$itemsHtml.'</table></td></tr>
                <tr><td style="padding:18px 0 6px"><h3 style="margin:0;font-size:16px;color:#111">Summary</h3></td></tr>
                <tr><td><table role="presentation" width="100%" cellspacing="0" cellpadding="0">'.$totalsHtml.'</table></td></tr>'.
                ($custNote !== '' ? '<tr><td style="padding:16px 0 0"><h3 style="margin:0 0 6px;font-size:16px;color:#111">Customer Note</h3><p style="margin:0;color:#444;line-height:1.5">'.esc($custNote).'</p></td></tr>' : '').
                ($tenantNote !== '' ? '<tr><td style="padding:16px 0 0"><h3 style="margin:0 0 6px;font-size:16px;color:#111">Shop Message</h3><p style="margin:0;color:#444;line-height:1.5">'.esc($tenantNote).'</p></td></tr>' : '').
                '<tr><td style="padding:22px 0 0"><p style="margin:0;color:#666;font-size:13px;line-height:1.5">'.esc($supportLine).'</p><p style="margin:10px 0 0;color:#9aa3b2;font-size:12px">This receipt is for order confirmation. Prices include VAT where applicable.</p></td></tr>
                </table></td></tr></table></body></html>';
    }
    function generateReceiptEmailFromOrder(array $order, array $brand = [], ?string $tenantReplyTo = null): array {
        return [
            'from'     => computeNoReplyFrom(),                                 // e.g. no-reply@yourdomain.tld
            'to'       => (string) aget($order,'userEmail',''),
            'subject'  => 'Your receipt for Order #'.(string) aget($order,'id',''),
            'html'     => buildEmailReceiptHtml($order, $brand),
            'replyTo'  => $tenantReplyTo,                                       // optional
            'fromName' => aget($brand,'name','Waitron'),
        ];
    }
    function sendReceiptEmail_viaMail(array $emailPayload): bool {
        $traceId = bin2hex(random_bytes(6)); // short trace
        $headers  = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/html; charset=utf-8\r\n";
        $headers .= "X-App-Trace-Id: {$traceId}\r\n";

        // Important: From domain should be local to the cPanel account
        $fromName  = $emailPayload['fromName'] ?? 'No-Reply';
        $fromEmail = $emailPayload['from'];
        $headers .= "From: {$fromName} <{$fromEmail}>\r\n";

        if (!empty($emailPayload['replyTo'])) {
            $headers .= "Reply-To: {$emailPayload['replyTo']}\r\n";
        }

        // Optional: Set envelope sender to match From (helps deliverability on cPanel/Exim)
        $params = "-f {$fromEmail}";

        $ok = mail($emailPayload['to'], $emailPayload['subject'], $emailPayload['html'], $headers, $params);

        // Log locally for debugging (ensure the directory is writable)
        error_log("[receipt-mail][$traceId] to={$emailPayload['to']} from={$fromEmail} ok=" . ($ok ? '1' : '0'));

        return $ok;
    }
    function sendReceiptEmail_smtpCpanel(array $emailPayload, array $cp): bool {
        if (!class_exists('PHPMailer\PHPMailer\PHPMailer')) {
            error_log('PHPMailer not found (composer require phpmailer/phpmailer).');
            return false;
        }
        $hostGuess = 'mail.'.apexDomain(currentHost());
        $host  = (string) (aget($cp,'host',$hostGuess));
        $port  = (int) (aget($cp,'port', 465));       // cPanel defaults: 465/SSL or 587/TLS
        $secure= strtolower((string) (aget($cp,'secure','ssl'))); // 'ssl' or 'tls'

        $mail = new PHPMailer\PHPMailer\PHPMailer(true);
        try {
            $mail->isSMTP();
            $mail->Host       = $host;
            $mail->Port       = $port;
            $mail->SMTPAuth   = true;
            $mail->Username   = (string) aget($cp,'username','');
            $mail->Password   = (string) aget($cp,'password','');

            if ($secure === 'ssl') {
                $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_SMTPS; // 465
            } else {
                $mail->SMTPSecure = PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS; // 587
            }

            // cPanel servers usually require From to match the authenticated domain/mailbox
            $mail->setFrom($emailPayload['from'], (string)($emailPayload['fromName'] ?? 'No-Reply'));
            $mail->addAddress((string)$emailPayload['to']);
            if (!empty($emailPayload['replyTo'])) {
                $mail->addReplyTo((string)$emailPayload['replyTo'], (string)($emailPayload['fromName'] ?? 'Shop'));
            }

            $mail->isHTML(true);
            $mail->Subject = (string)$emailPayload['subject'];
            $mail->Body    = (string)$emailPayload['html'];
            $mail->AltBody = 'This email requires HTML to view properly.';

            return $mail->send();
        } catch (Throwable $e) {
            error_log('cPanel SMTP send failed: '.$e->getMessage());
            return false;
        }
    }
    function buildCancelledEmail_FromInputData(array $inputData){
        // --- helpers (safe to redeclare if not already present)
        if (!function_exists('esc')) {
            function esc($s) { return htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
        }
        $step = function($msg) use (&$inputData) {
            if (!isset($inputData['step']) || !is_array($inputData['step'])) $inputData['step'] = [];
            $inputData['step'][] = "cancelEmail() - " . $msg;
        };

        $step('start');

        $stripe   = $inputData['stripe']  ?? null;  // Stripe PI
        $order    = $inputData['order']   ?? null;  // Enriched order block
        $tenantTz = $inputData['tenantTz'] ?? 'Europe/London';

        if (!$stripe) { $step('missing stripe data'); return ['status'=>'failed','message'=>'Stripe data missing','inputData'=>$inputData]; }
        if (!$order)  { $step('missing order');      return ['status'=>'failed','message'=>'Order block missing','inputData'=>$inputData]; }

        $toEmail  = trim((string)($order['userEmail'] ?? ''));
        $fullName = trim(implode(' ', array_filter([$order['firstName'] ?? '', $order['lastName'] ?? ''])));
        if ($toEmail === '') {
            $step('no recipient email');
            return ['status'=>'failed','message'=>'No recipient email on the order','inputData'=>$inputData];
        }

        // Time: Stripe canceled_at (epoch, UTC) -> local display
        $cancelEpoch = (int)($stripe['canceled_at'] ?? 0);
        if ($cancelEpoch <= 0) $cancelEpoch = time();
        $cancelUtcYmdHis = gmdate('Y-m-d H:i:s', $cancelEpoch);
        $cancelIso       = function_exists('utc_to_iso8601z') ? utc_to_iso8601z($cancelUtcYmdHis) : gmdate('Y-m-d\TH:i:s\Z', $cancelEpoch);
        $cancelDisplay   = function_exists('format_utc_for_tz')
            ? format_utc_for_tz($cancelUtcYmdHis, $tenantTz, 'd M Y H:i:s')
            : gmdate('d M Y H:i:s', $cancelEpoch) . ' (UTC)';
        $cancelDisplayWithTz = $cancelDisplay . " ({$tenantTz})";

        // Currency + amounts (minor units from Stripe; fallback to order total)
        $currency   = strtoupper((string)($stripe['currency'] ?? 'GBP'));
        $heldDec    = isset($stripe['amount'])
            ? number_format(((int)$stripe['amount']) / 100, 2, '.', '')
            : number_format((float)($order['totalOrderModifiedPrice'] ?? 0), 2, '.', '');
        $orderId    = (int)($order['id'] ?? ($stripe['metadata']['orderId'] ?? 0));
        $reason     = (string)($stripe['cancellation_reason'] ?? 'cancelled');
        $subject    = "Order #{$orderId} cancelled — pre-authorisation released";

        // Fees (normalize)
        $deliveryFee    = isset($order['deliveryFee'])    ? number_format((float)$order['deliveryFee'],    2, '.', '') : null;
        $orderFee       = isset($order['orderFee'])       ? number_format((float)$order['orderFee'],       2, '.', '') : null;
        $smallOrderFee  = isset($order['smallOrderFee'])  ? number_format((float)$order['smallOrderFee'],  2, '.', '') : null;
        $totalFormatted = isset($order['totalOrderModifiedPrice']) ? number_format((float)$order['totalOrderModifiedPrice'], 2, '.', '') : null;
        $orderTypeTitle = ucfirst((string)($order['orderType'] ?? '-'));

        // --- brand + assets (match success/receipt header)
        $brandName   = aget($inputData,'brandName','Waitron');
        $brandColor  = aget($inputData,'brandColor','#0b5fff');
        $brandLogo   = aget($inputData,'brandLogo',null);
        $baseUrl     = computeBaseUrl();
        if ($brandLogo) $brandLogo = absolutizeUrl((string)$brandLogo, $baseUrl);

        // Status pill styling (cancellation)
        $pillBg = '#fff1f1';
        $pillFg = '#d93025';

        // decide which rows to render (hide if 0/0.00/null/"0")
        $showDelivery   = is_numeric($deliveryFee)   ? ((float)$deliveryFee   > 0) : false;
        $showOrderFee   = is_numeric($orderFee)      ? ((float)$orderFee      > 0) : false;
        $showSmallOrder = is_numeric($smallOrderFee) ? ((float)$smallOrderFee > 0) : false;

        // --- HTML (header styled like success email)
        $html = "<!doctype html><html lang=\"en\">
                    <head>
                    <meta charset=\"utf-8\"><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/>
                    <title>Order Cancelled</title>
                    <style>@media(max-width:600px){.container{padding:16px!important}h2{font-size:20px!important}} a{color:".esc($brandColor).";}</style>
                    </head>
                    <body style=\"margin:0;background:#f6f7fb;font-family:Segoe UI,Roboto,Helvetica,Arial,sans-serif;\">
                    <table role=\"presentation\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"background:#f6f7fb;padding:20px 0\"><tr><td align=\"center\">

                    <table role=\"presentation\" width=\"640\" class=\"container\" cellspacing=\"0\" cellpadding=\"0\" style=\"width:640px;max-width:100%;background:#fff;border-radius:12px;padding:24px;box-shadow:0 4px 18px rgba(18,38,63,.08);border:1px solid #eee\">

                    <!-- Brand header (same style as success) -->
                    <tr><td style=\"text-align:center;padding:8px 0 18px\">"
                        . ($brandLogo ? '<img src=\"'.esc($brandLogo).'\" alt=\"'.esc($brandName).'\" style=\"max-width:180px;height:auto;display:block;margin:0 auto 8px\">' : '')
                        . '<div style=\"font-size:12px;color:#888\">'.esc($brandName).'</div>'
                    . "</td></tr>

                    <tr><td>
                        <div style=\"display:flex;justify-content:space-between;align-items:center;gap:12px;flex-wrap:wrap\">
                        <h2 style=\"margin:0;color:#111;font-size:22px\">Order #".esc($orderId)." cancelled</h2>
                        <span style=\"display:inline-block;background:{$pillBg};color:{$pillFg};font-weight:600;font-size:12px;padding:6px 10px;border-radius:999px;letter-spacing:.3px\">Cancelled</span>
                        </div>
                        <p style=\"margin:10px 0 0;color:#777\">".esc($cancelDisplayWithTz)."</p>

                        <p style=\"margin:16px 0 0;color:#111\">Hi ".esc($fullName ?: 'there').",</p>
                        <p style=\"margin:8px 0 0;color:#444\">
                        Your order has been <strong>cancelled</strong>. The card <em>pre-authorisation</em> has been released by your bank — you won’t be charged.
                        </p>

                        <p style=\"margin:8px 0 0;color:#444\"><strong>Reason:</strong> ".esc($reason)."</p>

                        <hr style=\"border:none;border-top:1px solid #eee;margin:16px 0\">
                    </td></tr>

                    <!-- Summary (hide rows that are zero/null) -->
                    <tr><td style=\"padding:0 0 6px\"><h3 style=\"margin:0;font-size:16px;color:#111\">Order summary</h3></td></tr>
                    <tr><td>
                        <p style=\"margin:6px 0 0;color:#444\"><strong>Type:</strong> ".esc($orderTypeTitle)."</p>"
                        . ($totalFormatted !== null ? "<p style=\"margin:6px 0 0;color:#444\"><strong>Total (authorised):</strong> £".esc($totalFormatted)."</p>" : "")
                        . "<table role=\"presentation\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse:collapse;margin-top:8px;font-size:14px;color:#444\">"
                        . ($showDelivery   ? "<tr><td style='padding:6px 0;border-bottom:1px solid #eee'>Delivery fee</td><td style='padding:6px 0;border-bottom:1px solid #eee;text-align:right'>£".esc($deliveryFee)."</td></tr>" : "")
                        . ($showOrderFee   ? "<tr><td style='padding:6px 0;border-bottom:1px solid #eee'>Service/Order fee</td><td style='padding:6px 0;border-bottom:1px solid #eee;text-align:right'>£".esc($orderFee)."</td></tr>" : "")
                        . ($showSmallOrder ? "<tr><td style='padding:6px 0;border-bottom:1px solid #eee'>Small order fee</td><td style='padding:6px 0;border-bottom:1px solid #eee;text-align:right'>£".esc($smallOrderFee)."</td></tr>" : "")
                        . "</table>
                    </td></tr>

                    <tr><td>
                        <div style=\"margin-top:12px;padding:10px;border:1px solid #e6f2e6;background:#f6fbf6;border-radius:8px;color:#0a3\">
                        <strong>Pre-authorisation released:</strong> £".esc($heldDec)." (".esc($currency).").<br>
                        Your bank may take a short time to show the release on your statement.
                        </div>

                        <p style=\"margin:16px 0 0;color:#9aa3b2;font-size:12px\">
                        Powered by Waitron.uk.
                        </p>
                    </td></tr>

                    </table>

                    <p style=\"text-align:center;color:#aaa;font-size:12px;margin-top:8px\">
                    This is an automated message. Ref: ".esc($stripe['id'] ?? '')."
                    </p>

                    </td></tr></table>
                    </body></html>";

        // --- Plain text (hide fee lines if zero)
        $textLines = [];
        $textLines[] = "Order #{$orderId} cancelled";
        $textLines[] = "{$cancelDisplayWithTz}";
        $textLines[] = "";
        $textLines[] = "Hi " . ($fullName ?: 'there') . ",";
        $textLines[] = "";
        $textLines[] = "Your order has been cancelled. The card pre-authorisation has been released by your bank — you won’t be charged.";
        $textLines[] = "";
        $textLines[] = "Reason: {$reason}";
        $textLines[] = "";
        $textLines[] = "Order summary";
        $textLines[] = "Type: {$orderTypeTitle}";
        if ($totalFormatted !== null) $textLines[] = "Total (authorised): £{$totalFormatted}";
        if ($showDelivery)   $textLines[] = " - Delivery fee: £{$deliveryFee}";
        if ($showOrderFee)   $textLines[] = " - Service/Order fee: £{$orderFee}";
        if ($showSmallOrder) $textLines[] = " - Small order fee: £{$smallOrderFee}";
        $textLines[] = "";
        $textLines[] = "Pre-authorisation released: £{$heldDec} ({$currency}).";
        $textLines[] = "Your bank may take a short time to show the release on your statement.";
        $textLines[] = "";
        $textLines[] = "Ref: " . ($stripe['id'] ?? '');
        $text = implode("\n", $textLines);

        // --- Sender fallbacks (safe local default)
        $defaultFrom  = computeNoReplyFrom();
        $fromEmail    = trim((string)($inputData['mail']['fromEmail']    ?? $defaultFrom));
        $fromName     = trim((string)($inputData['mail']['fromName']     ?? $brandName));
        $replyTo      = trim((string)($inputData['mail']['replyTo']      ?? ''));
        $envelopeFrom = trim((string)($inputData['mail']['envelopeFrom'] ?? $fromEmail));

        // --- Compose final payload
        $emailPayload = [
            'to'           => $toEmail,
            'toName'       => $fullName ?: null,
            'fromEmail'    => $fromEmail,
            'fromName'     => $fromName,
            'replyTo'      => $replyTo ?: null,
            'subject'      => $subject,
            'html'         => $html,
            'text'         => $text,
            'envelopeFrom' => $envelopeFrom,
            'meta'         => [
                'brand'            => $brandName,
                'orderId'          => $orderId,
                'tenantId'         => $inputData['tenantId'] ?? null,
                'paymentIntentId'  => $stripe['id'] ?? null,
                'cancelReason'     => $reason,
                'cancelledAtUtc'   => $cancelUtcYmdHis,
                'cancelledAtIso'   => $cancelIso,
                'cancelledAtDisplay'=> $cancelDisplayWithTz,
                'currency'         => $currency,
                'preauthRelease'   => true
            ],
        ];

        // --- Save into $inputData for downstream use
        $inputData['email']['cancelled'] = [
            'payload' => $emailPayload,
            'builtAt' => gmdate('c'),
        ];

        $sendNow = !empty($inputData['sendNow']);
        if ($sendNow) {
            if (!function_exists('sendCancelledEmail_viaMail')) {
                $inputData['email']['cancelled']['status']  = 'failed';
                $inputData['email']['cancelled']['message'] = 'sendCancelledEmail_viaMail() not defined';
                $step('send function missing');
                return ['status'=>'failed','message'=>'sendCancelledEmail_viaMail() not defined','emailPayload'=>$emailPayload,'inputData'=>$inputData];
            }
            $step('sending email');
            $ok = sendCancelledEmail_viaMail($emailPayload);
            if (!$ok) {
                $inputData['email']['cancelled']['status']  = 'failed';
                $inputData['email']['cancelled']['message'] = 'mail() returned false';
                $step('mail() returned false');
                return ['status'=>'failed','message'=>'mail() returned false','emailPayload'=>$emailPayload,'inputData'=>$inputData];
            }
            $inputData['email']['cancelled']['status']  = 'success';
            $inputData['email']['cancelled']['message'] = 'Cancellation email sent';
            $step('email sent');
            return ['status'=>'success','message'=>'Cancellation email sent','emailPayload'=>$emailPayload,'inputData'=>$inputData];
        }

        $inputData['email']['cancelled']['status']  = 'success';
        $inputData['email']['cancelled']['message'] = 'Cancellation email built (not sent)';
        $step('built only');
        return ['status'=>'success','message'=>'Cancellation email built (not sent)','emailPayload'=>$emailPayload,'inputData'=>$inputData];
    }
    function setUpReceipt(array &$inputData): array {
        $inputData['step'][] = 'setUpReceipt()';
        if (empty($inputData['orderId'])) {
            return ['status' => 'failed', 'message' => 'Order ID is required.'];
        }

        $inputData['receipt']   = 'enabled';
        $inputData['viewLevel'] = 'full';
        $orderRes = viewFullOrderDetails($inputData); // <-- your function

        $inputData['step'][] = 'setUpReceipt() - order details fetched';
        if (!is_array($orderRes) || ($orderRes['status'] ?? 'failed') !== 'success') {
            return ['status' => 'failed', 'message' => $orderRes['message'] ?? 'Order lookup failed.'];
        }

        $inputData['step'][] = 'setUpReceipt() - order details found';
        $orderList = $orderRes['orderDetails'][0] ?? $orderRes['data']['orderDetails'][0] ?? [];
        $order     = is_array($orderList) ? ($orderList ?? []) : (array)$orderList;
        if (!$order) {
            return ['status' => 'failed', 'message' => 'Order not found.'];
        }

        $inputData['step'][] = 'setUpReceipt() - generating email payload';
        // Pass brand + reply-to via $inputData (consistent with your pattern)
        $brand = [
            'name'    => aget($inputData,'brandName','Waitron'),
            'color'   => aget($inputData,'brandColor','#0b5fff'),
            'logo'    => aget($inputData,'brandLogo','/images/logo.png'),
            'support' => aget($inputData,'brandSupport','Reply to this email if you have any questions.'),
        ];

        $inputData['step'][] = 'setUpReceipt() - brand info prepared';
        $tenantReplyTo = aget($inputData,'tenantReplyTo',null);


        $inputData['step'][] = 'setUpReceipt() - generating email payload';
        $emailPayload = generateReceiptEmailFromOrder($orderList, $brand, $tenantReplyTo);

        // Send email (choose method as per your setup)
        // if test mode, skip sending
        if (defined('TEST_ENV') && TEST_ENV) {
            $inputData['step'][] = 'setUpReceipt() - test environment, skipping email send';
            $emailSent = false;
        } else {
            $inputData['step'][] = 'setUpReceipt() - sending email via cPanel SMTP';
            $emailSent = sendReceiptEmail_viaMail($emailPayload);
        }

        $inputData['step'][] = 'setUpReceipt() - email send attempted';

        return [
            'status'       => 'success',
            'message'      => 'Receipt built.',
            'data'         => $orderRes,
            'emailPayload' => $emailPayload,
        ];
    }
    function sendEmailCancelled(&$inputData) {
        $inputData['sendNow'] = true; // or false to just build

        $res = buildCancelledEmail_FromInputData($inputData);

        // Updated $inputData is also returned inside $res:
        $inputData = $res['inputData'];

        if ($res['status'] !== 'success') {
            error_log('[CancelEmail] ' . ($res['message'] ?? 'Unknown error'));
        }

        // Built payload for inspection/logging:
        $emailPayload = $inputData['email']['cancelled']['payload'] ?? null;

        if($res['status'] !== 'success') {
            return ['status' => 'failed', 'message' => $res['message'] ?? 'Email send failed', 'emailPayload' => $emailPayload];
        }else{
            return ['status' => 'success', 'message' => 'Cancellation email sent', 'emailPayload' => $emailPayload];
        }
    }
    function sendCancelledEmail_viaMail(array $p): bool{
        // ---- Basic validation
        $to         = trim((string)($p['to'] ?? ''));
        $subject    = (string)($p['subject'] ?? '');
        $fromEmail  = trim((string)($p['fromEmail'] ?? ''));
        $fromName   = (string)($p['fromName'] ?? '');
        $replyTo    = isset($p['replyTo']) ? trim((string)$p['replyTo']) : null;

        if ($to === '' || $subject === '' || $fromEmail === '') {
            return false;
        }
        if (!filter_var($to, FILTER_VALIDATE_EMAIL)) return false;
        if (!filter_var($fromEmail, FILTER_VALIDATE_EMAIL)) return false;
        if ($replyTo && !filter_var($replyTo, FILTER_VALIDATE_EMAIL)) $replyTo = null;

        // Guard against header injection
        foreach ([$to, $fromEmail, $replyTo, $fromName, $subject] as $v) {
            if ($v !== null && (str_contains((string)$v, "\r") || str_contains((string)$v, "\n"))) {
                return false;
            }
        }

        // ---- Helpers
        $encodeName = function (string $name): string {
            $name = trim($name);
            if ($name === '') return '';
            if (function_exists('mb_encode_mimeheader')) {
                return mb_encode_mimeheader($name, 'UTF-8', 'B', "\r\n");
            }
            // Fallback: simple quoting/escaping
            return '"' . addslashes($name) . '"';
        };

        $formatAddr = function (?string $name, string $email) use ($encodeName): string {
            $name = trim((string)$name);
            if ($name !== '') {
                return $encodeName($name) . " <{$email}>";
            }
            return $email;
        };

        $toHeader   = $formatAddr($p['toName'] ?? null, $to);
        $fromHeader = $formatAddr($fromName, $fromEmail);

        // ---- Subject encode (for non-ASCII)
        if (function_exists('mb_encode_mimeheader')) {
            $subject = mb_encode_mimeheader($subject, 'UTF-8', 'B', "\r\n");
        }

        // ---- Bodies
        $textBody = (string)($p['text'] ?? '');
        $htmlBody = (string)($p['html'] ?? '');

        // Pick a safe fallback if one is missing
        if ($textBody === '' && $htmlBody !== '') {
            // strip tags fallback for text
            $textBody = trim(html_entity_decode(strip_tags($htmlBody), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'));
        } elseif ($htmlBody === '' && $textBody !== '') {
            // minimal HTML wrapper fallback
            $htmlBody = '<!doctype html><html><body><pre style="white-space:pre-wrap">'
                    . htmlspecialchars($textBody, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8')
                    . '</pre></body></html>';
        } elseif ($htmlBody === '' && $textBody === '') {
            // nothing to send
            return false;
        }

        // ---- Headers
        $headers = [];
        $headers[] = "From: {$fromHeader}";
        if ($replyTo) {
            $headers[] = "Reply-To: {$replyTo}";
        }
        // CC / BCC (optional)
        $addListHeader = function (string $label, $val) use (&$headers) {
            if ($val === null) return;
            $arr = is_array($val) ? $val : [$val];
            $clean = [];
            foreach ($arr as $addr) {
                $addr = trim((string)$addr);
                if ($addr !== '' && filter_var($addr, FILTER_VALIDATE_EMAIL) && !str_contains($addr, "\r") && !str_contains($addr, "\n")) {
                    $clean[] = $addr;
                }
            }
            if ($clean) $headers[] = "{$label}: " . implode(', ', $clean);
        };
        $addListHeader('Cc',  $p['cc']  ?? null);
        $addListHeader('Bcc', $p['bcc'] ?? null);

        $headers[] = "MIME-Version: 1.0";

        $boundary = 'b_' . (function_exists('bin2hex') && function_exists('random_bytes')
                    ? bin2hex(random_bytes(12))
                    : md5(uniqid('', true)));

        // Always send multipart/alternative (text + HTML)
        $headers[] = "Content-Type: multipart/alternative; boundary=\"{$boundary}\"";

        $body  = "--{$boundary}\r\n";
        $body .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $body .= "Content-Transfer-Encoding: 8bit\r\n\r\n";
        $body .= $textBody . "\r\n\r\n";

        $body .= "--{$boundary}\r\n";
        $body .= "Content-Type: text/html; charset=UTF-8\r\n";
        $body .= "Content-Transfer-Encoding: 8bit\r\n\r\n";
        $body .= $htmlBody . "\r\n\r\n";

        $body .= "--{$boundary}--";

        // Envelope sender (Return-Path) improves deliverability on cPanel
        $params = '';
        if (!empty($p['envelopeFrom']) && filter_var($p['envelopeFrom'], FILTER_VALIDATE_EMAIL)) {
            // escapeshellarg to be safe; some hosts disable -f (in that case mail() will still return true if accepted)
            $params = '-f ' . escapeshellarg($p['envelopeFrom']);
        }

        // ---- Send
        return mail($to, $subject, $body, implode("\r\n", $headers), $params);
    }
?>