<?php
    function menuTableColumnMapping($table = null, $roleId = null, $actionType = null) {
       $allMappings = [
            'food_order' => [
                'fields' => [
                    'id'                        => ['mapping' => 'id',                          'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => null,         'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'userId'                    => ['mapping' => 'user_id',                     'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'guestUserId'               => ['mapping' => 'guest_user_id',               'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'tenantId'                  => ['mapping' => 'tenant_id',                   'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'deliveryAddressId'         => ['mapping' => 'delivery_address_id',         'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'billingAddressId'          => ['mapping' => 'billing_address_id',          'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'orderStatus'               => ['mapping' => 'order_status',                'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5, 6],         'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','completed','cancelled']],
                    'orderType'                 => ['mapping' => 'order_type',                  'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['delivery','pickup','dine-in','collection']],
                    'paymentStatus'             => ['mapping' => 'payment_status',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['unpaid','paid','refunded','partial_refund','payment_intent','payment_pre_auth']],
                    'deliveryFee'               => ['mapping' => 'delivery_fee',                'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'orderFee'                  => ['mapping' => 'order_fee',                   'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'smallOrderFee'             => ['mapping' => 'small_order_fee',             'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'currency'                  => ['mapping' => 'currency',                    'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'transactionId'             => ['mapping' => 'transaction_id',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'paymentIntentId'           => ['mapping' => 'payment_intent_id',           'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'comment'                   => ['mapping' => 'comment',                     'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'tenantComment'             => ['mapping' => 'tenant_comment',              'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'totalOrderPrice'           => ['mapping' => 'total_order_price',           'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedPrice'   => ['mapping' => 'total_order_modified_price',  'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'totalOrderModifiedReason'  => ['mapping' => 'total_order_modified_reason', 'insertRole'    => [0,1,2,3,4,5,6],         'updateRole' => [2, 4, 5],            'optionalInsert' => 1,            'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_item', 'foreignKey' => 'orderId']],
            ],
            'food_order_item' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'orderId'               => ['mapping' => 'order_id',                'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuItemId'            => ['mapping' => 'menu_item_id',            'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'itemName'              => ['mapping' => 'item_name',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'string', 'expectedValue' => null],
                    'itemBasePrice'         => ['mapping' => 'item_base_price',         'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedPrice'     => ['mapping' => 'item_modified_price',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                    'itemModifiedReason'    => ['mapping' => 'item_modified_reason',    'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemQuantity'          => ['mapping' => 'item_quantity',           'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemNote'              => ['mapping' => 'item_note',               'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'itemStatus'            => ['mapping' => 'item_status',             'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => ['pending','prepared','served','cancelled']],
                    'itemTenantComment'     => ['mapping' => 'item_tenant_comment',     'insertRole'    => [0,1,2,3,4,5,6],    'updateRole' => [2, 4, 5],           'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order_extra', 'foreignKey' => 'itemId']],
            ],
            'food_order_extra' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'itemId'                => ['mapping' => 'item_id',                 'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'menuExtraId'           => ['mapping' => 'menu_extra_id',           'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 1,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'extraName'             => ['mapping' => 'extra_name',              'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'extraPrice'            => ['mapping' => 'extra_price',             'insertRole'    => [0,1,2,3,4,5,6],     'updateRole' => [2, 4, 5],          'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'float',  'expectedValue' => null],
                ],
                'relationships' => [],
            ],
            'food_order_guest_user' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'fName'                 => ['mapping' => 'f_name',                  'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'lName'                 => ['mapping' => 'l_name',                  'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'phoneNumber'           => ['mapping' => 'phone_number',            'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'userEmail'             => ['mapping' => 'user_email',              'insertRole'    => [0,1,2,3,4,5,6],       'updateRole' => [2, 4, 5],        'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [['table' => 'food_order', 'foreignKey' => 'guestUserId']],
            ],
            'food_order_address' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'addressLine1'          => ['mapping' => 'address_line_1',          'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [0, 2, 4, 5],    'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'addressLine2'          => ['mapping' => 'address_line_2',          'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'city'                  => ['mapping' => 'city',                    'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'county'                => ['mapping' => 'county',                  'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'country'               => ['mapping' => 'country',                 'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'postalCode'            => ['mapping' => 'postal_code',             'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                    'checkSum'              => ['mapping' => 'check_sum',               'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'string', 'expectedValue' => null],
                ],
                'relationships' => [
                    ['table' => 'food_order', 'foreignKey' => 'deliveryAddressId'],
                    ['table' => 'food_order', 'foreignKey' => 'billingAddressId'],
                ],
            ],
            'food_order_user_address' => [
                'fields' => [
                    'id'                    => ['mapping' => 'id',                      'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => null,       'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'userId'                => ['mapping' => 'user_id',                 'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'addressId'             => ['mapping' => 'address_id',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [0, 2, 4, 5],    'optionalInsert' => 0,          'optionalUpdate' => 0, 'dataType' => 'int',    'expectedValue' => null],
                    'isDefault'             => ['mapping' => 'is_default',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'isActive'              => ['mapping' => 'is_active',               'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                    'isDeleted'             => ['mapping' => 'is_deleted',              'insertRole'    => [0,1,2,3,4,5,6],        'updateRole' => [2, 4, 5],       'optionalInsert' => 1,          'optionalUpdate' => 1, 'dataType' => 'int',    'expectedValue' => null],
                ],
                // No relationships for this table
                'relationships' => [],
            ],
        ];
        
        if (!$table) {
            return $allMappings;
        }
    
        $table = toSnakeCase($table);
        if (!isset($allMappings[$table])) {
            return null;
        }
    
        if ($roleId === null) {
            return $allMappings[$table];
        }
    
        $filtered = [];
        foreach ($allMappings[$table]['fields'] as $key => $meta) {
            if ($actionType === 'update' && isset($meta['updateRole'])) {
                if (in_array($roleId, $meta['updateRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'insert' && isset($meta['insertRole'])) {
                if (in_array($roleId, $meta['insertRole'])) {
                    $filtered[$key] = $meta;
                }
            }
            if ($actionType === 'view' && isset($meta['viewRole'])) {
                if (in_array($roleId, $meta['viewRole'])) {
                    $filtered[$key] = $meta;
                }
            }
        }

    
        return ['filtered' => $filtered, 'abc' => $table, 'roleId' => $roleId];
    }
    function updateContent($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $stage = [];
        try {
            $pdo->beginTransaction(); // Start transaction
            $tableName = toSnakeCase($inputData['table']) ?? null;
            $inputData['dataKey'] = $inputData['table'];
            $changeType = $inputData['recordType'] ?? null;
            // ✅ Check if the extracted data block actually exists
            if (!isset($inputData['dataKey']) || empty($inputData['dataKey'])) {
                $pdo->rollback(); // Rollback transaction
                return ['status' => 'failed', 'message' => "Missing data block for table: {$tableName}"];
            }
            $stage[] = '00: Validate ID, prepare $inputData with idField, id, checkParent';
            // 00: Validate ID, prepare $inputData with idField, id, checkParent
            $res = validateUpdateInputStep($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }

            $stage[] = '01: check item is not marked as deleted no update is possible';
            
    

        if($changeType === 'update') {
            $stage[] = '02: Fetch existing history data (before change)';
            // 02: Fetch existing history data (before change)
            $inputData['nextOperation'] = 'getDataForHistory';
            $res = executeDatabaseOperation($inputData);
            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
            $inputData['historyData'] = $res['historyData'] ?? null;

            $stage[] = '03: Insert history record into history table';
            // 03: Insert history record into history table
            $inputData['nextOperation'] = 'saveHistoryRecordStep';
            $res = executeDatabaseOperation($inputData);

            if ($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
            }
        }
            $stage[] = '04: check if this is an update or a delete action';
            // 04: check if this is an update or a delete action

            $stage[] = '05: check if this is an update or a duplicate action';
            // 05: check if this is an update or a delete action
            if($changeType === 'update') {
                $inputData['nextOperation'] = 'updateMenuTable';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '06: check if this is a duplicate action';
            // 06: check if this is a duplicate action
            if($changeType === 'duplicate') {
                $inputData['nextOperation'] = 'duplicateRecored';
                $res = executeDatabaseOperation($inputData);
            }

            $stage[] = '07: check if the delete or update was successful';
            // 07: check if the delete or update was successful
            if($res['status'] !== 'success') {
                $pdo->rollback(); // Rollback transaction
                if (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                    $res['stage'] = $stage;
                }
                return $res;
           }
            $pdo->commit();
            return [ 'status' => 'success','message' => 'Update completed successfully'];
        } catch (Exception $e) {
            $pdo->rollback(); // Rollback transaction on error
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                return ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                return ['status' => 'failed', 'message' => $errorMessage, 'stage' => $stage];
            } else {
                error_log("Error in updateContent: " . $e->getMessage());
                return ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
    }
    function validateUpdateInputStep(&$inputData) {
        $table = $inputData['table'] ?? null;
        $tableName = toSnakeCase($table);
        $roleId = $inputData['roleId'] ?? null;
        $dataKey = $inputData['table'];
        $actionType = $inputData['recordType'] ?? null;
    
        if (!$tableName) {
            return ['status' => 'failed', 'message' => 'Table name not specified in input'];
        }
    
        if (!$dataKey) {
            return ['status' => 'failed', 'message' => 'Data key not extracted from table name'];
        }


        $tableData = $inputData[$dataKey] ?? [];
            
        $map = menuTableColumnMapping($tableName, $roleId, $actionType);

        $columnMap = $map['filtered'] ?? null;
        
        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'No column mapping found for table: '. $tableName];
        }
    
        // 🆕 Find the primary key field
        $primaryKey = null;
        foreach ($columnMap as $key => $meta) {
            if (isset($meta['mapping']) && strtolower($meta['mapping']) === 'id') {
                $primaryKey = $key;
                break;
            }
        }
    
        if (!$primaryKey) {
            return ['status' => 'failed', 'message' => "No primary key (id) field found for table: {$tableName}"];
        }
    
        // 🆕 Recursively search for the ID value
        $idValue = findIdInData($tableData, $primaryKey);
    
        if ($idValue === null || $idValue === '') {
            return ['status' => 'failed', 'message' => "Missing required Id field: {$primaryKey} key: {$tableName}"];
        }
    
        // Set ID info for future steps
        $inputData['idField'] = $primaryKey;
        $inputData['id'] = $idValue;
    
        // Set checkParent flag
        $inputData['checkParent'] = array_key_exists('parentId', $columnMap) ? 1 : 0;

        return ['status' => 'success'];
    }
    function findIdInData($data, $primaryKey) {
        foreach ($data as $key => $value) {
            if (is_array($value)) {
                // Recurse into sub-arrays
                $found = findIdInData($value, $primaryKey);
                if ($found !== null) {
                    return $found;
                }
            } else {
                if ($key === $primaryKey) {
                    return $value;
                }
            }
        }
        return null;
    }
    function executeDatabaseOperation(&$inputData) {
        $operation = $inputData['nextOperation'];
        try {
            $results =  $operation($inputData);
        } catch (PDOException $e) {
            $errorInfo = $e->errorInfo ?? [];
            $errorCode = $errorInfo[1] ?? 0; // SQL error code
            $errorMessage = $e->getMessage();
    
            // Determine the type of error
            if ($errorCode == 1062) {
                $results =  ['status' => 'failed', 'message' => "Duplicate entry detected: " . $errorMessage];
            } elseif (isset($inputData['debug']) && $inputData['debug'] === $inputData['debugModeFlag']) {
                $results = ['status' => 'failed', 'message' => $errorMessage];
            }else{
                $results = ['status' => 'failed', 'message' => "Unknown failure"];
            }
        }
        return $results;
    }
    function convertKeysToCamelCase($array) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Convert snake_case to camelCase
            $camelKey = preg_replace_callback('/_([a-z])/', function ($matches) {
                return strtoupper($matches[1]);
            }, $key);

            // Lowercase first character to enforce camelCase
            $camelKey = lcfirst($camelKey);

            // Recursively handle nested arrays
            if (is_array($value)) {
                $converted[$camelKey] = convertKeysToCamelCase($value);
            } else {
                $converted[$camelKey] = $value;
            }
        }

        return $converted;
    }
    function toSnakeCase($input) {
        return strtolower(preg_replace('/([a-z])([A-Z])/', '$1_$2', $input));
    }
    function renameIdKeys($array, $newKeyName) {
        $converted = [];

        foreach ($array as $key => $value) {
            // Recursively handle nested arrays
            if (is_array($value)) {
                $value = renameIdKeys($value, $newKeyName);
            }

            if ($key === 'id') {
                $converted[$newKeyName] = $value;
            } else {
                $converted[$key] = $value;
            }
        }

        return $converted;
    }
    function extractDataKeyFromTableName($tableName) {
        $parts = explode('_', $tableName, 2);
        $base = $parts[1] ?? $tableName;
    
        $baseParts = explode('_', $base);
    
        $camelCase = array_shift($baseParts);
    
        foreach ($baseParts as $part) {
            $camelCase .= ucfirst($part);
        }
    
        return $camelCase;
    }
    function roleViewType($roleId) {
        if(in_array($roleId, [1, 2, 3])) {
            return 'sysAdmin';
        } elseif($roleId == 4) {
            return 'owner';
        } elseif($roleId == 5) {
            return 'manager';
        } elseif($roleId == 6) {
            return 'staff';
        } else{
            return 'guest';
        }
    }
    function prepListToCancel($inputData) {
        // Prepare the list of orders to cancel
        $orders = getListOfOrdersOutSide2Hours($inputData);
        if ($orders['status'] === 'failed') {
            return $orders;
        }

        // Map the orders to a format suitable for cancellation
        foreach ($orders['data'] as $order) {
            $inputData['secure']['stripeAccountKey'] = $order['payment_api_key'];
            $inputData['secure']['paymentIntentId'] = $order['payment_intent_id'];
            $inputData['tenantId'] = $order['tenant_id'];
            $res = cancelPayment($inputData, 'abandoned');
            if ($res['status'] !== 'success') {
                // Log the failure but continue with other orders
                error_log("Failed to cancel payment for order ID {$order['id']}: " . $res['message']);
            }
        }

        return ['status' => 'success', 'data' => $orders];
    }
    function prepListToCancelForgottenOrders($inputData) {
        // Prepare the list of orders to cancel
        $orders = getListOfOrdersForgottenOrders4Hours($inputData);
        if ($orders['status'] === 'failed') {
            return $orders;
        }

        // Map the orders to a format suitable for cancellation
        foreach ($orders['data'] as $order) {
            $inputData['secure']['stripeAccountKey'] = $order['payment_api_key'];
            $inputData['secure']['paymentIntentId'] = $order['payment_intent_id'];
            $inputData['skipEmail'] = "yes"; // Skip sending email for forgotten orders
            $res = cancelPayment($inputData, 'abandoned');
            if ($res['status'] !== 'success') {
                // Log the failure but continue with other orders
                error_log("Failed to cancel payment for order ID {$order['id']}: " . $res['message']);
            }
        }
        return ['status' => 'success', 'data' => $orders];
    }
    function cancelPayment($inputData, $cancellationReason = 'abandoned') {
        // Validate
        if (empty($inputData['secure']['paymentIntentId'])) {
            return ['status' => 'failed', 'message' => 'Payment intent ID is required for cancelling payment.'];
        }

        // Respect test mode
        if (defined('TEST_ENV') && TEST_ENV) {
            return ['status' => 'success', 'message' => 'Test environment – not cancelling.'];
        }

        require_once __DIR__ . '/../vendor/autoload.php';
        if (!class_exists('\Stripe\Stripe')) {
            return ['status' => 'failed', 'message' => 'Stripe dependency not available'];
        }

        $skipEmail = $inputData['skipEmail'] ?? null;

        \Stripe\Stripe::setApiKey($inputData['secure']['stripeSecretKey']);
        \Stripe\Stripe::setAccountId($inputData['secure']['stripeAccountKey'] ?? null);
        $piId = $inputData['secure']['paymentIntentId'];

        // If you created the PI on a connected account directly, set this:
        // $opts = ['stripe_account' => $inputData['secure']['shopStripeAccountId']];
        $opts = [];

        try {
            /** @var \Stripe\PaymentIntent $pi */
            $pi = \Stripe\PaymentIntent::retrieve($piId, $opts);

            // If already cancelled, we're done
            if ($pi->status === 'canceled') {
                
                return ['status' => 'success', 'message' => 'Payment already canceled (hold released).'];
            }

            // Allowed-to-cancel (releases the hold) — do NOT refund
            $cancellable = [
                'requires_capture',       // auth placed, waiting for capture
                'requires_confirmation',  // not confirmed yet
                'requires_payment_method',
                'requires_action',
                'processing',             // may cancel depending on timing/method
            ];

            if (in_array($pi->status, $cancellable, true)) {
                $pi = $pi->cancel(['cancellation_reason' => $cancellationReason], $opts);

                $inputData['stripe'] = $pi;
                $res = viewFullOrderDetails($inputData);
                $orderDetails = $res['orderDetails'][0] ?? null;
                $inputData['order'] =  $orderDetails ?? null;
                if($skipEmail === "yes") {
                    return ['status' => 'success', 'message' => 'Authorization hold released (payment canceled).', 'data' => $pi, 'order' => $inputData['order'], 'stripe' => $inputData['stripe']];
                }
                $res = sendEmailCancelled($inputData);
                return ['status' => 'success', 'message' => 'Authorization hold released (payment canceled).', 'data' => $pi, 'order' => $inputData['order'], 'stripe' => $inputData['stripe'], 'res' => $res];
            }

            // If already captured, do NOT refund (per your rule)
            if ($pi->status === 'succeeded') {

                $res = updateCancelled($inputData);
                if ($res['status'] !== 'success') {
                    return ['status' => 'failed', 'message' => $res['message']];
                }

                // If already captured, do NOT refund (per your rule)
                return [
                    'status'  => 'failed',
                    'message' => 'Payment already captured; cannot release hold without refund (refunds are disabled).'
                ];
            }

            // Any other odd status
            return [
                'status'  => 'failed',
                'message' => "Cannot cancel payment in status '{$pi->status}'."
            ];
        } catch (\Stripe\Exception\ApiErrorException $e) {
            return ['status' => 'failed', 'message' => 'Stripe error: ' . $e->getMessage()];
        } catch (\Exception $e) {
            return ['status' => 'failed', 'message' => 'Error: ' . $e->getMessage()];
        }
    }
    function sendEmailCancelled(&$inputData) {
        $inputData['sendNow'] = true; // or false to just build
        //Get tenant details

        $res = getTenantDetails($inputData);
        if ($res['status'] !== 'success') {
            return ['status' => 'failed', 'message' => $res['message'] ?? 'Failed to get tenant details'];
        }

        $res = shopAddress($inputData);
        if ($res['status'] !== 'success') {
            return ['status' => 'failed', 'message' => $res['message'] ?? 'Failed to get shop address'];
        }

        $res = buildCancelledEmail_FromInputData($inputData);

        // Updated $inputData is also returned inside $res:
        $inputData = $res['inputData'];

        if ($res['status'] !== 'success') {
            error_log('[CancelEmail] ' . ($res['message'] ?? 'Unknown error'));
        }

        // Built payload for inspection/logging:
        $emailPayload = $inputData['email']['cancelled']['payload'] ?? null;

        if($res['status'] !== 'success') {
            return ['status' => 'failed', 'message' => $res['message'] ?? 'Email send failed', 'emailPayload' => $emailPayload];
        }else{
            return ['status' => 'success', 'message' => 'Cancellation email sent', 'emailPayload' => $emailPayload];
        }
    }
    function sendCancelledEmail_viaMail(array $p): bool{
        // ---- Basic validation
        $to         = trim((string)($p['to'] ?? ''));
        $subject    = (string)($p['subject'] ?? '');
        $fromEmail  = trim((string)($p['fromEmail'] ?? ''));
        $fromName   = (string)($p['fromName'] ?? '');
        $replyTo    = isset($p['replyTo']) ? trim((string)$p['replyTo']) : null;

        if ($to === '' || $subject === '' || $fromEmail === '') {
            return false;
        }
        if (!filter_var($to, FILTER_VALIDATE_EMAIL)) return false;
        if (!filter_var($fromEmail, FILTER_VALIDATE_EMAIL)) return false;
        if ($replyTo && !filter_var($replyTo, FILTER_VALIDATE_EMAIL)) $replyTo = null;

        // Guard against header injection
        foreach ([$to, $fromEmail, $replyTo, $fromName, $subject] as $v) {
            if ($v !== null && (str_contains((string)$v, "\r") || str_contains((string)$v, "\n"))) {
                return false;
            }
        }

        // ---- Helpers
        $encodeName = function (string $name): string {
            $name = trim($name);
            if ($name === '') return '';
            if (function_exists('mb_encode_mimeheader')) {
                return mb_encode_mimeheader($name, 'UTF-8', 'B', "\r\n");
            }
            // Fallback: simple quoting/escaping
            return '"' . addslashes($name) . '"';
        };

        $formatAddr = function (?string $name, string $email) use ($encodeName): string {
            $name = trim((string)$name);
            if ($name !== '') {
                return $encodeName($name) . " <{$email}>";
            }
            return $email;
        };

        $toHeader   = $formatAddr($p['toName'] ?? null, $to);
        $fromHeader = $formatAddr($fromName, $fromEmail);

        // ---- Subject encode (for non-ASCII)
        if (function_exists('mb_encode_mimeheader')) {
            $subject = mb_encode_mimeheader($subject, 'UTF-8', 'B', "\r\n");
        }

        // ---- Bodies
        $textBody = (string)($p['text'] ?? '');
        $htmlBody = (string)($p['html'] ?? '');

        // Pick a safe fallback if one is missing
        if ($textBody === '' && $htmlBody !== '') {
            // strip tags fallback for text
            $textBody = trim(html_entity_decode(strip_tags($htmlBody), ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'));
        } elseif ($htmlBody === '' && $textBody !== '') {
            // minimal HTML wrapper fallback
            $htmlBody = '<!doctype html><html><body><pre style="white-space:pre-wrap">'
                    . htmlspecialchars($textBody, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8')
                    . '</pre></body></html>';
        } elseif ($htmlBody === '' && $textBody === '') {
            // nothing to send
            return false;
        }

        // ---- Headers
        $headers = [];
        $headers[] = "From: {$fromHeader}";
        if ($replyTo) {
            $headers[] = "Reply-To: {$replyTo}";
        }
        // CC / BCC (optional)
        $addListHeader = function (string $label, $val) use (&$headers) {
            if ($val === null) return;
            $arr = is_array($val) ? $val : [$val];
            $clean = [];
            foreach ($arr as $addr) {
                $addr = trim((string)$addr);
                if ($addr !== '' && filter_var($addr, FILTER_VALIDATE_EMAIL) && !str_contains($addr, "\r") && !str_contains($addr, "\n")) {
                    $clean[] = $addr;
                }
            }
            if ($clean) $headers[] = "{$label}: " . implode(', ', $clean);
        };
        $addListHeader('Cc',  $p['cc']  ?? null);
        $addListHeader('Bcc', $p['bcc'] ?? null);

        $headers[] = "MIME-Version: 1.0";

        $boundary = 'b_' . (function_exists('bin2hex') && function_exists('random_bytes')
                    ? bin2hex(random_bytes(12))
                    : md5(uniqid('', true)));

        // Always send multipart/alternative (text + HTML)
        $headers[] = "Content-Type: multipart/alternative; boundary=\"{$boundary}\"";

        $body  = "--{$boundary}\r\n";
        $body .= "Content-Type: text/plain; charset=UTF-8\r\n";
        $body .= "Content-Transfer-Encoding: 8bit\r\n\r\n";
        $body .= $textBody . "\r\n\r\n";

        $body .= "--{$boundary}\r\n";
        $body .= "Content-Type: text/html; charset=UTF-8\r\n";
        $body .= "Content-Transfer-Encoding: 8bit\r\n\r\n";
        $body .= $htmlBody . "\r\n\r\n";

        $body .= "--{$boundary}--";

        // Envelope sender (Return-Path) improves deliverability on cPanel
        $params = '';
        if (!empty($p['envelopeFrom']) && filter_var($p['envelopeFrom'], FILTER_VALIDATE_EMAIL)) {
            // escapeshellarg to be safe; some hosts disable -f (in that case mail() will still return true if accepted)
            $params = '-f ' . escapeshellarg($p['envelopeFrom']);
        }

        // ---- Send
        return mail($to, $subject, $body, implode("\r\n", $headers), $params);
    }
    function buildCancelledEmail_FromInputData(array $inputData){
        // --- helpers (safe to redeclare if not already present)
        if (!function_exists('esc')) {
            function esc($s) { return htmlspecialchars((string)$s, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); }
        }
        $step = function($msg) use (&$inputData) {
            if (!isset($inputData['step']) || !is_array($inputData['step'])) $inputData['step'] = [];
            $inputData['step'][] = "cancelEmail() - " . $msg;
        };

        $step('start');

        $stripe   = $inputData['stripe']  ?? null;  // Stripe PI
        $order    = $inputData['order']   ?? null;  // Enriched order block
        $tenantTz = $inputData['tenantTz'] ?? 'Europe/London';

        if (!$stripe) { $step('missing stripe data'); return ['status'=>'failed','message'=>'Stripe data missing','inputData'=>$inputData]; }
        if (!$order)  { $step('missing order');      return ['status'=>'failed','message'=>'Order block missing','inputData'=>$inputData]; }

        $toEmail  = trim((string)($order['userEmail'] ?? ''));
        $fullName = trim(implode(' ', array_filter([$order['firstName'] ?? '', $order['lastName'] ?? ''])));
        if ($toEmail === '') {
            $step('no recipient email');
            return ['status'=>'failed','message'=>'No recipient email on the order','inputData'=>$inputData];
        }

        // Time: Stripe canceled_at (epoch, UTC) -> local display
        $cancelEpoch = (int)($stripe['canceled_at'] ?? 0);
        if ($cancelEpoch <= 0) $cancelEpoch = time();
        $cancelUtcYmdHis = gmdate('Y-m-d H:i:s', $cancelEpoch);
        $cancelIso       = function_exists('utc_to_iso8601z') ? utc_to_iso8601z($cancelUtcYmdHis) : gmdate('Y-m-d\TH:i:s\Z', $cancelEpoch);
        $cancelDisplay   = function_exists('format_utc_for_tz')
            ? format_utc_for_tz($cancelUtcYmdHis, $tenantTz, 'd M Y H:i:s')
            : gmdate('d M Y H:i:s', $cancelEpoch) . ' (UTC)';
        $cancelDisplayWithTz = $cancelDisplay . " ({$tenantTz})";

        // Currency + amounts (minor units from Stripe; fallback to order total)
        $currency   = strtoupper((string)($stripe['currency'] ?? 'GBP'));
        $heldDec    = isset($stripe['amount'])
            ? number_format(((int)$stripe['amount']) / 100, 2, '.', '')
            : number_format((float)($order['totalOrderModifiedPrice'] ?? 0), 2, '.', '');
        $orderId    = (int)($order['id'] ?? ($stripe['metadata']['orderId'] ?? 0));
        $reason     = (string)($stripe['cancellation_reason'] ?? 'cancelled');
        $subject    = "Order #{$orderId} cancelled — pre-authorisation released";

        // Fees (normalize)
        $deliveryFee    = isset($order['deliveryFee'])    ? number_format((float)$order['deliveryFee'],    2, '.', '') : null;
        $orderFee       = isset($order['orderFee'])       ? number_format((float)$order['orderFee'],       2, '.', '') : null;
        $smallOrderFee  = isset($order['smallOrderFee'])  ? number_format((float)$order['smallOrderFee'],  2, '.', '') : null;
        $totalFormatted = isset($order['totalOrderModifiedPrice']) ? number_format((float)$order['totalOrderModifiedPrice'], 2, '.', '') : null;
        $orderTypeTitle = ucfirst((string)($order['orderType'] ?? '-'));

        // --- brand + assets (match success/receipt header)
        $brandName   = aget($inputData,'brandName','Waitron');
        $brandColor  = aget($inputData,'brandColor','#0b5fff');
        $brandLogo   = aget($inputData,'brandLogo',null);
        $baseUrl     = computeBaseUrl();
        if ($brandLogo) $brandLogo = absolutizeUrl((string)$brandLogo, $baseUrl);

        // Status pill styling (cancellation)
        $pillBg = '#fff1f1';
        $pillFg = '#d93025';

        // decide which rows to render (hide if 0/0.00/null/"0")
        $showDelivery   = is_numeric($deliveryFee)   ? ((float)$deliveryFee   > 0) : false;
        $showOrderFee   = is_numeric($orderFee)      ? ((float)$orderFee      > 0) : false;
        $showSmallOrder = is_numeric($smallOrderFee) ? ((float)$smallOrderFee > 0) : false;


        // company details (for email footer)
        $companyName    = aget($inputData['tenantDetails'],'companyName','');
        $companyNumber  = aget($inputData['tenantDetails'],'tenantNumber','');
        $companyAddress = formatShopAddressForEmail($inputData['shopAddress']['contact_value']);

        // $companyAddress replace all instance of <br> with , and trim
        $companyAddress = trim(str_replace(['<br>', '<br/>', '<br />'], ', ', $companyAddress), ", \n\r\t");

        // --- HTML (header styled like success email)
        $html = "<!doctype html><html lang=\"en\">
                    <head>
                    <meta charset=\"utf-8\"><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\"/>
                    <title>Order Cancelled</title>
                    <style>@media(max-width:600px){.container{padding:16px!important}h2{font-size:20px!important}} a{color:".esc($brandColor).";}</style>
                    </head>
                    <body style=\"margin:0;background:#f6f7fb;font-family:Segoe UI,Roboto,Helvetica,Arial,sans-serif;\">
                    <table role=\"presentation\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"background:#f6f7fb;padding:20px 0\"><tr><td align=\"center\">

                    <table role=\"presentation\" width=\"640\" class=\"container\" cellspacing=\"0\" cellpadding=\"0\" style=\"width:640px;max-width:100%;background:#fff;border-radius:12px;padding:24px;box-shadow:0 4px 18px rgba(18,38,63,.08);border:1px solid #eee\">

                    <!-- Brand header (same style as success) -->
                    <tr><td style=\"text-align:center;padding:8px 0 18px\">"
                        . ($brandLogo ? '<img src=\"'.esc($brandLogo).'\" alt=\"'.esc($brandName).'\" style=\"max-width:180px;height:auto;display:block;margin:0 auto 8px\">' : '')
                        . '<div style=\"font-size:12px;color:#888\">'.esc($brandName).'</div>'
                    . "</td></tr>

                    <tr><td>
                        <div style=\"display:flex;justify-content:space-between;align-items:center;gap:12px;flex-wrap:wrap\">
                        <h2 style=\"margin:0;color:#111;font-size:22px\">Order #".esc($orderId)." cancelled</h2>
                        <span style=\"display:inline-block;background:{$pillBg};color:{$pillFg};font-weight:600;font-size:12px;padding:6px 10px;border-radius:999px;letter-spacing:.3px\">Cancelled</span>
                        </div>
                        <p style=\"margin:10px 0 0;color:#777\">".esc($cancelDisplayWithTz)."</p>

                        <p style=\"margin:16px 0 0;color:#111\">Hi ".esc($fullName ?: 'there').",</p>
                        <p style=\"margin:8px 0 0;color:#444\">
                        Your order has been <strong>cancelled</strong>. The card <em>pre-authorisation</em> has been released by your bank — you won’t be charged.
                        </p>

                        <p style=\"margin:8px 0 0;color:#444\"><strong>Reason:</strong> ".esc($reason)."</p>

                        <hr style=\"border:none;border-top:1px solid #eee;margin:16px 0\">
                    </td></tr>

                    <!-- Summary (hide rows that are zero/null) -->
                    <tr><td style=\"padding:0 0 6px\"><h3 style=\"margin:0;font-size:16px;color:#111\">Order summary</h3></td></tr>
                    <tr><td>
                        <p style=\"margin:6px 0 0;color:#444\"><strong>Type:</strong> ".esc($orderTypeTitle)."</p>"
                        . ($totalFormatted !== null ? "<p style=\"margin:6px 0 0;color:#444\"><strong>Total (authorised):</strong> £".esc($totalFormatted)."</p>" : "")
                        . "<table role=\"presentation\" width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" style=\"border-collapse:collapse;margin-top:8px;font-size:14px;color:#444\">"
                        . ($showDelivery   ? "<tr><td style='padding:6px 0;border-bottom:1px solid #eee'>Delivery fee</td><td style='padding:6px 0;border-bottom:1px solid #eee;text-align:right'>£".esc($deliveryFee)."</td></tr>" : "")
                        . ($showOrderFee   ? "<tr><td style='padding:6px 0;border-bottom:1px solid #eee'>Service/Order fee</td><td style='padding:6px 0;border-bottom:1px solid #eee;text-align:right'>£".esc($orderFee)."</td></tr>" : "")
                        . ($showSmallOrder ? "<tr><td style='padding:6px 0;border-bottom:1px solid #eee'>Small order fee</td><td style='padding:6px 0;border-bottom:1px solid #eee;text-align:right'>£".esc($smallOrderFee)."</td></tr>" : "")
                        . "</table>
                    </td></tr>

                    <tr><td>
                        <div style=\"margin-top:12px;padding:10px;border:1px solid #e6f2e6;background:#f6fbf6;border-radius:8px;color:#0a3\">
                        <strong>Pre-authorisation released:</strong> £".esc($heldDec)." (".esc($currency).").<br>
                        Your bank may take a short time to show the release on your statement.
                        </div>
                        <p style=\"margin:16px 0 0;color:#9aa3b2;font-size:12px\">
                        Company Name: ".esc($companyName)." ".($companyNumber !== '' ? ' | Company Number: '.esc($companyNumber) : '')."
                        </p>
                        <p style=\"margin:4px 0 0;color:#9aa3b2;font-size:12px;white-space:pre-line\">
                        ".esc($companyAddress)."
                        </p>
                        <p style=\"margin:16px 0 0;color:#9aa3b2;font-size:12px\">
                        Powered by Waitron.uk.
                        </p>
                    </td></tr>

                    </table>

                    <p style=\"text-align:center;color:#aaa;font-size:12px;margin-top:8px\">
                    This is an automated message. Ref: ".esc($stripe['id'] ?? '')."
                    </p>

                    </td></tr></table>
                    </body></html>";

        // --- Plain text (hide fee lines if zero)
        $textLines = [];
        $textLines[] = "Order #{$orderId} cancelled";
        $textLines[] = "{$cancelDisplayWithTz}";
        $textLines[] = "";
        $textLines[] = "Hi " . ($fullName ?: 'there') . ",";
        $textLines[] = "";
        $textLines[] = "Your order has been cancelled. The card pre-authorisation has been released by your bank — you won’t be charged.";
        $textLines[] = "";
        $textLines[] = "Reason: {$reason}";
        $textLines[] = "";
        $textLines[] = "Order summary";
        $textLines[] = "Type: {$orderTypeTitle}";
        if ($totalFormatted !== null) $textLines[] = "Total (authorised): £{$totalFormatted}";
        if ($showDelivery)   $textLines[] = " - Delivery fee: £{$deliveryFee}";
        if ($showOrderFee)   $textLines[] = " - Service/Order fee: £{$orderFee}";
        if ($showSmallOrder) $textLines[] = " - Small order fee: £{$smallOrderFee}";
        $textLines[] = "";
        $textLines[] = "Pre-authorisation released: £{$heldDec} ({$currency}).";
        $textLines[] = "Your bank may take a short time to show the release on your statement.";
        $textLines[] = "";
        $textLines[] = "Ref: " . ($stripe['id'] ?? '');
        $text = implode("\n", $textLines);

        // --- Sender fallbacks (safe local default)
        $defaultFrom  = computeNoReplyFrom();
        $fromEmail    = trim((string)($inputData['mail']['fromEmail']    ?? $defaultFrom));
        $fromName     = trim((string)($inputData['mail']['fromName']     ?? $brandName));
        $replyTo      = trim((string)($inputData['mail']['replyTo']      ?? ''));
        $envelopeFrom = trim((string)($inputData['mail']['envelopeFrom'] ?? $fromEmail));

        // --- Compose final payload
        $emailPayload = [
            'to'           => $toEmail,
            'toName'       => $fullName ?: null,
            'fromEmail'    => $fromEmail,
            'fromName'     => $fromName,
            'replyTo'      => $replyTo ?: null,
            'subject'      => $subject,
            'html'         => $html,
            'text'         => $text,
            'envelopeFrom' => $envelopeFrom,
            'meta'         => [
                'brand'            => $brandName,
                'orderId'          => $orderId,
                'tenantId'         => $inputData['tenantId'] ?? null,
                'paymentIntentId'  => $stripe['id'] ?? null,
                'cancelReason'     => $reason,
                'cancelledAtUtc'   => $cancelUtcYmdHis,
                'cancelledAtIso'   => $cancelIso,
                'cancelledAtDisplay'=> $cancelDisplayWithTz,
                'currency'         => $currency,
                'preauthRelease'   => true
            ],
        ];

        // --- Save into $inputData for downstream use
        $inputData['email']['cancelled'] = [
            'payload' => $emailPayload,
            'builtAt' => gmdate('c'),
        ];

        $sendNow = !empty($inputData['sendNow']);
        if ($sendNow) {
            if (!function_exists('sendCancelledEmail_viaMail')) {
                $inputData['email']['cancelled']['status']  = 'failed';
                $inputData['email']['cancelled']['message'] = 'sendCancelledEmail_viaMail() not defined';
                $step('send function missing');
                return ['status'=>'failed','message'=>'sendCancelledEmail_viaMail() not defined','emailPayload'=>$emailPayload,'inputData'=>$inputData];
            }
            $step('sending email');
            $ok = sendCancelledEmail_viaMail($emailPayload);
            if (!$ok) {
                $inputData['email']['cancelled']['status']  = 'failed';
                $inputData['email']['cancelled']['message'] = 'mail() returned false';
                $step('mail() returned false');
                return ['status'=>'failed','message'=>'mail() returned false','emailPayload'=>$emailPayload,'inputData'=>$inputData];
            }
            $inputData['email']['cancelled']['status']  = 'success';
            $inputData['email']['cancelled']['message'] = 'Cancellation email sent';
            $step('email sent');
            return ['status'=>'success','message'=>'Cancellation email sent','emailPayload'=>$emailPayload,'inputData'=>$inputData];
        }

        $inputData['email']['cancelled']['status']  = 'success';
        $inputData['email']['cancelled']['message'] = 'Cancellation email built (not sent)';
        $step('built only');
        return ['status'=>'success','message'=>'Cancellation email built (not sent)','emailPayload'=>$emailPayload,'inputData'=>$inputData];
    }
    function esc($v): string { 
        return htmlspecialchars((string)$v, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8'); 
    }
    function money($n): string { 
        return '£' . number_format((float)($n ?? 0), 2, '.', ''); 
    }
    function aget(array $arr, string $key, $default = null) { 
        return array_key_exists($key, $arr) ? $arr[$key] : $default; 
    }
    function currentHost(): string {
        return preg_replace('#^https?://#i', '', (string)($_SERVER['HTTP_HOST'] ?? $_SERVER['SERVER_NAME'] ?? 'localhost'));
    }
    function apexDomain(string $host): string {
        $h = strtolower(preg_replace('/[^a-z0-9.\-]/i', '', $host));
        $parts = array_values(array_filter(explode('.', $h)));
        $n = count($parts);
        if ($n < 2) return $h ?: 'localhost';
        $tld = $parts[$n-1];
        $sld = $parts[$n-2];
        $ukLike = ($tld === 'uk' && in_array($sld, ['co','org','ac','gov','ltd','plc','net'], true));
        $keep = $ukLike && $n >= 3 ? 3 : 2;
        return implode('.', array_slice($parts, -$keep));
    }
    if (!function_exists('str_contains')) {
        function str_contains(string $haystack, string $needle): bool {
            return $needle === '' || strpos($haystack, $needle) !== false;
        }
    }
    if (!function_exists('str_starts_with')) {
        function str_starts_with(string $haystack, string $needle): bool {
            return $needle === '' || strpos($haystack, $needle) === 0;
        }
    }
    if (!function_exists('str_ends_with')) {
        function str_ends_with(string $haystack, string $needle): bool {
            if ($needle === '') return true;
            $len = strlen($needle);
            return substr($haystack, -$len) === $needle;
        }
    }
    function computeNoReplyFrom(?string $fallbackDomain = null): string {
        $host = currentHost();
        $apex = apexDomain($host);
        if ($apex === 'localhost') $apex = ($fallbackDomain ?: 'example.com');
        return "no-reply@{$apex}";
    }
    function computeBaseUrl(): string {
        $https  = $_SERVER['HTTPS'] ?? '';
        $scheme = (!empty($https) && strtolower($https) !== 'off') ? 'https' : 'http';
        return $scheme . '://' . currentHost();
    }
    function absolutizeUrl(string $url, string $base): string {
        if (preg_match('#^https?://#i', $url)) return $url;
        if (strpos($url, '//') === 0) {
            $scheme = parse_url($base, PHP_URL_SCHEME) ?: 'https';
            return $scheme . ':' . $url;
        }
        return rtrim($base, '/') . '/' . ltrim($url, '/');
    }
    function buildTrackUrl(array $order, ?string $baseUrl = null): string {
        $base = $baseUrl ?: computeBaseUrl();
        $q = http_build_query([
            'orderId' => aget($order, 'id', ''),
            'email'   => aget($order, 'userEmail', ''),
        ]);
        return rtrim($base, '/') . '/order-confirmed?' . $q;
    }
    function buildAddressHtml(array $order): string {
        if (strtolower((string)aget($order, 'orderType', '')) !== 'delivery') return '';
        $d = (array) aget($order, 'delivery', []);
        if (!$d) return '';
        return '
        <tr><td style="padding:12px 0 0">
        <h3 style="margin:0 0 8px;font-size:16px;color:#111">Delivery Address</h3>
        <p style="margin:0;line-height:1.5;color:#444">'.
            esc(aget($d,'address_line_1','')).'<br>'.
            (aget($d,'address_line_2') ? esc(aget($d,'address_line_2')).'<br>' : '').
            esc(aget($d,'city','')).(aget($d,'county') ? ', '.esc(aget($d,'county')) : '').'<br>'.
            esc(aget($d,'postal_code','')).'<br>'.
            esc(aget($d,'country','')).'
        </p>
        </td></tr>';
    }
    function buildItemsHtml(array $order): string {
        $items = (array) aget($order, 'details', []);
        if (!$items) return '<tr><td style="padding:8px 0;color:#666">No items.</td></tr>';
        $html = '';
        foreach ($items as $item) {
            $extrasHtml = '';
            $extras = (array) aget($item, 'extras', []);
            if ($extras) {
                $parts = array_map(function($ex){
                    return '<div>+ '.esc(aget($ex,'extraName','')).' (x'.((int)aget($ex,'extraQuantity',1)).', '.money(aget($ex,'extraPrice',0)).')</div>';
                }, $extras);
                $extrasHtml = '<div style="margin-top:4px;color:#666;font-size:13px">'.implode('', $parts).'</div>';
            }
            $html .= '
            <tr><td style="padding:8px 0;border-bottom:1px solid #eee;">
            <div style="display:flex;justify-content:space-between;gap:12px">
                <div><div style="font-weight:600;color:#111">'.esc(aget($item,'itemQuantity',1)).' × '.esc(aget($item,'itemName','')).'</div>'.$extrasHtml.'</div>
                <div style="white-space:nowrap">'.money(aget($item,'itemModifiedPrice',0)).'</div>
            </div>
            </td></tr>';
        }
        return $html;
    }
    function buildTotalsHtml(array $order): array {
        $subtotal      = (float) aget($order, 'totalOrderModifiedPrice', 0);
        $deliveryFee   = (float) aget($order, 'deliveryFee', 0);
        $serviceFee    = (float) aget($order, 'orderFee', 0);
        $smallOrderFee = (float) aget($order, 'smallOrderFee', 0);
        $grandTotal    = $subtotal + $deliveryFee + $serviceFee + $smallOrderFee;

        $rows = [
            ['Subtotal', $subtotal, true],
            ['Delivery Fee', $deliveryFee, $deliveryFee > 0],
            ['Service Fee', $serviceFee, $serviceFee > 0],
            ['Small Order Fee', $smallOrderFee, $smallOrderFee > 0],
        ];
        $html = '';
        foreach ($rows as [$label,$value,$show]) {
            if (!$show) continue;
            $html .= '<tr><td style="padding:6px 0;color:#444">'.esc($label).'</td><td style="padding:6px 0;text-align:right;color:#444">'.money($value).'</td></tr>';
        }
        $html .= '<tr><td style="padding-top:10px;border-top:1px solid #ddd;font-weight:700;color:#111">Total</td><td style="padding-top:10px;border-top:1px solid #ddd;text-align:right;font-weight:700;color:#111">'.money($grandTotal).'</td></tr>';
        return [$html, $grandTotal];
    }
    function formatShopAddressForEmail(string $raw, bool $asHtml = true): string{
        // 1) Turn &quot; etc. into real characters
        $json = html_entity_decode($raw, ENT_QUOTES | ENT_HTML5, 'UTF-8');

        // 2) Decode JSON -> array
        $data = json_decode($json, true);
        if (!is_array($data)) {
            // Fallback: return the raw string safely
            return $asHtml
                ? htmlspecialchars($raw, ENT_QUOTES | ENT_HTML5, 'UTF-8')
                : preg_replace('/\s+/', ' ', strip_tags($raw));
        }

        // 3) Pull + trim fields
        $street  = trim((string)($data['streetAddress'] ?? ''));
        $city    = trim((string)($data['city'] ?? ''));
        $county  = trim((string)($data['county'] ?? ''));
        $pc      = strtoupper(trim((string)($data['postcode'] ?? '')));
        $country = trim((string)($data['country'] ?? ''));

        // 4) UK postcode: ensure correct space (e.g., "PO29HF" -> "PO2 9HF")
        if ($pc !== '') {
            $pc = preg_replace('/^([A-Z]{1,2}\d{1,2}[A-Z]?)\s*(\d[A-Z]{2})$/i', '$1 $2', $pc);
        }

        // 5) Build lines (skip empties)
        $lines = array_values(array_filter([$street, $city, $county, $pc, $country], fn($v) => $v !== ''));

        // 6) Output for email
        if ($asHtml) {
            // escape each line for HTML emails
            $safeLines = array_map(fn($v) => htmlspecialchars($v, ENT_QUOTES | ENT_HTML5, 'UTF-8'), $lines);
            return implode('<br>', $safeLines);
        }
        return implode("\n", $lines);
    }
?>