<?php
    function getListOfOrdersOutSide2Hours($inputData){
        $db = $inputData['db']['dbApp'];
        $cutoff = (new DateTime('-2 hours'))->format('Y-m-d H:i:s');
        $sql = "SELECT fo.id, fo.payment_intent_id, te.payment_api_key
                FROM 	`food_order`  fo
                LEFT JOIN tenant te ON te.id = fo.tenant_id
                WHERE 	fo.`payment_status` 	= 'payment_pre_auth'
                AND 	fo.`order_status` 		= 'pending'
                AND 	fo.`created_at` 		<= :cutoffTime";

        $stmt = $db->prepare($sql);
        $stmt->bindValue(':cutoffTime', $cutoff);
        $stmt->execute();

        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (!$data) {
            return ['status' => 'failed', 'message' => 'No Orders to cancel'];
        } else {
            return ['status' => 'success', 'data' => $data];
        }
    }

?>