<?php
    function getListOfOrdersOutSide2Hours($inputData){
        $db = $inputData['db']['dbApp'];
        $cutoff = (new DateTime('-2 hours'))->format('Y-m-d H:i:s');
        $sql = "SELECT * 
            FROM 	`food_order` 
            WHERE 	`payment_status` 	    = 'payment_pre_auth'
                AND 	`order_status` 		= 'pending'
                AND 	`created_at` 		<= :cutoffTime";

        $stmt = $db->prepare($sql);
        $stmt->bindValue(':cutoffTime', $cutoff);
        $stmt->execute();

        $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

        if (!$data) {
            return ['status' => 'failed', 'message' => 'No Orders to cancel'];
        } else {
            return ['status' => 'success', 'data' => $data];
        }
    }

?>