<?php

    namespace Azui\Orbit\FoodOrderPublic;

    
    // this should only be used for testing purposes
    if (defined('TEST_ENV')) {
        //require_once __DIR__ . '/../../orbit-core/src/config.php';
        
        // Try core/src/ first, fallback to core/ if not found
        if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "src" . DIRECTORY_SEPARATOR . "Fcors.php")) {
            require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "src" . DIRECTORY_SEPARATOR . "Fcors.php";
        } else {
            require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "Fcors.php";
        }
        
        // Flexible path resolution for core files
        if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "unit-test" . DIRECTORY_SEPARATOR . "scripts" . DIRECTORY_SEPARATOR . "bootstrap.php")) {
            require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "unit-test" . DIRECTORY_SEPARATOR . "scripts" . DIRECTORY_SEPARATOR . "bootstrap.php";
        } else {
            require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "unit-test" . DIRECTORY_SEPARATOR . "scripts" . DIRECTORY_SEPARATOR . "bootstrap.php";
        }
        
        // Try core/src/ first, fallback to core/ if not found
        if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "src" . DIRECTORY_SEPARATOR . "generic.php")) {
            require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "src" . DIRECTORY_SEPARATOR . "generic.php";
        } else {
            require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "core" . DIRECTORY_SEPARATOR . "generic.php";
        }
        
        $testInfo['0'] = ("\nFunction Running in Test Environment\n");
    } else {
        // this is code for live environment Dev, Uat, Production
        require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "error_monitor.php";
        require_once __DIR__ . DIRECTORY_SEPARATOR . ".." . DIRECTORY_SEPARATOR . "generic.php";
    }

    require_once __DIR__ . DIRECTORY_SEPARATOR . "core.php";
    require_once __DIR__ . DIRECTORY_SEPARATOR . "view.php";
    require_once __DIR__ . DIRECTORY_SEPARATOR . "insert.php";
    require_once __DIR__ . DIRECTORY_SEPARATOR . "update.php";

    $inputData =\initializeGeneric();

    $inputData['requiresAdmin'] = [ 'Temp1'           =>  [2,4,5]];
    $inputData['keepLive'] = \checkLive();
    
    if(!isset($inputData['action']) || empty($inputData['action'])){
        $out['status']   = 'failed';
        $out['message']  = 'No Action Found';
        echo json_encode(\propagateStatusAndMessage($out));
exit;
    }

    $action = $inputData['action'];

    // check if action need auth and if does check it valid otherwise move to swithc statments 
    $security = \SecurityCheck($inputData); // skip security for a bit 

    if(isset($inputData['tenantId']) == false || $inputData['tenantId'] == null ){
        setTenantId($inputData);
        reinitializeTenantId($inputData);
    }
    if($security['security'] === '1'){
        switch ($action) {
            //Test
                case "test":
                    $out['status']   = 'success';
                    $out['message']  = 'Test Passed';
                    break;
            // View
                case "viewAddress":
                    $inputData['table']         = 'foodOrderAddress';
                    $inputData['nextOperation']      = __NAMESPACE__ . '\viewAddressWithUserLink';
                    $out = executeDatabaseOperation($inputData);
                    break;
                case "checkOrderStatus":
                    $inputData['nextOperation']      = __NAMESPACE__ . '\checkOrderStatus';
                    $out = executeDatabaseOperation($inputData);
                    break;
                case "viewOrder":
                    // requires orderId
                    if(isset($inputData['orderId']) == false || $inputData['orderId'] == null ){
                        $out['status']   = 'failed';
                        $out['message']  = 'orderId is required';
                        break;
                    }
                    if(isset($inputData['email']) == false || $inputData['email'] == null ){
                        $out['status']   = 'failed';
                        $out['message']  = 'email is required';
                        break;
                    }
                    $inputData['viewLevel'] = 'full';
                    $inputData['nextOperation']      = __NAMESPACE__ . '\viewFullOrderDetails';
                    $out = executeDatabaseOperation($inputData);
                    break;
                case "viewLoggedInUserAddressesList":
                    $inputData['nextOperation']      = __NAMESPACE__ . '\viewUserAddressList';
                    $out = executeDatabaseOperation($inputData);
                    break;
                case "viewDistanceToAddress":
                    if (!isset($inputData['addressId']) || empty($inputData['addressId'])) {
                        $out = [
                            'status' => 'failed',
                            'message' => 'addressId is required'
                        ];
                        break;
                    }
                    $inputData['nextOperation']      = __NAMESPACE__ . '\viewDistanceToAddress';
                    $out = executeDatabaseOperation($inputData);
                    break;
                case "viewLatestTerms":
                    $inputData['nextOperation']      = __NAMESPACE__ . '\viewLatestTerms';
                    $out = executeDatabaseOperation($inputData);
                    break;
                // insert
                case "insertAddress":
                    $inputData['foodOrderAddress']['checkSum'] = generateChecksum($inputData['foodOrderAddress']);
                    // check if address already exists
                    $inputData['nextOperation']      = __NAMESPACE__ . '\checkAddressExists';
                    $out = executeDatabaseOperation($inputData);

                    if ($out['status'] === 'Found') {
                        // If address already exists, return the error
                        $out['address'] = [
                            'status'    => 'skipped',
                            'message'   => 'Address already exists'
                        ];
                    }else{
                        $inputData['table']         = 'foodOrderAddress';
                        $inputData['nextOperation']      = __NAMESPACE__ . '\insertData';
                        $out['address'] = executeDatabaseOperation($inputData);
                    }
                
                    $inputData['foodOrderUserAddress']['userId'] = $inputData['userId'];
                    $inputData['foodOrderUserAddress']['addressId'] = $out['address']['id'] ?? $out['id'];

                    // check if link allready exists
                    checkIfUserToAddressExists($inputData);
                    if ($out['status'] === 'Found') {
                        // If address already exists, return the error
                        $out['link'] = [
                            'status'    => 'skipped',
                            'message'   => 'Link between user and address already exists'
                        ];
                        $out['status'] = 'skipped';
                    }else{
                        $inputData['table']         = 'foodOrderUserAddress';
                        $inputData['nextOperation']      = __NAMESPACE__ . '\insertData';
                        $out['link'] = executeDatabaseOperation($inputData);
                    }

                    break;
                case "insertUserToAddress":
                    $inputData['table']         = 'foodOrderUserAddress';
                    if (empty($inputData['userId'])) {
                        $out = [
                            'status' => 'failed',
                            'message' => 'userId is required'
                        ];
                        break;
                    }
                    $inputData['foodOrderUserAddress']['userId'] = $inputData['userId'];
                    $out = checkIfUserToAddressExists($inputData);
                    if ($out['status'] === 'Found') {
                        // If address already exists, return the error
                        $out['link'] = [
                            'status'    => 'skipped',
                            'message'   => 'Link between user and address already exists'
                        ];
                        $out['status'] = 'skipped';
                    }else{
                        $inputData['nextOperation']      = __NAMESPACE__ . '\insertData';
                        $out['link'] = executeDatabaseOperation($inputData);
                    }
                    break;
                case "insertOrder":
                    $inputData['nextOperation']      = __NAMESPACE__ . '\orderSetUP';
                    $out = executeDatabaseOperation($inputData);
                    break;
                case "setupNewDistanceToAddress":
                    if (!isset($inputData['addressId']) || empty($inputData['addressId'])) {
                        $out = [
                            'status' => 'failed',
                            'message' => 'addressId is required'
                        ];
                    }
                    $out = setupNewDistanceToAddress($inputData);
                    break;
            // Stipe
                case "stripeInbound":
                    $out  = stripeInboundDecision($inputData);
                    break;
            // Extras
            default:
                $out['status']   = 'failed';
                $out['message']  = 'No Action Found';
                break;
        }
    }else{
        $out = $security;
        if($security['security'] === '0'){
            unset($out['security']);
        }

    }

    if(defined('TEST_ENV')){
    //    $out['testInfo']['1'] = $testInfo;
    //    $out['testInfo']['2'] = $_GET;
    //    $out['testInfo']['3'] = $_POST;
    //    $out['inputData']     = $inputData;
        $out['security']      = $security;
        $out['action']        = $action;
    }
   \cleanUpOutputData($out);
    echo json_encode(\propagateStatusAndMessage($out));
?>
