<?php
    ini_set('error_log', 'php://stderr');


    use PHPUnit\Framework\TestCase;
    
    //require_once __DIR__ . '/../../tests/scripts/bootstrap.php'; // ✅ Use shared mock DB
    //require_once __DIR__ . '/../src/function.php';
    
    error_log(">>>>>>>>>>>>>>>>>>>>>>>>>====<<<<<<<<<<<<<<<<<<<<<<<<<");
    error_log("T09_FoodOrderingTest.php");
    
    // Print list of table that exist in the database
    //$tables = $GLOBALS['mockPdo']->query("SELECT name FROM sqlite_master WHERE type='table';")->fetchAll(\PDO::FETCH_COLUMN);
    //echo("\n🔍 Tables: " . implode(', ', $tables). "\n");
    
    class T09_FoodOrderingTest extends TestCase
    {
        private $mockPdo;
        private static $lastModified;

        protected function setUp(): void{
            // ✅ Use the shared mock database connection
            $_SESSION = [];
            $_GET = [];
            $_POST = [];
            $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
            $_SERVER['HTTP_REFERER'] = 'http://localhost/test';
            $this->mockPdo = $GLOBALS['mockPdo'];
            if (session_status() !== PHP_SESSION_ACTIVE) {
                if (session_status() !== PHP_SESSION_ACTIVE && !headers_sent()) {
                    session_start();
                }
            }
        }
        private function executeFunctionPhp(): array {
            ob_start();
        // Flexible path resolution for module function.php
        if (file_exists(__DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php')) {
            require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'src' . DIRECTORY_SEPARATOR . 'function.php';
        } else {
            require __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'function.php';
        }
        $output = ob_get_clean();
        
            // ✅ Ensure only valid JSON output
            $decodedOutput = json_decode($output, true);
            if (json_last_error() !== JSON_ERROR_NONE) {
                throw new Exception("Invalid JSON output: " . json_last_error_msg() . "\nOutput: " . $output);
            }
        
            return [$output, $decodedOutput];
        }
        public function test001DummyTest(): void{
            $this->assertTrue(true);
        }
        // set up data that is needed / renable deleted data sets from test file 7
        public function test002UpdateData(): void{
            date_default_timezone_set('Europe/London'); // or your local timezone

            $this->mockPdo->exec("update menu_categories        set is_active = 1 , is_deleted = 0"); // menu_category
            $this->mockPdo->exec("update menu_category_items    set is_active = 1 , is_deleted = 0"); // menu_category_items
            $this->mockPdo->exec("update menu_items             set is_active = 1 , is_deleted = 0"); // menu_items
            $this->mockPdo->exec("update menu_option_extra      set is_active = 1 , is_deleted = 0"); // menu_option_extra
            $this->mockPdo->exec("update menu_option_joins      set is_active = 1 , is_deleted = 0"); // menu_option_joins
            $this->mockPdo->exec("update menu_option_groups     set is_active = 1 , is_deleted = 0"); // menu_option_groups
            $this->mockPdo->exec("update menu_option_groups     set is_active = 0 , is_deleted = 1 where id in (1,2,3,4)"); // menu_option_groups
            $this->mockPdo->exec("update menu_category_items set category_id = 8 where id = 5"); // change item from one menu to another
            $this->assertTrue(true, "Data updated successfully");
            $this->mockPdo->exec("update tenant set minimum_order_amount = 15, small_order_fee = 2 where id = 1"); // tenant

            $this->mockPdo->exec("update tenant_business_hours set is_deleted = 1 where tenant_id = 1 and id in (1,2,3,4,5,6,7,8,9,10,12,13,14,15)"); // tenant_business_hours

            // tenant set payment_api_key
            $this->mockPdo->exec("update tenant set payment_api_key = 'test_api_key' where id = 1");

            // Get today's day name (e.g., 'Monday')
            $dayNames = ['Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday', 'Sunday'];
            $dayOfWeek = date('N') - 1; // 0 (Monday) to 6 (Sunday)
            $dayName = $dayNames[$dayOfWeek];

            // Get the current time and +1 hour
            $currentTime = date('H:i:s');
            $currentTimePlusOneHour = date('H:i:s', strtotime('+1 hour', strtotime($currentTime)));

            // Properly quote values in SQL
            $dayName = $this->mockPdo->quote($dayName);
            $currentTime = $this->mockPdo->quote($currentTime);
            $currentTimePlusOneHour = $this->mockPdo->quote($currentTimePlusOneHour);

            // Execute the insert
            $this->mockPdo->exec("
                INSERT INTO tenant_business_hours (tenant_id, opening_day, open_time, close_time, hours_category) 
                VALUES
                    (1, $dayName, $currentTime, $currentTimePlusOneHour, 'store'),
                    (1, $dayName, $currentTime, $currentTimePlusOneHour, 'delivery')
            ");
            // Debug output

            //echo $dayName . " " . $currentTime . " " . $currentTimePlusOneHour . "\n";

            // print out the data that was inserted
            $result = $this->mockPdo->query("SELECT * FROM tenant_business_hours WHERE tenant_id = 1 AND id in(16,17)")->fetchAll(\PDO::FETCH_ASSOC);
            //echo "Inserted data:\n";
            //foreach ($result as $row) {
            //    echo "ID: {$row['id']}, Opening Day: {$row['opening_day']}, Open Time: {$row['open_time']}, Close Time: {$row['close_time']}, Hours Category: {$row['hours_category']}, created_at: {$row['created_at']}\n";
            //}

            // selected the data from the tenant
            //$result = $this->mockPdo->query("SELECT * FROM tenant WHERE id = 1")->fetchAll(\PDO::FETCH_ASSOC);
            //echo "Inserted data:\n";
            ///foreach ($result as $row) {
            //    echo "ID: {$row['id']}, Name: {$row['name']}, Domain: {$row['domain']}, created_at: {$row['created_at']}, minimum_order_amount: {$row['minimum_order_amount']}, small_order_fee: {$row['small_order_fee']}\n";
            //}

            //4, 5

            $this->mockPdo->exec("update menu_option_extra set is_active = 1 , is_deleted = 0 where id in (4,5)"); // menu_option_extra

            $this->mockPdo->exec("update menu_option_joins set is_active = 1 , is_deleted = 0 where id in (4,5)"); // menu_option_joins

            $this->mockPdo->exec("update menu_option_groups set is_active = 1 , is_deleted = 0 where id in (2)"); // menu_option_groups

            $this->mockPdo->exec("update menu_item_to_options set is_active = 1 , is_deleted = 0 where id in (10)"); // menu_item_to_options

            $this->mockPdo->exec("update menu_item_to_options set is_active = 0 , is_deleted = 1 where id in (5)"); // menu_item_to_options

            $this->mockPdo->exec("update menu_option_groups set is_required = 1"); // menu_option_groups

            $this->mockPdo->exec("insert into food_order_terms_of_service (tenant_id, content, is_active, versions, effective_date) values (1, 'These are the latest terms and conditions.', 0, '0.1', '2024-01-01')");
            $this->mockPdo->exec("insert into food_order_terms_of_service (tenant_id, content, is_active, versions, effective_date) values (1, 'These are the latest terms and conditions.', 1, '0.2', '2024-01-01')");
            $this->mockPdo->exec("insert into food_order_terms_of_service (tenant_id, content, is_active, versions, effective_date) values (1, 'These are the latest terms and conditions.', 0, '0.3', '2024-01-01')");
        }
        public function test003InsertAddress(): void{
            $_SESSION['id'] = 5;              // User ID
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertAddress',
                'foodOrderAddress' => [ 
                    'addressLine1'  => '123 Main St',
                    'addressLine2'  => 'Apt 4B',
                    'city'          => 'Springfield',
                    'county'        => 'devon',
                    'country'       => 'United Kingdom',
                    'postalCode'    => 'EX1 2AB',
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);        
        }
        public function test004InsertAddressDuplicate(): void{
            $_SESSION['id'] = 5;              // User ID
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertAddress',
                'foodOrderAddress' => [ 
                    'addressLine1'  => '123 Main St',
                    'addressLine2'  => 'Apt 4B',
                    'city'          => 'Springfield',
                    'county'        => 'devon',
                    'country'       => 'United Kingdom',
                    'postalCode'    => 'EX1 2AB',
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('skipped', $decodedOutput['status']);
            $this->assertEquals('skipped', $decodedOutput['address']['status']);
            $this->assertEquals('Address already exists', $decodedOutput['address']['message']);
            $this->assertEquals('skipped', $decodedOutput['link']['status']);
            $this->assertEquals('Link between user and address already exists', $decodedOutput['link']['message']);

        }
        public function test005InsertJoinUserToAddress(): void{
            $_SESSION['id'] = 4;                // User ID
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertUserToAddress',
                'foodOrderUserAddress' => [ 
                    'addressId'    => 1,
                    'isDefault'    => 1,
                    'isActive'     => 1,
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
        }
        public function test006InsertAddressWithMissingUserId(): void{
            $_SESSION[] = [];              // Clear session
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertUserToAddress',
                'foodOrderUserAddress' => [ 
                    'addressId'    => 1,
                    'isDefault'    => 1,
                    'isActive'     => 1,
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertStringContainsString('userId is required', $decodedOutput['message']);
        }
        public function test007ViewAddress(): void{
            $_SESSION['id'] = 5;              // User ID
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'viewAddress',
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            $expectedResult = [
                'status' => 'success',
                'data' => [
                    'addressId' => 1,
                    'addressLine1' => '123 Main St',
                    'addressLine2' => 'Apt 4B',
                    'city' => 'Springfield',
                    'county' => 'Devon',
                    'country' => 'UK',
                    'postalCode' => 'EX1 2AB'
                ],
                'security' => [
                    'security' => '1'
                ],
                'action' => 'viewAddress',
            ];
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertEquals($expectedResult, $decodedOutput);
        }
        public function test008OrderMissingAllData(): void{
            //$_SESSION['id'] = 293;              // User ID
            //$_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertOrder',
                        'basket' => [
                            'items'     => [[],[]],
                            'promotion' => [[],[]],
                            'guestUser' => [],
                            'addressId' => []
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Tenant ID is required for order setup.', $decodedOutput['message']);
        }
        public function test009OrderMissingUserId(): void{
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertOrder',
                        'basket' => [
                            'items' => [[],[]],
                            'promotion' => [[],[]],
                            'guestUser' => [],
                            'address' => [
                                'deliveryId' => 0,
                                'billingId' => 0,
                            ],
                            'termsOfService' => [
                                'version'   => '0.2',
                                'accepted'  => 1
                            ],
                            'deliveryType' => 'delivery', // Assuming this is a valid delivery type
                        ],
                        'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput, true); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Either User Id or Guest Info is required for order setup.', $decodedOutput['message']);

            // Check is sql query was inserted food_order_terms_acceptance            
        }
        public function test010OrderWithUserIdUnkownExtra(): void{
            $_SESSION['id'] = 5;                // User ID
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertOrder',
                        'basket' => [
                            'items'  => [
                                [
                                    "id" => 4, 
                                    "quantity" => 2
                                ],
                                [
                            "id" => 3, 
                            "quantity" => 1,
                            "options" => [
                                [
                                    "id" => 5,
                                    "extras" => [
                                        [
                                            ["id" => 10,] // This extra is not in the database
                                        ]
                                    ]
                                ],      
                                [
                                    "id" => 6,
                                    "extras" => [
                                        [
                                            ["id" => 8,],
                                            ["id" => 9,]
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ],
                    'termsOfService' => [
                                'version'   => '0.2',
                                'accepted'  => 1
                            ],
                    'promotion' => [[],[]],
                    'guestUser' => [],
                    'address'   => [
                        'deliveryId' => 1, // Assuming this is a valid address ID
                    ],
                    'deliveryType' => 'delivery', // Assuming this is a valid delivery type
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            //$decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Options validation failed for item id 3: Inbound extra with id 10 for option group id 5 does not exist in the extra options.', $decodedOutput['message']);
        }
        public function test011OrderWithUserIdExtraMoreThanCount(): void{
            $_SESSION['id'] = 5;                // User ID
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertOrder',
                    'basket' => [
                        'items'  => [
                            [
                                "id" => 4, 
                                "quantity" => 2
                            ],
                            [
                                "id" => 3, 
                                "quantity" => 1,
                                "options" => [
                                    [
                                        "id" => 5,
                                        "extras" => [
                                            [
                                                ["id" => 6,],
                                                ["id" => 7,]
                                            ]
                                        ]
                                    ],      
                                    [
                                        "id" => 6,
                                        "extras" => [
                                            [
                                                ["id" => 8,],
                                                ["id" => 9,]
                                            ]
                                        ]
                                    ]
                                ]
                            ]
                        ],
                        'termsOfService' => [
                                'version'   => '0.2',
                                'accepted'  => 1
                            ],
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a valid delivery type
                    ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Options validation failed for item id 3: Selected options (2) for option group 5 do not meet min (1) and max (1) selection requirements.', $decodedOutput['message']);
        }
        public function test012OrderWithUserIdWithOptionExtraDupicate(): void{
            $_SESSION['id'] = 5;                // User ID
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
           $_POST = [
                'action' => 'insertOrder',
                        'basket' => [
                            'items'  => [
                                [
                                    "id" => 4, 
                                    "quantity" => 1,
                                    "options" => [
                                        [
                                            "id" => 4,
                                            "extras" => [
                                                [
                                                    ["id" => 6,],
                                                    ["id" => 6,]
                                                ]
                                            ]
                                        ],      
                                        [
                                            "id" => 6,
                                            "extras" => [
                                                [
                                                    ["id" => 8,]
                                                ]
                                            ]
                                        ]
                                    ]
                                ]
                    ],
                    'promotion' => [[],[]],
                    'guestUser' => [],
                    'address'   => [
                        'deliveryId' => 1, // Assuming this is a valid address ID
                    ],
                    'deliveryType' => 'delivery', // Assuming this is a valid delivery type
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
        }
        public function test013OrderWithGuestUserExtraOptionGroup(): void{
            $_SESSION[] = [];              // Clear session
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertOrder',
                'basket' => [
                    'items' => [
                        [
                            "id" => 4, 
                            "quantity" => 2
                        ],
                        [
                            "id" => 3, 
                            "quantity" => 1,
                            "options" => [
                                [
                                    "id" => 5,
                                    "extras" => [
                                         [
                                            ["id" => 6,]
                                        ]
                                    ]
                                ],      
                                [
                                    "id" => 1000,
                                    "extras" => [
                                        [
                                            ["id" => 8,]
                                        ]
                                    ]
                                ],
                            ]
                        ]
                    ],
                    'termsOfService' => [
                                'version'   => '0.2',
                                'accepted'  => 1
                    ],
                    'promotion' => [[],[]],
                    'guestUser' => [
                        'fName'         => 'John',
                        'lName'         => 'Doe',
                        'phoneNumber'   => '1234567890',
                        'userEmail'     => 'test@test.com',
                        'address'       => [
                                'addressLine1'  => '123 Main St',
                                'addressLine2'  => 'Apt 4B',
                                'city'          => 'Springfield',
                                'county'        => 'devon',
                                'country'       => 'United Kingdom',
                                'postalCode'    => 'BB1 2AB',
                        ],
                    ],
                    'deliveryType' => 'delivery', // Assuming this is a valid delivery type
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            //$this->assertEquals('Guest user order setup completed successfully.', $decodedOutput['message']);
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Options validation failed for item id 3: Inbound option group with id 1000 does not exist in the database options.', $decodedOutput['message']);
        }    
        public function test014OrderWithGuestUserDiffrentAddressMissingOptionExtra(): void{
            $_SESSION[] = [];              // Clear session
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertOrder',
                'basket' => [
                    'items' => [
                        [
                            "id" => 4, 
                            "quantity" => 2
                        ],
                        [
                            "id" => 3, 
                            "quantity" => 1,
                            "options" => [
                                [
                                    "id" => 5,
                                    "extras" => [
                                         [
                                            ["id" => 6,],
                                        ]
                                    ]
                                ],      
                                [
                                    "id" => 6,
                                    "extras" => [
                                         [

                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ],
                    'termsOfService' => [
                        'version'   => '0.2',
                        'accepted'  => 1
                    ],
                    'promotion' => [[],[]],
                    'guestUser' => [
                        'fName'         => 'John',
                        'lName'         => 'Doe',
                        'phoneNumber'   => '1234567890',
                        'userEmail'     => 'test@test.com',
                        'address'       => [
                                'addressLine1'  => '124 Main St',
                                'addressLine2'  => 'Apt 4B',
                                'city'          => 'Springfield',
                                'county'        => 'devon',
                                'country'       => 'United Kingdom',
                                'postalCode'    => 'TX1 2AB',
                        ],
                    ],
                    'deliveryType' => 'delivery', // Assuming this is a valid delivery type
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            //$this->assertEquals('Guest user order setup completed successfully.', $decodedOutput['message']);
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Options validation failed for item id 3: Required option group with id 6 is missing from the inbound options.', $decodedOutput['message']);
        }   
        public function test015OrderWithUserIdAndAddressIdMissing(): void{
            $_SESSION[] = [];                   // Clear session
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_SESSION['id'] = 5;                // User ID
            $_POST = [
                'action' => 'insertOrder',
                'basket' => [
                    'items'     => [[],[]],
                    'promotion' => [[],[]],
                    'guestUser' => [],        
                    'termsOfService' => [
                        'version'   => '0.2',
                        'accepted'  => 1
                    ],        
                    'deliveryType' => 'delivery', // Assuming this is a valid delivery type
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Delivery Address Id is required for delivery orders when User Id is provided.', $decodedOutput['message']);
        }
        public function test016OrderWithBothUserIdAndGuestUser(): void{
            $_SESSION['id'] = 293;              // User ID
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertOrder',
                'basket' => [
                    'items'     => [[],[]],
                    'promotion' => [[],[]],
                    'guestUser' => [
                        'f_name'        => 'John',
                        'l_name'        => 'Doe',
                        'phone_number'  => '1234567890'
                    ],
                    'termsOfService' => [
                        'version'   => '0.2',
                        'accepted'  => 1
                    ],                    
                    'addressId' => 1,
                    'deliveryType' => 'delivery', // Assuming this is a valid delivery type
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Both User Id and Guest Info cannot be set at the same time.', $decodedOutput['message']);
        }
        public function test017OrderWithInvalidUserId(): void{
            $_SESSION['id'] = 999;              // Invalid User ID
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertOrder',
                'basket' => [
                    'items'     => [[],[]],
                    'promotion' => [[],[]],
                    'guestUser' => [],
                    'address' => [
                        'deliveryId' => 1, // Assuming this is a valid address ID
                        'billingId' => 1,  // Assuming this is a valid address ID
                    ],
                    'termsOfService' => [
                        'version'   => '0.2',
                        'accepted'  => 1
                    ],                    
                    'deliveryType' => 'delivery', // Assuming this is a valid delivery type
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('User is invalid.', $decodedOutput['message']);
        }
        public function test018OrderWithValidIdAndAddressId(): void{
            $_SESSION['id'] = 5;                // Valid User ID
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertOrder',
                'basket' => [
                    'items'     => [[],[]],
                    'promotion' => [[],[]],
                    'guestUser' => [],
                    'address' => [
                        'deliveryId' => 1, // Assuming this is a valid address ID
                        'billingId' => 1,  // Assuming this is a valid address ID
                    ],
                    'termsOfService' => [
                        'version'   => '0.2',
                        'accepted'  => 1
                    ],                    
                    'deliveryType' => 'delivery', // Assuming this is a valid delivery type
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Each item must have a valid item id.', $decodedOutput['message']);

        }
        public function test019OrderWithValidIdAndNonValidDeliveryId(): void{
            $_SESSION['id'] = 5;              // Valid User ID
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertOrder',
                'basket' => [
                    'items'     => [
                        [
                            "id" => 4, 
                            "quantity" => 2
                        ],
                        [
                            "id" => 3, 
                            "quantity" => 1,
                            "options" => [
                                [
                                    "id" => 5,
                                    "extras" => [
                                         [
                                            ["id" => 6,],
                                            ["id" => 7,],
                                            ["id" => 8,],
                                            ["id" => 9,]
                                        ]
                                    ]
                                ],      
                                [
                                    "id" => 6,
                                    "extras" => [
                                         [
                                            ["id" => 8,],
                                            ["id" => 9,]
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ],
                    'promotion' => [[],[]],
                    'guestUser' => [],
                    'address'   => [
                        'deliveryId' => 999, // Assuming this is an invalid address ID
                        'billingId' => 1,    // Assuming this is a valid address ID
                    ],
                    'termsOfService' => [
                        'version'   => '0.2',
                        'accepted'  => 1
                    ],                    
                    'deliveryType' => 'delivery', // Assuming this is a valid delivery type
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Delivery Address is invalid.', $decodedOutput['message']);
        }
        public function test020OrderWithGuestUserMoreOption(): void{
            $_SESSION[] = [];              // Clear session
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
            $_POST = [
                'action' => 'insertOrder',
                'basket' => [
                    'items' => [
                        [
                            "id" => 4, 
                            "quantity" => 2
                        ],
                        [
                            "id" => 3, 
                            "quantity" => 1,
                            "options" => [
                                [
                                    "id" => 5,
                                    "extras" => [
                                         [
                                            ["id" => 6,],
                                            ["id" => 7,],
                                            ["id" => 8,],
                                            ["id" => 9,]
                                        ]
                                    ]
                                ],      
                                [
                                    "id" => 6,
                                    "extras" => [
                                         [
                                            ["id" => 8,]
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ],
                    'termsOfService' => [
                        'version'   => '0.2',
                        'accepted'  => 1
                    ],                    
                    'promotion' => [[],[]],
                    'guestUser' => [
                        'fName'         => 'John',
                        'lName'         => 'Doe',
                        'phoneNumber'   => '1234567890',
                        'userEmail'     => 'test@test.com',
                        'address'       => [
                                'addressLine1'  => '123 Main St',
                                'addressLine2'  => 'Apt 4B',
                                'city'          => 'Springfield',
                                'county'        => 'devon',
                                'country'       => 'United Kingdom',
                                'postalCode'    => 'EX1 5AB',
                        ],
                    ],
                    'deliveryType' => 'delivery', // Assuming this is a valid delivery type
                ],
                'debug' => 'CSD' // Add debug flag to the request
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            //$this->assertEquals('Guest user order setup completed successfully.', $decodedOutput['message']);
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertEquals('Options validation failed for item id 3: Selected options (4) for option group 5 do not meet min (1) and max (1) selection requirements.', $decodedOutput['message']);
        }   
        public function test021CheckUserList(): void{
            $stmt = $this->mockPdo->query("SELECT * FROM user_login ");
            $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows); // or var_dump($rows)
            $this->assertNotEmpty($rows, "User list should not be empty");
        }
        public function test022CheckAddressList(): void{
            $stmt = $this->mockPdo->query("SELECT * FROM food_order_address");
            $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows); // or var_dump($rows)
            $this->assertNotEmpty($rows, "Address list should not be empty");
        }
        public function test023CheckMenuItemsItems(): void{
            $stmt = $this->mockPdo->query("SELECT * FROM menu_items");
            $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            // Debug output
            //echo(print_r($rows, true)); // or var_dump($rows)
            $this->assertNotEmpty($rows, "Menu items items should not be empty");
        }
        public function test024CheckMenuGroup(): void{
            $stmt = $this->mockPdo->query("SELECT * FROM menu_option_groups");
            $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows); // or var_dump($rows)
            $this->assertNotEmpty($rows, "Menu group groups should not be empty");
        }   
        public function test025CheckMenuOptionsJoins(): void{
            $stmt = $this->mockPdo->query("SELECT * FROM menu_option_joins");
            $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows); // or var_dump($rows)
            $this->assertNotEmpty($rows, "Menu options should not be empty");
        }
        public function test026CheckTennantIdValue(): void{
            $stmt = $this->mockPdo->query("SELECT mi.id, mi.item_name, m.tenant_id , m.id as menu_id, m.is_active, mci.category_id, mci.item_id, mci.id as mci_id
                    FROM menu_items mi
                    inner join menu_category_items mci on mi.id = mci.item_id
                    inner join menu_categories mc on mci.category_id = mc.id
                    inner join menu_menus m on mc.menu_id = m.id
                    WHERE mi.id in (3,4)");
            $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows); // or var_dump($rows)
            $this->assertNotEmpty($rows, "Tenant history should not be empty for tenant_id 1");
        }
        // Db Checks
        public function test027ViewItem3Extras(): void{
            $stmt = $this->mockPdo->query("SELECT mog.min_select, mog.max_select, mog.is_required, mog.id, moe.extra_name, moe.price_adjustment, moe.id as extra_id
                    FROM  menu_item_to_options mito
                    INNER JOIN menu_option_joins moj     ON mog.id = moj.group_id
                    INNER JOIN menu_option_extra moe     ON moe.id = moj.extra_id
                    INNER JOIN menu_option_groups mog    ON mog.id = mito.group_id 
                    WHERE mito.item_id = 3
                    AND mito.is_active = 1
                    AND mito.is_deleted = 0
                    AND mog.is_active = 1
                    AND mog.is_deleted = 0
                    AND moj.is_active = 1
                    AND moj.is_deleted = 0
                    AND moe.is_active = 1
                    AND moe.is_deleted = 0"); // mi.id id menu item id
            $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows); // or var_dump($rows)
            $this->assertNotEmpty($rows, "Menu items with options should not be empty for item id x");
        }
        public function test028ViewOpenHours(): void{
            $stmt = $this->mockPdo->query("SELECT * FROM tenant_business_hours WHERE tenant_id = 1 and is_deleted = 0");
            $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            // Debug output
            //print_r($rows); // or var_dump($rows)
            $this->assertNotEmpty($rows, "Open hours should not be empty for tenant_id 1");
        }
        // Start Tests For orders from here Generate the data we need in order to preform the tests. Keep it simple and easy by doing direct inserts into the database
            //check if deliveryType is set
            public function test029OrderWithDeliveryTypeNotSet(): void{
                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [[],[]],
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Delivery type must be delivery or collection.', $decodedOutput['message']);
            }
            public function test030OrderWithDeliveryWrongValue(): void{
                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [[],[]],
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'deliveryType' => 'invalid', // Invalid delivery type
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Delivery type must be delivery or collection.', $decodedOutput['message']);
            }
            public function test031OrderWithDeliveryNoValue(): void{
                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [[],[]],
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'deliveryType' => '', // Invalid delivery type
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Delivery type must be delivery or collection.', $decodedOutput['message']);
            }
            public function test032OrderInClosedBusinessHours(): void{
                // disable the business hours for this test
                $this->mockPdo->query("UPDATE tenant_business_hours SET is_deleted = 1 WHERE tenant_id = 1 and id = 17");
                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [[],[]],
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('No valid business hours found for today', $decodedOutput['message']);
                $this->mockPdo->query("UPDATE tenant_business_hours SET is_deleted = 0 WHERE tenant_id = 1 and id = 17");
            }
            public function test033OrderWithNoItemsSet(): void{
                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Items are required for an order to be created.', $decodedOutput['message']);
            } 
            public function test034OrderWithNoItemIdSet(): void{
                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [["quantity" => 2]], // Valid item with quantity
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Each item must have a valid item id.', $decodedOutput['message']);
            }
            public function test035OrderWithNoQuantitySet(): void{
                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [["id" => 20]], // Valid item with no quantity
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Each item must have a quantity.', $decodedOutput['message']);
            }
            public function test036OrderWithIdNotNumerical(): void{
                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [["id" => "twenty", "quantity" => 2]], // Valid item with non-numerical id
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Each item id must be an integer.', $decodedOutput['message']);
            }
            public function test037OrderWithNoNumericalQuantitySet(): void{
                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [["id" => 20, "quantity" => "two"]], // Valid item with non-numerical quantity
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Each item quantity must be an integer.', $decodedOutput['message']);
            }
            public function test038OrderWithNoDecimalQuantitySet(): void{
                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [["id" => 20, "quantity" => 2.5]], // Valid item with non-numerical quantity
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Each item quantity must be an integer.', $decodedOutput['message']);
            }
            public function test039OrderWithNoValidItemId(): void{
                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [["id" => 999, "quantity" => 2]], // Invalid item id
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Item with id 999 does not exist or is not available for the current tenant.', $decodedOutput['message']);
            }
            public function test040OrderWithNoValidItemIdAndOptions(): void{
                // insert a new item
                $stmt = $this->mockPdo->prepare("INSERT INTO menu_items (item_name, base_price, is_active, tenant_id) VALUES ('Chips', 2.99, 1, 1)");
                $stmt->execute();
                // Get the last inserted item ID
                $lastItemId = $this->mockPdo->lastInsertId();
                // Insert into menu_category_items
                $stmt = $this->mockPdo->prepare("INSERT INTO menu_category_items (category_id, item_id, is_active) VALUES (12, $lastItemId, 1)");
                $stmt->execute();

                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [
                                        [
                                            "id" => $lastItemId, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 5,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 6,],
                                                                                    ["id" => 7,]
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]
                                        ]
                                    ],
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Options validation failed for item id 13: Item 13 does not allow extras, but extras were provided.', $decodedOutput['message']);
            }
            public function test041OrderWithDbExtraMissMatch(): void{
                // insert a new item
                $stmt = $this->mockPdo->prepare("INSERT INTO menu_option_groups (tenant_id, group_name, min_select, max_select, is_active) VALUES (1, 'Condiments', 0, 2, 1)");
                $stmt->execute();
                // Get the last inserted item ID
                $menuOptionGroupId = $this->mockPdo->lastInsertId();
                // insert into menu_item_to_options
                $stmt = $this->mockPdo->prepare("INSERT INTO menu_item_to_options (item_id, group_id, is_active) VALUES (13, $menuOptionGroupId, 1)");
                $stmt->execute();
                // Insert into menu_category_items
                $stmt = $this->mockPdo->prepare("INSERT INTO menu_option_extra (extra_name, is_active, price_adjustment, tenant_id) VALUES ('Salt', 1, 0.25, 1)");
                $stmt->execute();
                // Get the last inserted extra ID
                $lastExtraId = $this->mockPdo->lastInsertId();
                // Insert into menu_option_joins
                $stmt = $this->mockPdo->prepare("INSERT INTO menu_option_joins (extra_id, group_id, is_active, price_adjustment) VALUES ($lastExtraId, $menuOptionGroupId, 1, 0.25)");
                $stmt->execute();
                //echo "Menu Option Group ID: $menuOptionGroupId, First Extra ID: $lastExtraId\n";
                // Insert another extra
                $stmt = $this->mockPdo->prepare("INSERT INTO menu_option_extra (extra_name, is_active, price_adjustment, tenant_id) VALUES ('Vinegar', 1, 0.25, 1)");
                $stmt->execute();
                // Get the last inserted extra ID
                $lastExtraId = $this->mockPdo->lastInsertId();
                // Insert into menu_option_joins
                $stmt = $this->mockPdo->prepare("INSERT INTO menu_option_joins (extra_id, group_id, is_active, price_adjustment) VALUES ($lastExtraId, $menuOptionGroupId, 1, 0.25)");
                $stmt->execute();
                //echo "Menu Option Group ID: $menuOptionGroupId, Last Extra ID: $lastExtraId\n";

                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 10,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 13,], // Invalid extra id
                                                                                    ["id" => 14,],
                                                                                    ["id" => 15,]
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]
                                        ]
                                    ],
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Options validation failed for item id 13: Inbound extra with id 13 for option group id 10 does not exist in the extra options.', $decodedOutput['message']);
            }
            public function test042OrderWithMissingExtras(): void{
                // update the menu_option_groups table to allow extras
                $stmt = $this->mockPdo->prepare("UPDATE menu_option_groups SET min_select = 1, max_select = 2 WHERE id = 10");
                $stmt->execute();

                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                            ]
                                                        ]
                                        ]
                                    ],
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Options validation failed for item id 13: Required option group with id 10 is missing from the inbound options.', $decodedOutput['message']);
            }
            public function test043OrderWithDuplicateExtras(): void{
                // update the menu_option_groups table to allow extras
                $stmt = $this->mockPdo->prepare("UPDATE menu_option_groups SET min_select = 1, max_select = 2 WHERE id = 10");
                $stmt->execute();

                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 10,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 14,],
                                                                                    ["id" => 14,] // Duplicate extra
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]
                                        ]
                                    ],
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Options validation failed for item id 13: Duplicate extra with in option group 10.', $decodedOutput['message']);
            }
            public function test044OrderOutsideOfMinMax(): void{
                // update the menu_option_groups table to allow extras
                $stmt = $this->mockPdo->prepare("select * from menu_option_groups mog inner join menu_item_to_options mito on mog.id = mito.group_id where mito.item_id = 13");
                $stmt->execute();
                $optionGroup = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                //echo print_r($optionGroup, true);

                $stmt = $this->mockPdo->prepare("select * from menu_option_joins where group_id = 10");
                $stmt->execute();
                $optionJoins = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                //echo print_r($optionJoins, true);

                $stmt = $this->mockPdo->prepare("UPDATE menu_option_groups SET min_select = 1, max_select = 1, is_required = 1 WHERE id = 10");
                $stmt->execute();

                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 10,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 14,],
                                                                                    ["id" => 15,]
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]
                                        ]
                                    ],
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Options validation failed for item id 13: Selected options (2) for option group 10 do not meet min (1) and max (1) selection requirements.', $decodedOutput['message']);
            }
            public function test045ValidOrderPreLoggedInWithOptions(): void{
                // update the menu_option_groups table to allow extras
                $stmt = $this->mockPdo->prepare("UPDATE menu_option_groups SET min_select = 1, max_select = 2 WHERE id = 10");
                $stmt->execute();

                $stmt = $this->mockPdo->prepare("select * from menu_option_extra");
                $stmt->execute();
                $optionExtras = $stmt->fetchAll(\PDO::FETCH_ASSOC);

                //echo print_r($optionExtras, true);


                $stmt = $this->mockPdo->prepare("update menu_option_joins set price_adjustment = 0.25 where group_id = 10 and extra_id = 15");
                $stmt->execute();

                $stmt = $this->mockPdo->prepare("update menu_option_joins set price_adjustment = 0.00 where group_id = 10 and extra_id = 14");
                $stmt->execute();

                $stmt = $this->mockPdo->prepare("select * from menu_option_joins where id in (14,15)");
                $stmt->execute();
                $optionJoins = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                //echo print_r($optionJoins, true);

                $stmt = $this->mockPdo->prepare("select * from menu_items where id = 13");
                $stmt->execute();
                $menuItem = $stmt->fetch(\PDO::FETCH_ASSOC);
                //echo print_r($menuItem, true);

                $_SESSION['id'] = 5;                // User ID
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 10,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 14,],
                                                                                    ["id" => 15,]
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]
                                        ],
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 10,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 15,]
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]

                                        ]
                                    ],
                        'promotion' => [[],[]],
                        'guestUser' => [],
                        'address'   => [
                            'deliveryId' => 1, // Assuming this is a valid address ID
                        ],
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                // test the inserted data starting at the order first
                $stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE tenant_id = 1 AND user_id = 5 ORDER BY id DESC LIMIT 1");
                $order = $stmt->fetch(\PDO::FETCH_ASSOC);
                //echo(print_r($order, true));
                $this->assertNotEmpty($order, "Order should be created successfully.");
                $this->assertEquals(5, $order['user_id'], "User ID should be 5.");
                $this->assertEquals(1, $order['tenant_id'], "Tenant ID should be 1.");
                $this->assertEquals(1, $order['delivery_address_id'], "Delivery Address ID should be 1.");
                $this->assertEquals('pending', $order['order_status'], "Order status should be 'pending'.");
                $this->assertEquals('delivery', $order['order_type'], "Delivery type should be 'delivery'.");
                $this->assertEquals(12.96, $order['total_order_price'], "Total price should be 12.96.");
                $this->assertEquals(20.85, $order['total_order_modified_price'], "Total price with tax should be 20.65.");
                $this->assertEquals('Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', $order['total_order_modified_reason'], "Order Modified reason should match the expected text.");
                $this->assertEquals('GBP', $order['currency'], "Currency should be 'GBP'.");

                // test the order items
                $stmt = $this->mockPdo->query("SELECT * FROM food_order_item WHERE order_id = {$order['id']}");
                $item = $stmt->fetch(\PDO::FETCH_ASSOC);
                //echo(print_r($item, true));
                $this->assertNotEmpty($item, "Order item should be created successfully.");
                $this->assertEquals(13, $item['menu_item_id'], "Item ID should be 13.");
                $this->assertEquals('Chips', $item['item_name'], "Item name should be 'Chips'.");
                $this->assertEquals(2.99, $item['item_base_price'], "Item base price should be 2.99.");
                $this->assertEquals(6.48, $item['item_modified_price'], "Item modified price should be 6.48.");
                $this->assertEquals('Includes extras: Salt (£0.00), Vinegar (£0.25)', $item['item_modified_reason'], "Item modified reason should match the expected text.");
                $this->assertEquals(2, $item['item_quantity'], "Item quantity should be 2.");
                $this->assertEquals('pending', $item['item_status'], "Order item status should be 'pending'.");

                // test the order item options
                $stmt = $this->mockPdo->query("SELECT * FROM food_order_extra");    
                $options = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                //echo(print_r($options, true));
                $this->assertNotEmpty($options[0], "Order item options should be created successfully.");
                $this->assertEquals(1, $options[0]['id'], "Option group ID should be 1.");
                $this->assertEquals(1, $options[0]['item_id'], "Menu item ID should be 1.");
                $this->assertEquals(14, $options[0]['menu_extra_id'], "Extra ID should be 14.");
                $this->assertEquals('Salt', $options[0]['extra_name'], "Extra name should be 'Salt'.");
                $this->assertEquals(0.00, $options[0]['extra_price'], "Extra price should be 0.00.");

                $this->assertEquals(2, $options[1]['id'], "Option group ID should be 2.");
                $this->assertEquals(1, $options[1]['item_id'], "Menu item ID should be 1.");
                $this->assertEquals(15, $options[1]['menu_extra_id'], "Extra ID should be 13.");
                $this->assertEquals('Vinegar', $options[1]['extra_name'], "Extra name should be 'Vinegar'.");
                $this->assertEquals(0.25, $options[1]['extra_price'], "Extra price should be 0.25.");

                $this->assertEquals(3, $options[2]['id'], "Option group ID should be 3.");
                $this->assertEquals(2, $options[2]['item_id'], "Menu item ID should be 1.");
                $this->assertEquals(15, $options[2]['menu_extra_id'], "Extra ID should be 15.");
                $this->assertEquals('Vinegar', $options[2]['extra_name'], "Extra name should be 'Vinegar'.");
                $this->assertEquals(0.25, $options[2]['extra_price'], "Extra price should be 0.25.");
                //$this->assertNotEmpty($options, "Order item options should be created successfully.");

                //$rows = $this->mockPdo->query("SELECT * FROM food_order_terms_acceptance")->fetchAll(\PDO::FETCH_ASSOC);
                //echo(print_r($rows, true));
            }
            public function test046ValidOrderGuestInWithOptions(): void{
                // update the menu_option_groups table to allow extras
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 10,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 14,],
                                                                                    ["id" => 15,]
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]
                                        ],
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 10,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 15,]
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]

                                        ]
                                    ],
                        'promotion' => [[],[]],
                        'guestUser' => [
                            'fName'         => 'John',
                            'lName'         => 'Doe',
                            'phoneNumber'   => '1234567890',
                            'userEmail'     => 'test@test.com',
                            'address'       => [
                                    'addressLine1'  => '12 Main St',
                                    'addressLine2'  => 'Apt 7D',
                                    'city'          => 'Springfield',
                                    'county'        => 'devon',
                                    'country'       => 'United Kingdom',
                                    'postalCode'    => 'EX1 2AE',
                            ],
                        ],
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                        'address'   => [
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                // test the inserted data starting at the order first
                // select all oders
                //$stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE tenant_id = 1");
                //$orders = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                //echo(print_r($orders, true));
                // View address Data
                //$stmt = $this->mockPdo->query("SELECT * FROM food_order_address ORDER BY id DESC LIMIT 1");
                //$address = $stmt->fetch(\PDO::FETCH_ASSOC);
                //echo(print_r($address, true));

                $stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE tenant_id = 1 AND guest_user_id = 1 ORDER BY id DESC LIMIT 1");
                $order = $stmt->fetch(\PDO::FETCH_ASSOC);
                //echo(print_r($order, true));
                $this->assertNotEmpty($order, "Order should be created successfully.");
                $this->assertEquals(1, $order['guest_user_id'], "User ID should be 5.");
                $this->assertEquals(1, $order['tenant_id'], "Tenant ID should be 1.");
                $this->assertEquals(2, $order['delivery_address_id'], "Delivery Address ID should be 1.");
                $this->assertEquals('pending', $order['order_status'], "Order status should be 'pending'.");
                $this->assertEquals('delivery', $order['order_type'], "Delivery type should be 'delivery'.");
                $this->assertEquals(12.96, $order['total_order_price'], "Total price should be 12.96.");
                $this->assertEquals(20.85, $order['total_order_modified_price'], "Total price with tax should be 20.85.");
                $this->assertEquals('Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', $order['total_order_modified_reason'], "Order Modified reason should match the expected text.");
                $this->assertEquals('GBP', $order['currency'], "Currency should be 'GBP'.");

                // test the order items
                $stmt = $this->mockPdo->query("SELECT * FROM food_order_item WHERE order_id = {$order['id']}");
                $item = $stmt->fetch(\PDO::FETCH_ASSOC);
                //echo(print_r($item, true));
                $this->assertNotEmpty($item, "Order item should be created successfully.");
                $this->assertEquals(13, $item['menu_item_id'], "Item ID should be 13.");
                $this->assertEquals('Chips', $item['item_name'], "Item name should be 'Chips'.");
                $this->assertEquals(2.99, $item['item_base_price'], "Item base price should be 2.99.");
                $this->assertEquals(6.48, $item['item_modified_price'], "Item modified price should be 6.48.");
                $this->assertEquals('Includes extras: Salt (£0.00), Vinegar (£0.25)', $item['item_modified_reason'], "Item modified reason should match the expected text.");
                $this->assertEquals(2, $item['item_quantity'], "Item quantity should be 2.");
                $this->assertEquals('pending', $item['item_status'], "Order item status should be 'pending'.");

                // test the order item options
                $stmt = $this->mockPdo->query("SELECT * FROM food_order_extra");    
                $options = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                //echo(print_r($options, true));
                $this->assertNotEmpty($options[0], "Order item options should be created successfully.");
                $this->assertEquals(1, $options[0]['id'], "Option group ID should be 1.");
                $this->assertEquals(1, $options[0]['item_id'], "Menu item ID should be 1.");
                $this->assertEquals(14, $options[0]['menu_extra_id'], "Extra ID should be 14.");
                $this->assertEquals('Salt', $options[0]['extra_name'], "Extra name should be 'Salt'.");
                $this->assertEquals(0.00, $options[0]['extra_price'], "Extra price should be 0.00.");

                $this->assertEquals(2, $options[1]['id'], "Option group ID should be 2.");
                $this->assertEquals(1, $options[1]['item_id'], "Menu item ID should be 1.");
                $this->assertEquals(15, $options[1]['menu_extra_id'], "Extra ID should be 15.");
                $this->assertEquals('Vinegar', $options[1]['extra_name'], "Extra name should be 'Vinegar'.");
                $this->assertEquals(0.25, $options[1]['extra_price'], "Extra price should be 0.25.");

                $this->assertEquals(3, $options[2]['id'], "Option group ID should be 3.");
                $this->assertEquals(2, $options[2]['item_id'], "Menu item ID should be 2.");
                $this->assertEquals(15, $options[2]['menu_extra_id'], "Extra ID should be 15.");
                $this->assertEquals('Vinegar', $options[2]['extra_name'], "Extra name should be 'Vinegar'.");
                $this->assertEquals(0.25, $options[2]['extra_price'], "Extra price should be 0.25.");

                //$this->assertNotEmpty($options, "Order item options should be created successfully.");

                //$rows = $this->mockPdo->query("SELECT * FROM food_order_terms_acceptance")->fetchAll(\PDO::FETCH_ASSOC);
                //echo(print_r($rows, true));
            }
            public function test047ValidOrderGuestInWithOptionsCollection(): void{
                // update the menu_option_groups table to allow extras
                // insert into tenant contact 
                $stmt = $this->mockPdo->prepare("INSERT INTO tenant_contact (tenant_id, contact_type, is_primary, label, contact_value) VALUES (1,'address', 'yes', 'Shop Address', '{&quot;streetAddress&quot;:&quot; ''1'' Buckingham Palace&quot;,&quot;city&quot;:&quot;London&quot;,&quot;county&quot;:&quot;Westminster&quot;,&quot;postcode&quot;:&quot;SW1A 1AA&quot;,&quot;country&quot;:&quot;England&quot;}')");
                $stmt->execute();
                // check inserted data
                $stmt = $this->mockPdo->query("SELECT * FROM tenant_contact WHERE tenant_id = 1 AND contact_type = 'address' ORDER BY id DESC LIMIT 1");
                $contact = $stmt->fetch(\PDO::FETCH_ASSOC);
                //echo(print_r($contact, true));
                $this->assertNotEmpty($contact, "Tenant contact should be created successfully.");


                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 10,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 14,],
                                                                                    ["id" => 15,]
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]
                                        ],
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 10,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 15,]
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]

                                        ]
                                    ],
                        'promotion' => [[],[]],
                        'guestUser' => [
                            'fName'         => 'John',
                            'lName'         => 'Doe',
                            'phoneNumber'   => '1234567890',
                            'userEmail'     => 'test@test.com',
                        ],
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                        'address'   => [
                        ],
                        'deliveryType' => 'collection', // Assuming this is a 'delivery' or 'collection'
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                // test the inserted data starting at the order first
                // select all oders
                //$stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE tenant_id = 1");
                //$orders = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                //echo(print_r($orders, true));
                // View address Data
                //$stmt = $this->mockPdo->query("SELECT * FROM food_order_address ORDER BY id DESC LIMIT 1");
                //$address = $stmt->fetch(\PDO::FETCH_ASSOC);
                //echo(print_r($address, true));

                $stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE tenant_id = 1 AND guest_user_id = 1 ORDER BY id DESC LIMIT 1");
                $order = $stmt->fetch(\PDO::FETCH_ASSOC);
                //echo(print_r($order, true));
                $this->assertNotEmpty($order, "Order should be created successfully.");
                $this->assertEquals(1, $order['guest_user_id'], "User ID should be 5.");
                $this->assertEquals(1, $order['tenant_id'], "Tenant ID should be 1.");
                $this->assertEquals(2, $order['delivery_address_id'], "Delivery Address ID should be 1.");
                $this->assertEquals('pending', $order['order_status'], "Order status should be 'pending'.");
                $this->assertEquals('delivery', $order['order_type'], "Delivery type should be 'delivery'.");
                $this->assertEquals(12.96, $order['total_order_price'], "Total price should be 12.96.");
                $this->assertEquals(20.85, $order['total_order_modified_price'], "Total price with tax should be 20.85.");
                $this->assertEquals('Small Order Fee Applied, Delivery Charge Applied, Admin Fee Applied', $order['total_order_modified_reason'], "Order Modified reason should match the expected text.");
                $this->assertEquals('GBP', $order['currency'], "Currency should be 'GBP'.");

                // test the order items
                $stmt = $this->mockPdo->query("SELECT * FROM food_order_item WHERE order_id = {$order['id']}");
                $item = $stmt->fetch(\PDO::FETCH_ASSOC);
                //echo(print_r($item, true));
                $this->assertNotEmpty($item, "Order item should be created successfully.");
                $this->assertEquals(13, $item['menu_item_id'], "Item ID should be 13.");
                $this->assertEquals('Chips', $item['item_name'], "Item name should be 'Chips'.");
                $this->assertEquals(2.99, $item['item_base_price'], "Item base price should be 2.99.");
                $this->assertEquals(6.48, $item['item_modified_price'], "Item modified price should be 6.48.");
                $this->assertEquals('Includes extras: Salt (£0.00), Vinegar (£0.25)', $item['item_modified_reason'], "Item modified reason should match the expected text.");
                $this->assertEquals(2, $item['item_quantity'], "Item quantity should be 2.");
                $this->assertEquals('pending', $item['item_status'], "Order item status should be 'pending'.");

                // test the order item options
                $stmt = $this->mockPdo->query("SELECT * FROM food_order_extra");    
                $options = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                //echo(print_r($options, true));
                $this->assertNotEmpty($options[0], "Order item options should be created successfully.");
                $this->assertEquals(1, $options[0]['id'], "Option group ID should be 1.");
                $this->assertEquals(1, $options[0]['item_id'], "Menu item ID should be 1.");
                $this->assertEquals(14, $options[0]['menu_extra_id'], "Extra ID should be 14.");
                $this->assertEquals('Salt', $options[0]['extra_name'], "Extra name should be 'Salt'.");
                $this->assertEquals(0.00, $options[0]['extra_price'], "Extra price should be 0.00.");

                $this->assertEquals(2, $options[1]['id'], "Option group ID should be 2.");
                $this->assertEquals(1, $options[1]['item_id'], "Menu item ID should be 1.");
                $this->assertEquals(15, $options[1]['menu_extra_id'], "Extra ID should be 15.");
                $this->assertEquals('Vinegar', $options[1]['extra_name'], "Extra name should be 'Vinegar'.");
                $this->assertEquals(0.25, $options[1]['extra_price'], "Extra price should be 0.25.");

                $this->assertEquals(3, $options[2]['id'], "Option group ID should be 3.");
                $this->assertEquals(2, $options[2]['item_id'], "Menu item ID should be 2.");
                $this->assertEquals(15, $options[2]['menu_extra_id'], "Extra ID should be 15.");
                $this->assertEquals('Vinegar', $options[2]['extra_name'], "Extra name should be 'Vinegar'.");
                $this->assertEquals(0.25, $options[2]['extra_price'], "Extra price should be 0.25.");

                //$this->assertNotEmpty($options, "Order item options should be created successfully.");
            }
            public function test048ViewItemsToMenuWithOptionsBasedOnAnId(): void{
                $stmt = $this->mockPdo->query("SELECT
                                                    -- menu_menus
                                                    menu_menus.id AS table_menu_menus_id, menu_menus.tenant_id AS table_menu_menus_tenant_id, menu_menus.menu_name AS table_menu_menus_menu_name,menu_menus.is_active AS table_menu_menus_is_active, menu_menus.is_deleted AS table_menu_menus_is_deleted,
                                                    -- menu_categories
                                                    menu_categories.id AS table_menu_categories_id, menu_categories.menu_id AS table_menu_categories_menu_id, menu_categories.category_name AS table_menu_categories_category_name, menu_categories.is_active AS table_menu_categories_is_active, menu_categories.is_deleted AS table_menu_categories_is_deleted, 
                                                    -- menu_category_items
                                                    menu_category_items.id AS table_menu_category_items_id, menu_category_items.category_id AS table_menu_category_items_category_id, menu_category_items.item_id AS table_menu_category_items_item_id, menu_category_items.is_active AS table_menu_category_items_is_active, menu_category_items.is_deleted AS table_menu_category_items_is_deleted,
                                                    -- menu_items
                                                    menu_items.id AS table_menu_items_id, menu_items.item_name AS table_menu_items_item_name, menu_items.is_active AS table_menu_items_is_active, menu_items.is_deleted AS table_menu_items_is_deleted,
                                                    -- menu_item_to_options
                                                    menu_item_to_options.id AS table_menu_item_to_options_id, menu_item_to_options.item_id AS table_menu_item_to_options_item_id, menu_item_to_options.group_id AS table_menu_item_to_options_group_id, menu_item_to_options.is_active AS table_menu_item_to_options_is_active, menu_item_to_options.is_deleted AS table_menu_item_to_options_is_deleted,
                                                    -- menu_option_groups
                                                    menu_option_groups.id AS table_menu_option_groups_id, menu_option_groups.group_name AS table_menu_option_groups_group_name, menu_option_groups.is_active AS table_menu_option_groups_is_active, menu_option_groups.is_deleted AS table_menu_option_groups_is_deleted, menu_option_groups.min_select as table_menu_option_groups_min_select, menu_option_groups.max_select AS table_menu_option_groups_max_select,
                                                    -- menu_option_joins
                                                    menu_option_joins.id AS table_menu_option_joins_id, menu_option_joins.extra_id AS table_menu_option_joins_extra_id, menu_option_joins.group_id AS table_menu_option_joins_group_id, menu_option_joins.is_active AS table_menu_option_joins_is_active, menu_option_joins.is_deleted AS table_menu_option_joins_is_deleted,
                                                    -- menu_option_extra
                                                    menu_option_extra.id AS table_menu_option_extra_id, menu_option_extra.extra_name AS table_menu_option_extra_extra_name, menu_option_extra.is_active AS table_menu_option_extra_is_active, menu_option_extra.is_deleted AS table_menu_option_extra_is_deleted
                                                FROM menu_items
                                                    -- link this item into its category → menu → tenant
                                                LEFT JOIN menu_category_items ON menu_category_items.item_id = menu_items.id
                                                LEFT JOIN menu_categories ON menu_categories.id = menu_category_items.category_id
                                                LEFT JOIN menu_menus ON menu_menus.id = menu_categories.menu_id
                                                        -- link this item to any menu-item-to-options option‐groups → joins → extras
                                                LEFT JOIN menu_item_to_options  ON menu_item_to_options.item_id = menu_items.id
                                                LEFT JOIN menu_option_groups    ON menu_option_groups.id        = menu_item_to_options.group_id
                                                LEFT JOIN menu_option_joins     ON menu_option_joins.group_id   = menu_option_groups.id
                                                LEFT JOIN menu_option_extra     ON menu_option_extra.id         = menu_option_joins.extra_id
                                                --WHERE menu_items.id = 13 -- mi.id id menu item id
                                            "); 
                $rows = $stmt->fetchAll(\PDO::FETCH_ASSOC);

                if (!empty($rows)) {
                // Send CSV headers so the browser offers a download
                    header('Content-Type: text/csv; charset=UTF-8');
                    header('Content-Disposition: attachment; filename="export.csv"');
                    /* 
                        // Open output stream
                        $fp = fopen('php://output', 'w');

                        // 1) Write the column headers (the array keys)
                        fputcsv($fp, array_keys($rows[0]));

                        // 2) Write each row
                        foreach ($rows as $row) {
                            fputcsv($fp, $row);
                        }

                        fclose($fp);
                        // or var_dump($rows)
                    */
                }
                $this->assertNotEmpty($rows, "Menu items with options should not be empty for item id x");
            }
            public function test049ValidOrderGuestInWithOptionsNoDeliveryAllowed(): void{
                // update sql not to allow delivery for tenant id 1
                $this->mockPdo->exec("update tenant  set active_delivery = 0 where id = 1");

                // update the menu_option_groups table to allow extras
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 10,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 14,],
                                                                                    ["id" => 15,]
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]
                                        ],
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 10,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 15,]
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]

                                        ]
                                    ],
                        'promotion' => [[],[]],
                        'guestUser' => [
                            'fName'         => 'John',
                            'lName'         => 'Doe',
                            'phoneNumber'   => '1234567890',
                            'userEmail'     => 'test@test.com',
                            'address'       => [
                                    'addressLine1'  => '12 Main St',
                                    'addressLine2'  => 'Apt 7D',
                                    'city'          => 'Springfield',
                                    'county'        => 'devon',
                                    'country'       => 'United Kingdom',
                                    'postalCode'    => 'EX1 2AE',
                            ],
                        ],
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                        'address'   => [
                        ],
                        'deliveryType' => 'delivery', // Assuming this is a 'delivery' or 'collection'
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Delivery is not available at this time.', $decodedOutput['message']);
            }
            public function test050ValidOrderGuestInWithOptionsNoCollectionAllowed(): void{
                // update sql not to allow delivery for tenant id 1
                $this->mockPdo->exec("update tenant  set active_pickup = 0 where id = 1");

                // update the menu_option_groups table to allow extras
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user  
                $_POST = [
                    'action' => 'insertOrder',
                    'basket' => [
                        'items'     => [
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 10,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 14,],
                                                                                    ["id" => 15,]
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]
                                        ],
                                        [
                                            "id" => 13, 
                                            "quantity" => 2, 
                                            "options" => [      
                                                            [
                                                                "id" => 10,
                                                                "extras" => [
                                                                                [
                                                                                    ["id" => 15,]
                                                                                ]
                                                                            ]
                                                            ]
                                                        ]

                                        ]
                                    ],
                        'promotion' => [[],[]],
                        'guestUser' => [
                            'fName'         => 'John',
                            'lName'         => 'Doe',
                            'phoneNumber'   => '1234567890',
                            'userEmail'     => 'test@test.com',
                            'address'       => [
                                    'addressLine1'  => '12 Main St',
                                    'addressLine2'  => 'Apt 7D',
                                    'city'          => 'Springfield',
                                    'county'        => 'devon',
                                    'country'       => 'United Kingdom',
                                    'postalCode'    => 'EX1 2AE',
                            ],
                        ],
                        'termsOfService' => [
                            'version'   => '0.2',
                            'accepted'  => 1
                        ],
                        'address'   => [
                        ],
                        'deliveryType' => 'collection', // Assuming this is a 'delivery' or 'collection'
                    ],
                    'debug' => 'CSD' // Add debug flag to the request
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('failed', $decodedOutput['status']);
                $this->assertEquals('Collection is not available at this time.', $decodedOutput['message']);
            }
            public function test051RevertTestData(): void{
                // Revert the test data by deleting the inserted item
                $this->mockPdo->exec("update tenant_business_hours set is_deleted = 0 where tenant_id = 1 and id in (1,2,3,4,5,6,7,8,9,10,12,13,14,15)"); // tenant_business_hours
                $this->mockPdo->exec("delete from tenant_business_hours where id in (16,17)"); // menu_items
                $this->assertEquals(1, 1);
            }
            public function test052checkOrderStatusLoggedIn(): void{
                $_SESSION['tenantId'] = 1;          // Tenant ID for the user
                $_SESSION['id'] = 5;                // User ID
                $stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE tenant_id = 1 AND user_id = 5 ORDER BY id DESC LIMIT 1");
                $order = $stmt->fetch(\PDO::FETCH_ASSOC);

                $_POST = [
                    'action' => 'checkOrderStatus',
                    'orderId' => $order['id'] ?? 1, // Use the fetched order ID or default to 1
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);
                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);


            }
            public function test053CheckOrderStatusGuest(): void{
                $_SESSION['tenantId'] = 1;
                $stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE tenant_id = 1 AND guest_user_id = 1 ORDER BY id DESC LIMIT 1");
                $order = $stmt->fetch(\PDO::FETCH_ASSOC);

                $_POST = [
                    'action' => 'checkOrderStatus',
                    'orderId' => $order['id'] ?? 1, // Use the fetched order ID or default to 1
                    'guestUserId' => 1, // Assuming guest user ID is 1
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
            }
            public function test054ViewOrderId(): void{
                $_SESSION['tenantId'] = 1;
                $stmt = $this->mockPdo->query("SELECT * FROM food_order WHERE tenant_id = 1 AND guest_user_id = 1 ORDER BY id DESC LIMIT 1");
                $order = $stmt->fetch(\PDO::FETCH_ASSOC);
                //print_r($order);

                $stmt = $this->mockPdo->query("select * from food_order_guest_user where id = 1");
                $guest = $stmt->fetch(\PDO::FETCH_ASSOC);
                //print_r($guest);

                $_POST = [
                    'action' => 'viewOrder',
                    'orderId' => $order['id'] ?? 1, // Use the fetched order ID or default to 1
                    'email' => 'test@test.com',
                    'debug' => 'CSD',
                    //'guestUserId' => 1, // Assuming guest user ID is 1
                ];
                list($output, $decodedOutput) = $this->executeFunctionPhp();
                $decodedOutput = json_decode($output, true);

                // Debug output
                //echo print_r($decodedOutput); // or var_dump($decodedOutput)
                $this->assertEquals('success', $decodedOutput['status']);
                $this->assertArrayHasKey('orderDetails', $decodedOutput);
                //$this->assertNotEmpty($decodedOutput['orderDetails']['items'], "Order items should not be empty.");
            }
            // create a secure space in the inputData and make sure it is wiped before it can leave the test / output space 
        // Setup Address Data to a user
        // setup address data to a user
        public function test055InsertTempDataIntoUserAddressesList(): void{
            $stmt = $this->mockPdo->query("insert into food_order_address (address_line_1, address_line_2, city, county, country, postal_code) values ('12 Main St', 'Apt 7D', 'Springfield', 'devon', 'United Kingdom', 'EX1 2AD')");
            $addressId1 = $this->mockPdo->lastInsertId();

            $stmt = $this->mockPdo->query("insert into food_order_user_address (user_id, address_id) values (5, {$addressId1})");

            $stmt = $this->mockPdo->query("insert into food_order_address (address_line_1, address_line_2, city, county, country, postal_code) values ('34 Second St', 'Apt 8E', 'Springfield', 'devon', 'United Kingdom', 'EX2 3CD')");
            $addressId2 = $this->mockPdo->lastInsertId();

            $stmt = $this->mockPdo->query("insert into food_order_user_address (user_id, address_id) values (5, {$addressId2})");

            $this->assertEquals(1, 1);
        }
        public function test056SqlViewUserList():void{
            $stmt = $this->mockPdo->query("SELECT * FROM food_order_address");
            $addresses = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            //echo(print_r($addresses, true));
            $this->assertEquals(1, 1);

            $stmt = $this->mockPdo->query("SELECT * FROM food_order");
            $orders = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            //echo(print_r($orders, true));
            $this->assertEquals(1, 1);

            $stmt = $this->mockPdo->query("SELECT * FROM food_order_user_address");
            $userAddresses = $stmt->fetchAll(\PDO::FETCH_ASSOC);
            //echo(print_r($userAddresses, true));
            $this->assertEquals(1, 1);

            // user id 5
        }
        public function test057ViewLoggedInUserAddressesList(): void{
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user
            $_SESSION['id'] = 5;                // User ID

            //$stmt = $this->mockPdo->query("SELECT * FROM food_order_user_address WHERE user_id = 5");
            //$userAddresses = $stmt->fetchAll(\PDO::FETCH_ASSOC); 
            //echo(print_r($userAddresses, true));  


            $_POST = [
                'action' => 'viewLoggedInUserAddressesList',
                'debug' => 'CSD',
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            //echo(print_r($decodedOutput, true));

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertArrayHasKey('addresses', $decodedOutput);
            $this->assertNotEmpty($decodedOutput['addresses'], "User addresses should not be empty.");
            $this->assertCount(3, $decodedOutput['addresses'], "User should have 2 addresses.");
        }
        public function test058ViewLoggedInUserAddressesListNoId(): void{
            $_SESSION['id'] = 100;                // User ID

            $_POST = [
                'action' => 'viewLoggedInUserAddressesList',
                'debug' => 'CSD',
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);

            //echo(print_r($decodedOutput, true));

            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertArrayHasKey('message', $decodedOutput);
            $this->assertEquals('No addresses found for this user', $decodedOutput['message']);
        }
        // test address distance inserts
        public function test059InsertAddressDistanceData(): void{
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'setupNewDistanceToAddress',
                'addressId' => 1,
                'distance' => 5.0,
                'debug' => 'CSD',
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertArrayHasKey('message', $decodedOutput);
            $this->assertEquals('Address to tenant distance setup complete.', $decodedOutput['message']);
        }
        public function test060InsertAddressDistanceDataIncorrectAddressId(): void{
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'setupNewDistanceToAddress',
                'addressId' => 250,
                'distance' => 5.0,
                'debug' => 'CSD',
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertArrayHasKey('message', $decodedOutput);
            $this->assertEquals('Failed to load address for distance setup.', $decodedOutput['message']);
        }
        public function test061InsertAddressDistanceDataIncorrectNoTenantId(): void{
            // unset tenant id
            unset($_SESSION['tenantId']);          // Tenant ID for the user
            $_POST = [
                'action' => 'setupNewDistanceToAddress',
                'addressId' => 250,
                'distance' => 5.0,
                'debug' => 'CSD',
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('failed', $decodedOutput['status']);
            $this->assertArrayHasKey('message', $decodedOutput);
            $this->assertEquals('Failed to load address for distance setup.', $decodedOutput['message']);
        }
        public function test062ViewAddressDistanceData(): void{
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'viewDistanceToAddress',
                'addressId' => 1,
                'debug' => 'CSD',
            ];

            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertArrayHasKey('distance', $decodedOutput);
            $this->assertEquals(5.0, $decodedOutput['distance'], "Distance should be 5.0 km.");
        }       
        public function test063SqlOutputToFile(): void{
            /*
            $sql = 'SELECT id FROM menu_items WHERE is_active = 1 AND is_deleted = 0';
            $stmt = $this->mockPdo->prepare($sql);
            $stmt->execute();
            $items = $stmt->fetchAll(\PDO::FETCH_ASSOC);

            echo print_r($items, true);

            // Basic sanity check so it doesn't silently do nothing
            $this->assertNotEmpty($items, "Menu items should not be empty.");

            // One file for ALL data
            $filePath = __DIR__ . '/export_options_all_items.csv';
            $fp = fopen($filePath, 'w');

            $headerWritten = false;

            foreach ($items as $item) {
                $itemId = (int)$item['id'];

                $sql = 'SELECT 
                            mito.id,
                            mog.min_select, 
                            mog.max_select, 
                            mog.is_required, 
                            mog.id,
                            moe.extra_name, 
                            moj.price_adjustment, 
                            moe.id AS extra_id
                        FROM menu_option_groups mog
                        INNER JOIN menu_option_joins moj        ON mog.id = moj.group_id
                        INNER JOIN menu_option_extra moe        ON moe.id = moj.extra_id 
                        INNER JOIN menu_item_to_options mito    ON mog.id = mito.group_id
                        WHERE mito.item_id = :itemId
                        AND mito.is_active  = 1
                        AND mog.is_active   = 1
                        AND moj.is_active   = 1
                        AND moe.is_active   = 1
                        AND mito.is_deleted = 0
                        AND mog.is_deleted  = 0
                        AND moj.is_deleted  = 0
                        AND moe.is_deleted  = 0';

                $stmt = $this->mockPdo->prepare($sql);
                $stmt->bindParam(':itemId', $itemId, \PDO::PARAM_INT);
                $stmt->execute();
                $options = $stmt->fetchAll(\PDO::FETCH_ASSOC);

                if (empty($options)) {
                    // nothing to dump for this item, skip
                    continue;
                }

                // Add item_id into each row so you know which item it belongs to
                foreach ($options as &$option) {
                    $option['item_id'] = $itemId;
                }
                unset($option); // break reference

                // Write header once, using the first non-empty result
                if (!$headerWritten) {
                    fputcsv($fp, array_keys($options[0]));
                    $headerWritten = true;
                }

                // Write data rows
                foreach ($options as $option) {
                    fputcsv($fp, $option);
                }
            }

            fclose($fp);

            // Optional: if you want to ensure file was created and not empty:
            // $this->assertFileExists($filePath);
            // $this->assertGreaterThan(0, filesize($filePath));
            */
            $this->assertEquals(1, 1);
        }
        public function test064SqlOutput(): void{
            /*
                $sql = 'SELECT * FROM menu_option_extra';
                $stmt = $this->mockPdo->prepare($sql);
                $stmt->execute();
                $extras = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                echo print_r($extras, true);
                $this->assertNotEmpty($extras, "Menu extras should not be empty.");
            echo "-------------------------------------------------------------------------------";
                $sql = 'SELECT * FROM menu_option_joins where group_id = 2';
                $stmt = $this->mockPdo->prepare($sql);
                $stmt->execute();
                $joins = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                echo print_r($joins, true);
                $this->assertNotEmpty($joins, "Menu option joins should not be empty.");
            echo "-------------------------------------------------------------------------------";
                $sql = 'SELECT * FROM menu_item_to_options where group_id = 2';
                $stmt = $this->mockPdo->prepare($sql);
                $stmt->execute();
                $groups = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                echo print_r($groups, true);
                $this->assertNotEmpty($groups, "Menu option groups should not be empty.");
            echo "-------------------------------------------------------------------------------";
                $sql = 'SELECT * FROM menu_item_to_options 
                --    where group_id = 2
                    where item_id = 3  
                    ';
                $stmt = $this->mockPdo->prepare($sql);
                $stmt->execute();
                $groups = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                echo print_r($groups, true);
                $this->assertNotEmpty($groups, "Menu option groups should not be empty.");
            echo "-------------------------------------------------------------------------------";
                $sql = 'SELECT * FROM menu_option_groups where id = 2';
                $stmt = $this->mockPdo->prepare($sql);
                $stmt->execute();
                $menu_option_groups = $stmt->fetchAll(\PDO::FETCH_ASSOC);
                echo print_r($menu_option_groups, true);
                $this->assertNotEmpty($menu_option_groups, "Menu option groups should not be empty.");
            echo "-------------------------------------------------------------------------------";
            */
            $this->assertEquals(1, 1);
        }
        public function test065ViewLatestTerms(): void{
            $_SESSION['tenantId'] = 1;          // Tenant ID for the user

            $_POST = [
                'action' => 'viewLatestTerms',
                'debug' => 'CSD',
            ];
            list($output, $decodedOutput) = $this->executeFunctionPhp();
            $decodedOutput = json_decode($output, true);
            // Debug output
            //echo print_r($decodedOutput); // or var_dump($decodedOutput)
            $this->assertEquals('success', $decodedOutput['status']);
            $this->assertArrayHasKey('terms', $decodedOutput);
            $this->assertEquals('These are the latest terms and conditions.', $decodedOutput['terms']['content'], "Terms content should match the latest active version.");
            $this->assertArrayHasKey('versions', $decodedOutput['terms']);
            $this->assertEquals('0.2', $decodedOutput['terms']['versions'], "Terms version should be 0.2.");
            $this->assertNotEmpty($decodedOutput['terms'], "Terms content should not be empty.");

            // truncate the terms table
        }
  
    }
?>