<?php
    function saveHistoryRecordStep($inputData){
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        $table              = 'food_order_history';
        $changeType         = $inputData['recordType'];
        $toJsonhistoryData  = json_encode($inputData['historyData'], JSON_PRETTY_PRINT);
        $tableOfSource      = toSnakeCase($inputData['table']);
        $oldID              = $inputData['historyData']['id'] ?? null;

        $sql = "INSERT INTO {$table} (tenant_id, change_type, table_of_source, change_data, changed_by, order_id) VALUES (:tenantId, :actionType, :tableOfSource, :historyData, :actionBy, :oldID)";
        $stmt = $pdo->prepare($sql);
        $stmt->bindValue(':tenantId', $inputData['tenantId'], PDO::PARAM_INT);
        $stmt->bindValue(':oldID', $oldID, PDO::PARAM_INT);
        $stmt->bindValue(':actionType', $changeType, PDO::PARAM_STR);
        $stmt->bindValue(':tableOfSource', $tableOfSource, PDO::PARAM_STR);
        $stmt->bindValue(':historyData', $toJsonhistoryData, PDO::PARAM_STR);
        $stmt->bindValue(':actionBy', $inputData['userId'], PDO::PARAM_INT);
        $stmt->execute();
        $lastInsertId = $pdo->lastInsertId();
        return [
            'status' => 'success',
            'message' => 'History record saved successfully',
            'id' => $lastInsertId
        ];
    }
    function insertData($inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $table = $inputData['table'] ?? null;
        $table = toSnakeCase($table);
        $roleId = $inputData['roleId'] ?? null;
        $dataKey = extractDataKeyFromTableName($inputData['table']);
        $data = $inputData[$dataKey] ?? [];
        
        if (!$table) {
            return ['status' => 'failed', 'message' => 'Table not specified'];
        }
        

        $map = menuTableColumnMapping($table, $roleId, "insert");

        $columnMap = $map['filtered'] ?? null;

        if (!$columnMap) {
            return ['status' => 'failed', 'message' => 'Invalid table or insufficient permissions', 'abc' => $table, 'map' => $map];
        }
        
        $insertData = [];
        $errors = [];
        
        foreach ($columnMap as $key => $meta) {
            // Skip if optionalInsert is null (e.g., auto-increment ID)
            if (array_key_exists('optionalInsert', $meta) && $meta['optionalInsert'] === null) {
                continue;
            }
            
            $dbField = $meta['mapping'] ?? null;
            if (!$dbField) {
                continue; // No valid mapping
            }
            
            if (!isset($data[$key]) || $data[$key] === '') {
                if (!empty($meta['optionalInsert']) && $meta['optionalInsert'] == 1) {
                    // Field is optional, allow skipping
                    continue;
                }
                // Field is required, error
                $errors[] = "$key is required";
            } else {
                $insertData[$dbField] = $data[$key];
            }
        }
        
        if (!empty($errors)) {
            return [
                'status' => 'failed',
                'message' => implode(', ', $errors)
            ];
        }
        
        if (empty($insertData)) {
            return [
                'status' => 'failed',
                'message' => 'No valid data to insert'
            ];
        }
        
        $columns = implode(', ', array_keys($insertData));
        $placeholders = implode(', ', array_map(fn($k) => ':' . $k, array_keys($insertData)));
        



        if($table == 'menu_menus'){
            if(isset($data['isActive']) && $data['isActive'] == 1){
                if(in_array('isActive', array_keys($columnMap))){    
                    $tempRes = disableAnyActive($inputData, $table); // empty string as may break update function
                    if($tempRes['status'] == 'failed'){  
                        return ['res' => $tempRes];
                    }
                }
                    
            }
        }
    
        $sql = "INSERT INTO {$table} ($columns) VALUES ($placeholders)";
        $stmt = $pdo->prepare($sql);

        foreach ($insertData as $key => $value) {
            // if table is foodOrderAddress then for fields x,y,z captilaise the first letter of each word, for a,b,c full upper case of value
            if ($table == 'food_order_address') {
                if (in_array($key, ['address_line_1', 'address_line_2', 'city', 'county'])) {
                    $value = $value = smartUcwords($value); // Capitalize first letter of each word
                } elseif (in_array($key, ['postal_code'])) {
                    $value = strtoupper($value); // Full uppercase for postcode
                } elseif (in_array($key, ['country'])) {
                    $value = countryToShortCode($value); // Remove non-numeric characters
                }
            }
            $stmt->bindValue(":$key", $value);
        }

        $stmt->execute();
        $lastInsertId = $pdo->lastInsertId();

        return [
            'status' => 'success',
            'message' => 'Record inserted successfully',
            'id' => $lastInsertId
        ];
    }
    function insertOrder(&$inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $table = 'food_order';
        $data = $inputData['basket']['order'] ?? [];

        if (empty($data)) {
            return ['status' => 'failed', 'message' => 'No data provided for order insertion'];
        }

        // Validate required fields
        $requiredFields = ['items', 'tenantId', 'orderType', 'orderTotalPrice',  'totalOrderModifiedPrice'];
        foreach ($requiredFields as $field) {
            if (empty($data[$field])) {
                return ['status' => 'failed', 'message' => "$field is required"];
            }
        }
        // Either the userId or guestUserId must be provided
        if (empty($data['userId']) && empty($data['guestUserId'])) {
            return ['status' => 'failed', 'message' => 'Either userId or guestUserId must be provided'];
        }

        // Prepare insert data
        $insertData = [
            'user_id' => $data['userId'] ?? null,
            'guest_user_id' => $data['guestUserId'] ?? null,
            'tenant_id' => $data['tenantId'],
            'order_type' => $data['orderType'],
            'total_order_price' => $data['orderTotalPrice'],
            'total_order_modified_price' => $data['totalOrderModifiedPrice'],
            'original_total_order_modified_price' => $data['totalOrderModifiedPrice'],
            'total_order_modified_reason' => $data['totalOrderModifiedReason'] ?? null,
            'delivery_fee' => $data['deliveryFee'] ?? 0.00,
            'order_fee' => $data['orderFee'] ?? 0.00,
            'platform_fee' => $inputData['basket']['order']['tenantOrderFee'] ?? 0.00,
            'small_order_fee' => $data['smallOrderFee'] ?? 0.00,
            'comment' => $inputData['basket']['comment'] ?? null,
            'delivery_address_id' => $data['deliveryAddressId'] ?? null,
        ];

        // Insert into orders table
        $columns = implode(', ', array_keys($insertData));
        $placeholders = implode(', ', array_map(fn($k) => ':' . $k, array_keys($insertData)));

        $sql = "INSERT INTO {$table} ($columns) VALUES ($placeholders)";
        $stmt = $pdo->prepare($sql);

        foreach ($insertData as $key => $value) {
            $stmt->bindValue(":$key", $value);
        }
        try {
            $stmt->execute();
            $inputData['basket']['order']['orderId'] = $pdo->lastInsertId(); // Reset orderId in case of failure
            return [
                'status' => 'success',
                'message' => 'Order inserted successfully',
            ];
        } catch (PDOException $e) {
            return ['status' => 'failed', 'message' => 'Database error: ' . $e->getMessage()];
        }
    }
    function insertOrderItems(&$inputData) {
        $pdo = $inputData['db']['dbApp'];
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $table = 'food_order_item';
        $orderId = $inputData['basket']['order']['orderId'] ?? null;
        $items = $inputData['basket']['order']['items'] ?? [];

        if (empty($orderId)) {
            return ['status' => 'failed', 'message' => 'Order ID is required'];
        }
        if (empty($items)) {
            return ['status' => 'failed', 'message' => 'No items to insert'];
        }

        foreach ($items as $item) {
            if (empty($item['menuItemId']) || empty($item['itemQuantity'])) {
                return ['status' => 'failed', 'message' => 'Menu item ID and quantity are required for each item'];
            }

            $insertData = [
                'order_id' => $orderId,
                'menu_item_id' => $item['menuItemId'],
                'item_name' => $item['itemName'],
                'item_base_price' => $item['itemBasePrice'] ?? 0.00,
                'item_modified_price' => $item['itemModifiedPrice'] ?? 0.00,
                'item_modified_reason' => $item['itemModifiedReason'] ?? null,
                'item_quantity' => $item['itemQuantity'] ?? 1
            ];

            // Prepare insert statement
            $columns = implode(', ', array_keys($insertData));
            $placeholders = implode(', ', array_map(fn($k) => ':' . $k, array_keys($insertData)));

            $sql = "INSERT INTO {$table} ($columns) VALUES ($placeholders)";
            $stmt = $pdo->prepare($sql);

            foreach ($insertData as $key => $value) {
                $stmt->bindValue(":$key", $value);
            }

            try {
                $stmt->execute();
                $item['orderItemId'] = $pdo->lastInsertId();
                // insert the items extras if any options
                if (!empty($item['options'])) {
                    $item['options']['orderItemId'] = $item['orderItemId'];
                    $res = insertExtras($inputData, 'food_order_extra', $item['options'], $item['orderItemId']);
                    if ($res['status'] !== 'success') {
                        return ['status' => 'failed', 'message' => 'Failed to insert item options: ' . $res['message']];
                    }
                }
            } catch (PDOException $e) {
                return ['status' => 'failed', 'message' => 'Database error: ' . $e->getMessage()];
            }
        }
        return ['status' => 'success', 'message' => 'Order items inserted successfully'];
    }
    function insertExtras(&$inputData, $table, $data, $newItemId = null) {
        $pdo = $inputData['db']['dbApp'];
        $debug = $inputData['debug'] ?? false; // Use debug flag from input data
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $inputData['basket']['step'][] = 'insertExtras';

        if (!$table || empty($data)) {
            return [['status' => 'failed', 'message' => 'Table or data not provided']];
        }

        $results = [];

        // Detect if data is grouped: [groupId => [ [extra1], [extra2], ... ]]
        $firstGroup = reset($data);                            // first group: e.g. $data[10]
        $firstItem = is_array($firstGroup) ? reset($firstGroup) : null; // first item in that group
        $isGrouped = is_array($firstGroup) && is_array($firstItem);



        if ($isGrouped) {
            $inputData['basket']['step'][] = 'insertExtrasGrouped';
            // Multiple groups of extras
            foreach ($data as $groupId => $extrasList) {
                $inputData['basket']['step'][] = 'insertExtrasGroupedGroup';
                if (!is_array($extrasList)) continue;
                    $inputData['basket']['step'][] = 'insertExtrasGroupedGroupLoop';
                    foreach ($extrasList as $extra) {
                        $inputData['basket']['step'][] = 'insertExtrasGroupedGroupLoopExtra';
                        

                        $insertRow = [
                            'item_id' => $newItemId, // Use newItemId if provided, otherwise use $newItemId],
                            'menu_extra_id' => $extra['id'] ?? null,
                            'extra_name' => $extra['name'] ?? '',
                            'extra_price' => round((float)($extra['price'] ?? 0), 2)
                        ];

                        $columns = implode(', ', array_keys($insertRow));
                        $placeholders = implode(', ', array_map(fn($k) => ':' . $k, array_keys($insertRow)));
                        $sql = "INSERT INTO {$table} ($columns) VALUES ($placeholders)";
                        $stmt = $pdo->prepare($sql);

                        foreach ($insertRow as $key => $value) {
                            $stmt->bindValue(":$key", $value);
                        }

                        try {
                            $inputData['basket']['step'][] = 'insertExtrasGroupedGroupLoopExtraExecute';
                            $stmt->execute();
                        } catch (PDOException $e) {
                            // If debug is enabled, include the error message
                            // Otherwise, return a generic error message
                            if ($debug) {
                                return[
                                    'status' => 'failed',
                                    'message' => 'Database error: ' . $e->getMessage()
                                ];
                            } else {
                                // Generic error message
                                return[
                                    'status' => 'failed',
                                    'message' => 'Database error'
                                ];
                            }
                        }
                    }
            }
        } else {
            // Single row insert
            if (!isset($data['orderItemId'])) {
                return [['status' => 'failed', 'message' => 'Missing orderItemId']];
            }

            $insertRow = [
                'item_id' => $data['orderItemId'],
                'menu_extra_id' => $data['id'] ?? null,
                'extra_name' => $data['name'] ?? '',
                'extra_price' => round((float)($data['price'] ?? 0), 2)
            ];

            $columns = implode(', ', array_keys($insertRow));
            $placeholders = implode(', ', array_map(fn($k) => ':' . $k, array_keys($insertRow)));
            $sql = "INSERT INTO {$table} ($columns) VALUES ($placeholders)";
            $stmt = $pdo->prepare($sql);

            foreach ($insertRow as $key => $value) {
                $stmt->bindValue(":$key", $value);
            }

            try {
                $stmt->execute();
            } catch (PDOException $e) {
                if ($debug) {
                    return [
                        'status' => 'failed',
                        'message' => 'Database error: ' . $e->getMessage()
                    ];
                } else {
                    return [
                        'status' => 'failed',
                        'message' => 'Database error'
                    ];
                }
            }
        }
        
        return ['status' => 'success', 'message' => 'Extras inserted successfully'];
    }
    function setupStripeIntentDirect(array &$inputData): array{
        require_once __DIR__ . DIRECTORY_SEPARATOR . '..' . DIRECTORY_SEPARATOR . 'vendor' . DIRECTORY_SEPARATOR . 'autoload.php';
        if (!class_exists('\Stripe\Stripe')) {
            return ['status' => 'failed', 'message' => 'Stripe dependency not available'];
        }

        // --- Pull config using your existing keys, with safe fallbacks -------------
        // Platform (Waitron) keys
        $platformSecretKey   = $inputData['secure']['stripeSecretKey']      // your existing key
                            ?? getenv('STRIPE_SECRET_KEY')               // fallback to env
                            ?? null;

        // Publishable key is for the client; don't hard-fail if missing
        $platformPublishable = $inputData['secure']['stripePublishableKey']
                            ?? getenv('STRIPE_PUBLISHABLE_KEY')
                            ?? '';

        // Connected account id (acct_...) – accept your existing field names
        $acctId =  $inputData['secure']['paymentApiKey'];

        if (!$platformSecretKey) {
            return ['status' => 'failed', 'message' => 'Missing Stripe platform secret key'];
        }
        if (!$acctId) {
            return ['status' => 'failed', 'message' => 'Missing connected account ID (acct_...)'];
        }

        \Stripe\Stripe::setApiKey($platformSecretKey);

        // --- Order + fee amounts (keeps your original fee calc) --------------------
        $data        = $inputData['basket']['order'] ?? [];
        $orderId     = (string)($data['orderId'] ?? '');
        $tenantId    = (string)($data['tenantId'] ?? '');

        $amountInPence    = max(1, (int) round(($data['totalOrderModifiedPrice'] ?? 0) * 100));
        $customerAdminFee = (float)($data['customerAdminFee'] ?? 0);
        $tenantAdminFee   = (float)($data['tenantAdminFee']   ?? 0);

        $appFeeInPence    = max(0, (int)(round($customerAdminFee * 100) + round($tenantAdminFee * 100)));
        $shopAmountInPence= max(0, $amountInPence - $appFeeInPence);

        // --- Build PI params (DIRECT CHARGES: created on connected account) --------
        $params = [
            'amount'                    => $amountInPence,
            'currency'                  => 'gbp',
            'capture_method'            => 'manual',                // hold until shop accepts
            'automatic_payment_methods' => ['enabled' => true],
            'description'               => 'Order ' . $orderId,
            'application_fee_amount'    => $appFeeInPence,          // your fee → platform
            'metadata' => [
                'orderId'     => $orderId,
                'tenantId'    => $tenantId,
                'serviceFee'  => (string)$appFeeInPence,            // stored in pence
                'shopAmount'  => (string)$shopAmountInPence,        // stored in pence
            ],
        ];

        try {
            $idemKey = 'pi_create_direct_' . ($orderId !== '' ? $orderId : uniqid('noorder_', true));

            // IMPORTANT: direct charge = create in the connected account context
            $intent = \Stripe\PaymentIntent::create(
                $params,
                [
                    'idempotency_key' => $idemKey,
                    'stripe_account'  => $acctId, // <-- THIS makes it a direct charge
                ]
            );

            // Save for client
            $inputData['basket']['step'][]                      = 'setupStripeIntentDirect';
            $inputData['secure']['paymentIntentId']             = $intent->id;
            $inputData['basket']['order']['clientSecret']       = $intent->client_secret;
            $inputData['basket']['order']['publishableKey']     = $platformPublishable; // ok if empty; your UI can handle
            $inputData['basket']['order']['connectedAccount']   = $acctId;

            return ['status' => 'success'];

        } catch (\Stripe\Exception\ApiErrorException $e) {
            return [
                'status'  => 'failed',
                'message' => 'Stripe error: ' . $e->getMessage() . ' amount ' . ($data['totalOrderModifiedPrice'] ?? 0),
            ];
        } catch (\Exception $e) {
            return ['status' => 'failed', 'message' => 'Error: ' . $e->getMessage()];
        }
    }
?>