# Frontend API Interface Specification

---

## Overview
This document outlines the frontend API contract required to interact with the backend PHP application. All operations are triggered via a single endpoint (function.php) using POST or GET requests, with the action defined in the action field. Role-based access is enforced via session variables.

---

## Role Definitions

```sql
INSERT INTO `user_role` (`pk_role_id`, `role_name`, `scope`) VALUES
(1, "SystemAdmin", "Platform"),
(2, "SupportAgent", "Platform"),
(3, "ContentModerator", "Platform"),
(4, "BusinessOwner", "Tenant"),
(5, "BusinessManager", "Tenant"),
(6, "Staff", "Tenant"),
(7, "Operator", "Tenant"),
(8, "Customer", "Public");
```

## API Summary Table

| Action                            | Method | Required Role      | Payload Object           | Description                                                            |
|-----------------------------------|--------|--------------------|--------------------------|------------------------------------------------------------------------|
| [`insertAddress`](#insertAddress)                   | POST   |  8   (logged in)   | `foodOrderAddress`       | For a logged in user to set up an addess                               |
| [`insertUserToAddress`](#insertUserToAddress)             | POST   |  8   (logged in)   | `foodOrderUserAddress`   | Linking an logged in user to an address                                |
| [`insertOrder`](#insertOrder)                     | POST   |                    | `basket`                 | Create a new order                                                     |
| [`viewAddress`](#viewAddress)                     | POST   |                    | `viewAddress`            | List of address                                                        |
| [`checkOrderStatus`](#checkOrderStatus)                | Get    | 8 or guestUserID   |                          | check Order Status                                                     |
| [`viewOrder`](#viewOrder)                       | Get    |                    |                          | View Order by Id value                                                 |
| [`viewLoggedInUserAddressesList`](#viewLoggedInUserAddressesList)   | Get    |                    |                          | Get address that a user has inserted on                                |
| [`setupNewDistanceToAddress`](#setupNewDistanceToAddress)       | POST   |                    |                          | Insert into Distance Matrix                                            |
| [`viewDistanceToAddress`](#viewDistanceToAddress)           | GET    |                    |                          | View Distance from address data                                        |
| [`viewLatestTerms`](#viewLatestTerms)                   | GET    |                 |                          | View Latest Terms                                                    |
## Payload Structures



<a id="insertAddress"></a>
### `insertAddress`
```json
{
    "action" : "insertAddress",
    "foodOrderAddress" : [ 
                "addressLine1"  : string,
                "addressLine2"  : string,
                "city"          : string,
                "county"        : string,
                "country"       : string,
                "postalCode"    : string,
            ],
}
```

<a id="insertUserToAddress"></a>
### `insertUserToAddress`
```json
    "action" : "insertUserToAddress",
    "foodOrderUserAddress" : [ 
        "addressId"    : int,
        "isDefault"    : int, (1|0)
        "isActive"     : int
    ]
```

### `insertOrder`
```json
{
"action" : "insertOrder",
    "basket" : [
        "items" : [
            [
                "id" : int, 
                "quantity" : int, 
                "options" : [  // optional
                    [
                        "id" : int, // Extra Group ID
                        "extras" : [ // Extras for the option
                            [
                                ["id" : int,], // Extra ID
                                ["id" : int,],  // Another Extra ID
                                [...]
                            ]
                        ]
                    ],
                    [...]
                ]`
            ]
        ]
        "termsOfService" : [
            "aceppted": 1,  // needs to be a tick box agreeing
            "version" : string // eg "1.1"
        ],
        "promotion" : [[],[]],
        "guestUser" : [ // Optional guest user data if not logged in
            "fName"         : string
            "lName"         : string,
            "phoneNumber"   : string,
            "userEmail"     : string,
            "address"       : [
                "addressLine1"  : string,
                "addressLine2"  : string,
                "city"          : string,
                "county"        : string,
                "country"       : string,
                "postalCode"    : string,
        ],
        "address"   : [
            "deliveryId" : int, // Assuming this is a valid address ID
        ],
        "deliveryType" : string "delivery", // Assuming this is a "delivery" or "collection"
        "comment" : string // Comments 
    ]
}
```

<a id="viewAddress"></a>
### `viewAddress`
```json
{
    "action" : "viewAddress",
}
```
    
<a id="checkOrderStatus"></a>
### `checkOrderStatus`
```json
{
    "action"    : "checkOrderStatus",
    "orderId"   :  int,
    "guestId"   :  int, optional if not logged in  
}
```

<a id="viewOrder"></a>
### `viewOrder`
```json
{
    "action" : "viewOrder",
    "orderId": int,
    "email": string
}
```

<a id="viewLoggedInUserAddressesList"></a>
### `viewLoggedInUserAddressesList`
```json
{
    "action" : "viewLoggedInUserAddressesList"
}
```


<a id="setupNewDistanceToAddress"></a>
### `setupNewDistanceToAddress`
```json
{
    "action" : "setupNewDistanceToAddress",
    "addressId": int,
    "distance" : int  
}
```

<a id="viewDistanceToAddress"></a>
### `viewDistanceToAddress`
```json
{
    "action" : "viewDistanceToAddress",
    "addressId": int
}
```

<a id="viewLatestTerms"></a>
### `viewLatestTerms`
```json
    "action" : "viewLatestTerms",
```